/*
 * Copyright 2018-2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import '../style/index.css';
import * as React from 'react';
/**
 * The CSS class for expandable containers.
 */
const DETAILS_VISIBLE_CLASS = 'elyra-expandableContainer-details-visible';
const DETAILS_HIDDEN_CLASS = 'elyra-expandableContainer-details-hidden';
const DISPLAY_NAME_CLASS = 'elyra-expandableContainer-name';
const ELYRA_BUTTON_CLASS = 'elyra-button';
const DOWN_ICON_CLASS = 'elyra-downArrow-icon';
const UP_ICON_CLASS = 'elyra-upArrow-icon';
const BUTTON_CLASS = 'elyra-expandableContainer-button';
const TITLE_CLASS = 'elyra-expandableContainer-title';
const ACTION_BUTTONS_WRAPPER_CLASS = 'elyra-expandableContainer-action-buttons';
const ACTION_BUTTON_CLASS = 'elyra-expandableContainer-actionButton';
/**
 * A React component for expandable containers.
 */
export class ExpandableComponent extends React.Component {
    constructor(props) {
        super(props);
        this.state = { expanded: false };
    }
    toggleDetailsDisplay() {
        // Switch expanded flag
        const newExpandFlag = !this.state.expanded;
        this.setState({ expanded: newExpandFlag });
    }
    render() {
        const buttonClasses = [ELYRA_BUTTON_CLASS, BUTTON_CLASS].join(' ');
        return (React.createElement("div", null,
            React.createElement("div", { key: this.props.displayName, className: TITLE_CLASS },
                React.createElement("button", { className: buttonClasses +
                        ' ' +
                        (this.state.expanded ? UP_ICON_CLASS : DOWN_ICON_CLASS), onClick: () => {
                        this.toggleDetailsDisplay();
                    } }),
                React.createElement("span", { title: this.props.tooltip, className: DISPLAY_NAME_CLASS, onClick: () => {
                        this.toggleDetailsDisplay();
                    } }, this.props.displayName),
                React.createElement("div", { className: ACTION_BUTTONS_WRAPPER_CLASS }, this.props.actionButtons.map((btn) => {
                    return (React.createElement("button", { key: btn.title, title: btn.title, className: buttonClasses +
                            ' ' +
                            ACTION_BUTTON_CLASS +
                            ' ' +
                            btn.iconClass, onClick: () => {
                            btn.onClick();
                        } }));
                }))),
            React.createElement("div", { className: this.state.expanded ? DETAILS_VISIBLE_CLASS : DETAILS_HIDDEN_CLASS }, this.props.children ? this.props.children : null)));
    }
}
//# sourceMappingURL=ExpandableComponent.js.map