/*
 * Copyright 2018-2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import '../style/index.css';
import { ICommandPalette } from '@jupyterlab/apputils';
import { CodeSnippetWidget } from './CodeSnippetWidget';
const CODE_SNIPPET_EXTENSION_ID = 'elyra-code-snippet-extension';
/**
 * Initialization data for the code-snippet extension.
 */
export const code_snippet_extension = {
    id: CODE_SNIPPET_EXTENSION_ID,
    autoStart: true,
    requires: [ICommandPalette],
    activate: (app, palette) => {
        console.log('Elyra - code-snippet extension is activated!');
        const codeSnippetWidget = new CodeSnippetWidget();
        codeSnippetWidget.id = CODE_SNIPPET_EXTENSION_ID;
        codeSnippetWidget.title.iconClass =
            'jp-SideBar-tabIcon elyra-codeSnippet-icon';
        codeSnippetWidget.title.caption = 'Code Snippet';
        // Rank has been chosen somewhat arbitrarily to give priority to the running
        // sessions widget in the sidebar.
        app.shell.add(codeSnippetWidget, 'left', { rank: 900 });
    }
};
export default code_snippet_extension;
//# sourceMappingURL=index.js.map