import * as React from 'react';
import { GitExtension } from '../model';
import { Git } from '../tokens';
export declare const STATUS_CODES: {
    M: string;
    A: string;
    D: string;
    R: string;
    C: string;
    U: string;
    '?': string;
    '!': string;
};
export interface IFileItemProps {
    actions?: React.ReactElement;
    contextMenu?: (event: React.MouseEvent) => void;
    file: Git.IStatusFile;
    markBox?: boolean;
    model: GitExtension;
    selected?: boolean;
    selectFile?: (file: Git.IStatusFile | null) => void;
}
export interface IGitMarkBoxProps {
    fname: string;
    model: GitExtension;
    stage: string;
}
export declare class FileItem extends React.Component<IFileItemProps> {
    getFileChangedLabel(change: keyof typeof STATUS_CODES): string;
    getFileChangedLabelClass(change: string): string;
    getFileClass(): string;
    render(): JSX.Element;
}
export declare class GitMarkBox extends React.Component<IGitMarkBoxProps> {
    constructor(props: IGitMarkBoxProps);
    protected _onClick: (event: React.ChangeEvent<HTMLInputElement>) => void;
    protected _onDoubleClick: (event: React.MouseEvent<HTMLInputElement, MouseEvent>) => void;
    render(): JSX.Element;
}
