/**
 * A utilities class for parsing notebook files.
 */
export declare class NotebookParser {
    /**
     * Takes in a notebook and finds all env vars accessed in it.
     * @param notebookStr Raw notebook JSON in string format
     * @returns A string array of the env vars accessed in the given notebook
     */
    static getEnvVars(notebookStr: string): string[];
    /**
     * Splits code string on new lines and matches each line on the given regex.
     * @param code Multi-line string to match on
     * @param regex Match regex to run on each line of code
     * @returns A 2d string array containing an array of the matched array results
     */
    static findInCode(code: string, regex: RegExp): string[][];
}
