/*
 * Decompiled with CFR 0.152.
 */
package fpp.compiler.analysis;

import fpp.compiler.analysis.Format;
import fpp.compiler.analysis.Type;
import fpp.compiler.analysis.Type$;
import fpp.compiler.analysis.Type$AnonArray$;
import fpp.compiler.analysis.Type$AnonStruct$;
import fpp.compiler.analysis.Type$Array$;
import fpp.compiler.analysis.Type$Boolean$;
import fpp.compiler.analysis.Type$Float$;
import fpp.compiler.analysis.Type$Float$F32$;
import fpp.compiler.analysis.Type$Float$F64$;
import fpp.compiler.analysis.Type$Integer$;
import fpp.compiler.analysis.Type$PrimitiveInt$;
import fpp.compiler.analysis.Type$PrimitiveInt$I16$;
import fpp.compiler.analysis.Type$PrimitiveInt$I32$;
import fpp.compiler.analysis.Type$PrimitiveInt$I64$;
import fpp.compiler.analysis.Type$PrimitiveInt$I8$;
import fpp.compiler.analysis.Type$PrimitiveInt$U16$;
import fpp.compiler.analysis.Type$PrimitiveInt$U32$;
import fpp.compiler.analysis.Type$PrimitiveInt$U64$;
import fpp.compiler.analysis.Type$PrimitiveInt$U8$;
import fpp.compiler.analysis.Type$String$;
import fpp.compiler.analysis.Type$Struct$;
import fpp.compiler.analysis.Value$;
import fpp.compiler.analysis.Value$AbsType$;
import fpp.compiler.analysis.Value$AnonArray$;
import fpp.compiler.analysis.Value$AnonStruct$;
import fpp.compiler.analysis.Value$Array$;
import fpp.compiler.analysis.Value$Binop$;
import fpp.compiler.analysis.Value$Boolean$;
import fpp.compiler.analysis.Value$EnumConstant$;
import fpp.compiler.analysis.Value$Float$;
import fpp.compiler.analysis.Value$Integer$;
import fpp.compiler.analysis.Value$PrimitiveInt$;
import fpp.compiler.analysis.Value$String$;
import fpp.compiler.analysis.Value$Struct$;
import fpp.compiler.ast.Ast;
import fpp.compiler.ast.AstNode;
import java.io.Serializable;
import scala.Byte$;
import scala.Float$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Product;
import scala.Short$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public interface Value {
    public static int ordinal(Value value) {
        return Value$.MODULE$.ordinal(value);
    }

    public static Option $plus$(Value $this, Value v) {
        return $this.$plus(v);
    }

    default public Option<Value> $plus(Value v) {
        return this.binop(Value$Binop$.MODULE$.apply((Function2<BigInt, BigInt, BigInt> & Serializable)(v1, v2) -> Value.intOp$1(v1, v2), (v1, v2) -> Value.doubleOp$1(v1, v2)), v);
    }

    public static boolean isZero$(Value $this) {
        return $this.isZero();
    }

    default public boolean isZero() {
        return false;
    }

    public static Option convertToDistinctType$(Value $this, Type t) {
        return $this.convertToDistinctType(t);
    }

    default public Option<Value> convertToDistinctType(Type t) {
        return None$.MODULE$;
    }

    public static Option convertToType$(Value $this, Type t) {
        return $this.convertToType(t);
    }

    default public Option<Value> convertToType(Type t) {
        return Type$.MODULE$.areIdentical(this.getType(), t.getUnderlyingType()) ? Some$.MODULE$.apply(this) : this.convertToDistinctType(t);
    }

    public static Option $div$(Value $this, Value v) {
        return $this.$div(v);
    }

    default public Option<Value> $div(Value v) {
        return this.binop(Value$Binop$.MODULE$.apply((Function2<BigInt, BigInt, BigInt> & Serializable)(v1, v2) -> Value.intOp$2(v1, v2), (v1, v2) -> Value.doubleOp$2(v1, v2)), v);
    }

    public static Option binop$(Value $this, Binop op, Value v) {
        return $this.binop(op, v);
    }

    default public Option<Value> binop(Binop op, Value v) {
        return None$.MODULE$;
    }

    public Type getType();

    public static Option $times$(Value $this, Value v) {
        return $this.$times(v);
    }

    default public Option<Value> $times(Value v) {
        return this.binop(Value$Binop$.MODULE$.apply((Function2<BigInt, BigInt, BigInt> & Serializable)(v1, v2) -> Value.intOp$3(v1, v2), (v1, v2) -> Value.doubleOp$3(v1, v2)), v);
    }

    public static Option unary_$minus$(Value $this) {
        return $this.unary_$minus();
    }

    default public Option<Value> unary_$minus() {
        return None$.MODULE$;
    }

    public static Option promoteToAggregate$(Value $this, Type t) {
        return $this.promoteToAggregate(t);
    }

    default public Option<Value> promoteToAggregate(Type t) {
        Option option;
        Type type = t;
        if (type instanceof Type.AnonArray) {
            Type.AnonArray anonArray = (Type.AnonArray)type;
            option = this.promoteToAnonArray$1(anonArray);
        } else if (type instanceof Type.Array) {
            Type.Array array = (Type.Array)type;
            option = this.promoteToArray$1(array);
        } else if (type instanceof Type.AnonStruct) {
            Type.AnonStruct anonStruct = (Type.AnonStruct)type;
            option = this.promoteToAnonStruct$1(anonStruct);
        } else if (type instanceof Type.Struct) {
            Type.Struct struct = (Type.Struct)type;
            option = this.promoteToStruct$1(struct);
        } else {
            option = None$.MODULE$;
        }
        return option;
    }

    public static Option $minus$(Value $this, Value v) {
        return $this.$minus(v);
    }

    default public Option<Value> $minus(Value v) {
        return this.binop(Value$Binop$.MODULE$.apply((Function2<BigInt, BigInt, BigInt> & Serializable)(v1, v2) -> Value.intOp$4(v1, v2), (v1, v2) -> Value.doubleOp$4(v1, v2)), v);
    }

    public static Value truncate$(Value $this) {
        return $this.truncate();
    }

    default public Value truncate() {
        return this;
    }

    private static BigInt intOp$1(BigInt v1, BigInt v2) {
        return v1.$plus(v2);
    }

    private static double doubleOp$1(double v1, double v2) {
        return v1 + v2;
    }

    private static BigInt intOp$2(BigInt v1, BigInt v2) {
        return v1.$div(v2);
    }

    private static double doubleOp$2(double v1, double v2) {
        return v1 / v2;
    }

    private static BigInt intOp$3(BigInt v1, BigInt v2) {
        return v1.$times(v2);
    }

    private static double doubleOp$3(double v1, double v2) {
        return v1 * v2;
    }

    private static Value promoteToAnonArray$1$$anonfun$1$$anonfun$1$$anonfun$1(Value elt$1) {
        return elt$1;
    }

    private /* synthetic */ Option promoteToAnonArray$1$$anonfun$1(Type.AnonArray anonArray$1, int size) {
        return this.convertToType(anonArray$1.eltType()).map((Function1<Value, AnonArray> & Serializable)elt -> Value$AnonArray$.MODULE$.apply((List)package$.MODULE$.List().fill(size, () -> Value.promoteToAnonArray$1$$anonfun$1$$anonfun$1$$anonfun$1(elt))));
    }

    private Option promoteToAnonArray$1(Type.AnonArray anonArray) {
        return this.getType().isPromotableToArray() ? anonArray.size().flatMap((Function1<Object, Option> & Serializable)size -> this.promoteToAnonArray$1$$anonfun$1(anonArray, BoxesRunTime.unboxToInt(size))) : None$.MODULE$;
    }

    private Option promoteToArray$1(Type.Array array) {
        return this.promoteToAnonArray$1(array.anonArray()).map((Function1<AnonArray, Array> & Serializable)anonArray -> Value$Array$.MODULE$.apply((AnonArray)anonArray, array));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Option promote$1(List in, Map out) {
        Option<Value> option;
        Option option2;
        Map map = out;
        List list = in;
        while (true) {
            List list2 = list;
            Nil$ nil$ = package$.MODULE$.Nil();
            List list3 = list2;
            if (!(nil$ != null ? !((Object)nil$).equals(list3) : list3 != null)) {
                option2 = Some$.MODULE$.apply(Value$AnonStruct$.MODULE$.apply(map));
                return option2;
            }
            if (!(list2 instanceof $colon$colon)) throw new MatchError(list2);
            $colon$colon $colon$colon = ($colon$colon)list2;
            Tuple2 tuple2 = (Tuple2)$colon$colon.head();
            List list4 = $colon$colon.next$access$1();
            if (tuple2 == null) throw new MatchError(list2);
            java.lang.String m = (java.lang.String)tuple2._1();
            Type t = (Type)tuple2._2();
            List tail = list4;
            option = this.convertToType(t);
            if (!(option instanceof Some)) break;
            Value v = (Value)((Some)option).value();
            List list5 = tail;
            java.lang.String string2 = Predef$.MODULE$.ArrowAssoc(m);
            Map map2 = (Map)map.$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, v));
            list = list5;
            map = map2;
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        option2 = None$.MODULE$;
        return option2;
    }

    private Option promoteToAnonStruct$1(Type.AnonStruct anonStruct) {
        return this.getType().isPromotableToStruct() ? this.promote$1(anonStruct.members().toList(), (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(new Tuple2[0]))) : None$.MODULE$;
    }

    private Option promoteToStruct$1(Type.Struct struct) {
        return this.promoteToAnonStruct$1(struct.anonStruct()).map((Function1<AnonStruct, Struct> & Serializable)anonStruct -> Value$Struct$.MODULE$.apply((AnonStruct)anonStruct, struct));
    }

    private static BigInt intOp$4(BigInt v1, BigInt v2) {
        return v1.$minus(v2);
    }

    private static double doubleOp$4(double v1, double v2) {
        return v1 - v2;
    }

    public static class AbsType
    implements Value,
    Product,
    Serializable {
        private final Type.AbsType t;

        public static AbsType apply(Type.AbsType absType) {
            return Value$AbsType$.MODULE$.apply(absType);
        }

        public static AbsType fromProduct(Product product) {
            return Value$AbsType$.MODULE$.fromProduct(product);
        }

        public static AbsType unapply(AbsType absType) {
            return Value$AbsType$.MODULE$.unapply(absType);
        }

        public AbsType(Type.AbsType t) {
            this.t = t;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof AbsType)) return false;
            AbsType absType = (AbsType)object;
            Type.AbsType absType2 = this.t();
            Type.AbsType absType3 = absType.t();
            if (absType2 == null) {
                if (absType3 != null) {
                    return false;
                }
            } else if (!((Object)absType2).equals(absType3)) return false;
            if (!absType.canEqual(this)) return false;
            return true;
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof AbsType;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public java.lang.String productPrefix() {
            return "AbsType";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }
            return this._1();
        }

        @Override
        public java.lang.String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }
            return "t";
        }

        public Type.AbsType t() {
            return this.t;
        }

        @Override
        public Type getType() {
            return this.t();
        }

        public java.lang.String toString() {
            return new StringBuilder(14).append("value of type ").append(this.t()).toString();
        }

        public AbsType copy(Type.AbsType t) {
            return new AbsType(t);
        }

        public Type.AbsType copy$default$1() {
            return this.t();
        }

        public Type.AbsType _1() {
            return this.t();
        }
    }

    public static class AnonArray
    implements Value,
    Product,
    Serializable {
        private final List elements;

        public static AnonArray apply(List<Value> list) {
            return Value$AnonArray$.MODULE$.apply(list);
        }

        public static AnonArray fromProduct(Product product) {
            return Value$AnonArray$.MODULE$.fromProduct(product);
        }

        public static AnonArray unapply(AnonArray anonArray) {
            return Value$AnonArray$.MODULE$.unapply(anonArray);
        }

        public AnonArray(List<Value> elements) {
            this.elements = elements;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof AnonArray)) return false;
            AnonArray anonArray = (AnonArray)object;
            List<Value> list = this.elements();
            List<Value> list2 = anonArray.elements();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!((Object)list).equals(list2)) return false;
            if (!anonArray.canEqual(this)) return false;
            return true;
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof AnonArray;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public java.lang.String productPrefix() {
            return "AnonArray";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }
            return this._1();
        }

        @Override
        public java.lang.String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }
            return "elements";
        }

        public List<Value> elements() {
            return this.elements;
        }

        public Option<AnonArray> convertToAnonArray(Type.AnonArray anonArrayType) {
            Type.AnonArray anonArray = anonArrayType;
            if (anonArray == null) {
                throw new MatchError(anonArray);
            }
            Type.AnonArray anonArray2 = Type$AnonArray$.MODULE$.unapply(anonArray);
            Option<Object> option = anonArray2._1();
            Type type = anonArray2._2();
            Option<Object> size = option;
            Type eltType = type;
            Tuple2<Option<Object>, Type> tuple2 = Tuple2$.MODULE$.apply(size, eltType);
            Option<Object> size2 = tuple2._1();
            Type eltType2 = tuple2._2();
            return Type$Array$.MODULE$.sizesMatch(Some$.MODULE$.apply(BoxesRunTime.boxToInteger(this.elements().size())), size2) ? this.convertElements$1(this.elements(), eltType2, package$.MODULE$.Nil()).map((Function1<List, AnonArray> & Serializable)elements -> Value$AnonArray$.MODULE$.apply((List<Value>)elements)) : None$.MODULE$;
        }

        public Option<Array> convertToArray(Type.Array arrayType) {
            Type.Array array = arrayType;
            if (array == null) {
                throw new MatchError(array);
            }
            Type.Array array2 = Type$Array$.MODULE$.unapply(array);
            Tuple3<List<java.lang.String>, AstNode<Ast.DefArray>, List<java.lang.String>> tuple3 = array2._1();
            Type.AnonArray anonArray2 = array2._2();
            Option<Array> option = array2._3();
            Option<Format> option2 = array2._4();
            Type.AnonArray anonArrayType = anonArray2;
            Type.AnonArray anonArrayType2 = anonArrayType;
            return this.convertToAnonArray(anonArrayType2).map((Function1<AnonArray, Array> & Serializable)anonArray -> Value$Array$.MODULE$.apply((AnonArray)anonArray, arrayType));
        }

        @Override
        public Option<Value> convertToDistinctType(Type t) {
            Option option;
            Type type = t.getUnderlyingType();
            if (type instanceof Type.AnonArray) {
                Type.AnonArray anonArrayType = (Type.AnonArray)type;
                option = this.convertToAnonArray(anonArrayType);
            } else if (type instanceof Type.Array) {
                Type.Array arrayType = (Type.Array)type;
                option = this.convertToArray(arrayType);
            } else {
                option = None$.MODULE$;
            }
            return option;
        }

        @Override
        public Type getType() {
            return Type$AnonArray$.MODULE$.apply(Some$.MODULE$.apply(BoxesRunTime.boxToInteger(this.elements().size())), ((Value)this.elements().head()).getType());
        }

        public java.lang.String toString() {
            return StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString("[ "), this.elements().mkString(", "))), " ]");
        }

        @Override
        public AnonArray truncate() {
            return Value$AnonArray$.MODULE$.apply((List<Value>)this.elements().map((Function1<Value, Value> & Serializable)_$1 -> _$1.truncate()));
        }

        public AnonArray copy(List<Value> elements) {
            return new AnonArray(elements);
        }

        public List<Value> copy$default$1() {
            return this.elements();
        }

        public List<Value> _1() {
            return this.elements();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final Option convertElements$1(List in, Type t, List out) {
            Option<Value> option;
            Option option2;
            List<Value> list = out;
            Type type = t;
            List list2 = in;
            while (true) {
                List list3 = list2;
                Nil$ nil$ = package$.MODULE$.Nil();
                List list4 = list3;
                if (!(nil$ != null ? !((Object)nil$).equals(list4) : list4 != null)) {
                    option2 = Some$.MODULE$.apply(list.reverse());
                    return option2;
                }
                if (!(list3 instanceof $colon$colon)) throw new MatchError(list3);
                $colon$colon $colon$colon = ($colon$colon)list3;
                List list5 = $colon$colon.next$access$1();
                Value head = (Value)$colon$colon.head();
                List tail = list5;
                option = head.convertToType(type.getUnderlyingType());
                if (!(option instanceof Some)) break;
                Value v = (Value)((Some)option).value();
                List list6 = tail;
                Type type2 = type.getUnderlyingType();
                List<Value> list7 = list.$colon$colon(v);
                list2 = list6;
                type = type2;
                list = list7;
            }
            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            option2 = None$.MODULE$;
            return option2;
        }
    }

    public static class AnonStruct
    implements Value,
    Product,
    Serializable {
        private final Map members;

        public static AnonStruct apply(Map<java.lang.String, Value> map) {
            return Value$AnonStruct$.MODULE$.apply(map);
        }

        public static AnonStruct fromProduct(Product product) {
            return Value$AnonStruct$.MODULE$.fromProduct(product);
        }

        public static AnonStruct unapply(AnonStruct anonStruct) {
            return Value$AnonStruct$.MODULE$.unapply(anonStruct);
        }

        public AnonStruct(Map<java.lang.String, Value> members) {
            this.members = members;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof AnonStruct)) return false;
            AnonStruct anonStruct = (AnonStruct)object;
            Map<java.lang.String, Value> map = this.members();
            Map<java.lang.String, Value> map2 = anonStruct.members();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            if (!anonStruct.canEqual(this)) return false;
            return true;
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof AnonStruct;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public java.lang.String productPrefix() {
            return "AnonStruct";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }
            return this._1();
        }

        @Override
        public java.lang.String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }
            return "members";
        }

        public Map<java.lang.String, Value> members() {
            return this.members;
        }

        public Option<AnonStruct> convertToAnonStruct(Type.AnonStruct anonStructType) {
            return this.convertMembers$1(anonStructType.members().toList(), (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(new Tuple2[0]))).map((Function1<Map, AnonStruct> & Serializable)members -> Value$AnonStruct$.MODULE$.apply((Map<java.lang.String, Value>)members));
        }

        public Option<Struct> convertToStruct(Type.Struct structType) {
            Type.Struct struct = structType;
            if (struct == null) {
                throw new MatchError(struct);
            }
            Type.Struct struct2 = Type$Struct$.MODULE$.unapply(struct);
            Tuple3<List<java.lang.String>, AstNode<Ast.DefStruct>, List<java.lang.String>> tuple3 = struct2._1();
            Type.AnonStruct anonStruct2 = struct2._2();
            Option<Struct> option = struct2._3();
            Map<java.lang.String, Object> map = struct2._4();
            Map<java.lang.String, Format> map2 = struct2._5();
            Type.AnonStruct anonStructType = anonStruct2;
            Type.AnonStruct anonStructType2 = anonStructType;
            return this.convertToAnonStruct(anonStructType2).map((Function1<AnonStruct, Struct> & Serializable)anonStruct -> Value$Struct$.MODULE$.apply((AnonStruct)anonStruct, structType));
        }

        @Override
        public Option<Value> convertToDistinctType(Type t) {
            Option option;
            Type type = t.getUnderlyingType();
            if (type instanceof Type.AnonStruct) {
                Type.AnonStruct anonStructType = (Type.AnonStruct)type;
                option = this.convertToAnonStruct(anonStructType);
            } else if (type instanceof Type.Struct) {
                Type.Struct structType = (Type.Struct)type;
                option = this.convertToStruct(structType);
            } else {
                option = None$.MODULE$;
            }
            return option;
        }

        @Override
        public Type getType() {
            Map typeMembers = (Map)this.members().map((Function1<Tuple2, Tuple2> & Serializable)member -> this.f$1((Tuple2)member));
            return Type$AnonStruct$.MODULE$.apply(typeMembers);
        }

        public java.lang.String toString() {
            int n = this.members().size();
            return 0 == n ? "{ }" : StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString("{ "), ((IterableOnceOps)this.members().map((Function1<Tuple2, java.lang.String> & Serializable)member -> this.memberToString$1((Tuple2)member))).mkString(", "))), " }");
        }

        @Override
        public AnonStruct truncate() {
            return Value$AnonStruct$.MODULE$.apply((Map)this.members().map((Function1<Tuple2, Tuple2> & Serializable)member -> this.f$2((Tuple2)member)));
        }

        public AnonStruct copy(Map<java.lang.String, Value> members) {
            return new AnonStruct(members);
        }

        public Map<java.lang.String, Value> copy$default$1() {
            return this.members();
        }

        public Map<java.lang.String, Value> _1() {
            return this.members();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final Option convertMembers$1(List in, Map out) {
            Option<Value> option;
            Option option2;
            Map map = out;
            List list = in;
            while (true) {
                Option<Value> vOpt;
                Option<Value> option3;
                List list2 = list;
                Nil$ nil$ = package$.MODULE$.Nil();
                List list3 = list2;
                if (!(nil$ != null ? !((Object)nil$).equals(list3) : list3 != null)) {
                    option2 = Some$.MODULE$.apply(map);
                    return option2;
                }
                if (!(list2 instanceof $colon$colon)) throw new MatchError(list2);
                $colon$colon $colon$colon = ($colon$colon)list2;
                Tuple2 tuple2 = (Tuple2)$colon$colon.head();
                List list4 = $colon$colon.next$access$1();
                if (tuple2 == null) throw new MatchError(list2);
                java.lang.String m = (java.lang.String)tuple2._1();
                Type t = (Type)tuple2._2();
                List tail = list4;
                Option option4 = this.members().get(m);
                if (option4 instanceof Some) {
                    Value v = (Value)((Some)option4).value();
                    option3 = v.convertToType(t);
                } else {
                    if (!None$.MODULE$.equals(option4)) throw new MatchError(option4);
                    option3 = t.getDefaultValue();
                }
                option = vOpt = option3;
                if (!(option instanceof Some)) break;
                Value v = (Value)((Some)option).value();
                List list5 = tail;
                java.lang.String string2 = Predef$.MODULE$.ArrowAssoc(m);
                Map map2 = (Map)map.$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, v));
                list = list5;
                map = map2;
            }
            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            option2 = None$.MODULE$;
            return option2;
        }

        private final Tuple2 f$1(Tuple2 member) {
            return Tuple2$.MODULE$.apply(member._1(), ((Value)member._2()).getType());
        }

        private final java.lang.String memberToString$1(Tuple2 member) {
            return StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString((java.lang.String)member._1()), " = ")), member._2().toString());
        }

        private final Tuple2 f$2(Tuple2 member) {
            Tuple2 tuple2 = member;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            java.lang.String m = (java.lang.String)tuple2._1();
            Value v = (Value)tuple2._2();
            Tuple2<java.lang.String, Value> tuple22 = Tuple2$.MODULE$.apply(m, v);
            java.lang.String m2 = tuple22._1();
            Value v2 = tuple22._2();
            java.lang.String string2 = Predef$.MODULE$.ArrowAssoc(m2);
            return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, v2.truncate());
        }
    }

    public static class Array
    implements Value,
    Product,
    Serializable {
        private final AnonArray anonArray;
        private final Type.Array t;

        public static Array apply(AnonArray anonArray, Type.Array array) {
            return Value$Array$.MODULE$.apply(anonArray, array);
        }

        public static Array fromProduct(Product product) {
            return Value$Array$.MODULE$.fromProduct(product);
        }

        public static Array unapply(Array array) {
            return Value$Array$.MODULE$.unapply(array);
        }

        public Array(AnonArray anonArray, Type.Array t) {
            this.anonArray = anonArray;
            this.t = t;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Array)) return false;
            Array array = (Array)object;
            AnonArray anonArray = this.anonArray();
            AnonArray anonArray2 = array.anonArray();
            if (anonArray == null) {
                if (anonArray2 != null) {
                    return false;
                }
            } else if (!((Object)anonArray).equals(anonArray2)) return false;
            Type.Array array2 = this.t();
            Type.Array array3 = array.t();
            if (array2 == null) {
                if (array3 != null) {
                    return false;
                }
            } else if (!((Object)array2).equals(array3)) return false;
            if (!array.canEqual(this)) return false;
            return true;
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Array;
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public java.lang.String productPrefix() {
            return "Array";
        }

        @Override
        public Object productElement(int n) {
            Product product;
            int n2 = n;
            if (0 == n2) {
                product = this._1();
            } else if (1 == n2) {
                product = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }
            return product;
        }

        @Override
        public java.lang.String productElementName(int n) {
            java.lang.String string2;
            int n2 = n;
            if (0 == n2) {
                string2 = "anonArray";
            } else if (1 == n2) {
                string2 = "t";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }
            return string2;
        }

        public AnonArray anonArray() {
            return this.anonArray;
        }

        public Type.Array t() {
            return this.t;
        }

        public Option<AnonArray> convertToAnonArray(Type.AnonArray anonArrayType) {
            return this.anonArray().convertToAnonArray(anonArrayType);
        }

        public Option<Array> convertToArray(Type.Array arrayType) {
            return this.anonArray().convertToArray(arrayType);
        }

        @Override
        public Option<Value> convertToDistinctType(Type t) {
            Option option;
            Type type = t.getUnderlyingType();
            if (type instanceof Type.AnonArray) {
                Type.AnonArray anonArrayType = (Type.AnonArray)type;
                option = this.convertToAnonArray(anonArrayType);
            } else if (type instanceof Type.Array) {
                Type.Array arrayType = (Type.Array)type;
                option = this.convertToArray(arrayType);
            } else {
                option = None$.MODULE$;
            }
            return option;
        }

        @Override
        public Type getType() {
            return this.t();
        }

        public java.lang.String toString() {
            return StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(this.anonArray().toString()), ": ")), this.t().node()._2().data().name());
        }

        @Override
        public Array truncate() {
            return Value$Array$.MODULE$.apply(this.anonArray().truncate(), this.t());
        }

        public Array copy(AnonArray anonArray, Type.Array t) {
            return new Array(anonArray, t);
        }

        public AnonArray copy$default$1() {
            return this.anonArray();
        }

        public Type.Array copy$default$2() {
            return this.t();
        }

        public AnonArray _1() {
            return this.anonArray();
        }

        public Type.Array _2() {
            return this.t();
        }
    }

    public static class Binop
    implements Product,
    Serializable {
        private final Function2 intOp;
        private final Function2 doubleOp;

        public static Binop apply(Function2<BigInt, BigInt, BigInt> function2, Function2<Object, Object, Object> function22) {
            return Value$Binop$.MODULE$.apply(function2, function22);
        }

        public static Binop fromProduct(Product product) {
            return Value$Binop$.MODULE$.fromProduct(product);
        }

        public static Binop unapply(Binop binop) {
            return Value$Binop$.MODULE$.unapply(binop);
        }

        public Binop(Function2<BigInt, BigInt, BigInt> intOp, Function2<Object, Object, Object> doubleOp) {
            this.intOp = intOp;
            this.doubleOp = doubleOp;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Binop)) return false;
            Binop binop = (Binop)object;
            Function2<BigInt, BigInt, BigInt> function2 = this.intOp();
            Function2<BigInt, BigInt, BigInt> function22 = binop.intOp();
            if (function2 == null) {
                if (function22 != null) {
                    return false;
                }
            } else if (!function2.equals(function22)) return false;
            Function2<Object, Object, Object> function23 = this.doubleOp();
            Function2<Object, Object, Object> function24 = binop.doubleOp();
            if (function23 == null) {
                if (function24 != null) {
                    return false;
                }
            } else if (!function23.equals(function24)) return false;
            if (!binop.canEqual(this)) return false;
            return true;
        }

        public java.lang.String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Binop;
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public java.lang.String productPrefix() {
            return "Binop";
        }

        @Override
        public Object productElement(int n) {
            Function2<Object, Object, Object> function2;
            int n2 = n;
            if (0 == n2) {
                function2 = this._1();
            } else if (1 == n2) {
                function2 = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }
            return function2;
        }

        @Override
        public java.lang.String productElementName(int n) {
            java.lang.String string2;
            int n2 = n;
            if (0 == n2) {
                string2 = "intOp";
            } else if (1 == n2) {
                string2 = "doubleOp";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }
            return string2;
        }

        public Function2<BigInt, BigInt, BigInt> intOp() {
            return this.intOp;
        }

        public Function2<Object, Object, Object> doubleOp() {
            return this.doubleOp;
        }

        public Binop copy(Function2<BigInt, BigInt, BigInt> intOp, Function2<Object, Object, Object> doubleOp) {
            return new Binop(intOp, doubleOp);
        }

        public Function2<BigInt, BigInt, BigInt> copy$default$1() {
            return this.intOp();
        }

        public Function2<Object, Object, Object> copy$default$2() {
            return this.doubleOp();
        }

        public Function2<BigInt, BigInt, BigInt> _1() {
            return this.intOp();
        }

        public Function2<Object, Object, Object> _2() {
            return this.doubleOp();
        }
    }

    public static class Boolean
    implements Value,
    Product,
    Serializable {
        private final boolean value;

        public static Boolean apply(boolean bl) {
            return Value$Boolean$.MODULE$.apply(bl);
        }

        public static Boolean fromProduct(Product product) {
            return Value$Boolean$.MODULE$.fromProduct(product);
        }

        public static Boolean unapply(Boolean boolean_) {
            return Value$Boolean$.MODULE$.unapply(boolean_);
        }

        public Boolean(boolean value) {
            this.value = value;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, this.value() ? 1231 : 1237);
            return Statics.finalizeHash(n, 1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Boolean)) return false;
            Boolean boolean_ = (Boolean)object;
            if (this.value() != boolean_.value()) return false;
            if (!boolean_.canEqual(this)) return false;
            return true;
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Boolean;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public java.lang.String productPrefix() {
            return "Boolean";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }
            return BoxesRunTime.boxToBoolean(this._1());
        }

        @Override
        public java.lang.String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }
            return "value";
        }

        public boolean value() {
            return this.value;
        }

        @Override
        public Option<Value> convertToDistinctType(Type t) {
            return this.promoteToAggregate(t.getUnderlyingType());
        }

        @Override
        public Type getType() {
            return Type$Boolean$.MODULE$;
        }

        public java.lang.String toString() {
            return BoxesRunTime.boxToBoolean(this.value()).toString();
        }

        public Boolean copy(boolean value) {
            return new Boolean(value);
        }

        public boolean copy$default$1() {
            return this.value();
        }

        public boolean _1() {
            return this.value();
        }
    }

    public static class EnumConstant
    implements Value,
    Product,
    Serializable {
        private final Tuple2 value;
        private final Type.Enum t;

        public static EnumConstant apply(Tuple2<java.lang.String, BigInt> tuple2, Type.Enum enum_) {
            return Value$EnumConstant$.MODULE$.apply(tuple2, enum_);
        }

        public static EnumConstant fromProduct(Product product) {
            return Value$EnumConstant$.MODULE$.fromProduct(product);
        }

        public static EnumConstant unapply(EnumConstant enumConstant) {
            return Value$EnumConstant$.MODULE$.unapply(enumConstant);
        }

        public EnumConstant(Tuple2<java.lang.String, BigInt> value, Type.Enum t) {
            this.value = value;
            this.t = t;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof EnumConstant)) return false;
            EnumConstant enumConstant = (EnumConstant)object;
            Tuple2<java.lang.String, BigInt> tuple2 = this.value();
            Tuple2<java.lang.String, BigInt> tuple22 = enumConstant.value();
            if (tuple2 == null) {
                if (tuple22 != null) {
                    return false;
                }
            } else if (!((Object)tuple2).equals(tuple22)) return false;
            Type.Enum enum_ = this.t();
            Type.Enum enum_2 = enumConstant.t();
            if (enum_ == null) {
                if (enum_2 != null) {
                    return false;
                }
            } else if (!((Object)enum_).equals(enum_2)) return false;
            if (!enumConstant.canEqual(this)) return false;
            return true;
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof EnumConstant;
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public java.lang.String productPrefix() {
            return "EnumConstant";
        }

        @Override
        public Object productElement(int n) {
            Product product;
            int n2 = n;
            if (0 == n2) {
                product = this._1();
            } else if (1 == n2) {
                product = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }
            return product;
        }

        @Override
        public java.lang.String productElementName(int n) {
            java.lang.String string2;
            int n2 = n;
            if (0 == n2) {
                string2 = "value";
            } else if (1 == n2) {
                string2 = "t";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }
            return string2;
        }

        public Tuple2<java.lang.String, BigInt> value() {
            return this.value;
        }

        public Type.Enum t() {
            return this.t;
        }

        @Override
        public Option<Value> binop(Binop op, Value v) {
            return this.convertToRepType().binop(op, v);
        }

        public PrimitiveInt convertToRepType() {
            return Value$PrimitiveInt$.MODULE$.apply(this.value()._2(), this.t().repType().kind());
        }

        @Override
        public Option<Value> convertToDistinctType(Type t) {
            Some<Value> some;
            Option<Value> option = this.convertToRepType().convertToDistinctType(t.getUnderlyingType());
            if (option instanceof Some) {
                Value v = (Value)((Some)option).value();
                some = Some$.MODULE$.apply(v);
            } else if (None$.MODULE$.equals(option)) {
                some = this.promoteToAggregate(t);
            } else {
                throw new MatchError(option);
            }
            return some;
        }

        @Override
        public Type getType() {
            return this.t();
        }

        @Override
        public boolean isZero() {
            return this.convertToRepType().isZero();
        }

        public java.lang.String toString() {
            return StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(this.value().toString()), ": ")), this.t().node()._2().data().name());
        }

        @Override
        public Option<Value> unary_$minus() {
            return this.convertToRepType().unary_$minus();
        }

        public EnumConstant copy(Tuple2<java.lang.String, BigInt> value, Type.Enum t) {
            return new EnumConstant(value, t);
        }

        public Tuple2<java.lang.String, BigInt> copy$default$1() {
            return this.value();
        }

        public Type.Enum copy$default$2() {
            return this.t();
        }

        public Tuple2<java.lang.String, BigInt> _1() {
            return this.value();
        }

        public Type.Enum _2() {
            return this.t();
        }
    }

    public static class Float
    implements Value,
    Product,
    Serializable {
        private final double value;
        private final Type.Float.Kind kind;

        public static double EPSILON() {
            return Value$Float$.MODULE$.EPSILON();
        }

        public static Float apply(double d, Type.Float.Kind kind) {
            return Value$Float$.MODULE$.apply(d, kind);
        }

        public static Float fromProduct(Product product) {
            return Value$Float$.MODULE$.fromProduct(product);
        }

        public static Float unapply(Float float_) {
            return Value$Float$.MODULE$.unapply(float_);
        }

        public Float(double value, Type.Float.Kind kind) {
            this.value = value;
            this.kind = kind;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, Statics.doubleHash(this.value()));
            n = Statics.mix(n, Statics.anyHash(this.kind()));
            return Statics.finalizeHash(n, 2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Float)) return false;
            Float float_ = (Float)object;
            if (this.value() != float_.value()) return false;
            Type.Float.Kind kind = this.kind();
            Type.Float.Kind kind2 = float_.kind();
            if (kind == null) {
                if (kind2 != null) {
                    return false;
                }
            } else if (!kind.equals(kind2)) return false;
            if (!float_.canEqual(this)) return false;
            return true;
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Float;
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public java.lang.String productPrefix() {
            return "Float";
        }

        @Override
        public Object productElement(int n) {
            Object object;
            int n2 = n;
            if (0 == n2) {
                object = BoxesRunTime.boxToDouble(this._1());
            } else if (1 == n2) {
                object = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }
            return object;
        }

        @Override
        public java.lang.String productElementName(int n) {
            java.lang.String string2;
            int n2 = n;
            if (0 == n2) {
                string2 = "value";
            } else if (1 == n2) {
                string2 = "kind";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }
            return string2;
        }

        public double value() {
            return this.value;
        }

        public Type.Float.Kind kind() {
            return this.kind;
        }

        @Override
        public Option<Value> binop(Binop op, Value v) {
            Option option;
            Value value = v;
            if (value instanceof PrimitiveInt) {
                PrimitiveInt primitiveInt = Value$PrimitiveInt$.MODULE$.unapply((PrimitiveInt)value);
                BigInt bigInt = primitiveInt._1();
                Type.PrimitiveInt.Kind kind = primitiveInt._2();
                BigInt value1 = bigInt;
                Type.PrimitiveInt.Kind kind1 = kind;
                double result = op.doubleOp().apply$mcDDD$sp(this.value(), value1.toDouble());
                option = Some$.MODULE$.apply(Value$Float$.MODULE$.apply(Float$.MODULE$.float2double((float)result), Type$Float$F64$.MODULE$));
            } else if (value instanceof Integer) {
                BigInt bigInt;
                Integer integer = Value$Integer$.MODULE$.unapply((Integer)value);
                BigInt value1 = bigInt = integer._1();
                double result = op.doubleOp().apply$mcDDD$sp(this.value(), value1.toDouble());
                option = Some$.MODULE$.apply(Value$Float$.MODULE$.apply(result, Type$Float$F64$.MODULE$));
            } else if (value instanceof Float) {
                Float float_ = Value$Float$.MODULE$.unapply((Float)value);
                double d = float_._1();
                Type.Float.Kind kind = float_._2();
                double value1 = d;
                Type.Float.Kind kind1 = kind;
                double result1 = op.doubleOp().apply$mcDDD$sp(this.value(), value1);
                Type.Float.Kind kind2 = kind1;
                Type.Float.Kind kind3 = this.kind();
                Float result2 = !(kind2 != null ? !kind2.equals(kind3) : kind3 != null) ? Value$Float$.MODULE$.apply(result1, this.kind()) : Value$Float$.MODULE$.apply(result1, Type$Float$F64$.MODULE$);
                option = Some$.MODULE$.apply(result2);
            } else if (value instanceof EnumConstant) {
                EnumConstant enumConstant = (EnumConstant)value;
                option = this.binop(op, enumConstant.convertToRepType());
            } else {
                option = None$.MODULE$;
            }
            return option;
        }

        @Override
        public boolean isZero() {
            return Math.abs(this.value()) < Value$Float$.MODULE$.EPSILON();
        }

        @Override
        public Option<Value> convertToDistinctType(Type t) {
            Some<Value> some;
            Type type = t.getUnderlyingType();
            if (type instanceof Type.PrimitiveInt) {
                Type.PrimitiveInt.Kind kind;
                Type.PrimitiveInt primitiveInt = Type$PrimitiveInt$.MODULE$.unapply((Type.PrimitiveInt)type);
                Type.PrimitiveInt.Kind kind1 = kind = primitiveInt._1();
                some = Some$.MODULE$.apply(Value$PrimitiveInt$.MODULE$.apply(BigInt$.MODULE$.int2bigInt(Predef$.MODULE$.double2Double(this.value()).intValue()), kind1));
            } else if (Type$Integer$.MODULE$.equals(type)) {
                some = Some$.MODULE$.apply(Value$Integer$.MODULE$.apply(BigInt$.MODULE$.int2bigInt(Predef$.MODULE$.double2Double(this.value()).intValue())));
            } else if (type instanceof Type.Float) {
                Type.Float.Kind kind;
                Type.Float float_ = Type$Float$.MODULE$.unapply((Type.Float)type);
                Type.Float.Kind kind1 = kind = float_._1();
                some = Some$.MODULE$.apply(Value$Float$.MODULE$.apply(this.value(), kind1));
            } else {
                some = this.promoteToAggregate(t);
            }
            return some;
        }

        @Override
        public Type getType() {
            return Type$Float$.MODULE$.apply(this.kind());
        }

        public java.lang.String toString() {
            return new StringBuilder(2).append(BoxesRunTime.boxToDouble(this.value()).toString()).append(": ").append(this.kind().toString()).toString();
        }

        @Override
        public Value truncate() {
            Float float_;
            Type.Float.Kind kind = this.kind();
            if (Type$Float$F32$.MODULE$.equals(kind)) {
                float_ = Value$Float$.MODULE$.apply(Float$.MODULE$.float2double((float)this.value()), this.kind());
            } else if (Type$Float$F64$.MODULE$.equals(kind)) {
                float_ = this;
            } else {
                throw new MatchError(kind);
            }
            return float_;
        }

        @Override
        public Option<Value> unary_$minus() {
            return Some$.MODULE$.apply(Value$Float$.MODULE$.apply(-this.value(), this.kind()));
        }

        public Float copy(double value, Type.Float.Kind kind) {
            return new Float(value, kind);
        }

        public double copy$default$1() {
            return this.value();
        }

        public Type.Float.Kind copy$default$2() {
            return this.kind();
        }

        public double _1() {
            return this.value();
        }

        public Type.Float.Kind _2() {
            return this.kind();
        }
    }

    public static class Integer
    implements Value,
    Product,
    Serializable {
        private final BigInt value;

        public static Integer apply(BigInt bigInt) {
            return Value$Integer$.MODULE$.apply(bigInt);
        }

        public static Integer fromProduct(Product product) {
            return Value$Integer$.MODULE$.fromProduct(product);
        }

        public static Integer unapply(Integer integer) {
            return Value$Integer$.MODULE$.unapply(integer);
        }

        public Integer(BigInt value) {
            this.value = value;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Integer)) return false;
            Integer integer = (Integer)object;
            BigInt bigInt = this.value();
            BigInt bigInt2 = integer.value();
            if (bigInt == null) {
                if (bigInt2 != null) {
                    return false;
                }
            } else if (!((Object)bigInt).equals(bigInt2)) return false;
            if (!integer.canEqual(this)) return false;
            return true;
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Integer;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public java.lang.String productPrefix() {
            return "Integer";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }
            return this._1();
        }

        @Override
        public java.lang.String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }
            return "value";
        }

        public BigInt value() {
            return this.value;
        }

        public boolean fitsInU64Width() {
            BigInt u64Bound = package$.MODULE$.BigInt().apply(1).$less$less(64);
            return this.value().$greater$eq(u64Bound.$div(BigInt$.MODULE$.int2bigInt(2)).unary_$minus()) && this.value().$less(u64Bound);
        }

        @Override
        public Option<Value> binop(Binop op, Value v) {
            Option option;
            Value value = v;
            if (value instanceof PrimitiveInt) {
                PrimitiveInt primitiveInt = Value$PrimitiveInt$.MODULE$.unapply((PrimitiveInt)value);
                BigInt bigInt = primitiveInt._1();
                Type.PrimitiveInt.Kind kind = primitiveInt._2();
                BigInt value1 = bigInt;
                Type.PrimitiveInt.Kind kind1 = kind;
                BigInt result = op.intOp().apply(this.value(), value1);
                option = Some$.MODULE$.apply(Value$Integer$.MODULE$.apply(result));
            } else if (value instanceof Integer) {
                BigInt bigInt;
                Integer integer = Value$Integer$.MODULE$.unapply((Integer)value);
                BigInt value1 = bigInt = integer._1();
                option = Some$.MODULE$.apply(Value$Integer$.MODULE$.apply(op.intOp().apply(this.value(), value1)));
            } else if (value instanceof Float) {
                Float float_ = Value$Float$.MODULE$.unapply((Float)value);
                double d = float_._1();
                Type.Float.Kind kind = float_._2();
                double value1 = d;
                Type.Float.Kind kind1 = kind;
                double result = op.doubleOp().apply$mcDDD$sp(Float$.MODULE$.float2double(this.value().toFloat()), value1);
                option = Some$.MODULE$.apply(Value$Float$.MODULE$.apply(Float$.MODULE$.float2double((float)result), Type$Float$F64$.MODULE$));
            } else if (value instanceof EnumConstant) {
                EnumConstant enumConstant = (EnumConstant)value;
                option = this.binop(op, enumConstant.convertToRepType());
            } else {
                option = None$.MODULE$;
            }
            return option;
        }

        @Override
        public Option<Value> convertToDistinctType(Type t) {
            Some<Value> some;
            Type type = t.getUnderlyingType();
            if (type instanceof Type.PrimitiveInt) {
                Type.PrimitiveInt.Kind kind;
                Type.PrimitiveInt primitiveInt = Type$PrimitiveInt$.MODULE$.unapply((Type.PrimitiveInt)type);
                Type.PrimitiveInt.Kind kind1 = kind = primitiveInt._1();
                some = Some$.MODULE$.apply(Value$PrimitiveInt$.MODULE$.apply(this.value(), kind1));
            } else if (Type$Integer$.MODULE$.equals(type)) {
                some = Some$.MODULE$.apply(Value$Integer$.MODULE$.apply(this.value()));
            } else if (type instanceof Type.Float) {
                Type.Float.Kind kind;
                Type.Float float_ = Type$Float$.MODULE$.unapply((Type.Float)type);
                Type.Float.Kind kind1 = kind = float_._1();
                some = Some$.MODULE$.apply(Value$Float$.MODULE$.apply(this.value().doubleValue(), kind1));
            } else {
                some = this.promoteToAggregate(t);
            }
            return some;
        }

        @Override
        public Type getType() {
            return Type$Integer$.MODULE$;
        }

        @Override
        public boolean isZero() {
            return BoxesRunTime.equals(this.value(), BoxesRunTime.boxToInteger(0));
        }

        public java.lang.String toString() {
            return this.value().toString();
        }

        @Override
        public Option<Value> unary_$minus() {
            return Some$.MODULE$.apply(Value$Integer$.MODULE$.apply(this.value().unary_$minus()));
        }

        public Integer copy(BigInt value) {
            return new Integer(value);
        }

        public BigInt copy$default$1() {
            return this.value();
        }

        public BigInt _1() {
            return this.value();
        }
    }

    public static class PrimitiveInt
    implements Value,
    Product,
    Serializable {
        private final BigInt value;
        private final Type.PrimitiveInt.Kind kind;

        public static PrimitiveInt apply(BigInt bigInt, Type.PrimitiveInt.Kind kind) {
            return Value$PrimitiveInt$.MODULE$.apply(bigInt, kind);
        }

        public static PrimitiveInt fromProduct(Product product) {
            return Value$PrimitiveInt$.MODULE$.fromProduct(product);
        }

        public static PrimitiveInt unapply(PrimitiveInt primitiveInt) {
            return Value$PrimitiveInt$.MODULE$.unapply(primitiveInt);
        }

        public PrimitiveInt(BigInt value, Type.PrimitiveInt.Kind kind) {
            this.value = value;
            this.kind = kind;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PrimitiveInt)) return false;
            PrimitiveInt primitiveInt = (PrimitiveInt)object;
            BigInt bigInt = this.value();
            BigInt bigInt2 = primitiveInt.value();
            if (bigInt == null) {
                if (bigInt2 != null) {
                    return false;
                }
            } else if (!((Object)bigInt).equals(bigInt2)) return false;
            Type.PrimitiveInt.Kind kind = this.kind();
            Type.PrimitiveInt.Kind kind2 = primitiveInt.kind();
            if (kind == null) {
                if (kind2 != null) {
                    return false;
                }
            } else if (!kind.equals(kind2)) return false;
            if (!primitiveInt.canEqual(this)) return false;
            return true;
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof PrimitiveInt;
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public java.lang.String productPrefix() {
            return "PrimitiveInt";
        }

        @Override
        public Object productElement(int n) {
            Object object;
            int n2 = n;
            if (0 == n2) {
                object = this._1();
            } else if (1 == n2) {
                object = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }
            return object;
        }

        @Override
        public java.lang.String productElementName(int n) {
            java.lang.String string2;
            int n2 = n;
            if (0 == n2) {
                string2 = "value";
            } else if (1 == n2) {
                string2 = "kind";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }
            return string2;
        }

        public BigInt value() {
            return this.value;
        }

        public Type.PrimitiveInt.Kind kind() {
            return this.kind;
        }

        @Override
        public Option<Value> binop(Binop op, Value v) {
            Option option;
            Value value = v;
            if (value instanceof PrimitiveInt) {
                PrimitiveInt primitiveInt = Value$PrimitiveInt$.MODULE$.unapply((PrimitiveInt)value);
                BigInt bigInt = primitiveInt._1();
                Type.PrimitiveInt.Kind kind = primitiveInt._2();
                BigInt value1 = bigInt;
                Type.PrimitiveInt.Kind kind1 = kind;
                BigInt result1 = op.intOp().apply(this.value(), value1);
                Type.PrimitiveInt.Kind kind2 = kind1;
                Type.PrimitiveInt.Kind kind3 = this.kind();
                Value result2 = !(kind2 != null ? !kind2.equals(kind3) : kind3 != null) ? Value$PrimitiveInt$.MODULE$.apply(result1, this.kind()) : Value$Integer$.MODULE$.apply(result1);
                option = Some$.MODULE$.apply(result2);
            } else if (value instanceof Integer) {
                BigInt bigInt;
                Integer integer = Value$Integer$.MODULE$.unapply((Integer)value);
                BigInt value1 = bigInt = integer._1();
                option = Some$.MODULE$.apply(Value$Integer$.MODULE$.apply(op.intOp().apply(this.value(), value1)));
            } else if (value instanceof Float) {
                Float float_ = Value$Float$.MODULE$.unapply((Float)value);
                double d = float_._1();
                Type.Float.Kind kind = float_._2();
                double value1 = d;
                Type.Float.Kind kind1 = kind;
                double result = op.doubleOp().apply$mcDDD$sp(Float$.MODULE$.float2double(this.value().toFloat()), value1);
                option = Some$.MODULE$.apply(Value$Float$.MODULE$.apply(Float$.MODULE$.float2double((float)result), Type$Float$F64$.MODULE$));
            } else if (value instanceof EnumConstant) {
                EnumConstant enumConstant = (EnumConstant)value;
                option = this.binop(op, enumConstant.convertToRepType());
            } else {
                option = None$.MODULE$;
            }
            return option;
        }

        @Override
        public Option<Value> convertToDistinctType(Type t) {
            Some<Value> some;
            Type type = t.getUnderlyingType();
            if (type instanceof Type.PrimitiveInt) {
                Type.PrimitiveInt.Kind kind;
                Type.PrimitiveInt primitiveInt = Type$PrimitiveInt$.MODULE$.unapply((Type.PrimitiveInt)type);
                Type.PrimitiveInt.Kind kind1 = kind = primitiveInt._1();
                some = Some$.MODULE$.apply(Value$PrimitiveInt$.MODULE$.apply(this.value(), kind1));
            } else if (Type$Integer$.MODULE$.equals(type)) {
                some = Some$.MODULE$.apply(Value$Integer$.MODULE$.apply(this.value()));
            } else if (type instanceof Type.Float) {
                Type.Float.Kind kind;
                Type.Float float_ = Type$Float$.MODULE$.unapply((Type.Float)type);
                Type.Float.Kind kind1 = kind = float_._1();
                some = Some$.MODULE$.apply(Value$Float$.MODULE$.apply(this.value().doubleValue(), kind1));
            } else {
                some = this.promoteToAggregate(t);
            }
            return some;
        }

        @Override
        public Type getType() {
            return Type$PrimitiveInt$.MODULE$.apply(this.kind());
        }

        @Override
        public boolean isZero() {
            return BoxesRunTime.equals(this.value(), BoxesRunTime.boxToInteger(0));
        }

        public java.lang.String toString() {
            return new StringBuilder(2).append(this.value().toString()).append(": ").append(this.kind().toString()).toString();
        }

        @Override
        public PrimitiveInt truncate() {
            BigInt bigInt;
            Type.PrimitiveInt.Kind kind = this.kind();
            if (Type$PrimitiveInt$I8$.MODULE$.equals(kind)) {
                bigInt = package$.MODULE$.BigInt().apply(Byte$.MODULE$.byte2int(this.value().toByte()));
            } else if (Type$PrimitiveInt$I16$.MODULE$.equals(kind)) {
                bigInt = package$.MODULE$.BigInt().apply(Short$.MODULE$.short2int(this.value().toShort()));
            } else if (Type$PrimitiveInt$I32$.MODULE$.equals(kind)) {
                bigInt = package$.MODULE$.BigInt().apply(this.value().toInt());
            } else if (Type$PrimitiveInt$I64$.MODULE$.equals(kind)) {
                bigInt = package$.MODULE$.BigInt().apply(this.value().toLong());
            } else if (Type$PrimitiveInt$U8$.MODULE$.equals(kind)) {
                bigInt = this.truncateUnsigned$1(this.value(), 8);
            } else if (Type$PrimitiveInt$U16$.MODULE$.equals(kind)) {
                bigInt = this.truncateUnsigned$1(this.value(), 16);
            } else if (Type$PrimitiveInt$U32$.MODULE$.equals(kind)) {
                bigInt = this.truncateUnsigned$1(this.value(), 32);
            } else if (Type$PrimitiveInt$U64$.MODULE$.equals(kind)) {
                bigInt = this.truncateUnsigned$1(this.value(), 64);
            } else {
                throw new MatchError(kind);
            }
            BigInt v = bigInt;
            return Value$PrimitiveInt$.MODULE$.apply(v, this.kind());
        }

        @Override
        public Option<Value> unary_$minus() {
            return Some$.MODULE$.apply(Value$PrimitiveInt$.MODULE$.apply(this.value().unary_$minus(), this.kind()));
        }

        public PrimitiveInt copy(BigInt value, Type.PrimitiveInt.Kind kind) {
            return new PrimitiveInt(value, kind);
        }

        public BigInt copy$default$1() {
            return this.value();
        }

        public Type.PrimitiveInt.Kind copy$default$2() {
            return this.kind();
        }

        public BigInt _1() {
            return this.value();
        }

        public Type.PrimitiveInt.Kind _2() {
            return this.kind();
        }

        private final BigInt truncateUnsigned$1(BigInt v, int shiftAmt) {
            BigInt modulus = package$.MODULE$.BigInt().apply(1).$less$less(shiftAmt);
            BigInt truncated = v.$percent(modulus);
            return truncated.$less(BigInt$.MODULE$.int2bigInt(0)) ? truncated.$plus(modulus) : truncated;
        }
    }

    public static class String
    implements Value,
    Product,
    Serializable {
        private final java.lang.String value;

        public static String apply(java.lang.String string2) {
            return Value$String$.MODULE$.apply(string2);
        }

        public static String fromProduct(Product product) {
            return Value$String$.MODULE$.fromProduct(product);
        }

        public static String unapply(String string2) {
            return Value$String$.MODULE$.unapply(string2);
        }

        public String(java.lang.String value) {
            this.value = value;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof String)) return false;
            String string2 = (String)object;
            java.lang.String string3 = this.value();
            java.lang.String string4 = string2.value();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (!string2.canEqual(this)) return false;
            return true;
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof String;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public java.lang.String productPrefix() {
            return "String";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }
            return this._1();
        }

        @Override
        public java.lang.String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }
            return "value";
        }

        public java.lang.String value() {
            return this.value;
        }

        @Override
        public Option<Value> convertToDistinctType(Type t) {
            Some<String> some;
            Type type = t.getUnderlyingType();
            if (type instanceof Type.String) {
                Type.String string2 = Type$String$.MODULE$.unapply((Type.String)type);
                Option<AstNode<Ast.Expr>> option = string2._1();
                some = Some$.MODULE$.apply(this);
            } else {
                some = this.promoteToAggregate(t);
            }
            return some;
        }

        @Override
        public Type getType() {
            return Type$String$.MODULE$.apply(None$.MODULE$);
        }

        public java.lang.String toString() {
            return new StringBuilder(2).append("\"").append(this.value().toString()).append("\"").toString();
        }

        public String copy(java.lang.String value) {
            return new String(value);
        }

        public java.lang.String copy$default$1() {
            return this.value();
        }

        public java.lang.String _1() {
            return this.value();
        }
    }

    public static class Struct
    implements Value,
    Product,
    Serializable {
        private final AnonStruct anonStruct;
        private final Type.Struct t;

        public static Struct apply(AnonStruct anonStruct, Type.Struct struct) {
            return Value$Struct$.MODULE$.apply(anonStruct, struct);
        }

        public static Struct fromProduct(Product product) {
            return Value$Struct$.MODULE$.fromProduct(product);
        }

        public static Struct unapply(Struct struct) {
            return Value$Struct$.MODULE$.unapply(struct);
        }

        public Struct(AnonStruct anonStruct, Type.Struct t) {
            this.anonStruct = anonStruct;
            this.t = t;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Struct)) return false;
            Struct struct = (Struct)object;
            AnonStruct anonStruct = this.anonStruct();
            AnonStruct anonStruct2 = struct.anonStruct();
            if (anonStruct == null) {
                if (anonStruct2 != null) {
                    return false;
                }
            } else if (!((Object)anonStruct).equals(anonStruct2)) return false;
            Type.Struct struct2 = this.t();
            Type.Struct struct3 = struct.t();
            if (struct2 == null) {
                if (struct3 != null) {
                    return false;
                }
            } else if (!((Object)struct2).equals(struct3)) return false;
            if (!struct.canEqual(this)) return false;
            return true;
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Struct;
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public java.lang.String productPrefix() {
            return "Struct";
        }

        @Override
        public Object productElement(int n) {
            Product product;
            int n2 = n;
            if (0 == n2) {
                product = this._1();
            } else if (1 == n2) {
                product = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }
            return product;
        }

        @Override
        public java.lang.String productElementName(int n) {
            java.lang.String string2;
            int n2 = n;
            if (0 == n2) {
                string2 = "anonStruct";
            } else if (1 == n2) {
                string2 = "t";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }
            return string2;
        }

        public AnonStruct anonStruct() {
            return this.anonStruct;
        }

        public Type.Struct t() {
            return this.t;
        }

        public Option<AnonStruct> convertToAnonStruct(Type.AnonStruct anonStructType) {
            return this.anonStruct().convertToAnonStruct(anonStructType);
        }

        public Option<Struct> convertToStruct(Type.Struct structType) {
            return this.anonStruct().convertToStruct(structType);
        }

        @Override
        public Option<Value> convertToDistinctType(Type t) {
            Option option;
            Type type = t.getUnderlyingType();
            if (type instanceof Type.AnonStruct) {
                Type.AnonStruct anonStructType = (Type.AnonStruct)type;
                option = this.convertToAnonStruct(anonStructType);
            } else if (type instanceof Type.Struct) {
                Type.Struct structType = (Type.Struct)type;
                option = this.convertToStruct(structType);
            } else {
                option = None$.MODULE$;
            }
            return option;
        }

        @Override
        public Type.Struct getType() {
            return this.t();
        }

        public java.lang.String toString() {
            return StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(this.anonStruct().toString()), ": ")), this.t().node()._2().data().name());
        }

        @Override
        public Value truncate() {
            return Value$Struct$.MODULE$.apply(this.anonStruct().truncate(), this.t());
        }

        public Struct copy(AnonStruct anonStruct, Type.Struct t) {
            return new Struct(anonStruct, t);
        }

        public AnonStruct copy$default$1() {
            return this.anonStruct();
        }

        public Type.Struct copy$default$2() {
            return this.t();
        }

        public AnonStruct _1() {
            return this.anonStruct();
        }

        public Type.Struct _2() {
            return this.t();
        }
    }
}

