/*
 * Decompiled with CFR 0.152.
 */
package fpp.compiler.codegen;

import fpp.compiler.analysis.Event;
import fpp.compiler.analysis.PortInstance;
import fpp.compiler.analysis.Symbol;
import fpp.compiler.analysis.TlmChannel;
import fpp.compiler.analysis.Type;
import fpp.compiler.ast.Ast;
import fpp.compiler.ast.AstNode;
import fpp.compiler.codegen.AnnotationCppWriter$;
import fpp.compiler.codegen.ComponentGTestBaseWriter$;
import fpp.compiler.codegen.ComponentTestUtils;
import fpp.compiler.codegen.ComputeCppFiles$FileNames$;
import fpp.compiler.codegen.CppDoc;
import fpp.compiler.codegen.CppDoc$Function$Const$;
import fpp.compiler.codegen.CppDoc$Function$NonSV$;
import fpp.compiler.codegen.CppDoc$Function$Param$;
import fpp.compiler.codegen.CppDoc$Lines$Cpp$;
import fpp.compiler.codegen.CppDoc$Type$;
import fpp.compiler.codegen.CppDocWriter$;
import fpp.compiler.codegen.CppWriter$;
import fpp.compiler.codegen.CppWriterState;
import fpp.compiler.codegen.Line;
import fpp.compiler.codegen.Line$;
import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.AbstractIterable;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.StrictOptimizedSeqOps;
import scala.math.BigInt;
import scala.math.Ordering$String$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;

public class ComponentGTestBaseWriter
extends ComponentTestUtils
implements Product,
Serializable {
    private final CppWriterState s;
    private final Tuple3 aNode;
    private final String fileName;
    private final String name;
    private final List<String> namespaceIdentList;
    private final String relativeFileName;
    private final Symbol.Component symbol;
    private final String testerRelativeFileName;

    public static ComponentGTestBaseWriter apply(CppWriterState cppWriterState, Tuple3<List<String>, AstNode<Ast.DefComponent>, List<String>> tuple3) {
        return ComponentGTestBaseWriter$.MODULE$.apply(cppWriterState, tuple3);
    }

    public static ComponentGTestBaseWriter fromProduct(Product product) {
        return ComponentGTestBaseWriter$.MODULE$.fromProduct(product);
    }

    public static ComponentGTestBaseWriter unapply(ComponentGTestBaseWriter componentGTestBaseWriter) {
        return ComponentGTestBaseWriter$.MODULE$.unapply(componentGTestBaseWriter);
    }

    public ComponentGTestBaseWriter(CppWriterState s, Tuple3<List<String>, AstNode<Ast.DefComponent>, List<String>> aNode) {
        this.s = s;
        this.aNode = aNode;
        super(s, aNode);
        this.fileName = ComputeCppFiles$FileNames$.MODULE$.getComponentGTestBase(this.componentName());
        this.name = this.componentName();
        this.namespaceIdentList = this.componentNamespaceIdentList();
        this.relativeFileName = s.getRelativePath(this.fileName).toString();
        this.symbol = this.componentSymbol();
        String testerFileName = ComputeCppFiles$FileNames$.MODULE$.getComponentTesterBase(this.componentName());
        this.testerRelativeFileName = s.getRelativePath(testerFileName).toString();
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof ComponentGTestBaseWriter)) return false;
        ComponentGTestBaseWriter componentGTestBaseWriter = (ComponentGTestBaseWriter)object;
        CppWriterState cppWriterState = this.s();
        CppWriterState cppWriterState2 = componentGTestBaseWriter.s();
        if (cppWriterState == null) {
            if (cppWriterState2 != null) {
                return false;
            }
        } else if (!((Object)cppWriterState).equals(cppWriterState2)) return false;
        Tuple3<List<String>, AstNode<Ast.DefComponent>, List<String>> tuple3 = this.aNode();
        Tuple3<List<String>, AstNode<Ast.DefComponent>, List<String>> tuple32 = componentGTestBaseWriter.aNode();
        if (tuple3 == null) {
            if (tuple32 != null) {
                return false;
            }
        } else if (!((Object)tuple3).equals(tuple32)) return false;
        if (!componentGTestBaseWriter.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString(this);
    }

    @Override
    public boolean canEqual(Object that) {
        return that instanceof ComponentGTestBaseWriter;
    }

    @Override
    public int productArity() {
        return 2;
    }

    @Override
    public String productPrefix() {
        return "ComponentGTestBaseWriter";
    }

    @Override
    public Object productElement(int n) {
        Product product;
        int n2 = n;
        if (0 == n2) {
            product = this._1();
        } else if (1 == n2) {
            product = this._2();
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }
        return product;
    }

    @Override
    public String productElementName(int n) {
        String string2;
        int n2 = n;
        if (0 == n2) {
            string2 = "s";
        } else if (1 == n2) {
            string2 = "aNode";
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }
        return string2;
    }

    public CppWriterState s() {
        return this.s;
    }

    public Tuple3<List<String>, AstNode<Ast.DefComponent>, List<String>> aNode() {
        return this.aNode;
    }

    public CppDoc write() {
        String includeGuard = this.s().includeGuardFromQualifiedName(this.symbol, this.fileName, this.s().includeGuardFromQualifiedName$default$3());
        return CppWriter$.MODULE$.createCppDoc(new StringBuilder(41).append(this.name).append(" component Google Test harness base class").toString(), this.fileName, includeGuard, this.getMembers(), this.s().toolName(), CppWriter$.MODULE$.createCppDoc$default$6(), CppWriter$.MODULE$.createCppDoc$default$7());
    }

    private List<CppDoc.Member> getMembers() {
        CppDoc.Member.Class cls = this.classMember(Some$.MODULE$.apply(new StringBuilder(69).append("\\class ").append(this.gTestClassName()).append("\n\\brief Auto-generated base for ").append(this.name).append(" component Google Test harness").toString()), this.gTestClassName(), Some$.MODULE$.apply(new StringBuilder(7).append("public ").append(this.testerBaseClassName()).toString()), (List)this.getClassMembers(), this.classMember$default$5());
        return (List)package$.MODULE$.List().concat(ScalaRunTime$.MODULE$.wrapRefArray(new Iterable[]{(Iterable)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new CppDoc.Member.Lines[]{this.getHppIncludes(), this.getCppIncludes()})), this.getMacros(), this.wrapInNamespaces((List)this.namespaceIdentList, (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new CppDoc.Member.Class[]{cls})))}));
    }

    private CppDoc.Member.Lines getHppIncludes() {
        Object userHeaders = ((List)((List)((StrictOptimizedSeqOps)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new String[]{new StringBuilder(4).append(this.testerRelativeFileName).append(".hpp").toString(), "gtest/gtest.h"}))).sorted(Ordering$String$.MODULE$)).map(CppWriter$.MODULE$.headerString())).map((Function1<String, Line> & Serializable)s -> this.line((String)s));
        return this.linesMember((List)this.addBlankPrefix().apply(userHeaders), this.linesMember$default$2(), this.linesMember$default$3());
    }

    private CppDoc.Member.Lines getCppIncludes() {
        List userHeader = this.lines(CppWriter$.MODULE$.headerString().apply(new StringBuilder(4).append(this.relativeFileName).append(".hpp").toString()));
        return this.linesMember((List)this.addBlankPrefix().apply(userHeader), (CppDoc.Lines.Output)CppDoc$Lines$Cpp$.MODULE$, this.linesMember$default$3());
    }

    private List<CppDoc.Member> getMacros() {
        return (List)package$.MODULE$.List().concat(ScalaRunTime$.MODULE$.wrapRefArray(new Iterable[]{(Iterable)((Function1)this.guardedList().apply(BoxesRunTime.boxToBoolean(this.hasTypedOutputPorts()))).apply(this::getMacros$$anonfun$1), (Iterable)((Function1)this.guardedList().apply(BoxesRunTime.boxToBoolean(this.hasCommands()))).apply(this::getMacros$$anonfun$2), (Iterable)((Function1)this.guardedList().apply(BoxesRunTime.boxToBoolean(this.hasEvents()))).apply(this::getMacros$$anonfun$3), (Iterable)((Function1)this.guardedList().apply(BoxesRunTime.boxToBoolean(this.hasTelemetry()))).apply(this::getMacros$$anonfun$4), (Iterable)((Function1)this.guardedList().apply(BoxesRunTime.boxToBoolean(this.hasDataProducts()))).apply(this::getMacros$$anonfun$5)}));
    }

    private List<CppDoc.Class.Member> getClassMembers() {
        return (List)package$.MODULE$.List().concat(ScalaRunTime$.MODULE$.wrapRefArray(new Iterable[]{this.getConstructors(), (Iterable)((Function1)this.guardedList().apply(BoxesRunTime.boxToBoolean(this.hasTypedOutputPorts()))).apply(this::getClassMembers$$anonfun$1), (Iterable)((Function1)this.guardedList().apply(BoxesRunTime.boxToBoolean(this.hasCommands()))).apply(this::getClassMembers$$anonfun$2), (Iterable)((Function1)this.guardedList().apply(BoxesRunTime.boxToBoolean(this.hasEvents()))).apply(this::getClassMembers$$anonfun$3), (Iterable)((Function1)this.guardedList().apply(BoxesRunTime.boxToBoolean(this.hasTelemetry()))).apply(this::getClassMembers$$anonfun$4), (Iterable)((Function1)this.guardedList().apply(BoxesRunTime.boxToBoolean(this.hasDataProducts()))).apply(this::getClassMembers$$anonfun$5)}));
    }

    private List<CppDoc.Class.Member> getConstructors() {
        return this.addAccessTagAndComment("protected", "Construction and destruction", (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new CppDoc.Class.Member[]{this.constructorClassMember(Some$.MODULE$.apply(new StringBuilder(17).append("Construct object ").append(this.gTestClassName()).toString()), (List)this.constructorParams(), (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new String[]{new StringBuilder(26).append(this.testerBaseClassName()).append("(compName, maxHistorySize)").toString()})), (List)package$.MODULE$.Nil(), this.constructorClassMember$default$5(), this.constructorClassMember$default$6()), this.destructorClassMember(Some$.MODULE$.apply(new StringBuilder(15).append("Destroy object ").append(this.gTestClassName()).toString()), (List)package$.MODULE$.Nil(), this.destructorClassMember$default$3(), this.destructorClassMember$default$4())})), this.addAccessTagAndComment$default$4(), this.addAccessTagAndComment$default$5());
    }

    private List<CppDoc.Member.Lines> getPortMacros() {
        CppDoc.Member.Lines[] linesArray = new CppDoc.Member.Lines[1];
        Iterable[] iterableArray = new Iterable[3];
        iterableArray[0] = CppDocWriter$.MODULE$.writeBannerComment("Macros for typed user from port history assertions");
        Line line = Line$.MODULE$.blank();
        iterableArray[1] = this.lines("#define ASSERT_FROM_PORT_HISTORY_SIZE(size) \\\n            |  this->assertFromPortHistory_size(__FILE__, __LINE__, size)\n            |").$colon$colon(line);
        iterableArray[2] = this.typedOutputPorts().flatMap((Function1<PortInstance.General, IterableOnce> & Serializable)p -> {
            List params = (List)this.portParamTypeMap().apply(p.getUnqualifiedName());
            String paramList = ((AbstractIterable)params.map((Function1<Tuple3, String> & Serializable)x$1 -> new StringBuilder(3).append(", _").append(ComponentGTestBaseWriter.name$1(x$1)).toString())).mkString("");
            String portName = p.getUnqualifiedName();
            String historyName = this.fromPortHistoryName(portName);
            String sizeAssertFnName = this.fromPortSizeAssertionFuncName(portName);
            String entryName = this.fromPortEntryName(portName);
            Iterable[] iterableArray = new Iterable[3];
            Line line = Line$.MODULE$.blank();
            iterableArray[0] = this.lines(new StringBuilder(105).append("#define ASSERT_from_").append(portName).append("_SIZE(size) \\\n                 |  this->").append(sizeAssertFnName).append("(__FILE__, __LINE__, size)\n                 |").toString()).$colon$colon(line);
            iterableArray[1] = (Iterable)this.addBlankPrefix().apply(this.lines(new StringBuilder(608).append("#define ASSERT_from_").append(portName).append("(index").append(paramList).append(") \\\n                   |  { \\\n                   |    ASSERT_GT(this->").append(historyName).append("->size(), static_cast<U32>(index)) \\\n                   |      << \"\\n\" \\\n                   |      << __FILE__ << \":\" << __LINE__ << \"\\n\" \\\n                   |      << \"  Value:    Index into history of ").append(portName).append("\\n\" \\\n                   |      << \"  Expected: Less than size of history (\" \\\n                   |      << this->").append(historyName).append("->size() << \")\\n\" \\\n                   |      << \"  Actual:   \" << index << \"\\n\"; \\\n                   |      const ").append(entryName).append("& _e = \\\n                   |        this->").append(historyName).append("->at(index); \\\n                   |").toString()).$plus$plus((IterableOnce)params.flatMap((Function1<Tuple3, IterableOnce> & Serializable)x$1 -> this.lines(new StringBuilder(446).append("    ASSERT_EQ(_").append(ComponentGTestBaseWriter.name$2(x$1)).append(", _e.").append(ComponentGTestBaseWriter.name$2(x$1)).append(") \\\n                     |      << \"\\n\" \\\n                     |      << __FILE__ << \":\" << __LINE__ << \"\\n\" \\\n                     |      << \"  Value:    Value of argument ").append(ComponentGTestBaseWriter.name$2(x$1)).append(" at index \" \\\n                     |      << index \\\n                     |      << \" in history of ").append(portName).append("\\n\" \\\n                     |      << \"  Expected: \" << _").append(ComponentGTestBaseWriter.name$2(x$1)).append(" << \"\\n\" \\\n                     |      << \"  Actual:   \" << _e.").append(ComponentGTestBaseWriter.name$2(x$1)).append(" << \"\\n\"; \\\n                     |").toString()))));
            iterableArray[2] = this.lines("  }");
            return package$.MODULE$.List().concat(ScalaRunTime$.MODULE$.wrapRefArray(iterableArray));
        });
        linesArray[0] = this.linesMember((List)package$.MODULE$.List().concat(ScalaRunTime$.MODULE$.wrapRefArray(iterableArray)), this.linesMember$default$2(), this.linesMember$default$3());
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(linesArray));
    }

    private List<CppDoc.Member> getCmdMacros() {
        CppDoc.Member.Lines[] linesArray = new CppDoc.Member.Lines[1];
        Iterable[] iterableArray = new Iterable[2];
        iterableArray[0] = CppDocWriter$.MODULE$.writeBannerComment("Macros for command history assertions");
        Line line = Line$.MODULE$.blank();
        iterableArray[1] = this.lines("#define ASSERT_CMD_RESPONSE_SIZE(size) \\\n            |  this->assertCmdResponse_size(__FILE__, __LINE__, size)\n            |\n            |#define ASSERT_CMD_RESPONSE(index, opCode, cmdSeq, response) \\\n            |  this->assertCmdResponse(__FILE__, __LINE__, index, opCode, cmdSeq, response)\n            |").$colon$colon(line);
        linesArray[0] = this.linesMember((List)package$.MODULE$.List().concat(ScalaRunTime$.MODULE$.wrapRefArray(iterableArray)), this.linesMember$default$2(), this.linesMember$default$3());
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(linesArray));
    }

    private List<CppDoc.Member.Lines> getEventMacros() {
        CppDoc.Member.Lines[] linesArray = new CppDoc.Member.Lines[1];
        Iterable[] iterableArray = new Iterable[3];
        iterableArray[0] = CppDocWriter$.MODULE$.writeBannerComment("Macros for event history assertions");
        Line line = Line$.MODULE$.blank();
        iterableArray[1] = this.lines("#define ASSERT_EVENTS_SIZE(size) \\\n            |  this->assertEvents_size(__FILE__, __LINE__, size)\n            |").$colon$colon(line);
        iterableArray[2] = this.sortedEvents().flatMap((Function1<Tuple2, IterableOnce> & Serializable)x$12 -> {
            List list;
            String params = ((AbstractIterable)((List)this.eventParamTypeMap().apply(ComponentGTestBaseWriter.id$1(x$12))).map((Function1<Tuple3, String> & Serializable)x$1 -> new StringBuilder(3).append(", _").append(ComponentGTestBaseWriter.name$3(x$1)).toString())).mkString("");
            String eventName = ComponentGTestBaseWriter.event$1(x$12).getName();
            String sizeAssertFn = this.eventSizeAssertionFuncName(eventName);
            String eventAssertFn = this.eventAssertionFuncName(eventName);
            Line line = Line$.MODULE$.blank();
            List list2 = this.lines(new StringBuilder(103).append("#define ASSERT_EVENTS_").append(eventName).append("_SIZE(size) \\\n               |  this->").append(sizeAssertFn).append("(__FILE__, __LINE__, size)\n               |").toString());
            List list3 = (List)this.eventParamTypeMap().apply(ComponentGTestBaseWriter.id$1(x$12));
            Nil$ nil$ = package$.MODULE$.Nil();
            List list4 = list3;
            if (!(nil$ != null ? !((Object)nil$).equals(list4) : list4 != null)) {
                list = package$.MODULE$.Nil();
            } else {
                Line line2 = Line$.MODULE$.blank();
                list = this.lines(new StringBuilder(102).append("#define ASSERT_EVENTS_").append(eventName).append("(size").append(params).append(") \\\n                 |  this->").append(eventAssertFn).append("(__FILE__, __LINE__, size").append(params).append(")\n                 |").toString()).$colon$colon(line2);
            }
            return ((List)list2.$plus$plus((IterableOnce)list)).$colon$colon(line);
        });
        linesArray[0] = this.linesMember((List)package$.MODULE$.List().concat(ScalaRunTime$.MODULE$.wrapRefArray(iterableArray)), this.linesMember$default$2(), this.linesMember$default$3());
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(linesArray));
    }

    private List<CppDoc.Member.Lines> getTlmMacros() {
        CppDoc.Member.Lines[] linesArray = new CppDoc.Member.Lines[1];
        Iterable[] iterableArray = new Iterable[3];
        iterableArray[0] = CppDocWriter$.MODULE$.writeBannerComment("Macros for telemetry history assertions");
        Line line = Line$.MODULE$.blank();
        iterableArray[1] = this.lines("#define ASSERT_TLM_SIZE(size) \\\n            |  this->assertTlm_size(__FILE__, __LINE__, size)\n            |").$colon$colon(line);
        iterableArray[2] = this.sortedChannels().flatMap((Function1<Tuple2, IterableOnce> & Serializable)x$1 -> {
            String channelName = ComponentGTestBaseWriter.channel$1(x$1).getName();
            String sizeAssertFunc = this.tlmSizeAssertionFuncName(channelName);
            String assertFunc = this.tlmAssertionFuncName(channelName);
            Line line = Line$.MODULE$.blank();
            return this.lines(new StringBuilder(228).append("#define ASSERT_TLM_").append(channelName).append("_SIZE(size) \\\n               |  this->").append(sizeAssertFunc).append("(__FILE__, __LINE__, size)\n               |\n               |#define ASSERT_TLM_").append(channelName).append("(index, value) \\\n               |  this->").append(assertFunc).append("(__FILE__, __LINE__, index, value)\n               |").toString()).$colon$colon(line);
        });
        linesArray[0] = this.linesMember((List)package$.MODULE$.List().concat(ScalaRunTime$.MODULE$.wrapRefArray(iterableArray)), this.linesMember$default$2(), this.linesMember$default$3());
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(linesArray));
    }

    private List<CppDoc.Member> getProductGetMacros() {
        CppDoc.Member.Lines[] linesArray = new CppDoc.Member.Lines[1];
        Iterable[] iterableArray = new Iterable[2];
        iterableArray[0] = CppDocWriter$.MODULE$.writeBannerComment("Macros for product get assertions");
        Line line = Line$.MODULE$.blank();
        iterableArray[1] = this.lines("#define ASSERT_PRODUCT_GET_SIZE(size) \\\n            |  this->assertProductGet_size(__FILE__, __LINE__, size)\n            |\n            |#define ASSERT_PRODUCT_GET(index, id, size) \\\n            |  this->assertProductGet(__FILE__, __LINE__, index, id, size)\n            |").$colon$colon(line);
        linesArray[0] = this.linesMember((List)package$.MODULE$.List().concat(ScalaRunTime$.MODULE$.wrapRefArray(iterableArray)), this.linesMember$default$2(), this.linesMember$default$3());
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(linesArray));
    }

    private List<CppDoc.Member> getProductRequestMacros() {
        CppDoc.Member.Lines[] linesArray = new CppDoc.Member.Lines[1];
        Iterable[] iterableArray = new Iterable[2];
        iterableArray[0] = CppDocWriter$.MODULE$.writeBannerComment("Macros for product request assertions");
        Line line = Line$.MODULE$.blank();
        iterableArray[1] = this.lines("#define ASSERT_PRODUCT_REQUEST_SIZE(size) \\\n            |  this->assertProductRequest_size(__FILE__, __LINE__, size)\n            |\n            |#define ASSERT_PRODUCT_REQUEST(index, id, size) \\\n            |  this->assertProductRequest(__FILE__, __LINE__, index, id, size)\n            |").$colon$colon(line);
        linesArray[0] = this.linesMember((List)package$.MODULE$.List().concat(ScalaRunTime$.MODULE$.wrapRefArray(iterableArray)), this.linesMember$default$2(), this.linesMember$default$3());
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(linesArray));
    }

    private List<CppDoc.Member> getProductSendMacros() {
        CppDoc.Member.Lines[] linesArray = new CppDoc.Member.Lines[1];
        Iterable[] iterableArray = new Iterable[2];
        iterableArray[0] = CppDocWriter$.MODULE$.writeBannerComment("Macros for product send assertions");
        Line line = Line$.MODULE$.blank();
        iterableArray[1] = this.lines("#define ASSERT_PRODUCT_SEND_SIZE(size) \\\n            |  this->assertProductSend_size(__FILE__, __LINE__, size)\n            |\n            |#define ASSERT_PRODUCT_SEND(index, id, priority, timeTag, procTypes, userData, dpState, dataSize, buffer) \\\n            |    assertProductSend(__FILE__, __LINE__, index, id, priority, timeTag, procTypes, userData, dpState, dataSize, buffer)\n            |").$colon$colon(line);
        linesArray[0] = this.linesMember((List)package$.MODULE$.List().concat(ScalaRunTime$.MODULE$.wrapRefArray(iterableArray)), this.linesMember$default$2(), this.linesMember$default$3());
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(linesArray));
    }

    private List<CppDoc.Class.Member> getPortAssertFunctions() {
        CppDoc.Class.Member.Function fromPortHistorySize = this.functionClassMember(Some$.MODULE$.apply("From ports"), "assertFromPortHistory_size", (List)this.sizeAssertionFunctionParams(), CppDoc$Type$.MODULE$.apply("void", CppDoc$Type$.MODULE$.$lessinit$greater$default$2()), this.lines("ASSERT_EQ(size, this->fromPortHistorySize)\n                 |  << \"\\n\"\n                 |  << __callSiteFileName << \":\" << __callSiteLineNumber << \"\\n\"\n                 |  << \"  Value:    Total size of all from port histories\\n\"\n                 |  << \"  Expected: \" << size << \"\\n\"\n                 |  << \"  Actual:   \" << this->fromPortHistorySize << \"\\n\";\n                 |"), (CppDoc.Function.SVQualifier)CppDoc$Function$NonSV$.MODULE$, (CppDoc.Function.ConstQualifier)CppDoc$Function$Const$.MODULE$, this.functionClassMember$default$8());
        Object fromPorts = this.typedOutputPorts().map((Function1<PortInstance.General, CppDoc.Class.Member.Function> & Serializable)p -> {
            String portName = p.getUnqualifiedName();
            String portHistory = this.fromPortHistoryName(portName);
            List list = (List)this.portParamTypeMap().apply(portName);
            Nil$ nil$ = package$.MODULE$.Nil();
            List list2 = list;
            String portSize = !(nil$ != null ? !((Object)nil$).equals(list2) : list2 != null) ? this.fromPortHistorySizeName(portName) : new StringBuilder(8).append(portHistory).append("->size()").toString();
            return this.functionClassMember(Some$.MODULE$.apply(new StringBuilder(11).append("From port: ").append(portName).toString()), this.fromPortSizeAssertionFuncName(portName), (List)this.sizeAssertionFunctionParams(), CppDoc$Type$.MODULE$.apply("void", CppDoc$Type$.MODULE$.$lessinit$greater$default$2()), this.lines(new StringBuilder(322).append("ASSERT_EQ(size, this->").append(portSize).append(")\n                 |  << \"\\n\"\n                 |  << __callSiteFileName << \":\" << __callSiteLineNumber << \"\\n\"\n                 |  << \"  Value:    Size of history for ").append(portName).append("\\n\"\n                 |  << \"  Expected: \" << size << \"\\n\"\n                 |  << \"  Actual:   \" << this->").append(portSize).append(" << \"\\n\";\n                 |").toString()), (CppDoc.Function.SVQualifier)CppDoc$Function$NonSV$.MODULE$, (CppDoc.Function.ConstQualifier)CppDoc$Function$Const$.MODULE$, this.functionClassMember$default$8());
        });
        return this.addAccessTagAndComment("protected", "From ports", (List)package$.MODULE$.List().concat(ScalaRunTime$.MODULE$.wrapRefArray(new Iterable[]{(Iterable)((Function1)this.guardedList().apply(BoxesRunTime.boxToBoolean(this.hasTypedOutputPorts()))).apply(() -> ComponentGTestBaseWriter.getPortAssertFunctions$$anonfun$1(fromPortHistorySize)), fromPorts})), this.addAccessTagAndComment$default$4(), this.addAccessTagAndComment$default$5());
    }

    private List<CppDoc.Class.Member> getCmdAssertFunctions() {
        LazyRef lazyRef = new LazyRef();
        LazyRef lazyRef2 = new LazyRef();
        return this.addAccessTagAndComment("protected", "Commands", (List)((Function1)this.guardedList().apply(BoxesRunTime.boxToBoolean(this.hasCommands()))).apply(() -> this.getCmdAssertFunctions$$anonfun$1(lazyRef, lazyRef2)), this.addAccessTagAndComment$default$4(), this.addAccessTagAndComment$default$5());
    }

    private List<CppDoc.Class.Member> getEventAssertFunctions() {
        LazyRef lazyRef = new LazyRef();
        return this.addAccessTagAndComment("protected", "Events", (List)package$.MODULE$.List().concat(ScalaRunTime$.MODULE$.wrapRefArray(new Iterable[]{(Iterable)((Function1)this.guardedList().apply(BoxesRunTime.boxToBoolean(this.hasEvents()))).apply(() -> this.getEventAssertFunctions$$anonfun$1(lazyRef)), this.sortedEvents().flatMap((Function1<Tuple2, IterableOnce> & Serializable)x$1 -> this.writeAssertFuncs$1(ComponentGTestBaseWriter.id$2(x$1), ComponentGTestBaseWriter.event$2(x$1)))})), this.addAccessTagAndComment$default$4(), this.addAccessTagAndComment$default$5());
    }

    private List<CppDoc.Class.Member> getTlmAssertFunctions() {
        CppDoc.Class.Member.Function historySize = this.functionClassMember(Some$.MODULE$.apply("Assert the size of telemetry history"), "assertTlm_size", (List)this.sizeAssertionFunctionParams(), CppDoc$Type$.MODULE$.apply("void", CppDoc$Type$.MODULE$.$lessinit$greater$default$2()), this.lines("ASSERT_EQ(size, this->tlmSize)\n               |  << \"\\n\"\n               |  << __callSiteFileName << \":\" << __callSiteLineNumber << \"\\n\"\n               |  << \"  Value:    Total size of all telemetry histories\\n\"\n               |  << \"  Expected: \" << size << \"\\n\"\n               |  << \"  Actual:   \" << this->tlmSize << \"\\n\";\n               |"), (CppDoc.Function.SVQualifier)CppDoc$Function$NonSV$.MODULE$, (CppDoc.Function.ConstQualifier)CppDoc$Function$Const$.MODULE$, this.functionClassMember$default$8());
        return this.addAccessTagAndComment("protected", "Telemetry", (List)package$.MODULE$.List().concat(ScalaRunTime$.MODULE$.wrapRefArray(new Iterable[]{(Iterable)((Function1)this.guardedList().apply(BoxesRunTime.boxToBoolean(this.hasChannels()))).apply(() -> ComponentGTestBaseWriter.getTlmAssertFunctions$$anonfun$1(historySize)), this.sortedChannels().flatMap((Function1<Tuple2, IterableOnce> & Serializable)x$1 -> (IterableOnce)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new CppDoc.Class.Member.Function[]{this.channelHistorySize$1(ComponentGTestBaseWriter.channel$2(x$1)), this.channelIndex$1(ComponentGTestBaseWriter.channel$2(x$1))})))})), this.addAccessTagAndComment$default$4(), this.addAccessTagAndComment$default$5());
    }

    private List<CppDoc.Class.Member> getProductGetAssertFunctions() {
        LazyRef lazyRef = new LazyRef();
        LazyRef lazyRef2 = new LazyRef();
        return this.addAccessTagAndComment("protected", "Data Product Get", (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new CppDoc.Class.Member.Function[]{this.historySize$4(lazyRef), this.historyIndex$2(lazyRef2)})), this.addAccessTagAndComment$default$4(), this.addAccessTagAndComment$default$5());
    }

    private List<CppDoc.Class.Member> getProductRequestAssertFunctions() {
        LazyRef lazyRef = new LazyRef();
        LazyRef lazyRef2 = new LazyRef();
        return this.addAccessTagAndComment("protected", "Data Product Request", (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new CppDoc.Class.Member.Function[]{this.historySize$5(lazyRef), this.historyIndex$3(lazyRef2)})), this.addAccessTagAndComment$default$4(), this.addAccessTagAndComment$default$5());
    }

    private List<CppDoc.Class.Member> getProductSendAssertFunctions() {
        LazyRef lazyRef = new LazyRef();
        LazyRef lazyRef2 = new LazyRef();
        return this.addAccessTagAndComment("protected", "Data Product Send", (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new CppDoc.Class.Member.Function[]{this.historySize$6(lazyRef), this.historyIndex$4(lazyRef2)})), this.addAccessTagAndComment$default$4(), this.addAccessTagAndComment$default$5());
    }

    public ComponentGTestBaseWriter copy(CppWriterState s, Tuple3<List<String>, AstNode<Ast.DefComponent>, List<String>> aNode) {
        return new ComponentGTestBaseWriter(s, aNode);
    }

    public CppWriterState copy$default$1() {
        return this.s();
    }

    public Tuple3<List<String>, AstNode<Ast.DefComponent>, List<String>> copy$default$2() {
        return this.aNode();
    }

    public CppWriterState _1() {
        return this.s();
    }

    public Tuple3<List<String>, AstNode<Ast.DefComponent>, List<String>> _2() {
        return this.aNode();
    }

    private final List getMacros$$anonfun$1() {
        return this.getPortMacros();
    }

    private final List getMacros$$anonfun$2() {
        return this.getCmdMacros();
    }

    private final List getMacros$$anonfun$3() {
        return this.getEventMacros();
    }

    private final List getMacros$$anonfun$4() {
        return this.getTlmMacros();
    }

    private final List getMacros$$anonfun$5$$anonfun$1() {
        return this.getProductGetMacros();
    }

    private final List getMacros$$anonfun$5$$anonfun$2() {
        return this.getProductRequestMacros();
    }

    private final List getMacros$$anonfun$5() {
        return (List)package$.MODULE$.List().concat(ScalaRunTime$.MODULE$.wrapRefArray(new Iterable[]{(Iterable)((Function1)this.guardedList().apply(BoxesRunTime.boxToBoolean(this.hasProductGetPort()))).apply(this::getMacros$$anonfun$5$$anonfun$1), (Iterable)((Function1)this.guardedList().apply(BoxesRunTime.boxToBoolean(this.hasProductRequestPort()))).apply(this::getMacros$$anonfun$5$$anonfun$2), this.getProductSendMacros()}));
    }

    private final List getClassMembers$$anonfun$1() {
        return this.getPortAssertFunctions();
    }

    private final List getClassMembers$$anonfun$2() {
        return this.getCmdAssertFunctions();
    }

    private final List getClassMembers$$anonfun$3() {
        return this.getEventAssertFunctions();
    }

    private final List getClassMembers$$anonfun$4() {
        return this.getTlmAssertFunctions();
    }

    private final List getClassMembers$$anonfun$5$$anonfun$1() {
        return this.getProductGetAssertFunctions();
    }

    private final List getClassMembers$$anonfun$5$$anonfun$2() {
        return this.getProductRequestAssertFunctions();
    }

    private final List getClassMembers$$anonfun$5() {
        return (List)package$.MODULE$.List().concat(ScalaRunTime$.MODULE$.wrapRefArray(new Iterable[]{(Iterable)((Function1)this.guardedList().apply(BoxesRunTime.boxToBoolean(this.hasProductGetPort()))).apply(this::getClassMembers$$anonfun$5$$anonfun$1), (Iterable)((Function1)this.guardedList().apply(BoxesRunTime.boxToBoolean(this.hasProductRequestPort()))).apply(this::getClassMembers$$anonfun$5$$anonfun$2), this.getProductSendAssertFunctions()}));
    }

    private static final String name$1(Tuple3 x$1$1) {
        Tuple3 NonEmptyTuple_this = x$1$1;
        return (String)NonEmptyTuple_this._1();
    }

    private static final String _$1$1(Tuple3 x$1$2) {
        Tuple3 NonEmptyTuple_this = x$1$2;
        return (String)NonEmptyTuple_this._2();
    }

    private static final Type _$2$1(Tuple3 x$1$3) {
        Tuple3 NonEmptyTuple_this = x$1$3;
        return (Type)NonEmptyTuple_this._3();
    }

    private static final String name$2(Tuple3 x$1$4) {
        Tuple3 NonEmptyTuple_this = x$1$4;
        return (String)NonEmptyTuple_this._1();
    }

    private static final String _$3$1(Tuple3 x$1$5) {
        Tuple3 NonEmptyTuple_this = x$1$5;
        return (String)NonEmptyTuple_this._2();
    }

    private static final Type _$4$1(Tuple3 x$1$6) {
        Tuple3 NonEmptyTuple_this = x$1$6;
        return (Type)NonEmptyTuple_this._3();
    }

    private static final BigInt id$1(Tuple2 x$1$7) {
        return (BigInt)x$1$7._1();
    }

    private static final Event event$1(Tuple2 x$1$8) {
        return (Event)x$1$8._2();
    }

    private static final String name$3(Tuple3 x$1$9) {
        Tuple3 NonEmptyTuple_this = x$1$9;
        return (String)NonEmptyTuple_this._1();
    }

    private static final String _$5$1(Tuple3 x$1$10) {
        Tuple3 NonEmptyTuple_this = x$1$10;
        return (String)NonEmptyTuple_this._2();
    }

    private static final Type _$6$1(Tuple3 x$1$11) {
        Tuple3 NonEmptyTuple_this = x$1$11;
        return (Type)NonEmptyTuple_this._3();
    }

    private static final BigInt _$7$1(Tuple2 x$1$12) {
        return (BigInt)x$1$12._1();
    }

    private static final TlmChannel channel$1(Tuple2 x$1$13) {
        return (TlmChannel)x$1$13._2();
    }

    private static final List getPortAssertFunctions$$anonfun$1(CppDoc.Class.Member.Function fromPortHistorySize$1) {
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new CppDoc.Class.Member.Function[]{fromPortHistorySize$1}));
    }

    private final CppDoc.Class.Member.Function historySize$lzyINIT1$1(LazyRef historySize$lzy1$1) {
        CppDoc.Class.Member.Function function;
        LazyRef lazyRef = historySize$lzy1$1;
        synchronized (lazyRef) {
            function = (CppDoc.Class.Member.Function)(historySize$lzy1$1.initialized() ? historySize$lzy1$1.value() : historySize$lzy1$1.initialize(this.functionClassMember(Some$.MODULE$.apply("Assert size of command response history"), "assertCmdResponse_size", (List)this.sizeAssertionFunctionParams(), CppDoc$Type$.MODULE$.apply("void", CppDoc$Type$.MODULE$.$lessinit$greater$default$2()), this.lines("ASSERT_EQ(size, this->cmdResponseHistory->size())\n                   |  << \"\\n\"\n                   |  << __callSiteFileName << \":\" << __callSiteLineNumber << \"\\n\"\n                   |  << \"  Value:    Size of command response history\\n\"\n                   |  << \"  Expected: \" << size << \"\\n\"\n                   |  << \"  Actual:   \" << this->cmdResponseHistory->size() << \"\\n\";\n                   |"), (CppDoc.Function.SVQualifier)CppDoc$Function$NonSV$.MODULE$, (CppDoc.Function.ConstQualifier)CppDoc$Function$Const$.MODULE$, this.functionClassMember$default$8())));
        }
        return function;
    }

    private final CppDoc.Class.Member.Function historySize$2(LazyRef historySize$lzy1$2) {
        return (CppDoc.Class.Member.Function)(historySize$lzy1$2.initialized() ? historySize$lzy1$2.value() : this.historySize$lzyINIT1$1(historySize$lzy1$2));
    }

    private final CppDoc.Class.Member.Function historyIndex$lzyINIT1$1(LazyRef historyIndex$lzy1$1) {
        CppDoc.Class.Member.Function function;
        LazyRef lazyRef = historyIndex$lzy1$1;
        synchronized (lazyRef) {
            function = (CppDoc.Class.Member.Function)(historyIndex$lzy1$1.initialized() ? historyIndex$lzy1$1.value() : historyIndex$lzy1$1.initialize(this.functionClassMember(Some$.MODULE$.apply("Assert the command response history at index"), "assertCmdResponse", (List)this.assertionFunctionParams().$plus$plus((IterableOnce)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new CppDoc.Function.Param[]{this.opcodeParam(), this.cmdSeqParam(), CppDoc$Function$Param$.MODULE$.apply(CppDoc$Type$.MODULE$.apply("Fw::CmdResponse", CppDoc$Type$.MODULE$.$lessinit$greater$default$2()), "response", Some$.MODULE$.apply("The command response"), CppDoc$Function$Param$.MODULE$.$lessinit$greater$default$4())}))), CppDoc$Type$.MODULE$.apply("void", CppDoc$Type$.MODULE$.$lessinit$greater$default$2()), this.lines("ASSERT_LT(__index, this->cmdResponseHistory->size())\n                   |  << \"\\n\"\n                   |  << __callSiteFileName << \":\" << __callSiteLineNumber << \"\\n\"\n                   |  << \"  Value:    Index into command response history\\n\"\n                   |  << \"  Expected: Less than size of command response history (\"\n                   |  << this->cmdResponseHistory->size() << \")\\n\"\n                   |  << \"  Actual:   \" << __index << \"\\n\";\n                   |const CmdResponse& e = this->cmdResponseHistory->at(__index);\n                   |ASSERT_EQ(opCode, e.opCode)\n                   |  << \"\\n\"\n                   |  << __callSiteFileName << \":\" << __callSiteLineNumber << \"\\n\"\n                   |  << \"  Value:    Opcode at index \"\n                   |  << __index\n                   |  << \" in command response history\\n\"\n                   |  << \"  Expected: \" << opCode << \"\\n\"\n                   |  << \"  Actual:   \" << e.opCode << \"\\n\";\n                   |ASSERT_EQ(cmdSeq, e.cmdSeq)\n                   |  << \"\\n\"\n                   |  << __callSiteFileName << \":\" << __callSiteLineNumber << \"\\n\"\n                   |  << \"  Value:    Command sequence number at index \"\n                   |  << __index\n                   |  << \" in command response history\\n\"\n                   |  << \"  Expected: \" << cmdSeq << \"\\n\"\n                   |  << \"  Actual:   \" << e.cmdSeq << \"\\n\";\n                   |ASSERT_EQ(response, e.response)\n                   |  << \"\\n\"\n                   |  << __callSiteFileName << \":\" << __callSiteLineNumber << \"\\n\"\n                   |  << \"  Value:    Command response at index \"\n                   |  << __index\n                   |  << \" in command response history\\n\"\n                   |  << \"  Expected: \" << response << \"\\n\"\n                   |  << \"  Actual:   \" << e.response << \"\\n\";\n                   |"), (CppDoc.Function.SVQualifier)CppDoc$Function$NonSV$.MODULE$, (CppDoc.Function.ConstQualifier)CppDoc$Function$Const$.MODULE$, this.functionClassMember$default$8())));
        }
        return function;
    }

    private final CppDoc.Class.Member.Function historyIndex$1(LazyRef historyIndex$lzy1$2) {
        return (CppDoc.Class.Member.Function)(historyIndex$lzy1$2.initialized() ? historyIndex$lzy1$2.value() : this.historyIndex$lzyINIT1$1(historyIndex$lzy1$2));
    }

    private final List getCmdAssertFunctions$$anonfun$1(LazyRef historySize$lzy1$3, LazyRef historyIndex$lzy1$3) {
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new CppDoc.Class.Member.Function[]{this.historySize$2(historySize$lzy1$3), this.historyIndex$1(historyIndex$lzy1$3)}));
    }

    private static final String name$4(Tuple3 x$1$14) {
        Tuple3 NonEmptyTuple_this = x$1$14;
        return (String)NonEmptyTuple_this._1();
    }

    private static final String tn$1(Tuple3 x$1$15) {
        Tuple3 NonEmptyTuple_this = x$1$15;
        return (String)NonEmptyTuple_this._2();
    }

    private static final Type _$8$1(Tuple3 x$1$16) {
        Tuple3 NonEmptyTuple_this = x$1$16;
        return (Type)NonEmptyTuple_this._3();
    }

    private final List writeAssertFuncs$1(BigInt id, Event event) {
        List list;
        String eventName = event.getName();
        List list2 = (List)this.eventParamTypeMap().apply(id);
        Nil$ nil$ = package$.MODULE$.Nil();
        List list3 = list2;
        String eventsSize = !(nil$ != null ? !((Object)nil$).equals(list3) : list3 != null) ? this.eventSizeName(eventName) : new StringBuilder(8).append(this.eventHistoryName(eventName)).append("->size()").toString();
        CppDoc.Class.Member.Function function = this.functionClassMember(Some$.MODULE$.apply(new StringBuilder(7).append("Event: ").append(eventName).toString()), this.eventSizeAssertionFuncName(eventName), (List)this.sizeAssertionFunctionParams(), CppDoc$Type$.MODULE$.apply("void", CppDoc$Type$.MODULE$.$lessinit$greater$default$2()), this.lines(new StringBuilder(304).append("ASSERT_EQ(size, this->").append(eventsSize).append(")\n             |  << \"\\n\"\n             |  << __callSiteFileName << \":\" << __callSiteLineNumber << \"\\n\"\n             |  << \"  Value:    Size of history for event ").append(eventName).append("\\n\"\n             |  << \"  Expected: \" << size << \"\\n\"\n             |  << \"  Actual:   \" << this->").append(eventsSize).append(" << \"\\n\";\n             |").toString()), (CppDoc.Function.SVQualifier)CppDoc$Function$NonSV$.MODULE$, (CppDoc.Function.ConstQualifier)CppDoc$Function$Const$.MODULE$, this.functionClassMember$default$8());
        List list4 = (List)this.eventParamTypeMap().apply(id);
        Nil$ nil$2 = package$.MODULE$.Nil();
        List list5 = list4;
        if (!(nil$2 != null ? !((Object)nil$2).equals(list5) : list5 != null)) {
            list = package$.MODULE$.Nil();
        } else {
            CppDoc.Class.Member.Function[] functionArray = new CppDoc.Class.Member.Function[1];
            String entryName = this.eventEntryName(eventName);
            String historyName = this.eventHistoryName(eventName);
            functionArray[0] = this.functionClassMember(Some$.MODULE$.apply(new StringBuilder(7).append("Event: ").append(eventName).toString()), this.eventAssertionFuncName(eventName), (List)this.assertionFunctionParams().$plus$plus((IterableOnce)event.aNode()._2().data().params().map((Function1<Tuple3, CppDoc.Function.Param> & Serializable)aNode -> {
                Ast.FormalParam data = (Ast.FormalParam)((AstNode)aNode._2()).data();
                return CppDoc$Function$Param$.MODULE$.apply(CppDoc$Type$.MODULE$.apply(this.writeCppType((Type)this.s().a().typeMap().apply(BoxesRunTime.boxToInteger(data.typeName().id())), this.writeCppType$default$2()), CppDoc$Type$.MODULE$.$lessinit$greater$default$2()), data.name(), AnnotationCppWriter$.MODULE$.asStringOpt(aNode), CppDoc$Function$Param$.MODULE$.$lessinit$greater$default$4());
            })), CppDoc$Type$.MODULE$.apply("void", CppDoc$Type$.MODULE$.$lessinit$greater$default$2()), (List)package$.MODULE$.List().concat(ScalaRunTime$.MODULE$.wrapRefArray(new Iterable[]{this.lines(new StringBuilder(492).append("ASSERT_GT(this->").append(eventsSize).append(", __index)\n                     |  << \"\\n\"\n                     |  << __callSiteFileName << \":\" << __callSiteLineNumber << \"\\n\"\n                     |  << \"  Value:    Index into history of event ").append(eventName).append("\\n\"\n                     |  << \"  Expected: Less than size of history (\"\n                     |  << this->").append(eventsSize).append(" << \")\\n\"\n                     |  << \"  Actual:   \" << __index << \"\\n\";\n                     |const ").append(entryName).append("& _e =\n                     |  this->").append(historyName).append("->at(__index);\n                     |").toString()), ((List)this.eventParamTypeMap().apply(id)).flatMap((Function1<Tuple3, IterableOnce> & Serializable)x$1 -> {
                String assertEq = this.writeEventAssertEq(ComponentGTestBaseWriter.tn$1(x$1));
                String eventValue = this.writeEventValue(new StringBuilder(3).append("_e.").append(ComponentGTestBaseWriter.name$4(x$1)).toString(), ComponentGTestBaseWriter.tn$1(x$1));
                return this.lines(new StringBuilder(427).append(assertEq).append("(").append(ComponentGTestBaseWriter.name$4(x$1)).append(", ").append(eventValue).append(")\n                       |  << \"\\n\"\n                       |  << __callSiteFileName << \":\" << __callSiteLineNumber << \"\\n\"\n                       |  << \"  Value:    Value of argument ").append(ComponentGTestBaseWriter.name$4(x$1)).append(" at index \"\n                       |  << __index\n                       |  << \" in history of event ").append(eventName).append("\\n\"\n                       |  << \"  Expected: \" << ").append(ComponentGTestBaseWriter.name$4(x$1)).append(" << \"\\n\"\n                       |  << \"  Actual:   \" << ").append(eventValue).append(" << \"\\n\";\n                       |").toString());
            })})), (CppDoc.Function.SVQualifier)CppDoc$Function$NonSV$.MODULE$, (CppDoc.Function.ConstQualifier)CppDoc$Function$Const$.MODULE$, this.functionClassMember$default$8());
            list = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(functionArray));
        }
        return list.$colon$colon(function);
    }

    private final CppDoc.Class.Member.Function historySize$lzyINIT2$1(LazyRef historySize$lzy2$1) {
        CppDoc.Class.Member.Function function;
        LazyRef lazyRef = historySize$lzy2$1;
        synchronized (lazyRef) {
            function = (CppDoc.Class.Member.Function)(historySize$lzy2$1.initialized() ? historySize$lzy2$1.value() : historySize$lzy2$1.initialize(this.functionClassMember(Some$.MODULE$.apply("Assert the size of event history"), "assertEvents_size", (List)this.sizeAssertionFunctionParams(), CppDoc$Type$.MODULE$.apply("void", CppDoc$Type$.MODULE$.$lessinit$greater$default$2()), this.lines("ASSERT_EQ(size, this->eventsSize)\n                 |  << \"\\n\"\n                 |  << __callSiteFileName << \":\" << __callSiteLineNumber << \"\\n\"\n                 |  << \"  Value:    Total size of all event histories\\n\"\n                 |  << \"  Expected: \" << size << \"\\n\"\n                 |  << \"  Actual:   \" << this->eventsSize << \"\\n\";\n                 |"), (CppDoc.Function.SVQualifier)CppDoc$Function$NonSV$.MODULE$, (CppDoc.Function.ConstQualifier)CppDoc$Function$Const$.MODULE$, this.functionClassMember$default$8())));
        }
        return function;
    }

    private final CppDoc.Class.Member.Function historySize$3(LazyRef historySize$lzy2$2) {
        return (CppDoc.Class.Member.Function)(historySize$lzy2$2.initialized() ? historySize$lzy2$2.value() : this.historySize$lzyINIT2$1(historySize$lzy2$2));
    }

    private final List getEventAssertFunctions$$anonfun$1(LazyRef historySize$lzy2$3) {
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new CppDoc.Class.Member.Function[]{this.historySize$3(historySize$lzy2$3)}));
    }

    private static final BigInt id$2(Tuple2 x$1$17) {
        return (BigInt)x$1$17._1();
    }

    private static final Event event$2(Tuple2 x$1$18) {
        return (Event)x$1$18._2();
    }

    private final CppDoc.Class.Member.Function channelHistorySize$1(TlmChannel channel) {
        String channelName = channel.getName();
        String historyName = this.tlmHistoryName(channelName);
        return this.functionClassMember(Some$.MODULE$.apply(new StringBuilder(9).append("Channel: ").append(channelName).toString()), this.tlmSizeAssertionFuncName(channelName), (List)this.sizeAssertionFunctionParams(), CppDoc$Type$.MODULE$.apply("void", CppDoc$Type$.MODULE$.$lessinit$greater$default$2()), this.lines(new StringBuilder(344).append("ASSERT_EQ(this->").append(historyName).append("->size(), size)\n               |  << \"\\n\"\n               |  << __callSiteFileName << \":\" << __callSiteLineNumber << \"\\n\"\n               |  << \"  Value:    Size of history for telemetry channel ").append(channelName).append("\\n\"\n               |  << \"  Expected: \" << size << \"\\n\"\n               |  << \"  Actual:   \" << this->").append(historyName).append("->size() << \"\\n\";\n               |").toString()), (CppDoc.Function.SVQualifier)CppDoc$Function$NonSV$.MODULE$, (CppDoc.Function.ConstQualifier)CppDoc$Function$Const$.MODULE$, this.functionClassMember$default$8());
    }

    private final CppDoc.Class.Member.Function channelIndex$1(TlmChannel channel) {
        String channelName = channel.getName();
        String historyName = this.tlmHistoryName(channelName);
        String entryName = this.tlmEntryName(channelName);
        String assertEq = this.writeAssertEq(channel.channelType());
        String value = this.writeValue("_e.arg", channel.channelType());
        return this.functionClassMember(Some$.MODULE$.apply(new StringBuilder(9).append("Channel: ").append(channelName).toString()), this.tlmAssertionFuncName(channelName), (List)this.assertionFunctionParams().$plus$plus((IterableOnce)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new CppDoc.Function.Param[]{CppDoc$Function$Param$.MODULE$.apply(CppDoc$Type$.MODULE$.apply(this.writeCppType(channel.channelType(), this.writeCppType$default$2()), CppDoc$Type$.MODULE$.$lessinit$greater$default$2()), "val", Some$.MODULE$.apply("The channel value"), CppDoc$Function$Param$.MODULE$.$lessinit$greater$default$4())}))), CppDoc$Type$.MODULE$.apply("void", CppDoc$Type$.MODULE$.$lessinit$greater$default$2()), this.lines(new StringBuilder(829).append("ASSERT_LT(__index, this->").append(historyName).append("->size())\n               |  << \"\\n\"\n               |  << __callSiteFileName << \":\" << __callSiteLineNumber << \"\\n\"\n               |  << \"  Value:    Index into history of telemetry channel ").append(channelName).append("\\n\"\n               |  << \"  Expected: Less than size of history (\"\n               |  << this->").append(historyName).append("->size() << \")\\n\"\n               |  << \"  Actual:   \" << __index << \"\\n\";\n               |const ").append(entryName).append("& _e =\n               |  this->").append(historyName).append("->at(__index);\n               |").append(assertEq).append("(val, ").append(value).append(")\n               |  << \"\\n\"\n               |  << __callSiteFileName << \":\" << __callSiteLineNumber << \"\\n\"\n               |  << \"  Value:    Value at index \"\n               |  << __index\n               |  << \" on telemetry channel ").append(channelName).append("\\n\"\n               |  << \"  Expected: \" << val << \"\\n\"\n               |  << \"  Actual:   \" << _e.arg << \"\\n\";\n               |").toString()), (CppDoc.Function.SVQualifier)CppDoc$Function$NonSV$.MODULE$, (CppDoc.Function.ConstQualifier)CppDoc$Function$Const$.MODULE$, this.functionClassMember$default$8());
    }

    private static final List getTlmAssertFunctions$$anonfun$1(CppDoc.Class.Member.Function historySize$1) {
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new CppDoc.Class.Member.Function[]{historySize$1}));
    }

    private static final BigInt _$9$1(Tuple2 x$1$19) {
        return (BigInt)x$1$19._1();
    }

    private static final TlmChannel channel$2(Tuple2 x$1$20) {
        return (TlmChannel)x$1$20._2();
    }

    private final CppDoc.Class.Member.Function historySize$lzyINIT3$1(LazyRef historySize$lzy3$1) {
        CppDoc.Class.Member.Function function;
        LazyRef lazyRef = historySize$lzy3$1;
        synchronized (lazyRef) {
            function = (CppDoc.Class.Member.Function)(historySize$lzy3$1.initialized() ? historySize$lzy3$1.value() : historySize$lzy3$1.initialize(this.functionClassMember(Some$.MODULE$.apply("Assert size of product get history"), "assertProductGet_size", (List)this.sizeAssertionFunctionParams(), CppDoc$Type$.MODULE$.apply("void", CppDoc$Type$.MODULE$.$lessinit$greater$default$2()), this.lines("ASSERT_EQ(size, this->productGetHistory->size())\n               |  << \"\\n\"\n               |  << __callSiteFileName << \":\" << __callSiteLineNumber << \"\\n\"\n               |  << \"  Value:    Size of product get history\\n\"\n               |  << \"  Expected: \" << size << \"\\n\"\n               |  << \"  Actual:   \" << this->productGetHistory->size() << \"\\n\";\n               |"), (CppDoc.Function.SVQualifier)CppDoc$Function$NonSV$.MODULE$, (CppDoc.Function.ConstQualifier)CppDoc$Function$Const$.MODULE$, this.functionClassMember$default$8())));
        }
        return function;
    }

    private final CppDoc.Class.Member.Function historySize$4(LazyRef historySize$lzy3$2) {
        return (CppDoc.Class.Member.Function)(historySize$lzy3$2.initialized() ? historySize$lzy3$2.value() : this.historySize$lzyINIT3$1(historySize$lzy3$2));
    }

    private final CppDoc.Class.Member.Function historyIndex$lzyINIT2$1(LazyRef historyIndex$lzy2$1) {
        CppDoc.Class.Member.Function function;
        LazyRef lazyRef = historyIndex$lzy2$1;
        synchronized (lazyRef) {
            function = (CppDoc.Class.Member.Function)(historyIndex$lzy2$1.initialized() ? historyIndex$lzy2$1.value() : historyIndex$lzy2$1.initialize(this.functionClassMember(Some$.MODULE$.apply("Assert the product get history at index"), "assertProductGet", (List)this.assertionFunctionParams().$plus$plus((IterableOnce)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new CppDoc.Function.Param[]{CppDoc$Function$Param$.MODULE$.apply(CppDoc$Type$.MODULE$.apply("FwDpIdType", CppDoc$Type$.MODULE$.$lessinit$greater$default$2()), "id", Some$.MODULE$.apply("The container ID"), CppDoc$Function$Param$.MODULE$.$lessinit$greater$default$4()), CppDoc$Function$Param$.MODULE$.apply(CppDoc$Type$.MODULE$.apply("FwSizeType", CppDoc$Type$.MODULE$.$lessinit$greater$default$2()), "size", Some$.MODULE$.apply("The size of the requested buffer"), CppDoc$Function$Param$.MODULE$.$lessinit$greater$default$4())}))), CppDoc$Type$.MODULE$.apply("void", CppDoc$Type$.MODULE$.$lessinit$greater$default$2()), this.lines("ASSERT_LT(__index, this->productGetHistory->size())\n               |  << \"\\n\"\n               |  << __callSiteFileName << \":\" << __callSiteLineNumber << \"\\n\"\n               |  << \"  Value:    Index into product get history\\n\"\n               |  << \"  Expected: Less than size of product get history (\"\n               |  << this->productGetHistory->size() << \")\\n\"\n               |  << \"  Actual:   \" << __index << \"\\n\";\n               |const DpGet& e = this->productGetHistory->at(__index);\n               |ASSERT_EQ(id, e.id)\n               |  << \"\\n\"\n               |  << __callSiteFileName << \":\" << __callSiteLineNumber << \"\\n\"\n               |  << \"  Value:    Id at index \"\n               |  << __index\n               |  << \" in product get history\\n\"\n               |  << \"  Expected: \" << id << \"\\n\"\n               |  << \"  Actual:   \" << e.id << \"\\n\";\n               |ASSERT_EQ(size, e.size)\n               |  << \"\\n\"\n               |  << __callSiteFileName << \":\" << __callSiteLineNumber << \"\\n\"\n               |  << \"  Value:    Size at index \"\n               |  << __index\n               |  << \" in product get history\\n\"\n               |  << \"  Expected: \" << size << \"\\n\"\n               |  << \"  Actual:   \" << e.size << \"\\n\";\n               |"), (CppDoc.Function.SVQualifier)CppDoc$Function$NonSV$.MODULE$, (CppDoc.Function.ConstQualifier)CppDoc$Function$Const$.MODULE$, this.functionClassMember$default$8())));
        }
        return function;
    }

    private final CppDoc.Class.Member.Function historyIndex$2(LazyRef historyIndex$lzy2$2) {
        return (CppDoc.Class.Member.Function)(historyIndex$lzy2$2.initialized() ? historyIndex$lzy2$2.value() : this.historyIndex$lzyINIT2$1(historyIndex$lzy2$2));
    }

    private final CppDoc.Class.Member.Function historySize$lzyINIT4$1(LazyRef historySize$lzy4$1) {
        CppDoc.Class.Member.Function function;
        LazyRef lazyRef = historySize$lzy4$1;
        synchronized (lazyRef) {
            function = (CppDoc.Class.Member.Function)(historySize$lzy4$1.initialized() ? historySize$lzy4$1.value() : historySize$lzy4$1.initialize(this.functionClassMember(Some$.MODULE$.apply("Assert size of product request history"), "assertProductRequest_size", (List)this.sizeAssertionFunctionParams(), CppDoc$Type$.MODULE$.apply("void", CppDoc$Type$.MODULE$.$lessinit$greater$default$2()), this.lines("ASSERT_EQ(size, this->productRequestHistory->size())\n               |  << \"\\n\"\n               |  << __callSiteFileName << \":\" << __callSiteLineNumber << \"\\n\"\n               |  << \"  Value:    Size of product request history\\n\"\n               |  << \"  Expected: \" << size << \"\\n\"\n               |  << \"  Actual:   \" << this->productRequestHistory->size() << \"\\n\";\n               |"), (CppDoc.Function.SVQualifier)CppDoc$Function$NonSV$.MODULE$, (CppDoc.Function.ConstQualifier)CppDoc$Function$Const$.MODULE$, this.functionClassMember$default$8())));
        }
        return function;
    }

    private final CppDoc.Class.Member.Function historySize$5(LazyRef historySize$lzy4$2) {
        return (CppDoc.Class.Member.Function)(historySize$lzy4$2.initialized() ? historySize$lzy4$2.value() : this.historySize$lzyINIT4$1(historySize$lzy4$2));
    }

    private final CppDoc.Class.Member.Function historyIndex$lzyINIT3$1(LazyRef historyIndex$lzy3$1) {
        CppDoc.Class.Member.Function function;
        LazyRef lazyRef = historyIndex$lzy3$1;
        synchronized (lazyRef) {
            function = (CppDoc.Class.Member.Function)(historyIndex$lzy3$1.initialized() ? historyIndex$lzy3$1.value() : historyIndex$lzy3$1.initialize(this.functionClassMember(Some$.MODULE$.apply("Assert the product request history at index"), "assertProductRequest", (List)this.assertionFunctionParams().$plus$plus((IterableOnce)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new CppDoc.Function.Param[]{CppDoc$Function$Param$.MODULE$.apply(CppDoc$Type$.MODULE$.apply("FwDpIdType", CppDoc$Type$.MODULE$.$lessinit$greater$default$2()), "id", Some$.MODULE$.apply("The container ID"), CppDoc$Function$Param$.MODULE$.$lessinit$greater$default$4()), CppDoc$Function$Param$.MODULE$.apply(CppDoc$Type$.MODULE$.apply("FwSizeType", CppDoc$Type$.MODULE$.$lessinit$greater$default$2()), "size", Some$.MODULE$.apply("The size of the requested buffer"), CppDoc$Function$Param$.MODULE$.$lessinit$greater$default$4())}))), CppDoc$Type$.MODULE$.apply("void", CppDoc$Type$.MODULE$.$lessinit$greater$default$2()), this.lines("ASSERT_LT(__index, this->productRequestHistory->size())\n               |  << \"\\n\"\n               |  << __callSiteFileName << \":\" << __callSiteLineNumber << \"\\n\"\n               |  << \"  Value:    Index into product request history\\n\"\n               |  << \"  Expected: Less than size of product request history (\"\n               |  << this->productRequestHistory->size() << \")\\n\"\n               |  << \"  Actual:   \" << __index << \"\\n\";\n               |const DpRequest& e = this->productRequestHistory->at(__index);\n               |ASSERT_EQ(id, e.id)\n               |  << \"\\n\"\n               |  << __callSiteFileName << \":\" << __callSiteLineNumber << \"\\n\"\n               |  << \"  Value:    Id at index \"\n               |  << __index\n               |  << \" in product request history\\n\"\n               |  << \"  Expected: \" << id << \"\\n\"\n               |  << \"  Actual:   \" << e.id << \"\\n\";\n               |ASSERT_EQ(size, e.size)\n               |  << \"\\n\"\n               |  << __callSiteFileName << \":\" << __callSiteLineNumber << \"\\n\"\n               |  << \"  Value:    Size at index \"\n               |  << __index\n               |  << \" in product request history\\n\"\n               |  << \"  Expected: \" << size << \"\\n\"\n               |  << \"  Actual:   \" << e.size << \"\\n\";\n               |"), (CppDoc.Function.SVQualifier)CppDoc$Function$NonSV$.MODULE$, (CppDoc.Function.ConstQualifier)CppDoc$Function$Const$.MODULE$, this.functionClassMember$default$8())));
        }
        return function;
    }

    private final CppDoc.Class.Member.Function historyIndex$3(LazyRef historyIndex$lzy3$2) {
        return (CppDoc.Class.Member.Function)(historyIndex$lzy3$2.initialized() ? historyIndex$lzy3$2.value() : this.historyIndex$lzyINIT3$1(historyIndex$lzy3$2));
    }

    private final CppDoc.Class.Member.Function historySize$lzyINIT5$1(LazyRef historySize$lzy5$1) {
        CppDoc.Class.Member.Function function;
        LazyRef lazyRef = historySize$lzy5$1;
        synchronized (lazyRef) {
            function = (CppDoc.Class.Member.Function)(historySize$lzy5$1.initialized() ? historySize$lzy5$1.value() : historySize$lzy5$1.initialize(this.functionClassMember(Some$.MODULE$.apply("Assert size of product send history"), "assertProductSend_size", (List)this.sizeAssertionFunctionParams(), CppDoc$Type$.MODULE$.apply("void", CppDoc$Type$.MODULE$.$lessinit$greater$default$2()), this.lines("ASSERT_EQ(size, this->productSendHistory->size())\n               |  << \"\\n\"\n               |  << __callSiteFileName << \":\" << __callSiteLineNumber << \"\\n\"\n               |  << \"  Value:    Size of product send history\\n\"\n               |  << \"  Expected: \" << size << \"\\n\"\n               |  << \"  Actual:   \" << this->productSendHistory->size() << \"\\n\";\n               |"), (CppDoc.Function.SVQualifier)CppDoc$Function$NonSV$.MODULE$, (CppDoc.Function.ConstQualifier)CppDoc$Function$Const$.MODULE$, this.functionClassMember$default$8())));
        }
        return function;
    }

    private final CppDoc.Class.Member.Function historySize$6(LazyRef historySize$lzy5$2) {
        return (CppDoc.Class.Member.Function)(historySize$lzy5$2.initialized() ? historySize$lzy5$2.value() : this.historySize$lzyINIT5$1(historySize$lzy5$2));
    }

    private final CppDoc.Class.Member.Function historyIndex$lzyINIT4$1(LazyRef historyIndex$lzy4$1) {
        CppDoc.Class.Member.Function function;
        LazyRef lazyRef = historyIndex$lzy4$1;
        synchronized (lazyRef) {
            function = (CppDoc.Class.Member.Function)(historyIndex$lzy4$1.initialized() ? historyIndex$lzy4$1.value() : historyIndex$lzy4$1.initialize(this.functionClassMember(Some$.MODULE$.apply(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|Assert the product send history at index\n             |\n             |This function sets the output buffer, deserializes and checks the\n             |data product header, and sets the deserialization pointer to the start\n             |of the data payload. User-written code can then check the data payload.\n             |"))), "assertProductSend", (List)this.assertionFunctionParams().$plus$plus((IterableOnce)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new CppDoc.Function.Param[]{CppDoc$Function$Param$.MODULE$.apply(CppDoc$Type$.MODULE$.apply("FwDpIdType", CppDoc$Type$.MODULE$.$lessinit$greater$default$2()), "id", Some$.MODULE$.apply("The expected container ID (input)"), CppDoc$Function$Param$.MODULE$.$lessinit$greater$default$4()), CppDoc$Function$Param$.MODULE$.apply(CppDoc$Type$.MODULE$.apply("FwDpPriorityType", CppDoc$Type$.MODULE$.$lessinit$greater$default$2()), "priority", Some$.MODULE$.apply("The expected priority (input)"), CppDoc$Function$Param$.MODULE$.$lessinit$greater$default$4()), CppDoc$Function$Param$.MODULE$.apply(CppDoc$Type$.MODULE$.apply("const Fw::Time&", CppDoc$Type$.MODULE$.$lessinit$greater$default$2()), "timeTag", Some$.MODULE$.apply("The expected time tag (input)"), CppDoc$Function$Param$.MODULE$.$lessinit$greater$default$4()), CppDoc$Function$Param$.MODULE$.apply(CppDoc$Type$.MODULE$.apply("Fw::DpCfg::ProcType::SerialType", CppDoc$Type$.MODULE$.$lessinit$greater$default$2()), "procTypes", Some$.MODULE$.apply("The expected processing types (input)"), CppDoc$Function$Param$.MODULE$.$lessinit$greater$default$4()), CppDoc$Function$Param$.MODULE$.apply(CppDoc$Type$.MODULE$.apply("const Fw::DpContainer::Header::UserData&", CppDoc$Type$.MODULE$.$lessinit$greater$default$2()), "userData", Some$.MODULE$.apply("The expected user data (input)"), CppDoc$Function$Param$.MODULE$.$lessinit$greater$default$4()), CppDoc$Function$Param$.MODULE$.apply(CppDoc$Type$.MODULE$.apply("Fw::DpState", CppDoc$Type$.MODULE$.$lessinit$greater$default$2()), "dpState", Some$.MODULE$.apply("The expected data product state (input)"), CppDoc$Function$Param$.MODULE$.$lessinit$greater$default$4()), CppDoc$Function$Param$.MODULE$.apply(CppDoc$Type$.MODULE$.apply("FwSizeType", CppDoc$Type$.MODULE$.$lessinit$greater$default$2()), "dataSize", Some$.MODULE$.apply("The expected data size (input)"), CppDoc$Function$Param$.MODULE$.$lessinit$greater$default$4()), CppDoc$Function$Param$.MODULE$.apply(CppDoc$Type$.MODULE$.apply("Fw::Buffer&", CppDoc$Type$.MODULE$.$lessinit$greater$default$2()), "historyBuffer", Some$.MODULE$.apply("The buffer from the history (output)"), CppDoc$Function$Param$.MODULE$.$lessinit$greater$default$4())}))), CppDoc$Type$.MODULE$.apply("void", CppDoc$Type$.MODULE$.$lessinit$greater$default$2()), this.lines("ASSERT_LT(__index, this->productSendHistory->size())\n               |  << \"\\n\"\n               |  << __callSiteFileName << \":\" << __callSiteLineNumber << \"\\n\"\n               |  << \"  Value:    Index into product send history\\n\"\n               |  << \"  Expected: Less than size of product send history (\"\n               |  << this->productSendHistory->size() << \")\\n\"\n               |  << \"  Actual:   \" << __index << \"\\n\";\n               |const DpSend& e = this->productSendHistory->at(__index);\n               |// Set the history buffer output\n               |historyBuffer = e.buffer;\n               |// Check the container id\n               |ASSERT_EQ(e.id, id)\n               |  << \"\\n\"\n               |  << __callSiteFileName << \":\" << __callSiteLineNumber << \"\\n\"\n               |  << \"  Value:    Container ID at index \" << __index << \" in product send history\\n\"\n               |  << \"  Expected: \" << id << \"\\n\"\n               |  << \"  Actual:   \" << e.id << \"\\n\";\n               |// Check the header\n               |Fw::TestUtil::DpContainerHeader header;\n               |header.deserialize(__callSiteFileName, __callSiteLineNumber, historyBuffer);\n               |header.check(\n               |    __callSiteFileName,\n               |    __callSiteLineNumber,\n               |    historyBuffer,\n               |    id,\n               |    priority,\n               |    timeTag,\n               |    procTypes,\n               |    userData,\n               |    dpState,\n               |    dataSize\n               |);\n               |"), (CppDoc.Function.SVQualifier)CppDoc$Function$NonSV$.MODULE$, (CppDoc.Function.ConstQualifier)CppDoc$Function$Const$.MODULE$, this.functionClassMember$default$8())));
        }
        return function;
    }

    private final CppDoc.Class.Member.Function historyIndex$4(LazyRef historyIndex$lzy4$2) {
        return (CppDoc.Class.Member.Function)(historyIndex$lzy4$2.initialized() ? historyIndex$lzy4$2.value() : this.historyIndex$lzyINIT4$1(historyIndex$lzy4$2));
    }
}

