/*
 * Decompiled with CFR 0.152.
 */
package fpp.compiler.syntax;

import fpp.compiler.util.Chars$;

public abstract class CharArrayReader {
    private char ch;
    private int charOffset = this.startFrom();
    private int lastCharOffset = this.startFrom();
    private int lineStartOffset = this.startFrom();
    private int lineNo = 0;
    private int lastUnicodeOffset = -1;

    public abstract char[] buf();

    private int startFrom() {
        return 0;
    }

    public boolean decodeUni() {
        return false;
    }

    public abstract void error(String var1);

    public char ch() {
        return this.ch;
    }

    public void ch_$eq(char x$1) {
        this.ch = x$1;
    }

    public int charOffset() {
        return this.charOffset;
    }

    public void charOffset_$eq(int x$1) {
        this.charOffset = x$1;
    }

    public int lastCharOffset() {
        return this.lastCharOffset;
    }

    public void lastCharOffset_$eq(int x$1) {
        this.lastCharOffset = x$1;
    }

    public int lineStartOffset() {
        return this.lineStartOffset;
    }

    public void lineStartOffset_$eq(int x$1) {
        this.lineStartOffset = x$1;
    }

    public int lineNo() {
        return this.lineNo;
    }

    public void lineNo_$eq(int x$1) {
        this.lineNo = x$1;
    }

    public boolean isUnicodeEscape() {
        return this.charOffset() == this.lastUnicodeOffset;
    }

    public final void nextChar() {
        int idx = this.charOffset();
        this.lastCharOffset_$eq(idx);
        this.charOffset_$eq(idx + 1);
        if (idx >= this.buf().length) {
            this.ch_$eq('\u001a');
        } else {
            char c = this.buf()[idx];
            this.ch_$eq(c);
            if (c == '\\') {
                this.potentialUnicode();
            } else if (c < ' ') {
                this.skipCR();
                this.potentialLineEnd();
            }
        }
    }

    public char getc() {
        this.nextChar();
        return this.ch();
    }

    public final void nextRawChar() {
        int idx = this.charOffset();
        this.lastCharOffset_$eq(idx);
        this.charOffset_$eq(idx + 1);
        if (idx >= this.buf().length) {
            this.ch_$eq('\u001a');
        } else {
            char c = this.buf()[idx];
            this.ch_$eq(c);
            if (c == '\\') {
                this.potentialUnicode();
            }
        }
    }

    private void potentialUnicode() {
        if (this.charOffset() < this.buf().length && this.buf()[this.charOffset()] == 'u' && this.decodeUni() && this.evenSlashPrefix$1()) {
            do {
                this.charOffset_$eq(this.charOffset() + 1);
            } while (this.charOffset() < this.buf().length && this.buf()[this.charOffset()] == 'u');
            int code = this.udigit$1() << 12 | this.udigit$1() << 8 | this.udigit$1() << 4 | this.udigit$1();
            this.lastUnicodeOffset = this.charOffset();
            this.ch_$eq((char)code);
        }
    }

    private void skipCR() {
        if (this.ch() == '\r' && this.charOffset() < this.buf().length && this.buf()[this.charOffset()] == '\n') {
            this.charOffset_$eq(this.charOffset() + 1);
            this.ch_$eq('\n');
        }
    }

    private void potentialLineEnd() {
        if (this.ch() == '\n' || this.ch() == '\f') {
            this.lineStartOffset_$eq(this.charOffset());
            this.lineNo_$eq(this.lineNo() + 1);
        }
    }

    public boolean isAtEnd() {
        return this.charOffset() >= this.buf().length;
    }

    public CharArrayLookaheadReader lookaheadReader() {
        return new CharArrayLookaheadReader();
    }

    public char lookaheadChar() {
        return this.lookaheadReader().getc();
    }

    private final boolean evenSlashPrefix$1() {
        int p;
        for (p = this.charOffset() - 2; p >= 0 && this.buf()[p] == '\\'; --p) {
        }
        return (this.charOffset() - p) % 2 == 0;
    }

    /*
     * WARNING - void declaration
     */
    private final int udigit$1() {
        int n;
        if (this.charOffset() >= this.buf().length) {
            this.error("incomplete unicode escape");
            n = 26;
        } else {
            void var1_1;
            int d = Chars$.MODULE$.digit2int(this.buf()[this.charOffset()], 16);
            if (d >= 0) {
                this.charOffset_$eq(this.charOffset() + 1);
            } else {
                this.error("error in unicode escape");
            }
            n = var1_1;
        }
        return n;
    }

    public class CharArrayLookaheadReader
    extends CharArrayReader {
        private final char[] buf;

        public CharArrayLookaheadReader() {
            if (CharArrayReader.this == null) {
                throw new NullPointerException();
            }
            this.buf = CharArrayReader.this.buf();
            this.charOffset_$eq(CharArrayReader.this.charOffset());
            this.ch_$eq(CharArrayReader.this.ch());
        }

        @Override
        public char[] buf() {
            return this.buf;
        }

        @Override
        public boolean decodeUni() {
            return CharArrayReader.this.decodeUni();
        }

        @Override
        public void error(String msg) {
            CharArrayReader.this.error(msg);
        }

        public final /* synthetic */ CharArrayReader fpp$compiler$syntax$CharArrayReader$CharArrayLookaheadReader$$$outer() {
            return CharArrayReader.this;
        }
    }
}

