from .version import version


TAGLINE = f"Generated by Klarenz v{version}"

# polymetric notation
UNEQUAL_LENGTH_MEASURES_POLYMETRY = """
\layout {
    \context {
        \Score
        \\remove "Timing_translator"
        \\remove "Default_bar_line_engraver"
    }
    \context {
        \Staff
        \consists "Timing_translator"
        \consists "Default_bar_line_engraver"
        \RemoveEmptyStaves
    }
}
"""

HEADER_TAGLINE = """
\header {
tagline = ##f
}
"""


def make_center_align(line):
    return f"""
            \center-align {{
                "{line}"
            }}
"""

NL = "\n"
def make_copyright(lines):
    if lines:
        return f"""copyright = \markup {{
            \column {{
                {"".join([make_center_align(line) for line in lines])}
            }}
        }}
    """
    else: return ""


def make_tagline(cp_lines):
    if cp_lines: # then no need for tagline
        return "tagline = ##f"
    else: # no copyright, put klarenz tagline
        return f"tagline = \"Generated by Klarenz v{version}\""

def make_header(cp_lines):
    return f"""\header {{
    {make_tagline(cp_lines)}  
    {make_copyright(cp_lines)}
}}
"""


PAPER = """
\paper {
    left-margin = 20
    right-margin = 20
    score-system-spacing = #'( (basic-distance . 10) (minimum-distance . 10) (padding . 10) (stretchability . 0) )
    system-system-spacing = #'( (basic-distance . 0) (minimum-distance . 0) (padding . 10) (stretchability . 0) )
    top-margin = 20
    bottom-margin = 20
    indent = 0
    %% entfernt die Trennline oberhalb der Fußnotentexte am Seitenende
    footnote-separator-markup = ##f  
}
"""
