# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/910_Nbdev.ipynb.

# %% auto 0
__all__ = ['prep', 'gacp', 'upload', 'reinstall', 'update', 'release_git', 'release_pypi', 'release', 'help_output', 'everything']

# %% ../nbs/910_Nbdev.ipynb 6
def prep():
    "Export, test, and clean notebooks, and render README if needed"
    import nbdev.test, nbdev.clean, nbdev.quarto
    
    nbdev.quarto.nbdev_export.__wrapped__()
    print(f'### nbdev_export finished ###')
    nbdev.test.nbdev_test.__wrapped__(
        n_workers = 8,  # Number of workers
        timing = True,  # Time each notebook to see which are slow
    )
    print(f'### nbdev_test finished ###')
    nbdev.clean.nbdev_clean.__wrapped__()
    print(f'### nbdev_clean finished ###')
    nbdev.quarto.refresh_quarto_yml()
    print(f'### refresh_quarto_yml finished ###')
    nbdev.quarto.nbdev_readme.__wrapped__(chk_time=True)
    print(f'### nbdev_readme finished ###')

# %% ../nbs/910_Nbdev.ipynb 7
def gacp(
    comment:str="update"
):
    "git add, commit and push to github"
    import subprocess
    subprocess.run(["git", "add", "."])
    print(f'### git added ###')
    status = subprocess.check_output(["git", "status", "-s"])
    print(f'### git status: "{status}" ###')
    subprocess.run(["git", "commit", "-m", f'"{status}"'])
    print(f'### git commited ###')
    subprocess.run(["git", "push"])
    print(f'### git pushed ###')

# %% ../nbs/910_Nbdev.ipynb 8
def upload():
    "prep, then gacp"
    prep()
    gacp()

# %% ../nbs/910_Nbdev.ipynb 9
def reinstall():
    "runs pip install -e ."
    import subprocess
    subprocess.run(["pip", "install", "-e", "."])

# %% ../nbs/910_Nbdev.ipynb 10
def update():
    "prep, then reinstall"
    prep()
    reinstall()

# %% ../nbs/910_Nbdev.ipynb 12
def release_git(part:int = 2):
    "release to git"
    import nbdev.release
    nbdev.release.nbdev_bump_version(part)
    nbdev.release.release_git()

# %% ../nbs/910_Nbdev.ipynb 13
def release_pypi():
    "release to pypi"
    import nbdev.release
    nbdev.release.release_pypi()

# %% ../nbs/910_Nbdev.ipynb 14
def release():
    "release to github and pip"
    release_git()
    release_pypi()

# %% ../nbs/910_Nbdev.ipynb 16
def help_output():
    "Show help for all console scripts"
    from fastcore.xtras import console_help
    console_help('nbdevAuto')

# %% ../nbs/910_Nbdev.ipynb 18
def everything():
    "prep, gacp, release, reinstall"
    prep()
    
    gacp()
    release()
    
    reinstall()
