from unskript.enums.enum_by_name import EnumByName
import enum


@enum.unique
class EBSMetrics(str, EnumByName):
    VOLUMEREADBYTES = "VolumeReadBytes"
    VOLUMEWRITEBYTES = "VolumeWriteBytes"
    VOLUMEREADOPS = "VolumeReadOps"
    VOLUMEWRITEOPS = "VolumeWriteOps"
    VOLUMETOTALREADTIME = "VolumeTotalReadTime"
    VOLUMETOTALWRITETIME = "VolumeTotalWriteTime"
    VOLUMEIDLETIME = "VolumeIdleTime"
    VOLUMEQUEUELENGTH = "VolumeQueueLength"
    VOLUMETHROUGHPUTPERCENTAGE = "VolumeThroughputPercentage"
    VOLUMECONSUMEDREADWRITEOPS = "VolumeConsumedReadWriteOps"
    BURSTBALANCE = "BurstBalance"


@enum.unique
class EC2Metrics(str, EnumByName):
    CPUUTILIZATION = "CPUUtilization"
    DISKREADOPS = "DiskReadOps"
    DISKWRITEOPS = "DiskWriteOps"
    DISKREADBYTES = "DiskReadBytes"
    DISKWRITEBYTES = "DiskWriteBytes"
    METADATANOTOKEN = "MetadataNoToken"
    NETWORKIN = "NetworkIn"
    NETWORKOUT = "NetworkOut"
    NETWORKPACKETSIN = "NetworkPacketsIn"
    NETWORKPACKETSOUT = "NetworkPacketsOut"
    CPUCREDITUSAGE = "CPUCreditUsage"
    CPUCREDITBALANCE = "CPUCreditBalance"
    CPUSURPLUSCREDITBALANCE = "CPUSurplusCreditBalance"
    CPUSURPLUSCREDITSCHARGED = "CPUSurplusCreditsCharged"
    DEDICATEDHOSTCPUUTILIZATION = "DedicatedHostCPUUtilization"
    EBSREADOPS = "EBSReadOps"
    EBSWRITEOPS = "EBSWriteOps"
    EBSREADBYTES = "EBSReadBytes"
    EBSWRITEBYTES = "EBSWriteBytes"
    EBSIOBALANCE = "EBSIOBalance%"
    EBSBYTEBALANCE = "EBSByteBalance%"
    STATUSCHECKFAILED = "StatusCheckFailed"
    STATUSCHECKFAILED_INSTANCE = "StatusCheckFailed_Instance"
    STATUSCHECKFAILED_SYSTEM = "StatusCheckFailed_System"


@enum.unique
class UnitsType(str, EnumByName):
    SECONDS = "Seconds"
    COUNT = "Count"
    BYTES = "Bytes"
    GIGABITSPERSECOND = "Gigabits/Second"
    GIGABITS = "Gigabits"
    PERCENT = "Percent"
    TERABITS = "Terabits"
    BITS = "Bits"
    KILOBITS = "kilobits"
    MEGABYTESPERSECOND = "megabytes/Second"
    KILOBYTES = "kilobytes"
    MEGABITSPERSECOND = "Megabits/Second"
    TERABYTES = "Terabytes"
    GIGABYTES = "Gigabytes"
    MILLISECONDS = "Milliseconds"
    COUNTPERSECOND = "Count/Second"
    GIGABYTESPERSECOND = "Gigabytes/Second"
    NONE = "None"
    TERABYTESPERSECOND = "Terabytes/Second"
    BYTESPERSECOND = "Bytes/Second"
    MEGABITS = "Megabits"
    KILOBYTESPERSECOND = "Kilobytes/Second"
    MEGABYTES = "Megabytes"
    MICROSECONDS = "Microseconds"
    KILOBITSPERSECOND = "Kilobits/Second"
    TERABITSPERSECOND = "Terabits/Second"
    BITSPERSECOND = "Bits/Second"


@enum.unique
class NetworkELBMetrics(str, EnumByName):
    ACTIVEFLOWCOUNT = "ActiveFlowCount"
    ACTIVEFLOWCOUNT_TCP = "ActiveFlowCount_TCP"
    ACTIVEFLOWCOUNT_TLS = "ActiveFlowCount_TLS"
    ACTIVEFLOWCOUNT_UDP = "ActiveFlowCount_UDP"
    CLIENTTLSNEGOTIATIONERRORCOUNT = "ClientTLSNegotiationErrorCount"
    CONSUMEDLCUS = "ConsumedLCUs"
    CONSUMEDLCUS_TCP = "ConsumedLCUs_TCP"
    CONSUMEDLCUS_TLS = "ConsumedLCUs_TLS"
    CONSUMEDLCUS_UDP = "ConsumedLCUs_UDP"
    HEALTHYHOSTCOUNT = "HealthyHostCount"
    NEWFLOWCOUNT = "NewFlowCount"
    NEWFLOWCOUNT_TCP = "NewFlowCount_TCP"
    NEWFLOWCOUNT_TLS = "NewFlowCount_TLS"
    NEWFLOWCOUNT_UDP = "NewFlowCount_UDP"
    PEAKPACKETSPERSECOND = "PeakPacketsPerSecond"
    PORTALLOCATIONERRORCOUNT = "PortAllocationErrorCount"
    PROCESSEDBYTES = "ProcessedBytes"
    PROCESSEDBYTES_TCP = "ProcessedBytes_TCP"
    PROCESSEDBYTES_TLS = "ProcessedBytes_TLS"
    PROCESSEDBYTES_UDP = "ProcessedBytes_UDP"
    PROCESSEDPACKETS = "ProcessedPackets"
    TARGETTLSNEGOTIATIONERRORCOUNT = "TargetTLSNegotiationErrorCount"
    TCP_CLIENT_RESET_COUNT = "TCP_Client_Reset_Count"
    TCP_ELB_RESET_COUNT = "TCP_ELB_Reset_Count"
    TCP_TARGET_RESET_COUNT = "TCP_Target_Reset_Count"
    UNHEALTHYHOSTCOUNT = "UnHealthyHostCount"


@enum.unique
class ClassicELBMetrics(str, EnumByName):
    BACKENDCONNECTIONERRORS = "BackendConnectionErrors"
    DESYNCMITIGATIONMODE_NONCOMPLIANT_REQUEST_COUNT = "DesyncMitigationMode_NonCompliant_Request_Count"
    HEALTHYHOSTCOUNT = "HealthyHostCount"
    HTTPCODE_BACKEND_2XX = "HTTPCode_Backend_2XX"
    HTTPCODE_BACKEND_3XX = "HTTPCode_Backend_3XX"
    HTTPCODE_BACKEND_4XX = "HTTPCode_Backend_4XX"
    HTTPCODE_BACKEND_5XX = "HTTPCode_Backend_5XX"
    HTTPCODE_ELB_4XX = "HTTPCode_ELB_4XX"
    HTTPCODE_ELB_5XX = "HTTPCode_ELB_5XX"
    LATENCY = "Latency"
    REQUESTCOUNT = "RequestCount"
    SPILLOVERCOUNT = "SpilloverCount"
    SURGEQUEUELENGTH = "SurgeQueueLength"
    UNHEALTHYHOSTCOUNT = "UnHealthyHostCount"


@enum.unique
class SQSMetrics(str, EnumByName):
    APPROXIMATEAGEOFOLDESTMESSAGE = "ApproximateAgeOfOldestMessage"
    APPROXIMATENUMBEROFMESSAGESDELAYED = "ApproximateNumberOfMessagesDelayed"
    APPROXIMATENUMBEROFMESSAGESNOTVISIBLE = "ApproximateNumberOfMessagesNotVisible"
    APPROXIMATENUMBEROFMESSAGESVISIBLE = "ApproximateNumberOfMessagesVisible"
    NUMBEROFEMPTYRECEIVES = "NumberOfEmptyReceives"
    NUMBEROFMESSAGESDELETED = "NumberOfMessagesDeleted"
    NUMBEROFMESSAGESRECEIVED = "NumberOfMessagesReceived"
    NUMBEROFMESSAGESSENT = "NumberOfMessagesSent"
    SENTMESSAGESIZE = "SentMessageSize"


@enum.unique
class ApplicationELBMetrics(str, EnumByName):
    ACTIVECONNECTIONCOUNT = "ActiveConnectionCount"
    CLIENTTLSNEGOTIATIONERRORCOUNT = "ClientTLSNegotiationErrorCount"
    CONSUMEDLCUS = "ConsumedLCUs"
    DESYNCMITIGATIONMODE_NONCOMPLIANT_REQUEST_COUNT = "DesyncMitigationMode_NonCompliant_Request_Count"
    DROPPEDINVALIDHEADERREQUESTCOUNT = "DroppedInvalidHeaderRequestCount"
    FORWARDEDINVALIDHEADERREQUESTCOUNT = "ForwardedInvalidHeaderRequestCount"
    GRPCREQUESTCOUNT = "GrpcRequestCount"
    HTTP_FIXED_RESPONSE_COUNT = "HTTP_Fixed_Response_Count"
    HTTP_REDIRECT_COUNT = "HTTP_Redirect_Count"
    HTTP_REDIRECT_URL_LIMIT_EXCEEDED_COUNT = "HTTP_Redirect_Url_Limit_Exceeded_Count"
    HTTPCODE_ELB_3XX_COUNT = "HTTPCode_ELB_3XX_Count"
    HTTPCODE_ELB_4XX_COUNT = "HTTPCode_ELB_4XX_Count"
    HTTPCODE_ELB_5XX_COUNT = "HTTPCode_ELB_5XX_Count"
    HTTPCODE_ELB_500_COUNT = "HTTPCode_ELB_500_Count"
    HTTPCODE_ELB_502_COUNT = "HTTPCode_ELB_502_Count"
    HTTPCODE_ELB_503_COUNT = "HTTPCode_ELB_503_Count"
    HTTPCODE_ELB_504_COUNT = "HTTPCode_ELB_504_Count"
    IPV6PROCESSEDBYTES = "IPv6ProcessedBytes"
    IPV6REQUESTCOUNT = "IPv6RequestCount"
    NEWCONNECTIONCOUNT = "NewConnectionCount"
    NONSTICKYREQUESTCOUNT = "NonStickyRequestCount"
    PROCESSEDBYTES = "ProcessedBytes"
    REJECTEDCONNECTIONCOUNT = "RejectedConnectionCount"
    REQUESTCOUNT = "RequestCount"
    RULEEVALUATIONS = "RuleEvaluations"
    HEALTHYHOSTCOUNT = "HealthyHostCount"
    HTTPCODE_TARGET_2XX_COUNT = "HTTPCode_Target_2XX_Count"
    HTTPCODE_TARGET_3XX_COUNT = "HTTPCode_Target_3XX_Count"
    HTTPCODE_TARGET_4XX_COUNT = "HTTPCode_Target_4XX_Count"
    HTTPCODE_TARGET_5XX_COUNT = "HTTPCode_Target_5XX_Count"
    REQUESTCOUNTPERTARGET = "RequestCountPerTarget"
    TARGETCONNECTIONERRORCOUNT = "TargetConnectionErrorCount"
    TARGETRESPONSETIME = "TargetResponseTime"
    TARGETTLSNEGOTIATIONERRORCOUNT = "TargetTLSNegotiationErrorCount"
    UNHEALTHYHOSTCOUNT = "UnHealthyHostCount"
    LAMBDAINTERNALERROR = "LambdaInternalError"
    LAMBDATARGETPROCESSEDBYTES = "LambdaTargetProcessedBytes"
    LAMBDAUSERERROR = "LambdaUserError"
    ELBAUTHERROR = "ELBAuthError"
    ELBAUTHFAILURE = "ELBAuthFailure"
    ELBAUTHLATENCY = "ELBAuthLatency"
    ELBAUTHREFRESHTOKENSUCCESS = "ELBAuthRefreshTokenSuccess"
    ELBAUTHSUCCESS = "ELBAuthSuccess"
    ELBAUTHUSERCLAIMSSIZEEXCEEDED = "ELBAuthUserClaimsSizeExceeded"


@enum.unique
class GatewayELBMetrics(str, EnumByName):
    ACTIVEFLOWCOUNT = "ActiveFlowCount"
    CONSUMEDLCUS = "ConsumedLCUs"
    HEALTHYHOSTCOUNT = "HealthyHostCount"
    NEWFLOWCOUNT = "NewFlowCount"
    PROCESSEDBYTES = "ProcessedBytes"
    UNHEALTHYHOSTCOUNT = "UnHealthyHostCount"


@enum.unique
class DynamoDBMetrics(str, EnumByName):
    ACCOUNTMAXREADS = "AccountMaxReads"
    ACCOUNTMAXTABLELEVELREADS = "AccountMaxTableLevelReads"
    ACCOUNTMAXTABLELEVELWRITES = "AccountMaxTableLevelWrites"
    ACCOUNTMAXWRITES = "AccountMaxWrites"
    ACCOUNTPROVISIONEDREADCAPACITYUTILIZATION = "AccountProvisionedReadCapacityUtilization"
    ACCOUNTPROVISIONEDWRITECAPACITYUTILIZATION = "AccountProvisionedWriteCapacityUtilization"
    AGEOFOLDESTUNREPLICATEDRECORD = "AgeOfOldestUnreplicatedRecord"
    CONDITIONALCHECKFAILEDREQUESTS = "ConditionalCheckFailedRequests"
    CONSUMEDCHANGEDATACAPTUREUNITS = "ConsumedChangeDataCaptureUnits"
    CONSUMEDREADCAPACITYUNITS = "ConsumedReadCapacityUnits"
    CONSUMEDWRITECAPACITYUNITS = "ConsumedWriteCapacityUnits"
    FAILEDTOREPLICATERECORDCOUNT = "FailedToReplicateRecordCount"
    MAXPROVISIONEDTABLEWRITECAPACITYUTILIZATION = "MaxProvisionedTableWriteCapacityUtilization"
    ONLINEINDEXCONSUMEDWRITECAPACITY = "OnlineIndexConsumedWriteCapacity"
    ONLINEINDEXPERCENTAGEPROGRESS = "OnlineIndexPercentageProgress"
    ONLINEINDEXTHROTTLEEVENTS = "OnlineIndexThrottleEvents"
    PENDINGREPLICATIONCOUNT = "PendingReplicationCount"
    PROVISIONEDREADCAPACITYUNITS = "ProvisionedReadCapacityUnits"
    PROVISIONEDWRITECAPACITYUNITS = "ProvisionedWriteCapacityUnits"
    READTHROTTLEEVENTS = "ReadThrottleEvents"
    REPLICATIONLATENCY = "ReplicationLatency"
    RETURNEDBYTES = "ReturnedBytes"
    RETURNEDITEMCOUNT = "ReturnedItemCount"
    RETURNEDRECORDSCOUNT = "ReturnedRecordsCount"
    SUCCESSFULREQUESTLATENCY = "SuccessfulRequestLatency"
    SYSTEMERRORS = "SystemErrors"
    TIMETOLIVEDELETEDITEMCOUNT = "TimeToLiveDeletedItemCount"
    THROTTLEDPUTRECORDCOUNT = "ThrottledPutRecordCount"
    THROTTLEDREQUESTS = "ThrottledRequests"
    TRANSACTIONCONFLICT = "TransactionConflict"
    USERERRORS = "UserErrors"
    WRITETHROTTLEEVENTS = "WriteThrottleEvents"


@enum.unique
class EC2AutoscalingMetrics(str, EnumByName):
    GROUPMINSIZE = "GroupMinSize"
    GROUPMAXSIZE = "GroupMaxSize"
    GROUPDESIREDCAPACITY = "GroupDesiredCapacity"
    GROUPINSERVICEINSTANCES = "GroupInServiceInstances"
    GROUPPENDINGINSTANCES = "GroupPendingInstances"
    GROUPSTANDBYINSTANCES = "GroupStandbyInstances"
    GROUPTERMINATINGINSTANCES = "GroupTerminatingInstances"
    GROUPTOTALINSTANCES = "GroupTotalInstances"
    GROUPINSERVICECAPACITY = "GroupInServiceCapacity"
    GROUPPENDINGCAPACITY = "GroupPendingCapacity"
    GROUPSTANDBYCAPACITY = "GroupStandbyCapacity"
    GROUPTERMINATINGCAPACITY = "GroupTerminatingCapacity"
    GROUPTOTALCAPACITY = "GroupTotalCapacity"
    WARMPOOLMINSIZE = "WarmPoolMinSize"
    WARMPOOLDESIREDCAPACITY = "WarmPoolDesiredCapacity"
    WARMPOOLPENDINGCAPACITY = "WarmPoolPendingCapacity"
    WARMPOOLTERMINATINGCAPACITY = "WarmPoolTerminatingCapacity"
    WARMPOOLWARMEDCAPACITY = "WarmPoolWarmedCapacity"
    WARMPOOLTOTALCAPACITY = "WarmPoolTotalCapacity"
    GROUPANDWARMPOOLDESIREDCAPACITY = "GroupAndWarmPoolDesiredCapacity"
    GROUPANDWARMPOOLTOTALCAPACITY = "GroupAndWarmPoolTotalCapacity"


@enum.unique
class RDSMetrics(str, EnumByName):
    BINLOGDISKUSAGE = "BinLogDiskUsage"
    BURSTBALANCE = "BurstBalance"
    CPUUTILIZATION = "CPUUtilization"
    CPUCREDITUSAGE = "CPUCreditUsage"
    CPUCREDITBALANCE = "CPUCreditBalance"
    DATABASECONNECTIONS = "DatabaseConnections"
    DISKQUEUEDEPTH = "DiskQueueDepth"
    EBSBYTEBALANCEPERCENT = "EBSByteBalance%"
    EBSIOBALANCEPERCENT = "EBSIOBalance%"
    FAILEDSQLSERVERAGENTJOBSCOUNT = "FailedSQLServerAgentJobsCount"
    FREEABLEMEMORY = "FreeableMemory"
    FREELOCALSTORAGE = "FreeLocalStorage"
    FREESTORAGESPACE = "FreeStorageSpace"
    MAXIMUMUSEDTRANSACTIONIDS = "MaximumUsedTransactionIDs"
    NETWORKRECEIVETHROUGHPUT = "NetworkReceiveThroughput"
    NETWORKTRANSMITTHROUGHPUT = "NetworkTransmitThroughput"
    OLDESTREPLICATIONSLOTLAG = "OldestReplicationSlotLag"
    READIOPS = "ReadIOPS"
    READIOPSLOCALSTORAGE = "ReadIOPSLocalStorage"
    READLATENCY = "ReadLatency"
    READLATENCYLOCALSTORAGE = "ReadLatencyLocalStorage"
    READTHROUGHPUT = "ReadThroughput"
    READTHROUGHPUTLOCALSTORAGE = "ReadThroughputLocalStorage"
    REPLICALAG = "ReplicaLag"
    REPLICATIONSLOTDISKUSAGE = "ReplicationSlotDiskUsage"
    SWAPUSAGE = "SwapUsage"
    TRANSACTIONLOGSDISKUSAGE = "TransactionLogsDiskUsage"
    TRANSACTIONLOGSGENERATION = "TransactionLogsGeneration"
    WRITEIOPS = "WriteIOPS"
    WRITEIOPSLOCALSTORAGE = "WriteIOPSLocalStorage"
    WRITELATENCY = "WriteLatency"
    WRITELATENCYLOCALSTORAGE = "WriteLatencyLocalStorage"
    WRITETHROUGHPUT = "WriteThroughput"
    WRITETHROUGHPUTLOCALSTORAGE = "WriteThroughputLocalStorage"


@enum.unique
class RedshiftMetrics(str, EnumByName):
    COMMITQUEUELENGTH = "CommitQueueLength"
    CONCURRENCYSCALINGACTIVECLUSTERS = "ConcurrencyScalingActiveClusters"
    CONCURRENCYSCALINGSECONDS = "ConcurrencyScalingSeconds"
    DATABASECONNECTIONS = "DatabaseConnections"
    CPUUTILIZATION = "CPUUtilization"
    HEALTHSTATUS = "HealthStatus"
    MAINTENANCEMODE = "MaintenanceMode"
    MAXCONFIGUREDCONCURRENCYSCALINGCLUSTERS = "MaxConfiguredConcurrencyScalingClusters"
    NETWORKRECEIVETHROUGHPUT = "NetworkReceiveThroughput"
    NETWORKTRANSMITTHROUGHPUT = "NetworkTransmitThroughput"
    PERCENTAGEDISKSPACEUSED = "PercentageDiskSpaceUsed"
    QUERIESCOMPLETEDPERSECOND = "QueriesCompletedPerSecond"
    QUERYDURATION = "QueryDuration"
    QUERYRUNTIMEBREAKDOWN = "QueryRuntimeBreakdown"
    READIOPS = "ReadIOPS"
    READLATENCY = "ReadLatency"
    READTHROUGHPUT = "ReadThroughput"
    TOTALTABLECOUNT = "TotalTableCount"
    WLMQUEUELENGTH = "WLMQueueLength"
    WLMQUEUEWAITTIME = "WLMQueueWaitTime"
    WLMQUERIESCOMPLETEDPERSECOND = "WLMQueriesCompletedPerSecond"
    WLMQUERYDURATION = "WLMQueryDuration"
    WLMRUNNINGQUERIES = "WLMRunningQueries"
    WRITEIOPS = "WriteIOPS"
    WRITELATENCY = "WriteLatency"
    WRITETHROUGHPUT = "WriteThroughput"
    SCHEMAQUOTA = "SchemaQuota"
    NUMEXCEEDEDSCHEMAQUOTAS = "NumExceededSchemaQuotas"
    STORAGEUSED = "StorageUsed"
    PERCENTAGEQUOTAUSED = "PercentageQuotaUsed"


@enum.unique
class LambdaMetrics(str, EnumByName):
    INVOCATIONS = "Invocations"
    ERRORS = "Errors"
    DEADLETTERERRORS = "DeadLetterErrors"
    DESTINATIONDELIVERYFAILURES = "DestinationDeliveryFailures"
    THROTTLES = "Throttles"
    PROVISIONEDCONCURRENCYINVOCATIONS = "ProvisionedConcurrencyInvocations"
    PROVISIONEDCONCURRENCYSPILLOVERINVOCATIONS = "ProvisionedConcurrencySpilloverInvocations"
    DURATION = "Duration"
    POSTRUNTIMEEXTENSIONSDURATION = "PostRuntimeExtensionsDuration"
    ITERATORAGE = "IteratorAge"
    OFFSETLAG = "OffsetLag"
    CONCURRENTEXECUTIONS = "ConcurrentExecutions"
    PROVISIONEDCONCURRENTEXECUTIONS = "ProvisionedConcurrentExecutions"
    PROVISIONEDCONCURRENCYUTILIZATION = "ProvisionedConcurrencyUtilization"
    UNRESERVEDCONCURRENTEXECUTIONS = "UnreservedConcurrentExecutions"
