# coding: utf-8

# flake8: noqa
"""
    Pingdom Public API

    # Welcome to the Pingdom API! The Pingdom API is a way for you to automate your interaction with the Pingdom system. With the API, you can create your own scripts or applications with most of the functionality you can find inside the Pingdom control panel.  The Pingdom API is RESTful and HTTP-based. Basically, this means that the communication is made through normal HTTP requests.  # Authentication Authentication is needed in order to use the Pingdom API, and for this a Pingdom API Token is required. You generate your Pingdom API Token inside My Pingdom. The Pingdom API Token has a property called “Access level” to define its permissions. All operations that create or modify something (e.g. checks) need the Read/Write permission. If you only need to read data using the API token, we recommend to set the access level to “Read access”.  The authentication method for using tokens is HTTP Bearer Authentication (encrypted over HTTPS). This means that you will provide your token every time you make a request. No sessions are used.  Request ``` GET /checks HTTP/1.1 Host: api.pingdom.com Authorization: Bearer ofOhK18Ca6w4S_XmInGv0QPkqly-rbRBBoHsp_2FEH5QnIbH0VZhRPO3tlvrjMIKQ36VapX ```  Response ``` HTTP/1.1 200 OK Content-Length: 13 Content-Type: application/json {\"checks\":[]} ```  ## Basic Auth For compatibility reasons, the Pingdom API allows to use HTTP Basic Authentication with tokens. In cases where this is necessary, input the API token as the username and leave the password field empty.  An example request of how that would look like with the following API token: ofOhK18Ca6w4S_XmInGv0QPkqly-rbRBBoHsp_2FEH5QnIbH0VZhRPO3tlvrjMIKQ36VapX  ``` GET /checks HTTP/1.1 Host: api.pingdom.com Authorization: Basic b2ZPaEsxOENhNnc0U19YbUluR3YwUVBrcWx5LXJiUkJCb0hzcF8yRkVINVFuSWJIMFZaaFJQTzN0bHZyak1JS1EzNlZhcFg6 ```  # Server Address The base server address is: https://api.pingdom.com  Please note that HTTPS is required. You will not be able to connect through unencrypted HTTP.  # Providing Parameters GET requests should provide their parameters as a query string, part of the URL.  POST, PUT and DELETE requests should provide their parameters as a JSON. This should be part of the request body. Remember to add the proper content type header to the request: `Content-Type: application/json`.  We still support providing parameters as a query string for POST, PUT and DELETE requests, but we recommend using JSON going forward. If you are using query strings, they should be part of the body, URL or a combination. The encoding of the query string should be standard URL-encoding, as provided by various programming libraries.  When using `requests` library for Python, use `json` parameter instead of `data`. Due to the inner mechanisms of requests.post() etc. some endpoints may return responses not conforming to the documentation when dealing with `data` body.  # HTTP/1.1 Status Code Definitions The HTTP status code returned by a successful API request is defined in the documentation for that method. Usually, this will be 200 OK.  If something goes wrong, other codes may be returned. The API uses standard HTTP/1.1 status codes defined by [RFC 2616](https://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html).  # JSON Responses All responses are sent JSON-encoded. The specific responses (successful ones) are described in the documentation section for each method.  However, if something goes wrong, our standard JSON error message (together with an appropriate status code) follows this format: ``` {     \"error\": {         \"statuscode\": 403,         \"statusdesc\": \"Forbidden\",         \"errormessage\":\" Something went wrong! This string describes what happened.\"     } } ``` See http://en.wikipedia.org/wiki/Json for more information on JSON.  Please note that all attributes of a method response are not always present. A client application should never assume that a certain attribute is present in a response.  # Limits The Pingdom API has usage limits to avoid individual rampant applications degrading the overall user experience. There are two layers of limits, the first cover a shorter period of time and the second a longer period. This enables you to \"burst\" requests for shorter periods. There are two HTTP headers in every response describing your limits status.  The response headers are: * **Req-Limit-Short** * **Req-Limit-Long**  An example of the values of these headers: * **Req-Limit-Short: Remaining: 394 Time until reset: 3589** * **Req-Limit-Long: Remaining: 71994 Time until reset: 2591989**  In this case, we can see that the user has 394 requests left until the short limit is reached. In 3589 seconds, the short limit will be reset. In similar fashion, the long limit has 71994 requests left, and will be reset in 2591989 seconds.  If limits are exceeded, an HTTP 429 error code with the message \"Request limit exceeded, try again later\" is sent back.  # gzip Responses can be gzip-encoded on demand. This is nice if your bandwidth is limited, or if big results are causing performance issues.  To enable gzip, simply add the following header to your request:  Accept-Encoding: gzip  # Best Practices ## Use caching If you are building a web page using the Pingdom API, we recommend that you do all API request on the server side, and if possible cache them. If you get any substantial traffic, you do not want to call the API each time you get a page hit, since this may cause you to hit the request limit faster than expected. In general, whenever you can cache data, do so.  ## Send your user credentials in a preemptive manner Some HTTP clients omit the authentication header, and make a second request with the header when they get a 401 Unauthorized response. Please make sure you send the credentials directly, to avoid unnecessary requests.  ## Use common sense Should be simple enough. For example, don't check for the status of a check every other second. The highest check resolution is one minute. Checking more often than that won't give you much of an advantage.  ## The Internet is unreliable Networks in general are unreliable, and particularly one as large and complex as the Internet. Your application should not assume it will get an answer. There may be timeouts.  # PHP Code Example **\"This is too much to read. I just want to get started right now! Give me a simple example!\"**  Here is a short example of how you can use the API with PHP. You need the cURL extension for PHP.  The example prints the current status of all your checks. This sample obviously focuses on Pingdom API code and does not worry about any potential problems connecting to the API, but your code should.  Code: ```php <?php     // Init cURL     $curl = curl_init();     // Set target URL     curl_setopt($curl, CURLOPT_URL, \"https://api.pingdom.com/api/3.1/checks\");     // Set the desired HTTP method (GET is default, see the documentation for each request)     curl_setopt($curl, CURLOPT_CUSTOMREQUEST, \"GET\");     // Add header with Bearer Authorization     curl_setopt($curl, CURLOPT_HTTPHEADER, array(\"Authorization: Bearer 907c762e069589c2cd2a229cdae7b8778caa9f07\"));     // Ask cURL to return the result as a string     curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);     // Execute the request and decode the json result into an associative array     $response = json_decode(curl_exec($curl), true);     // Check for errors returned by the API     if (isset($response['error'])) {         print \"Error: \" . $response['error']['errormessage'] . \"\\n\";         exit;     }     // Fetch the list of checks from the response     $checksList = $response['checks'];     // Print the names and statuses of all checks in the list     foreach ($checksList as $check) {         print $check['name'] . \" is \" . $check['status'] . \"\\n\";     } ?> ```  Example output: ``` Ubuntu Packages is up Google is up Pingdom is up My server 1 is down My server 2 is up ```  If you are running PHP on Windows, you need to be sure that you have installed the CA certificates for HTTPS/SSL to work correctly. Please see the cURL manual for more information. As a quick (but unsafe) workaround, you can add the following cURL option to ignore certificate validation.  ` curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0); `  # TMS Steps Vocabulary  There are two types of transaction checks: <ul>     <li><b>script</b>: the legacy TMS check created with predefined commands in the Pingdom UI or via the public API</li>     <li><b>recording</b>: the TMS check created by recording performed actions in WPM recorder.         More information about how to use it can be found in the         <a class=\"default-link\" href=\"https://documentation.solarwinds.com/en/success_center/wpm/Content/WPM-Use-the-WPM3-Recorder.htm\">             WPM recorder documentation</a>     </li> </ul>  ## Script transaction checks    ### Commands   Actions to be performed for the script TMS check    Step Name                                 | \"fn\"                  | Required \"args\"     | Remarks   ----------------------------------------- | --------------------- | --------------      | -------   Go to URL                                 | go_to                 | url                 | There has to be **exactly one** go_to step   Click                                     | click                 | element             | label, name or CSS selector   Fill in field                             | fill                  | input, value        | input: label, name or CSS selector, value: text   Check checkbox                            | check                 | checkbox            | label, name or CSS selector   Uncheck checkbox                          | uncheck               | checkbox            | label, name or CSS selector   Sleep for                                 | sleep                 | seconds             | number (e.g. 0.1)   Select radio button                       | select_radio          | radio               | name of the radio button   Select dropdown                           | select                | select, option      | select: label, name or CSS selector, option: content, value or CSS selector   Basic auth login with                     | basic_auth            | username, password  | username and password as text   Submit form                               | submit                | form                | name or CSS selector   Wait for element                          | wait_for_element      | element             | label, name or CSS selector   Wait for element to contain               | wait_for_contains     | element, value      | element: label, name or CSS selector, value: text    ### Validations   Verify the state of the page    Step Name                                 | \"fn\"                  | Required \"args\"     | Remarks   ----------------------------------------- | --------------------- | --------------      | -------   URL should be                             | url                   | url                 | url to be verified   Element should exist                      | exists                | element             | label, name or CSS selector   Element shouldn't exist                   | not_exists            | element             | label, name or CSS selector   Element should contain                    | contains              | element, value      | element: label, name or CSS selector, value: text   Element shouldn't containt                | not_contains          | element, value      | element: label, name or CSS selector, value: text   Text field should contain                 | field_contains        | input, value        | input: label, name or CSS selector, value: text   Text field shouldn't contain              | field_not_contains    | input, value        | input: label, name or CSS selector, value: text   Checkbox should be checked                | is_checked            | checkbox            | label, name or CSS selector   Checkbox shouldn't be checked             | is_not_checked        | checkbox            | label, name or CSS selector   Radio button should be selected           | radio_selected        | radio               | name of the radio button   Dropdown with name should be selected     | dropdown_selected     | select, option      | select: label, name or CSS selector, option: content, value or CSS selector   Dropdown with name shouldn't be selected  | dropdown_not_selected | select, option      | select: label, name or CSS selector, option: content, value or CSS selector    ### Example steps    ```   \"steps\": [   {     \"fn\": \"go_to\",     \"args\": {       \"url\": \"pingdom.com\"     }   },   {     \"fn\": \"click\",     \"args\": {       \"element\": \"START FREE TRIAL\"     }   },   {     \"fn\": \"url\",     \"args\": {       \"url\": \"https://www.pingdom.com/sign-up/\"     }   }   ]   ```  ## Recording transaction checks  Each of check steps contains: <ul>   <li><b>fn</b>: function name of the step</li>   <li><b>args</b>: function arguments</li>   <li><b>guid</b>: automatically generated identifier</li>   <li><b>contains_navigate</b>: recorder sets it on true if the step would trigger a page navigation</li> </ul>    ### Commands   Actions to be performed for the recording TMS check    Step Name                 | \"fn\"                      | Required \"args\"                 | Remarks   ------------------------- | ------------------------- | ------------------------------- | -------   Go to URL                 | wpm_go_to                 | url                             | Goes to the given url location   Click                     | wpm_click                 | element, offsetX, offsetY       | **element**: label, name or CSS selector,</br> **offsetX/Y**: exact position of a click in the element   Click in a exact location | wpm_click_xy              | element, x, y, scrollX, scrollY | **element**: label, name or CSS selector,</br> **x/y**: coordinates for the click (in viewport),</br> **scrollX/Y**: scrollbar position   Fill                      | wpm_fill                  | input, value                    | **input**: target element,</br> **value**: text to fill the target   Move mouse to element     | wpm_move_mouse_to_element | element, offsetX, offsetY       | **element**: target element,</br> **offsetX/Y**: exact position of the mouse in the element   Select dropdown           | wpm_select_dropdown       | select, option                  | **select**: target element (drop-down),</br> **option**: text of the option to select   Wait                      | wpm_wait                  | seconds                         | **seconds:** numbers of seconds to wait   Close tab                 | wpm_close_tab             | -                               | Closes the latest tab on the tab stack    ### Validations   Verify the state of the page    Step Name              | \"fn\"                     | Required \"args\"                                | Remarks   ---------------------- | ------------------------ | ---------------------------------------------- | -------   Contains text          | wpm_contains_timeout     | element, value, waitTime, useRegularExpression | **element**: label, name or CSS selector,</br> **value**: text to search for,</br> **waitTime**: time to wait for the value to appear,</br> **useRegularExpression**: use the value as a RegEx   Does not contains text | wpm_not_contains_timeout | element, value, waitTime, useRegularExpression | **element**: label, name or CSS selector,</br> **value**: text to search for,</br> **waitTime**: time to wait for the value to appear,</br> **useRegularExpression**: use the value as a RegEx    ### Metadata   Recording checks contain metadata which is automatically generated by the WPM recorder. Modify with caution!   # noqa: E501

    OpenAPI spec version: 3.1

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

# import models into model package
from unskript.thirdparty.pingdom.swagger_client.models.agcm import AGCM
from unskript.thirdparty.pingdom.swagger_client.models.agcm_inner import AGCMInner
from unskript.thirdparty.pingdom.swagger_client.models.apns import APNS
from unskript.thirdparty.pingdom.swagger_client.models.apns_inner import APNSInner
from unskript.thirdparty.pingdom.swagger_client.models.actions_alerts_entry import ActionsAlertsEntry
from unskript.thirdparty.pingdom.swagger_client.models.actions_alerts_entry_actions import ActionsAlertsEntryActions
from unskript.thirdparty.pingdom.swagger_client.models.actions_alerts_entry_actions_alerts import ActionsAlertsEntryActionsAlerts
from unskript.thirdparty.pingdom.swagger_client.models.actions_checkids import ActionsCheckids
from unskript.thirdparty.pingdom.swagger_client.models.actions_from import ActionsFrom
from unskript.thirdparty.pingdom.swagger_client.models.actions_limit import ActionsLimit
from unskript.thirdparty.pingdom.swagger_client.models.actions_offset import ActionsOffset
from unskript.thirdparty.pingdom.swagger_client.models.actions_status import ActionsStatus
from unskript.thirdparty.pingdom.swagger_client.models.actions_to import ActionsTo
from unskript.thirdparty.pingdom.swagger_client.models.actions_userids import ActionsUserids
from unskript.thirdparty.pingdom.swagger_client.models.actions_via import ActionsVia
from unskript.thirdparty.pingdom.swagger_client.models.alerting_team_id import AlertingTeamID
from unskript.thirdparty.pingdom.swagger_client.models.alerting_teams import AlertingTeams
from unskript.thirdparty.pingdom.swagger_client.models.all_of_detailed_check_dns_check import AllOfDetailedCheckDnsCheck
from unskript.thirdparty.pingdom.swagger_client.models.all_of_detailed_check_http_check import AllOfDetailedCheckHttpCheck
from unskript.thirdparty.pingdom.swagger_client.models.all_of_detailed_check_http_custom_check import AllOfDetailedCheckHttpCustomCheck
from unskript.thirdparty.pingdom.swagger_client.models.all_of_detailed_check_imap_check import AllOfDetailedCheckImapCheck
from unskript.thirdparty.pingdom.swagger_client.models.all_of_detailed_check_pop3_check import AllOfDetailedCheckPop3Check
from unskript.thirdparty.pingdom.swagger_client.models.all_of_detailed_check_smtp_check import AllOfDetailedCheckSmtpCheck
from unskript.thirdparty.pingdom.swagger_client.models.all_of_detailed_check_tcp_check import AllOfDetailedCheckTcpCheck
from unskript.thirdparty.pingdom.swagger_client.models.all_of_detailed_check_udp_check import AllOfDetailedCheckUdpCheck
from unskript.thirdparty.pingdom.swagger_client.models.analysis_analysisid import AnalysisAnalysisid
from unskript.thirdparty.pingdom.swagger_client.models.analysis_checkid import AnalysisCheckid
from unskript.thirdparty.pingdom.swagger_client.models.analysis_from import AnalysisFrom
from unskript.thirdparty.pingdom.swagger_client.models.analysis_limit import AnalysisLimit
from unskript.thirdparty.pingdom.swagger_client.models.analysis_offset import AnalysisOffset
from unskript.thirdparty.pingdom.swagger_client.models.analysis_resp_attrs import AnalysisRespAttrs
from unskript.thirdparty.pingdom.swagger_client.models.analysis_resp_attrs_analysis import AnalysisRespAttrsAnalysis
from unskript.thirdparty.pingdom.swagger_client.models.analysis_to import AnalysisTo
from unskript.thirdparty.pingdom.swagger_client.models.any_of_contact_targets_notification_targets import AnyOfContactTargetsNotificationTargets
from unskript.thirdparty.pingdom.swagger_client.models.any_of_create_contact_notification_targets import AnyOfCreateContactNotificationTargets
from unskript.thirdparty.pingdom.swagger_client.models.any_of_update_contact_notification_targets import AnyOfUpdateContactNotificationTargets
from unskript.thirdparty.pingdom.swagger_client.models.average_response import AverageResponse
from unskript.thirdparty.pingdom.swagger_client.models.check import Check
from unskript.thirdparty.pingdom.swagger_client.models.check_general import CheckGeneral
from unskript.thirdparty.pingdom.swagger_client.models.check_simple import CheckSimple
from unskript.thirdparty.pingdom.swagger_client.models.check_status import CheckStatus
from unskript.thirdparty.pingdom.swagger_client.models.check_with_string_type import CheckWithStringType
from unskript.thirdparty.pingdom.swagger_client.models.check_without_id import CheckWithoutID
from unskript.thirdparty.pingdom.swagger_client.models.check_without_idget import CheckWithoutIDGET
from unskript.thirdparty.pingdom.swagger_client.models.check_without_idput import CheckWithoutIDPUT
from unskript.thirdparty.pingdom.swagger_client.models.checks import Checks
from unskript.thirdparty.pingdom.swagger_client.models.checks_all import ChecksAll
from unskript.thirdparty.pingdom.swagger_client.models.checks_body import ChecksBody
from unskript.thirdparty.pingdom.swagger_client.models.checks_body1 import ChecksBody1
from unskript.thirdparty.pingdom.swagger_client.models.contact import Contact
from unskript.thirdparty.pingdom.swagger_client.models.contact_targets import ContactTargets
from unskript.thirdparty.pingdom.swagger_client.models.contact_targets_teams import ContactTargetsTeams
from unskript.thirdparty.pingdom.swagger_client.models.contacts_list import ContactsList
from unskript.thirdparty.pingdom.swagger_client.models.country import Country
from unskript.thirdparty.pingdom.swagger_client.models.counts import Counts
from unskript.thirdparty.pingdom.swagger_client.models.create_check import CreateCheck
from unskript.thirdparty.pingdom.swagger_client.models.create_contact import CreateContact
from unskript.thirdparty.pingdom.swagger_client.models.create_team import CreateTeam
from unskript.thirdparty.pingdom.swagger_client.models.credits_resp_attrs import CreditsRespAttrs
from unskript.thirdparty.pingdom.swagger_client.models.credits_resp_attrs_credits import CreditsRespAttrsCredits
from unskript.thirdparty.pingdom.swagger_client.models.dns import DNS
from unskript.thirdparty.pingdom.swagger_client.models.date_time_format import DateTimeFormat
from unskript.thirdparty.pingdom.swagger_client.models.days import Days
from unskript.thirdparty.pingdom.swagger_client.models.detailed_check import DetailedCheck
from unskript.thirdparty.pingdom.swagger_client.models.detailed_check_attributes import DetailedCheckAttributes
from unskript.thirdparty.pingdom.swagger_client.models.detailed_check_dns import DetailedCheckDns
from unskript.thirdparty.pingdom.swagger_client.models.detailed_check_http import DetailedCheckHttp
from unskript.thirdparty.pingdom.swagger_client.models.detailed_check_http_custom import DetailedCheckHttpCustom
from unskript.thirdparty.pingdom.swagger_client.models.detailed_check_imap import DetailedCheckImap
from unskript.thirdparty.pingdom.swagger_client.models.detailed_check_pop3 import DetailedCheckPop3
from unskript.thirdparty.pingdom.swagger_client.models.detailed_check_smtp import DetailedCheckSmtp
from unskript.thirdparty.pingdom.swagger_client.models.detailed_check_tcp import DetailedCheckTcp
from unskript.thirdparty.pingdom.swagger_client.models.detailed_check_udp import DetailedCheckUdp
from unskript.thirdparty.pingdom.swagger_client.models.detailed_dns_attributes import DetailedDnsAttributes
from unskript.thirdparty.pingdom.swagger_client.models.detailed_dns_attributes_type import DetailedDnsAttributesType
from unskript.thirdparty.pingdom.swagger_client.models.detailed_http_attributes import DetailedHttpAttributes
from unskript.thirdparty.pingdom.swagger_client.models.detailed_http_attributes_type import DetailedHttpAttributesType
from unskript.thirdparty.pingdom.swagger_client.models.detailed_http_custom_attributes import DetailedHttpCustomAttributes
from unskript.thirdparty.pingdom.swagger_client.models.detailed_http_custom_attributes_type import DetailedHttpCustomAttributesType
from unskript.thirdparty.pingdom.swagger_client.models.detailed_imap_attributes import DetailedImapAttributes
from unskript.thirdparty.pingdom.swagger_client.models.detailed_imap_attributes_type import DetailedImapAttributesType
from unskript.thirdparty.pingdom.swagger_client.models.detailed_pop3_attributes import DetailedPop3Attributes
from unskript.thirdparty.pingdom.swagger_client.models.detailed_pop3_attributes_type import DetailedPop3AttributesType
from unskript.thirdparty.pingdom.swagger_client.models.detailed_smtp_attributes import DetailedSmtpAttributes
from unskript.thirdparty.pingdom.swagger_client.models.detailed_smtp_attributes_type import DetailedSmtpAttributesType
from unskript.thirdparty.pingdom.swagger_client.models.detailed_tcp_attributes import DetailedTcpAttributes
from unskript.thirdparty.pingdom.swagger_client.models.detailed_tcp_attributes_type import DetailedTcpAttributesType
from unskript.thirdparty.pingdom.swagger_client.models.detailed_udp_attributes import DetailedUdpAttributes
from unskript.thirdparty.pingdom.swagger_client.models.detailed_udp_attributes_type import DetailedUdpAttributesType
from unskript.thirdparty.pingdom.swagger_client.models.dns_attributes import DnsAttributes
from unskript.thirdparty.pingdom.swagger_client.models.downtime import Downtime
from unskript.thirdparty.pingdom.swagger_client.models.emails import Emails
from unskript.thirdparty.pingdom.swagger_client.models.emails_inner import EmailsInner
from unskript.thirdparty.pingdom.swagger_client.models.http import HTTP
from unskript.thirdparty.pingdom.swagger_client.models.http_custom import HTTPCustom
from unskript.thirdparty.pingdom.swagger_client.models.hours import Hours
from unskript.thirdparty.pingdom.swagger_client.models.http_attributes_base import HttpAttributesBase
from unskript.thirdparty.pingdom.swagger_client.models.http_attributes_get import HttpAttributesGet
from unskript.thirdparty.pingdom.swagger_client.models.http_attributes_set import HttpAttributesSet
from unskript.thirdparty.pingdom.swagger_client.models.http_authentications import HttpAuthentications
from unskript.thirdparty.pingdom.swagger_client.models.http_authentications_credentials import HttpAuthenticationsCredentials
from unskript.thirdparty.pingdom.swagger_client.models.http_certificate_attributes import HttpCertificateAttributes
from unskript.thirdparty.pingdom.swagger_client.models.http_custom_attributes import HttpCustomAttributes
from unskript.thirdparty.pingdom.swagger_client.models.imap import IMAP
from unskript.thirdparty.pingdom.swagger_client.models.imap_attributes import ImapAttributes
from unskript.thirdparty.pingdom.swagger_client.models.inline_response200 import InlineResponse200
from unskript.thirdparty.pingdom.swagger_client.models.inline_response2001 import InlineResponse2001
from unskript.thirdparty.pingdom.swagger_client.models.inline_response2001_check import InlineResponse2001Check
from unskript.thirdparty.pingdom.swagger_client.models.inline_response2002 import InlineResponse2002
from unskript.thirdparty.pingdom.swagger_client.models.inline_response2003 import InlineResponse2003
from unskript.thirdparty.pingdom.swagger_client.models.inline_response2004 import InlineResponse2004
from unskript.thirdparty.pingdom.swagger_client.models.inline_response2005 import InlineResponse2005
from unskript.thirdparty.pingdom.swagger_client.models.inline_response2005_team import InlineResponse2005Team
from unskript.thirdparty.pingdom.swagger_client.models.inline_response2006 import InlineResponse2006
from unskript.thirdparty.pingdom.swagger_client.models.inline_response2007 import InlineResponse2007
from unskript.thirdparty.pingdom.swagger_client.models.inline_response2007_contact import InlineResponse2007Contact
from unskript.thirdparty.pingdom.swagger_client.models.inline_response2008 import InlineResponse2008
from unskript.thirdparty.pingdom.swagger_client.models.inline_response2009 import InlineResponse2009
from unskript.thirdparty.pingdom.swagger_client.models.maintenance_delete import MaintenanceDelete
from unskript.thirdparty.pingdom.swagger_client.models.maintenance_delete_resp_attrs import MaintenanceDeleteRespAttrs
from unskript.thirdparty.pingdom.swagger_client.models.maintenance_id import MaintenanceId
from unskript.thirdparty.pingdom.swagger_client.models.maintenance_id_delete_resp_attrs import MaintenanceIdDeleteRespAttrs
from unskript.thirdparty.pingdom.swagger_client.models.maintenance_id_put import MaintenanceIdPut
from unskript.thirdparty.pingdom.swagger_client.models.maintenance_id_put_resp_attrs import MaintenanceIdPutRespAttrs
from unskript.thirdparty.pingdom.swagger_client.models.maintenance_id_resp_attrs import MaintenanceIdRespAttrs
from unskript.thirdparty.pingdom.swagger_client.models.maintenance_id_resp_attrs_maintenance import MaintenanceIdRespAttrsMaintenance
from unskript.thirdparty.pingdom.swagger_client.models.maintenance_id_resp_attrs_maintenance_checks import MaintenanceIdRespAttrsMaintenanceChecks
from unskript.thirdparty.pingdom.swagger_client.models.maintenance_limit import MaintenanceLimit
from unskript.thirdparty.pingdom.swagger_client.models.maintenance_occurrences_delete import MaintenanceOccurrencesDelete
from unskript.thirdparty.pingdom.swagger_client.models.maintenance_occurrences_delete_resp_attrs import MaintenanceOccurrencesDeleteRespAttrs
from unskript.thirdparty.pingdom.swagger_client.models.maintenance_occurrences_from import MaintenanceOccurrencesFrom
from unskript.thirdparty.pingdom.swagger_client.models.maintenance_occurrences_id import MaintenanceOccurrencesId
from unskript.thirdparty.pingdom.swagger_client.models.maintenance_occurrences_id_delete_resp_attrs import MaintenanceOccurrencesIdDeleteRespAttrs
from unskript.thirdparty.pingdom.swagger_client.models.maintenance_occurrences_id_put import MaintenanceOccurrencesIdPut
from unskript.thirdparty.pingdom.swagger_client.models.maintenance_occurrences_id_put_resp_attrs import MaintenanceOccurrencesIdPutRespAttrs
from unskript.thirdparty.pingdom.swagger_client.models.maintenance_occurrences_id_resp_attrs import MaintenanceOccurrencesIdRespAttrs
from unskript.thirdparty.pingdom.swagger_client.models.maintenance_occurrences_id_resp_attrs_occurrence import MaintenanceOccurrencesIdRespAttrsOccurrence
from unskript.thirdparty.pingdom.swagger_client.models.maintenance_occurrences_maintenanceid import MaintenanceOccurrencesMaintenanceid
from unskript.thirdparty.pingdom.swagger_client.models.maintenance_occurrences_resp_attrs import MaintenanceOccurrencesRespAttrs
from unskript.thirdparty.pingdom.swagger_client.models.maintenance_occurrences_resp_attrs_occurrences import MaintenanceOccurrencesRespAttrsOccurrences
from unskript.thirdparty.pingdom.swagger_client.models.maintenance_occurrences_to import MaintenanceOccurrencesTo
from unskript.thirdparty.pingdom.swagger_client.models.maintenance_offset import MaintenanceOffset
from unskript.thirdparty.pingdom.swagger_client.models.maintenance_order import MaintenanceOrder
from unskript.thirdparty.pingdom.swagger_client.models.maintenance_orderby import MaintenanceOrderby
from unskript.thirdparty.pingdom.swagger_client.models.maintenance_post import MaintenancePost
from unskript.thirdparty.pingdom.swagger_client.models.maintenance_post_resp_attrs import MaintenancePostRespAttrs
from unskript.thirdparty.pingdom.swagger_client.models.maintenance_post_resp_attrs_maintenance import MaintenancePostRespAttrsMaintenance
from unskript.thirdparty.pingdom.swagger_client.models.maintenance_resp_attrs import MaintenanceRespAttrs
from unskript.thirdparty.pingdom.swagger_client.models.maintenance_resp_attrs_checks import MaintenanceRespAttrsChecks
from unskript.thirdparty.pingdom.swagger_client.models.maintenance_resp_attrs_maintenance import MaintenanceRespAttrsMaintenance
from unskript.thirdparty.pingdom.swagger_client.models.members import Members
from unskript.thirdparty.pingdom.swagger_client.models.metadata import Metadata
from unskript.thirdparty.pingdom.swagger_client.models.metadata_get import MetadataGET
from unskript.thirdparty.pingdom.swagger_client.models.metadata_get_authentications import MetadataGETAuthentications
from unskript.thirdparty.pingdom.swagger_client.models.modify_check_settings import ModifyCheckSettings
from unskript.thirdparty.pingdom.swagger_client.models.number_format import NumberFormat
from unskript.thirdparty.pingdom.swagger_client.models.one_of_create_check import OneOfCreateCheck
from unskript.thirdparty.pingdom.swagger_client.models.one_of_detailed_check import OneOfDetailedCheck
from unskript.thirdparty.pingdom.swagger_client.models.one_of_modify_check_settings import OneOfModifyCheckSettings
from unskript.thirdparty.pingdom.swagger_client.models.one_of_query_parameters import OneOfQueryParameters
from unskript.thirdparty.pingdom.swagger_client.models.one_ofsummary_performance_resp_attrs_summary import OneOfsummaryPerformanceRespAttrsSummary
from unskript.thirdparty.pingdom.swagger_client.models.one_ofsummary_resp_attrs_summary_responsetime_avgresponse import OneOfsummaryRespAttrsSummaryResponsetimeAvgresponse
from unskript.thirdparty.pingdom.swagger_client.models.pop3 import POP3
from unskript.thirdparty.pingdom.swagger_client.models.phone_code import PhoneCode
from unskript.thirdparty.pingdom.swagger_client.models.pop3_attributes import Pop3Attributes
from unskript.thirdparty.pingdom.swagger_client.models.probe import Probe
from unskript.thirdparty.pingdom.swagger_client.models.probes import Probes
from unskript.thirdparty.pingdom.swagger_client.models.property_check_id import PropertyCheckID
from unskript.thirdparty.pingdom.swagger_client.models.property_check_name import PropertyCheckName
from unskript.thirdparty.pingdom.swagger_client.models.property_from import PropertyFrom
from unskript.thirdparty.pingdom.swagger_client.models.query_parameters import QueryParameters
from unskript.thirdparty.pingdom.swagger_client.models.references import References
from unskript.thirdparty.pingdom.swagger_client.models.region import Region
from unskript.thirdparty.pingdom.swagger_client.models.report_performance import ReportPerformance
from unskript.thirdparty.pingdom.swagger_client.models.report_performance_report import ReportPerformanceReport
from unskript.thirdparty.pingdom.swagger_client.models.report_performance_report_intervals import ReportPerformanceReportIntervals
from unskript.thirdparty.pingdom.swagger_client.models.report_performance_report_steps import ReportPerformanceReportSteps
from unskript.thirdparty.pingdom.swagger_client.models.report_status_all import ReportStatusAll
from unskript.thirdparty.pingdom.swagger_client.models.report_status_single import ReportStatusSingle
from unskript.thirdparty.pingdom.swagger_client.models.results_checkid import ResultsCheckid
from unskript.thirdparty.pingdom.swagger_client.models.results_from import ResultsFrom
from unskript.thirdparty.pingdom.swagger_client.models.results_includeanalysis import ResultsIncludeanalysis
from unskript.thirdparty.pingdom.swagger_client.models.results_limit import ResultsLimit
from unskript.thirdparty.pingdom.swagger_client.models.results_maxresponse import ResultsMaxresponse
from unskript.thirdparty.pingdom.swagger_client.models.results_minresponse import ResultsMinresponse
from unskript.thirdparty.pingdom.swagger_client.models.results_offset import ResultsOffset
from unskript.thirdparty.pingdom.swagger_client.models.results_probes import ResultsProbes
from unskript.thirdparty.pingdom.swagger_client.models.results_resp_attrs import ResultsRespAttrs
from unskript.thirdparty.pingdom.swagger_client.models.results_resp_attrs_results import ResultsRespAttrsResults
from unskript.thirdparty.pingdom.swagger_client.models.results_status import ResultsStatus
from unskript.thirdparty.pingdom.swagger_client.models.results_to import ResultsTo
from unskript.thirdparty.pingdom.swagger_client.models.sm_ses import SMSes
from unskript.thirdparty.pingdom.swagger_client.models.sm_ses_inner import SMSesInner
from unskript.thirdparty.pingdom.swagger_client.models.smtp import SMTP
from unskript.thirdparty.pingdom.swagger_client.models.single_resp import SingleResp
from unskript.thirdparty.pingdom.swagger_client.models.single_resp_result import SingleRespResult
from unskript.thirdparty.pingdom.swagger_client.models.smtp_attributes_base import SmtpAttributesBase
from unskript.thirdparty.pingdom.swagger_client.models.smtp_attributes_get import SmtpAttributesGet
from unskript.thirdparty.pingdom.swagger_client.models.smtp_attributes_set import SmtpAttributesSet
from unskript.thirdparty.pingdom.swagger_client.models.state import State
from unskript.thirdparty.pingdom.swagger_client.models.step import Step
from unskript.thirdparty.pingdom.swagger_client.models.step_args import StepArgs
from unskript.thirdparty.pingdom.swagger_client.models.summary_average_bycountry import SummaryAverageBycountry
from unskript.thirdparty.pingdom.swagger_client.models.summary_average_byprobe import SummaryAverageByprobe
from unskript.thirdparty.pingdom.swagger_client.models.summary_average_checkid import SummaryAverageCheckid
from unskript.thirdparty.pingdom.swagger_client.models.summary_average_from import SummaryAverageFrom
from unskript.thirdparty.pingdom.swagger_client.models.summary_average_includeuptime import SummaryAverageIncludeuptime
from unskript.thirdparty.pingdom.swagger_client.models.summary_average_probes import SummaryAverageProbes
from unskript.thirdparty.pingdom.swagger_client.models.summary_average_to import SummaryAverageTo
from unskript.thirdparty.pingdom.swagger_client.models.summary_hoursofday_checkid import SummaryHoursofdayCheckid
from unskript.thirdparty.pingdom.swagger_client.models.summary_hoursofday_from import SummaryHoursofdayFrom
from unskript.thirdparty.pingdom.swagger_client.models.summary_hoursofday_probes import SummaryHoursofdayProbes
from unskript.thirdparty.pingdom.swagger_client.models.summary_hoursofday_resp_attrs import SummaryHoursofdayRespAttrs
from unskript.thirdparty.pingdom.swagger_client.models.summary_hoursofday_resp_attrs_hoursofday import SummaryHoursofdayRespAttrsHoursofday
from unskript.thirdparty.pingdom.swagger_client.models.summary_hoursofday_to import SummaryHoursofdayTo
from unskript.thirdparty.pingdom.swagger_client.models.summary_hoursofday_uselocaltime import SummaryHoursofdayUselocaltime
from unskript.thirdparty.pingdom.swagger_client.models.summary_outage_checkid import SummaryOutageCheckid
from unskript.thirdparty.pingdom.swagger_client.models.summary_outage_from import SummaryOutageFrom
from unskript.thirdparty.pingdom.swagger_client.models.summary_outage_order import SummaryOutageOrder
from unskript.thirdparty.pingdom.swagger_client.models.summary_outage_resp_attrs import SummaryOutageRespAttrs
from unskript.thirdparty.pingdom.swagger_client.models.summary_outage_resp_attrs_summary import SummaryOutageRespAttrsSummary
from unskript.thirdparty.pingdom.swagger_client.models.summary_outage_resp_attrs_summary_states import SummaryOutageRespAttrsSummaryStates
from unskript.thirdparty.pingdom.swagger_client.models.summary_outage_to import SummaryOutageTo
from unskript.thirdparty.pingdom.swagger_client.models.summary_performance_checkid import SummaryPerformanceCheckid
from unskript.thirdparty.pingdom.swagger_client.models.summary_performance_from import SummaryPerformanceFrom
from unskript.thirdparty.pingdom.swagger_client.models.summary_performance_includeuptime import SummaryPerformanceIncludeuptime
from unskript.thirdparty.pingdom.swagger_client.models.summary_performance_order import SummaryPerformanceOrder
from unskript.thirdparty.pingdom.swagger_client.models.summary_performance_probes import SummaryPerformanceProbes
from unskript.thirdparty.pingdom.swagger_client.models.summary_performance_resolution import SummaryPerformanceResolution
from unskript.thirdparty.pingdom.swagger_client.models.summary_performance_resp_attrs import SummaryPerformanceRespAttrs
from unskript.thirdparty.pingdom.swagger_client.models.summary_performance_results import SummaryPerformanceResults
from unskript.thirdparty.pingdom.swagger_client.models.summary_performance_results_inner import SummaryPerformanceResultsInner
from unskript.thirdparty.pingdom.swagger_client.models.summary_performance_to import SummaryPerformanceTo
from unskript.thirdparty.pingdom.swagger_client.models.summary_probes_checkid import SummaryProbesCheckid
from unskript.thirdparty.pingdom.swagger_client.models.summary_probes_from import SummaryProbesFrom
from unskript.thirdparty.pingdom.swagger_client.models.summary_probes_resp_attrs import SummaryProbesRespAttrs
from unskript.thirdparty.pingdom.swagger_client.models.summary_probes_to import SummaryProbesTo
from unskript.thirdparty.pingdom.swagger_client.models.summary_resp_attrs import SummaryRespAttrs
from unskript.thirdparty.pingdom.swagger_client.models.summary_resp_attrs_summary import SummaryRespAttrsSummary
from unskript.thirdparty.pingdom.swagger_client.models.summary_resp_attrs_summary_responsetime import SummaryRespAttrsSummaryResponsetime
from unskript.thirdparty.pingdom.swagger_client.models.summary_resp_attrs_summary_status import SummaryRespAttrsSummaryStatus
from unskript.thirdparty.pingdom.swagger_client.models.tcp import TCP
from unskript.thirdparty.pingdom.swagger_client.models.tag import Tag
from unskript.thirdparty.pingdom.swagger_client.models.tcp_attributes import TcpAttributes
from unskript.thirdparty.pingdom.swagger_client.models.team_id import TeamID
from unskript.thirdparty.pingdom.swagger_client.models.teams import Teams
from unskript.thirdparty.pingdom.swagger_client.models.timezone import Timezone
from unskript.thirdparty.pingdom.swagger_client.models.traceroute import Traceroute
from unskript.thirdparty.pingdom.swagger_client.models.traceroute_data import TracerouteData
from unskript.thirdparty.pingdom.swagger_client.models.udp import UDP
from unskript.thirdparty.pingdom.swagger_client.models.udp_attributes import UdpAttributes
from unskript.thirdparty.pingdom.swagger_client.models.unmonitored import Unmonitored
from unskript.thirdparty.pingdom.swagger_client.models.update_contact import UpdateContact
from unskript.thirdparty.pingdom.swagger_client.models.update_team import UpdateTeam
from unskript.thirdparty.pingdom.swagger_client.models.uptime import Uptime
from unskript.thirdparty.pingdom.swagger_client.models.weeks import Weeks
