"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
/// !cdk-integ *
const aws_cdk_lib_1 = require("aws-cdk-lib");
const lib_1 = require("../lib");
const lambda = require("aws-cdk-lib/aws-lambda");
const defaults = require("@aws-solutions-constructs/core");
// Setup
const app = new aws_cdk_lib_1.App();
const stack = new aws_cdk_lib_1.Stack(app, defaults.generateIntegStackName(__filename), {});
const lambdaProps = {
    code: lambda.Code.fromAsset(`${__dirname}/lambda`),
    runtime: lambda.Runtime.NODEJS_16_X,
    handler: 'index.handler',
};
const openSearchDomainProps = {
    clusterConfig: {
        dedicatedMasterCount: 3,
        dedicatedMasterEnabled: true,
        instanceCount: 3,
        zoneAwarenessEnabled: false,
    }
};
new lib_1.LambdaToOpenSearch(stack, 'test-lambda-opensearch', {
    lambdaFunctionProps: lambdaProps,
    openSearchDomainName: "disabledzoneawareness",
    openSearchDomainProps,
    deployVpc: true,
    vpcProps: {
        maxAzs: 1
    }
});
// Synth
app.synth();
//# sourceMappingURL=data:application/json;base64,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