/*
 * Decompiled with CFR 0.152.
 */
package ciat.agrobio.core;

import ciat.agrobio.core.CalculateDistancesD2;
import ciat.agrobio.core.DissimilarityMeasuresD2;
import ciat.agrobio.core.GeneralTools;
import ciat.agrobio.core.Logger;
import ciat.agrobio.core.SequenceD2;
import ciat.agrobio.io.FastaManager;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RecursiveAction;
import java.util.concurrent.atomic.AtomicInteger;

class CalculateD2ChildTask
extends RecursiveAction {
    private static AtomicInteger sequenceCounter = new AtomicInteger(0);
    private static AtomicInteger taskCount = new AtomicInteger(0);
    private final int id = taskCount.getAndIncrement();
    private ConcurrentHashMap<Integer, SequenceD2> seqVectors;
    private List<String> seqNames;
    private List<Integer> seqIds;
    private FastaManager frm;
    private double[][] distances;
    private int row;

    public static void resetCounters() {
        sequenceCounter = new AtomicInteger(0);
        taskCount = new AtomicInteger(0);
    }

    public CalculateD2ChildTask(ConcurrentHashMap<Integer, SequenceD2> seqVectors, List<String> seqNames, List<Integer> seqIds, FastaManager frm, double[][] distances, int row) {
        this.seqVectors = seqVectors;
        this.seqNames = seqNames;
        this.seqIds = seqIds;
        this.frm = frm;
        this.distances = distances;
        this.row = row;
    }

    @Override
    protected void compute() {
        try {
            SequenceD2 X = this.seqVectors.get(this.seqIds.get(this.row));
            for (int column = this.seqNames.size() - 1; column >= this.row; --column) {
                SequenceD2 Y = this.seqVectors.get(this.seqIds.get(column));
                double d2_measure = DissimilarityMeasuresD2.d2_S_Dissimilarity(X, Y);
                if (Math.abs(d2_measure) < Double.valueOf("1E-15")) {
                    d2_measure = 0.0;
                }
                this.distances[this.row][column] = Double.parseDouble(GeneralTools.decimalFormat.format(d2_measure));
                this.distances[column][this.row] = this.distances[this.row][column];
            }
            int count = sequenceCounter.incrementAndGet();
            if (count % 1 == 0 && CalculateDistancesD2.verbose) {
                Logger.infoCarret(this, "CalculateD2ChildTask(" + this.id + "): \t" + count);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

