/*
 * Decompiled with CFR 0.152.
 */
package ciat.agrobio.core;

import ciat.agrobio.core.CalculateD2ChildTask;
import ciat.agrobio.core.SequenceD2;
import ciat.agrobio.io.FastaManager;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RecursiveTask;

class CalculateD2Task
extends RecursiveTask<double[][]> {
    private ConcurrentHashMap<Integer, SequenceD2> seqVectors;
    private List<String> seqNames;
    private List<Integer> seqIds;
    private FastaManager frm;
    private double[][] distances;

    public CalculateD2Task(ConcurrentHashMap<Integer, SequenceD2> seqVectors, List<String> seqNames, List<Integer> seqIds, FastaManager frm, double[][] distances) {
        this.seqVectors = seqVectors;
        this.seqNames = seqNames;
        this.seqIds = seqIds;
        this.frm = frm;
        this.distances = distances;
    }

    @Override
    protected double[][] compute() {
        ArrayList<CalculateD2ChildTask> children = new ArrayList<CalculateD2ChildTask>();
        for (int row = this.seqNames.size() - 1; row >= 0; --row) {
            children.add(new CalculateD2ChildTask(this.seqVectors, this.seqNames, this.seqIds, this.frm, this.distances, row));
        }
        CalculateD2Task.invokeAll(children);
        return this.distances;
    }
}

