/*
 * Decompiled with CFR 0.152.
 */
package ciat.agrobio.core;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class Logger {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static boolean verbose = false;

    public static void setVerbose(boolean v) {
        verbose = v;
    }

    public static void info(Object caller, String msg) {
        if (verbose) {
            Logger.info(caller, msg, System.err);
        }
    }

    public static void info(Object caller, String msg, PrintStream ps) {
        if (verbose) {
            ps.println(caller.getClass().getSimpleName() + " [INFO] " + Logger.timestamp() + " - " + msg);
        }
    }

    public static void infoCarret(Object caller, String msg) {
        if (verbose) {
            Logger.info(caller, msg, System.err);
        }
    }

    public static void infoCarret(Object caller, String msg, PrintStream ps) {
        if (verbose) {
            ps.print("\r" + caller.getClass().getSimpleName() + " [INFO] " + Logger.timestamp() + " - " + msg);
            ps.flush();
        }
    }

    public static void warn(Object caller, String msg) {
        Logger.warn(caller, msg, System.err);
    }

    public static void warn(Object caller, String msg, PrintStream ps) {
        ps.println(caller.getClass().getSimpleName() + " [WARN] " + Logger.timestamp() + " - " + msg);
    }

    public static void error(Object caller, String msg) {
        Logger.error(caller, msg, System.err);
    }

    public static void error(Object caller, String msg, PrintStream ps) {
        ps.println(caller.getClass().getSimpleName() + " [ERROR] " + Logger.timestamp() + " - " + msg);
    }

    public static void debug(Object caller, String msg) {
        if (verbose) {
            Logger.debug(caller, msg, System.err);
        }
    }

    public static void debug(Object caller, String msg, PrintStream ps) {
        if (verbose) {
            ps.println(caller.getClass().getSimpleName() + " [DEBUG] " + Logger.timestamp() + " - " + msg);
        }
    }

    public static String timestamp() {
        return Logger.timestamp(DATE_FORMAT);
    }

    public static String timestamp(SimpleDateFormat dataFormat) {
        return dataFormat.format(Calendar.getInstance().getTime());
    }
}

