/*
 * Decompiled with CFR 0.152.
 */
package ciat.agrobio.core;

import ciat.agrobio.core.Sequence;
import ciat.agrobio.core.SequenceD2Interface;
import gnu.trove.iterator.TLongDoubleIterator;
import gnu.trove.iterator.TLongIntIterator;
import gnu.trove.map.hash.TLongDoubleHashMap;
import java.nio.ByteBuffer;

public class SequenceD2
extends Sequence
implements SequenceD2Interface {
    public int as = 0;
    public int ts = 0;
    public int cs = 0;
    public int gs = 0;
    private long totalCounts = 0L;
    private double norm = 0.0;
    private TLongDoubleHashMap kmerProbs = new TLongDoubleHashMap(256);

    public SequenceD2(Sequence read) {
        super(read.getSequenceId(), read.getHeader(), read.getSeq(), read.getQual());
    }

    @Override
    public long getAs() {
        return this.as;
    }

    @Override
    public long getTs() {
        return this.ts;
    }

    @Override
    public long getCs() {
        return this.cs;
    }

    @Override
    public long getGs() {
        return this.gs;
    }

    @Override
    public long getNumOfElements() {
        return 1L;
    }

    @Override
    public long getTotalATCG() {
        return (long)this.as + (long)this.ts + (long)this.cs + (long)this.gs;
    }

    @Override
    public double getDoubleCountForKmerCode(long kmerCode) {
        return super.getCountForKmerCode(kmerCode);
    }

    @Override
    public double getDoubleProbForKmerCode(long kmerCode) {
        return this.kmerProbs.get(kmerCode);
    }

    @Override
    public long getTotalCounts() {
        if (this.totalCounts == 0L) {
            TLongIntIterator it = this.iteratorCounts();
            while (it.hasNext()) {
                it.advance();
                this.totalCounts += (long)it.value();
            }
        }
        return this.totalCounts;
    }

    public double getNorm() {
        this.norm = 0.0;
        if (this.norm == 0.0) {
            TLongDoubleIterator it = this.iteratorProbs();
            while (it.hasNext()) {
                it.advance();
                this.norm += Math.pow(it.value(), 2.0);
            }
            this.norm = Math.sqrt(this.norm);
        }
        return this.norm;
    }

    public void normalizeProbs(double norm) {
        TLongDoubleIterator it = this.iteratorProbs();
        while (it.hasNext()) {
            it.advance();
            this.kmerProbs.put(it.key(), it.value() / norm);
        }
    }

    public void insertKmerProb(long kmerCode, short A, short T, short C, short G) {
        if (kmerCode < 0L) {
            return;
        }
        this.kmerProbs.put(kmerCode, ((ByteBuffer)ByteBuffer.wrap(new byte[8]).putShort(A).putShort(T).putShort(C).putShort(G).position(0)).getDouble());
    }

    public void insertKmerProb(long kmerCode, double prob) {
        if (kmerCode < 0L) {
            return;
        }
        this.kmerProbs.putIfAbsent(kmerCode, prob);
    }

    public void insertKmerProbForce(long kmerCode, double prob) {
        if (kmerCode < 0L) {
            return;
        }
        this.kmerProbs.put(kmerCode, prob);
    }

    public void adjustKmerProb(long kmerCode, double prob) {
        if (kmerCode < 0L) {
            return;
        }
        this.kmerProbs.adjustOrPutValue(kmerCode, prob, prob);
    }

    public double calculateProbs(int k) {
        double sum = 0.0;
        long total = this.getTotalATCG();
        ByteBuffer bb = ByteBuffer.wrap(new byte[8]);
        TLongDoubleIterator it = this.iteratorProbs();
        while (it.hasNext()) {
            it.advance();
            long kmerCode = it.key();
            ((ByteBuffer)bb.position(0)).putDouble(this.kmerProbs.get(kmerCode)).position(0);
            short a = bb.getShort();
            short t = bb.getShort();
            short c = bb.getShort();
            short g = bb.getShort();
            double prob = Math.pow((double)this.as / (double)total, a);
            prob *= Math.pow((double)this.ts / (double)total, t);
            prob *= Math.pow((double)this.cs / (double)total, c);
            this.insertKmerProbForce(kmerCode, prob *= Math.pow((double)this.gs / (double)total, g));
            sum += prob;
        }
        return sum;
    }

    public void clear() {
        super.clearFull();
        if (this.kmerProbs != null) {
            this.kmerProbs.clear();
            this.kmerProbs = null;
        }
    }

    @Override
    public TLongDoubleIterator iteratorProbs() {
        return new MyIterator();
    }

    private class MyIterator
    implements TLongDoubleIterator {
        private final TLongDoubleIterator iterator;
        private int current;
        private boolean hasNext;

        MyIterator() {
            this.iterator = SequenceD2.this.kmerProbs.iterator();
            this.current = SequenceD2.this.kmerProbs.size();
        }

        @Override
        public boolean hasNext() {
            this.hasNext = this.current > 0;
            return this.hasNext;
        }

        @Override
        public void advance() {
            if (!this.hasNext) {
                return;
            }
            this.iterator.advance();
            --this.current;
        }

        @Override
        public long key() {
            return this.iterator.key();
        }

        @Override
        public double value() {
            return this.iterator.value();
        }

        @Override
        public void remove() {
        }

        @Override
        public double setValue(double arg0) {
            return 0.0;
        }
    }
}

