/*
 * Decompiled with CFR 0.152.
 */
package ciat.agrobio.hcluster;

import ciat.agrobio.core.Logger;
import gnu.trove.iterator.TLongDoubleIterator;
import gnu.trove.map.hash.TLongDoubleHashMap;

public class ClusterVectorTrove {
    private double norm = 0.0;
    private TLongDoubleHashMap kmersLo1;
    private TLongDoubleHashMap kmersLo2;
    private TLongDoubleHashMap kmersHi1;
    private TLongDoubleHashMap kmersHi2;
    private long splitKey;

    public ClusterVectorTrove(long initialCapacityLong, long splitKey) {
        int initialCapacityInt = (int)((double)(initialCapacityLong / 4L) * 1.1);
        if (initialCapacityInt > 1000000000) {
            initialCapacityInt = 1000000000;
        }
        Logger.info(this, "\tTrove size/4=" + initialCapacityInt);
        this.kmersLo1 = new TLongDoubleHashMap(initialCapacityInt);
        this.kmersLo1.ensureCapacity(initialCapacityInt);
        this.kmersLo2 = new TLongDoubleHashMap(initialCapacityInt);
        this.kmersLo2.ensureCapacity(initialCapacityInt);
        this.kmersHi1 = new TLongDoubleHashMap(initialCapacityInt);
        this.kmersHi1.ensureCapacity(initialCapacityInt);
        this.kmersHi2 = new TLongDoubleHashMap(initialCapacityInt);
        this.kmersHi2.ensureCapacity(initialCapacityInt);
        this.splitKey = splitKey;
    }

    public void clear() {
        if (this.kmersLo1 != null) {
            this.kmersLo1.clear();
            this.kmersLo1 = null;
        }
        if (this.kmersLo2 != null) {
            this.kmersLo2.clear();
            this.kmersLo2 = null;
        }
        if (this.kmersHi1 != null) {
            this.kmersHi1.clear();
            this.kmersHi1 = null;
        }
        if (this.kmersHi2 != null) {
            this.kmersHi2.clear();
            this.kmersHi2 = null;
        }
    }

    public boolean isEmpty() {
        return !(this.kmersLo1 != null && !this.kmersLo1.isEmpty() || this.kmersLo2 != null && !this.kmersLo2.isEmpty() || this.kmersHi1 != null && !this.kmersHi1.isEmpty() || this.kmersHi2 != null && !this.kmersHi2.isEmpty());
    }

    public void insertKMer(long kmerCode, double count) {
        try {
            if (kmerCode < 0L) {
                return;
            }
            if (kmerCode > this.splitKey) {
                if (kmerCode > this.splitKey * 15L / 10L) {
                    this.kmersHi2.adjustOrPutValue(kmerCode, count, count);
                } else {
                    this.kmersHi1.adjustOrPutValue(kmerCode, count, count);
                }
            } else if (kmerCode > this.splitKey * 5L / 10L) {
                this.kmersLo2.adjustOrPutValue(kmerCode, count, count);
            } else {
                this.kmersLo1.adjustOrPutValue(kmerCode, count, count);
            }
        }
        catch (Exception e) {
            System.out.println("\tTrove full\tLo1=" + this.kmersLo1.size() + "\tLo2=" + this.kmersLo2.size() + "\tHi1=" + this.kmersHi1.size() + "\tHi2=" + this.kmersHi2.size());
        }
    }

    public void replaceKMer(long kmerCode, double count) {
        if (kmerCode < 0L) {
            return;
        }
        if (kmerCode > this.splitKey) {
            if (kmerCode > this.splitKey * 15L / 10L) {
                this.kmersHi2.put(kmerCode, count);
            } else {
                this.kmersHi1.put(kmerCode, count);
            }
        } else if (kmerCode > this.splitKey * 5L / 10L) {
            this.kmersLo2.put(kmerCode, count);
        } else {
            this.kmersLo1.put(kmerCode, count);
        }
    }

    public double getCountForKmerCode(long kmerCode) {
        if (kmerCode > this.splitKey) {
            if (kmerCode > this.splitKey * 15L / 10L) {
                return this.kmersHi2.get(kmerCode);
            }
            return this.kmersHi1.get(kmerCode);
        }
        if (kmerCode > this.splitKey * 5L / 10L) {
            return this.kmersLo2.get(kmerCode);
        }
        return this.kmersLo1.get(kmerCode);
    }

    public long size() {
        return (long)this.kmersLo1.size() + (long)this.kmersHi1.size() + (long)this.kmersLo2.size() + (long)this.kmersHi2.size();
    }

    public void normalize(double norm) {
        if (this.isEmpty() || norm == 0.0) {
            return;
        }
        TLongDoubleIterator it = this.iterator();
        while (it.hasNext()) {
            it.advance();
            long kmerCode = it.key();
            double kmerCount = it.value();
            this.replaceKMer(kmerCode, kmerCount / norm);
        }
    }

    public double getNorm() {
        double n = this.norm;
        if (n == 0.0) {
            this.norm = n = this.computeNorm();
        }
        return n;
    }

    private double computeNorm() {
        double norm = 0.0;
        try {
            if (this.isEmpty()) {
                return 0.0;
            }
            TLongDoubleIterator it = this.iterator();
            while (it.hasNext()) {
                it.advance();
                norm += it.value() * it.value();
            }
            return Math.sqrt(norm);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Math.sqrt(norm);
        }
    }

    public TLongDoubleIterator iterator() {
        return new MyIterator();
    }

    private class MyIterator
    implements TLongDoubleIterator {
        private final TLongDoubleIterator iteratorLo1;
        private final TLongDoubleIterator iteratorLo2;
        private final TLongDoubleIterator iteratorHi1;
        private final TLongDoubleIterator iteratorHi2;
        private int currentLo1;
        private int currentLo2;
        private int currentHi1;
        private int currentHi2;
        private boolean isOnLo1;
        private boolean isOnLo2;
        private boolean isOnHi1;
        private boolean isOnHi2;
        private boolean hasNext;

        MyIterator() {
            this.iteratorLo1 = ClusterVectorTrove.this.kmersLo1.iterator();
            this.iteratorLo2 = ClusterVectorTrove.this.kmersLo2.iterator();
            this.iteratorHi1 = ClusterVectorTrove.this.kmersHi1.iterator();
            this.iteratorHi2 = ClusterVectorTrove.this.kmersHi2.iterator();
            this.currentLo1 = ClusterVectorTrove.this.kmersLo1.size();
            this.currentLo2 = ClusterVectorTrove.this.kmersLo2.size();
            this.currentHi1 = ClusterVectorTrove.this.kmersHi1.size();
            this.currentHi2 = ClusterVectorTrove.this.kmersHi2.size();
            this.isOnLo1 = true;
            this.isOnLo2 = false;
            this.isOnHi1 = false;
            this.isOnHi2 = false;
        }

        @Override
        public boolean hasNext() {
            if (this.isOnLo1) {
                boolean bl = this.hasNext = this.currentLo1 > 0;
                if (!this.hasNext) {
                    this.isOnLo1 = false;
                    this.isOnLo2 = true;
                    return this.hasNext();
                }
                return this.hasNext;
            }
            if (this.isOnLo2) {
                boolean bl = this.hasNext = this.currentLo2 > 0;
                if (!this.hasNext) {
                    this.isOnLo2 = false;
                    this.isOnHi1 = true;
                    return this.hasNext();
                }
                return this.hasNext;
            }
            if (this.isOnHi1) {
                boolean bl = this.hasNext = this.currentHi1 > 0;
                if (!this.hasNext) {
                    this.isOnHi1 = false;
                    this.isOnHi2 = true;
                    return this.hasNext();
                }
                return this.hasNext;
            }
            if (this.isOnHi2) {
                boolean bl = this.hasNext = this.currentHi2 > 0;
                if (!this.hasNext) {
                    this.isOnHi2 = false;
                    return false;
                }
            }
            return this.hasNext;
        }

        @Override
        public void advance() {
            if (!this.hasNext) {
                return;
            }
            if (this.isOnLo1) {
                this.iteratorLo1.advance();
                --this.currentLo1;
            } else if (this.isOnLo2) {
                this.iteratorLo2.advance();
                --this.currentLo2;
            } else if (this.isOnHi1) {
                this.iteratorHi1.advance();
                --this.currentHi1;
            } else if (this.isOnHi2) {
                this.iteratorHi2.advance();
                --this.currentHi2;
            }
        }

        @Override
        public long key() {
            if (this.isOnLo1) {
                return this.iteratorLo1.key();
            }
            if (this.isOnLo2) {
                return this.iteratorLo2.key();
            }
            if (this.isOnHi1) {
                return this.iteratorHi1.key();
            }
            if (this.isOnHi2) {
                return this.iteratorHi2.key();
            }
            return 0L;
        }

        @Override
        public double value() {
            if (this.isOnLo1) {
                return this.iteratorLo1.value();
            }
            if (this.isOnLo2) {
                return this.iteratorLo2.value();
            }
            if (this.isOnHi1) {
                return this.iteratorHi1.value();
            }
            if (this.isOnHi2) {
                return this.iteratorHi2.value();
            }
            return 0.0;
        }

        @Override
        public void remove() {
        }

        @Override
        public double setValue(double arg0) {
            return 0.0;
        }
    }
}

