/*
 * Decompiled with CFR 0.152.
 */
package ciat.agrobio.io;

import ciat.agrobio.core.GeneralTools;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPInputStream;

public class FastaIterator<T>
implements Iterable<List<byte[]>> {
    private static final byte LF = 10;
    private static int CHUNK_SIZE = (int)Runtime.getRuntime().maxMemory() / 32;
    private static ByteBuffer buffer_static;
    private Iterator<String> inputPaths;

    public FastaIterator(String ... inputPaths) {
        this(Arrays.asList(inputPaths));
    }

    public FastaIterator(List<String> inputPaths) {
        this.inputPaths = inputPaths.iterator();
    }

    @Override
    public Iterator<List<byte[]>> iterator() {
        return new Iterator<List<byte[]>>(){
            private int chunkPos = -1;
            private ByteBuffer buffer;
            private BufferedInputStream bis;

            @Override
            public List<byte[]> next() {
                try {
                    if (!this.hasNext()) {
                        return null;
                    }
                    ArrayList<byte[]> entries = new ArrayList<byte[]>();
                    boolean last_round = false;
                    boolean ready = false;
                    int prev_line_start = 0;
                    int pos = 0;
                    while (this.hasNext()) {
                        while (this.buffer.hasRemaining()) {
                            byte b = this.buffer.get();
                            if (b == 10) {
                                entries.add(Arrays.copyOfRange(this.buffer.array(), prev_line_start, pos));
                                prev_line_start = pos + 1;
                                this.chunkPos = -1;
                                ready = false;
                            } else if (!(entries.isEmpty() || b != 62 && b != 64)) {
                                this.chunkPos = pos;
                                ready = true;
                                if (last_round) break;
                            }
                            ++pos;
                        }
                        last_round = true;
                        if (entries.isEmpty() && pos > 0) {
                            CHUNK_SIZE = 2 * CHUNK_SIZE;
                            if (CHUNK_SIZE > Integer.MAX_VALUE) {
                                CHUNK_SIZE = Integer.MAX_VALUE;
                            }
                            System.err.println("IO Chunk: " + CHUNK_SIZE);
                            ByteBuffer temp = ByteBuffer.allocate(CHUNK_SIZE);
                            buffer_static.position(0);
                            temp.position(CHUNK_SIZE / 2);
                            temp.put(buffer_static);
                            buffer_static = temp;
                            this.buffer = null;
                            this.chunkPos = CHUNK_SIZE / 2;
                            prev_line_start = 0;
                            pos = 0;
                            continue;
                        }
                        if (ready) {
                            this.buffer = null;
                            break;
                        }
                        if (pos > prev_line_start) {
                            entries.add(Arrays.copyOfRange(this.buffer.array(), prev_line_start, pos));
                        }
                        this.buffer = null;
                        this.chunkPos = -1;
                        prev_line_start = 0;
                        pos = 0;
                    }
                    if (entries.isEmpty()) {
                        return null;
                    }
                    return entries;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }

            @Override
            public boolean hasNext() {
                return this.buffer == null ? (this.buffer = this.nextBuffer()) != null : true;
            }

            private ByteBuffer nextBuffer() {
                try {
                    int read;
                    if (this.bis == null) {
                        if (FastaIterator.this.inputPaths.hasNext()) {
                            File file = new File((String)FastaIterator.this.inputPaths.next());
                            this.bis = GeneralTools.isGZipped(file) ? new BufferedInputStream(new GZIPInputStream((InputStream)new FileInputStream(file), CHUNK_SIZE)) : new BufferedInputStream(new FileInputStream(file), CHUNK_SIZE);
                            this.chunkPos = -1;
                        } else {
                            return null;
                        }
                    }
                    int residual = 0;
                    if (this.chunkPos >= 0 && this.chunkPos < buffer_static.limit()) {
                        residual = buffer_static.limit() - this.chunkPos;
                        byte[] b = new byte[residual];
                        buffer_static.position(this.chunkPos);
                        buffer_static.get(b);
                        buffer_static.position(0);
                        buffer_static.put(b);
                        this.chunkPos = -1;
                    }
                    if ((read = this.bis.read(buffer_static.array(), residual, CHUNK_SIZE - residual)) >= 0) {
                        buffer_static.limit(residual + read);
                    } else {
                        buffer_static.limit(buffer_static.arrayOffset());
                        this.bis.close();
                        this.bis = null;
                    }
                    buffer_static.position(0);
                    return buffer_static;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    static {
        if ((CHUNK_SIZE = CHUNK_SIZE / 1024 * 1024) < 0x800000) {
            CHUNK_SIZE = 0x800000;
        }
        if (CHUNK_SIZE > Integer.MAX_VALUE) {
            CHUNK_SIZE = Integer.MAX_VALUE;
        }
        System.err.println("Max RAM: " + Runtime.getRuntime().maxMemory());
        System.err.println("Using MappedByteBuffer");
        System.err.println("IO Chunk: " + CHUNK_SIZE);
        buffer_static = ByteBuffer.allocate(CHUNK_SIZE);
    }
}

