/*
 * Decompiled with CFR 0.152.
 */
package ciat.agrobio.io;

import ciat.agrobio.core.GeneralTools;
import ciat.agrobio.core.Logger;
import ciat.agrobio.core.Sequence;
import ciat.agrobio.io.FastaIterator;
import ciat.agrobio.io.FastaStreamingIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class FastaManager
implements Runnable {
    private BlockingQueue<Sequence> sequences = null;
    private ConcurrentHashMap<Integer, Sequence> staticSequences = null;
    private List<Integer> sequenceIds = null;
    private List<String> sequenceNames = null;
    private AtomicInteger currSequenceId = new AtomicInteger(0);
    public boolean isFastq = false;
    private boolean keepQualities = false;
    private List<String> inputFileNames = null;
    private boolean done = false;
    private CountDownLatch startSignal = null;
    private CountDownLatch doneSignal = null;
    private boolean useMappedBuffer = false;

    public FastaManager(boolean isFastq, boolean keepQualities, List<String> inputFileNames, CountDownLatch startSignal, CountDownLatch doneSignal, boolean useMappedBuffer) {
        this.isFastq = isFastq;
        this.keepQualities = keepQualities;
        this.inputFileNames = inputFileNames;
        this.startSignal = startSignal;
        this.doneSignal = doneSignal;
        this.useMappedBuffer = useMappedBuffer;
        this.sequences = new LinkedBlockingQueue<Sequence>();
        this.staticSequences = new ConcurrentHashMap();
        this.sequenceIds = new ArrayList<Integer>();
        this.sequenceNames = new ArrayList<String>();
    }

    public void clear() {
        if (this.sequences != null) {
            this.sequences.clear();
        }
        this.sequences = new LinkedBlockingQueue<Sequence>();
        if (this.staticSequences != null) {
            this.staticSequences.clear();
        }
        this.staticSequences = new ConcurrentHashMap();
        if (this.sequenceIds != null) {
            this.sequenceIds.clear();
        }
        this.sequenceIds = new ArrayList<Integer>();
        if (this.sequenceNames != null) {
            this.sequenceNames.clear();
        }
        this.sequenceNames = new ArrayList<String>();
    }

    public final ConcurrentHashMap<Integer, Sequence> getStaticSequences() {
        return this.staticSequences;
    }

    public final List<Integer> getSequenceIds() {
        return this.sequenceIds;
    }

    public final List<String> getSequenceNames() {
        return this.sequenceNames;
    }

    public boolean hasMore() {
        if (!this.done) {
            return true;
        }
        return !this.sequences.isEmpty();
    }

    private boolean putSequence(Sequence sequence) {
        try {
            if (sequence == null || sequence.getSeq() == null || sequence.getHeader() == null) {
                return false;
            }
            this.sequences.put(sequence);
            this.sequenceIds.add(sequence.getSequenceId());
            this.sequenceNames.add(sequence.getShortName());
            return true;
        }
        catch (Exception e) {
            this.sequences.remove(sequence);
            this.sequenceIds.remove(sequence.getSequenceId());
            this.sequenceNames.remove(sequence.getShortName());
            return false;
        }
    }

    public Sequence getNextSequence() {
        try {
            return this.sequences.poll(100L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean addSequence(byte[] header, byte[] seq) {
        return this.addSequence(header, seq, null);
    }

    private boolean addSequence(byte[] header, byte[] seq, byte[] qual) {
        try {
            boolean ret = true;
            int seqId = this.currSequenceId.incrementAndGet();
            Sequence sequence = qual == null ? new Sequence(seqId, header, seq) : new Sequence(seqId, header, seq, qual);
            if (!this.putSequence(sequence)) {
                this.currSequenceId.decrementAndGet();
                ret = false;
            }
            return ret;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void run() {
        try {
            this.done = false;
            Logger.info(this, "START READ\tStreaming:" + !this.useMappedBuffer);
            this.startSignal.countDown();
            Iterable<List<byte[]>> iterator = this.useMappedBuffer ? new FastaIterator(this.inputFileNames) : new FastaStreamingIterator(this.inputFileNames);
            for (List<byte[]> reads_chunk : iterator) {
                if (reads_chunk == null) continue;
                this.processReadLines(reads_chunk);
            }
            Logger.info(this, "END READ");
            Logger.info(this, this.isFastq ? "FASTQ" : "FASTA");
            this.done = true;
            this.doneSignal.countDown();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    private void processReadLines(List<byte[]> reads_chunk) {
        try {
            boolean on_qual = false;
            byte[] header = null;
            ArrayList<byte[]> seq = new ArrayList<byte[]>();
            ArrayList<byte[]> qual = new ArrayList<byte[]>();
            if (!this.isFastq) {
                for (byte[] line : reads_chunk) {
                    if (line.length == 0) continue;
                    if (line[0] == 62) {
                        if (!seq.isEmpty()) {
                            this.addSequence(header, GeneralTools.concat(seq));
                            seq.clear();
                        }
                        header = line;
                        continue;
                    }
                    seq.add(line);
                }
                if (!seq.isEmpty()) {
                    this.addSequence(header, GeneralTools.concat(seq));
                    seq.clear();
                }
            } else {
                for (byte[] line : reads_chunk) {
                    if (line.length == 0) continue;
                    if (line[0] == 64) {
                        if (!seq.isEmpty() && !qual.isEmpty()) {
                            if (this.keepQualities) {
                                this.addSequence(header, GeneralTools.concat(seq), GeneralTools.concat(qual));
                            } else {
                                this.addSequence(header, GeneralTools.concat(seq));
                            }
                            seq.clear();
                            qual.clear();
                            on_qual = false;
                        }
                        header = line;
                        continue;
                    }
                    if (line[0] == 43) {
                        on_qual = true;
                        continue;
                    }
                    if (on_qual) {
                        qual.add(line);
                        continue;
                    }
                    seq.add(line);
                }
                if (!seq.isEmpty() && !qual.isEmpty()) {
                    if (this.keepQualities) {
                        this.addSequence(header, GeneralTools.concat(seq), GeneralTools.concat(qual));
                    } else {
                        this.addSequence(header, GeneralTools.concat(seq));
                    }
                    seq.clear();
                    qual.clear();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

