/*
 * Decompiled with CFR 0.152.
 */
package ciat.agrobio.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.zip.GZIPInputStream;

public class FastaStreamingIterator
implements Iterable<List<byte[]>> {
    private final List<String> inputPaths;

    public FastaStreamingIterator(List<String> inputPaths) {
        this.inputPaths = inputPaths;
    }

    public FastaStreamingIterator(String ... inputPaths) {
        this(Arrays.asList(inputPaths));
    }

    @Override
    public Iterator<List<byte[]>> iterator() {
        return new Iterator<List<byte[]>>(){
            private BufferedReader reader = null;
            private int currentPathIndex = -1;
            private boolean usingStdin = false;
            private String line = null;
            private List<byte[]> nextChunk = null;

            private void advanceFile() {
                try {
                    InputStream in;
                    if (this.reader != null && !this.usingStdin) {
                        this.reader.close();
                    }
                    ++this.currentPathIndex;
                    if (this.currentPathIndex >= FastaStreamingIterator.this.inputPaths.size()) {
                        this.reader = null;
                        return;
                    }
                    String path = (String)FastaStreamingIterator.this.inputPaths.get(this.currentPathIndex);
                    if (path.equals("-")) {
                        in = System.in;
                        this.usingStdin = true;
                    } else {
                        File f = new File(path);
                        in = new FileInputStream(f);
                        if (this.isGzipped(f)) {
                            in = new GZIPInputStream(in);
                        }
                    }
                    this.reader = new BufferedReader(new InputStreamReader(in));
                }
                catch (IOException e) {
                    throw new RuntimeException("Error opening input: " + (String)FastaStreamingIterator.this.inputPaths.get(this.currentPathIndex), e);
                }
            }

            private boolean isGzipped(File file) throws IOException {
                try (FileInputStream in = new FileInputStream(file);){
                    byte[] sig = new byte[2];
                    int n = ((InputStream)in).read(sig);
                    boolean bl = n == 2 && sig[0] == 31 && sig[1] == -117;
                    return bl;
                }
            }

            private List<byte[]> nextRecord() {
                try {
                    ArrayList<byte[]> chunk = new ArrayList<byte[]>();
                    while (true) {
                        if (this.reader == null) {
                            this.advanceFile();
                            if (this.reader == null) {
                                return null;
                            }
                        }
                        if (this.line == null) {
                            this.line = this.reader.readLine();
                        }
                        while (this.line != null && this.line.trim().isEmpty()) {
                            this.line = this.reader.readLine();
                        }
                        if (this.line == null) {
                            this.advanceFile();
                            continue;
                        }
                        if (this.line.startsWith(">") || this.line.startsWith("@")) {
                            chunk.add(this.line.getBytes());
                            String prefix = this.line.startsWith("@") ? "@" : ">";
                            this.line = this.reader.readLine();
                            while (!(this.line == null || this.line.startsWith(">") || this.line.startsWith("@") || this.line.startsWith("+"))) {
                                chunk.add(this.line.getBytes());
                                this.line = this.reader.readLine();
                            }
                            if (prefix.equals("@") && this.line != null && this.line.startsWith("+")) {
                                chunk.add(this.line.getBytes());
                                this.line = this.reader.readLine();
                                while (this.line != null && !this.line.startsWith("@") && !this.line.startsWith(">")) {
                                    chunk.add(this.line.getBytes());
                                    this.line = this.reader.readLine();
                                }
                            }
                            return chunk;
                        }
                        this.line = this.reader.readLine();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Error reading FASTA/FASTQ input", e);
                }
            }

            @Override
            public boolean hasNext() {
                if (this.nextChunk != null) {
                    return true;
                }
                this.nextChunk = this.nextRecord();
                return this.nextChunk != null;
            }

            @Override
            public List<byte[]> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                List<byte[]> result = this.nextChunk;
                this.nextChunk = null;
                return result;
            }
        };
    }
}

