/*
 * Decompiled with CFR 0.152.
 */
package ciat.agrobio.io;

import ciat.agrobio.io.VCFDecoderInterface;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class VCFIterator<T>
implements Iterable<List<T>> {
    private static long CHUNK_SIZE = Runtime.getRuntime().maxMemory() / 32L;
    private final VCFDecoderInterface<T> decoder;
    private Iterator<String> inputPaths;

    public VCFIterator(VCFDecoderInterface<T> decoder, String ... inputPaths) {
        this(decoder, Arrays.asList(inputPaths));
    }

    public VCFIterator(VCFDecoderInterface<T> decoder, List<String> inputPaths) {
        this.inputPaths = inputPaths.iterator();
        this.decoder = decoder;
    }

    @Override
    public Iterator<List<T>> iterator() {
        return new Iterator<List<T>>(){
            private List<T> entries;
            private long chunkPos = 0L;
            private MappedByteBuffer buffer;
            private FileChannel channel;
            private final ByteOrder byteOrder = ByteOrder.nativeOrder();

            @Override
            public boolean hasNext() {
                if (this.buffer == null || !this.buffer.hasRemaining()) {
                    this.buffer = this.nextBuffer(this.chunkPos);
                    if (this.buffer == null) {
                        return false;
                    }
                    this.buffer.order(this.byteOrder);
                }
                Object result = null;
                while (true) {
                    Object t = VCFIterator.this.decoder.decode(this.buffer);
                    result = t;
                    if (t == null) break;
                    if (this.entries == null) {
                        this.entries = new ArrayList();
                    }
                    this.entries.add(result);
                }
                this.chunkPos += (long)this.buffer.position();
                this.buffer = null;
                if (this.entries != null) {
                    return true;
                }
                try {
                    this.channel.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return false;
            }

            private MappedByteBuffer nextBuffer(long position) {
                try {
                    if (this.channel == null || this.channel.size() == position) {
                        if (this.channel != null) {
                            this.channel.close();
                            this.channel = null;
                        }
                        if (VCFIterator.this.inputPaths.hasNext()) {
                            File file = new File((String)VCFIterator.this.inputPaths.next());
                            this.channel = new RandomAccessFile(file, "r").getChannel();
                            this.chunkPos = 0L;
                            position = 0L;
                        } else {
                            return null;
                        }
                    }
                    long chunkSize = CHUNK_SIZE;
                    if (this.channel.size() - position < chunkSize) {
                        chunkSize = this.channel.size() - position;
                    }
                    return this.channel.map(FileChannel.MapMode.READ_ONLY, this.chunkPos, chunkSize);
                }
                catch (IOException e) {
                    try {
                        this.channel.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    throw new RuntimeException(e);
                }
            }

            @Override
            public List<T> next() {
                List res = this.entries;
                this.entries = null;
                return res;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    static {
        if ((CHUNK_SIZE = CHUNK_SIZE / 1024L * 1024L) < 0x800000L) {
            CHUNK_SIZE = 0x800000L;
        }
        if (CHUNK_SIZE > Integer.MAX_VALUE) {
            CHUNK_SIZE = Integer.MAX_VALUE;
        }
        System.err.println("Max RAM: " + Runtime.getRuntime().maxMemory());
        System.err.println("Using MappedByteBuffer");
        System.err.println("IO Chunk: " + CHUNK_SIZE);
    }
}

