/*
 * Decompiled with CFR 0.152.
 */
package ciat.agrobio.io;

import ciat.agrobio.core.Logger;
import ciat.agrobio.core.Variant;
import ciat.agrobio.core.VariantManager;
import ciat.agrobio.io.VCFDecoder;
import ciat.agrobio.io.VCFIterator;
import ciat.agrobio.io.VCFStreamingIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class VCFManager
implements Runnable {
    private List<byte[]> commentData;
    private byte[][] headerData;
    private AtomicInteger currVariantId = new AtomicInteger(0);
    private VariantManager vm = null;
    private List<String> inputFileNames = null;
    private boolean done = false;
    private CountDownLatch startSignal = null;
    private CountDownLatch doneSignal = null;
    private boolean useMappedBuffer = false;
    private boolean verbose = false;

    public VCFManager(VariantManager vm, List<String> inputFileNames, CountDownLatch startSignal, CountDownLatch doneSignal, boolean useMappedBuffer, boolean verbose) {
        this.vm = vm;
        this.inputFileNames = inputFileNames;
        this.startSignal = startSignal;
        this.doneSignal = doneSignal;
        this.useMappedBuffer = useMappedBuffer;
        this.verbose = verbose;
        this.commentData = new ArrayList<byte[]>();
    }

    public final List<byte[]> getCommentData() {
        return this.commentData;
    }

    public final byte[][] getHeaderData() {
        return this.headerData;
    }

    public boolean isDone() {
        return this.done;
    }

    @Override
    public void run() {
        try {
            Logger.setVerbose(this.verbose);
            this.done = false;
            this.startSignal.countDown();
            Logger.info(this, "START READ\tStreaming:" + !this.useMappedBuffer);
            VCFDecoder decoder = new VCFDecoder();
            if (this.useMappedBuffer) {
                VCFIterator<byte[][]> iterator = new VCFIterator<byte[][]>(decoder, this.inputFileNames);
                for (List<byte[][]> list : iterator) {
                    for (int i = 0; i < list.size(); ++i) {
                        byte[][] line = list.get(i);
                        this.processVariantLine(line);
                    }
                    list.clear();
                    Object var4_7 = null;
                }
            } else {
                VCFStreamingIterator<byte[][]> iterator = new VCFStreamingIterator<byte[][]>(decoder, this.verbose, this.inputFileNames);
                for (byte[][] byArray : iterator) {
                    this.processVariantLine(byArray);
                }
            }
            Logger.info(this, "END READ");
            this.vm.setNumVariants(this.currVariantId.get());
            this.done = true;
            this.doneSignal.countDown();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    private void processVariantLine(byte[][] line) {
        try {
            if (line[0][0] == 35 && line[0][1] == 35) {
                this.commentData.add(line[0]);
            } else if (line[0][0] == 35) {
                this.headerData = line;
                this.vm.setNumSamples(this.headerData.length - 9);
            } else if (line.length >= 10) {
                Variant variant = new Variant(this.currVariantId.incrementAndGet(), line);
                if (this.vm.getPloidy() <= 0) {
                    String format = variant.getFormat();
                    int indexGT = Arrays.asList(format.split(":")).indexOf("GT");
                    String GT = new String(variant.getDataRaw()[9]).split(":")[indexGT];
                    if (GT.contains("/")) {
                        this.vm.setPloidy((byte)GT.split("/").length);
                    } else if (GT.contains("|")) {
                        this.vm.setPloidy((byte)GT.split("\\|").length);
                    } else {
                        this.vm.setPloidy((byte)1);
                    }
                }
                while (!this.vm.putVariantRaw(variant)) {
                    TimeUnit.MILLISECONDS.sleep(500L);
                }
                line = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

