/*
 * Decompiled with CFR 0.152.
 */
package ciat.agrobio.io;

import ciat.agrobio.io.VCFDecoderInterface;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.zip.GZIPInputStream;

public class VCFStreamingIterator<T>
implements Iterator<T>,
Iterable<T> {
    private final List<String> inputPaths;
    private final VCFDecoderInterface<T> decoder;
    private BufferedReader currentReader;
    private int currentPathIndex;
    private String nextLine;
    private T nextDecoded;
    private boolean usingStdin = false;
    private boolean verbose = false;

    public VCFStreamingIterator(VCFDecoderInterface<T> decoder, boolean verbose, List<String> inputPaths) {
        this.inputPaths = inputPaths;
        this.decoder = decoder;
        this.verbose = verbose;
        this.currentPathIndex = -1;
        this.advanceFile();
        this.advance();
    }

    public VCFStreamingIterator(VCFDecoderInterface<T> decoder, boolean verbose, String ... inputPaths) {
        this(decoder, verbose, Arrays.asList(inputPaths));
    }

    private void advanceFile() {
        try {
            if (this.currentReader != null && !this.usingStdin) {
                this.currentReader.close();
            }
            ++this.currentPathIndex;
            if (this.currentPathIndex < this.inputPaths.size()) {
                InputStream in;
                String path = this.inputPaths.get(this.currentPathIndex);
                if (this.verbose) {
                    System.err.println("Reading from: " + path);
                }
                if (path.equals("-")) {
                    in = System.in;
                    this.usingStdin = true;
                } else {
                    File file = new File(path);
                    in = new FileInputStream(file);
                }
                in = this.detectAndWrap(in);
                this.currentReader = new BufferedReader(new InputStreamReader(in));
            } else {
                this.currentReader = null;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error opening input: " + this.inputPaths.get(this.currentPathIndex), e);
        }
    }

    private InputStream detectAndWrap(InputStream in) throws IOException {
        PushbackInputStream pb = new PushbackInputStream(in, 2);
        byte[] signature = new byte[2];
        int read = pb.read(signature);
        pb.unread(signature, 0, read);
        if (read == 2 && signature[0] == 31 && signature[1] == -117) {
            return new GZIPInputStream(pb);
        }
        return pb;
    }

    private void advance() {
        try {
            while (this.currentReader != null) {
                this.nextLine = this.currentReader.readLine();
                if (this.nextLine != null) {
                    this.nextDecoded = this.decoder.decode(this.nextLine);
                    if (this.nextDecoded == null) continue;
                    return;
                }
                this.advanceFile();
            }
            this.nextDecoded = null;
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading input", e);
        }
    }

    @Override
    public boolean hasNext() {
        return this.nextDecoded != null;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T result = this.nextDecoded;
        this.advance();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() not supported.");
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    public void close() {
        try {
            if (this.currentReader != null && !this.usingStdin) {
                this.currentReader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

