/*
 * Decompiled with CFR 0.152.
 */
package ciat.agrobio.javautils;

import ciat.agrobio.core.GeneralTools;
import ciat.agrobio.hcluster.HierarchicalCluster;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.FileInputStream;
import java.io.PrintStream;
import java.util.TreeMap;
import java.util.TreeSet;

@Parameters(commandDescription="DIST2Clusters")
public class UtilDIST2Clusters {
    @Parameter(names={"--help"}, help=true)
    private boolean help;
    @Parameter(names={"-v", "--verbose"})
    private boolean verbose = false;
    @Parameter(description="Positional Input File")
    private String positionalInputFile;
    @Parameter(names={"-i", "--input"}, description="Input file (overrides positional)")
    private String namedInputFile;
    @Parameter(names={"-o", "--output"}, description="Tree output file")
    private String outputFile;
    @Parameter(names={"--cutHeight", "-c"})
    private Double cutHeight = null;
    @Parameter(names={"--minClusterSize", "-m"})
    private Integer minClusterSize = 1;
    @Parameter(names={"--extra", "-e"})
    private boolean extra = false;

    public static String getUtilName() {
        return "DIST2Clusters";
    }

    public void go() {
        try {
            Object[] data;
            String inputFileName;
            PrintStream ops = System.out;
            if (this.outputFile != null) {
                try {
                    ops = new PrintStream(this.outputFile);
                }
                catch (Exception e) {
                    System.err.println("Error: Cannot write to " + this.outputFile);
                    return;
                }
            }
            String string = inputFileName = this.namedInputFile != null ? this.namedInputFile : this.positionalInputFile;
            if (inputFileName == null) {
                System.err.println("Error: No input file provided.");
                return;
            }
            if ("-".equals(inputFileName)) {
                data = GeneralTools.readDistancesSamples(System.in);
            } else {
                FileInputStream fis = new FileInputStream(inputFileName);
                data = GeneralTools.readDistancesSamples(fis);
                fis.close();
            }
            HierarchicalCluster hc = new HierarchicalCluster(true);
            TreeMap<Integer, TreeSet<String>> clusters = hc.hclusteringClusters((String[])data[1], (double[][])data[0], this.minClusterSize, this.cutHeight, this.extra, ops);
            ops.flush();
            ops.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

