/*
 * Decompiled with CFR 0.152.
 */
package ciat.agrobio.javautils;

import ciat.agrobio.core.GeneralTools;
import ciat.agrobio.hcluster.HierarchicalCluster;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.FileInputStream;
import java.io.PrintStream;

@Parameters(commandDescription="DIST2TREE")
public class UtilDIST2TREE {
    @Parameter(names={"--help"}, help=true)
    private boolean help;
    @Parameter(names={"-v", "--verbose"})
    private boolean verbose = false;
    @Parameter(description="Positional Input File")
    private String positionalInputFile;
    @Parameter(names={"-i", "--input"}, description="Input file (overrides positional)")
    private String namedInputFile;
    @Parameter(names={"-o", "--output"}, description="Tree output file")
    private String outputFile;

    public static String getUtilName() {
        return "DIST2TREE";
    }

    public void go() {
        try {
            Object[] data;
            String inputFileName;
            PrintStream ops = System.out;
            if (this.outputFile != null) {
                try {
                    ops = new PrintStream(this.outputFile);
                }
                catch (Exception e) {
                    System.err.println("Error: Cannot write to " + this.outputFile);
                    return;
                }
            }
            String string = inputFileName = this.namedInputFile != null ? this.namedInputFile : this.positionalInputFile;
            if (inputFileName == null) {
                System.err.println("Error: No input file provided.");
                return;
            }
            if ("-".equals(inputFileName)) {
                data = GeneralTools.readDistancesSamples(System.in);
            } else {
                FileInputStream fis = new FileInputStream(inputFileName);
                data = GeneralTools.readDistancesSamples(fis);
                fis.close();
            }
            HierarchicalCluster hc = new HierarchicalCluster(this.verbose);
            String treeString = hc.hclusteringTree((String[])data[1], (double[][])data[0], null);
            ops.println(treeString);
            ops.flush();
            ops.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

