/*
 * Decompiled with CFR 0.152.
 */
package ciat.agrobio.javautils;

import ciat.agrobio.core.CalculateDistancesD2;
import ciat.agrobio.core.GeneralTools;
import ciat.agrobio.core.SequenceD2;
import ciat.agrobio.core.SequenceProcessor;
import ciat.agrobio.io.FastaManager;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@Parameters(commandDescription="FASTA2DIST")
public class UtilFASTA2DIST {
    @Parameter(names={"--help"}, help=true)
    private boolean help;
    @Parameter(names={"-v", "--verbose"})
    private boolean verbose = false;
    @Parameter(description="FASTA positional input files")
    private List<String> positionalInputFiles = new ArrayList<String>();
    @Parameter(names={"-i", "--input"}, description="FASTA input file(s)", variableArity=true)
    private List<String> namedInputFiles = new ArrayList<String>();
    @Parameter(names={"-o", "--output"}, description="Distance output file")
    private String outputFile;
    @Parameter(names={"--isFastq", "-q"}, description="Input is FASTQ (default: false)")
    private boolean isFastq = false;
    @Parameter(names={"--kmerSize", "-k"}, description="Kmer size (default: 4)")
    private Integer k = 4;
    @Parameter(names={"--normalize", "-n"})
    private boolean normalize = false;
    @Parameter(names={"--numberOfThreads", "-t"})
    private int numOfThreads = 1;
    @Parameter(names={"--useMappedBuffer"}, description="Use MappedByteBuffer for reading input files. Not compatible with piped input.")
    private boolean useMappedBuffer = false;

    public static String getUtilName() {
        return "FASTA2DIST";
    }

    public void go() {
        try {
            int usingThreads;
            PrintStream ops = System.out;
            if (this.outputFile != null) {
                try {
                    ops = new PrintStream(this.outputFile);
                }
                catch (Exception e) {
                    System.err.println("Error: Cannot write to " + this.outputFile);
                    return;
                }
            }
            ArrayList<String> inputFileNames = new ArrayList<String>();
            inputFileNames.addAll(this.positionalInputFiles);
            inputFileNames.addAll(this.namedInputFiles);
            if (inputFileNames.isEmpty()) {
                System.err.println("Error: No FASTA input files provided.");
                return;
            }
            int cpus = Runtime.getRuntime().availableProcessors();
            int n = usingThreads = cpus < this.numOfThreads ? cpus : this.numOfThreads;
            if (this.verbose) {
                System.err.println("cpus=" + cpus);
            }
            if (this.verbose) {
                System.err.println("using=" + usingThreads);
            }
            ConcurrentHashMap<Integer, SequenceD2> seqVectors = new ConcurrentHashMap<Integer, SequenceD2>();
            CountDownLatch startSignal = new CountDownLatch(1);
            CountDownLatch doneSignal = new CountDownLatch(usingThreads + 1);
            ExecutorService pool = Executors.newFixedThreadPool(usingThreads + 1);
            HashMap<Integer, SequenceProcessor> sequenceProcessors = new HashMap<Integer, SequenceProcessor>();
            FastaManager frm = new FastaManager(this.isFastq, false, inputFileNames, startSignal, doneSignal, this.useMappedBuffer);
            pool.execute(frm);
            SequenceProcessor.resetCounters();
            for (int i = 0; i < usingThreads; ++i) {
                SequenceProcessor sp = new SequenceProcessor(seqVectors, frm, this.k, this.normalize, startSignal, doneSignal, this.verbose);
                sequenceProcessors.put(sp.getId(), sp);
                pool.execute(sp);
            }
            doneSignal.await();
            pool.shutdown();
            List<String> seqNames = frm.getSequenceNames();
            List<Integer> seqIds = frm.getSequenceIds();
            CalculateDistancesD2 fj = new CalculateDistancesD2(this.verbose);
            double[][] distances = fj.calculateDistances(usingThreads, seqVectors, seqNames, seqIds, frm);
            int seqCounter = 0;
            ops.println(seqNames.size());
            for (int i = 0; i < seqNames.size(); ++i) {
                String seqName1 = seqNames.get(i);
                ops.print(seqName1);
                for (int j = 0; j < seqNames.size(); ++j) {
                    String seqName2 = seqNames.get(j);
                    ops.print("\t" + GeneralTools.decimalFormat.format(distances[i][j]));
                }
                ops.println("");
                ++seqCounter;
            }
            ops.flush();
            ops.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

