/*
 * Decompiled with CFR 0.152.
 */
package ciat.agrobio.javautils;

import ciat.agrobio.core.CalculateDistancesCOSINE;
import ciat.agrobio.core.GeneralTools;
import ciat.agrobio.core.VariantManager;
import ciat.agrobio.core.VariantProcessor;
import ciat.agrobio.io.VCFManager;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@Parameters(commandDescription="VCF2DIST")
public class UtilVCF2DIST {
    @Parameter(names={"--help"}, help=true)
    private boolean help;
    @Parameter(names={"-v", "--verbose"})
    private boolean verbose = false;
    @Parameter(description="VCF positional input files")
    private List<String> positionalInputFiles = new ArrayList<String>();
    @Parameter(names={"-i", "--input"}, description="VCF input file(s)", variableArity=true)
    private List<String> namedInputFiles = new ArrayList<String>();
    @Parameter(names={"-o", "--output"}, description="Distance output file")
    private String outputFile;
    @Parameter(names={"--numberOfThreads", "-t"})
    private int numOfThreads = 1;
    @Parameter(names={"--ignoreMissing", "-m"})
    private boolean ignoreMissing = false;
    @Parameter(names={"--onlyHets", "-h"})
    private boolean onlyHets = false;
    @Parameter(names={"--ignoreHets", "-g"})
    private boolean ignoreHets = false;
    @Parameter(names={"--useMappedBuffer"}, description="Use MappedByteBuffer for reading input files. Not compatible with piped input.")
    private boolean useMappedBuffer = false;

    public static String getUtilName() {
        return "VCF2DIST";
    }

    public void go() {
        try {
            int usingThreads;
            PrintStream ops = System.out;
            if (this.outputFile != null) {
                try {
                    ops = new PrintStream(this.outputFile);
                }
                catch (Exception e) {
                    System.err.println("Error: Cannot write to " + this.outputFile);
                    return;
                }
            }
            ArrayList<String> inputFileNames = new ArrayList<String>();
            inputFileNames.addAll(this.positionalInputFiles);
            inputFileNames.addAll(this.namedInputFiles);
            if (inputFileNames.isEmpty()) {
                System.err.println("Error: No VCF input files provided.");
                return;
            }
            int cpus = Runtime.getRuntime().availableProcessors();
            int n = usingThreads = cpus < this.numOfThreads + 0 ? cpus : this.numOfThreads + 0;
            if (this.verbose) {
                System.err.println("cpus=" + cpus);
            }
            if (this.verbose) {
                System.err.println("using=" + usingThreads);
            }
            CountDownLatch startSignal = new CountDownLatch(1);
            CountDownLatch doneSignal = new CountDownLatch(usingThreads + 1);
            ExecutorService pool = Executors.newFixedThreadPool(usingThreads + 1);
            HashMap<Integer, VariantProcessor> variantProcessors = new HashMap<Integer, VariantProcessor>();
            VariantManager vm = new VariantManager();
            VCFManager vcfm = new VCFManager(vm, inputFileNames, startSignal, doneSignal, this.useMappedBuffer, this.verbose);
            pool.execute(vcfm);
            VariantProcessor.resetCounters();
            for (int i = 0; i < usingThreads; ++i) {
                VariantProcessor vp = new VariantProcessor(vm, vcfm, startSignal, doneSignal, this.verbose);
                variantProcessors.put(vp.getId(), vp);
                pool.execute(vp);
            }
            doneSignal.await();
            pool.shutdown();
            vm.populateSampleVariant();
            ArrayList<String> sampleNames = new ArrayList<String>();
            for (int i = 9; i < vcfm.getHeaderData().length; ++i) {
                sampleNames.add(new String(vcfm.getHeaderData()[i]));
            }
            if (this.verbose) {
                System.err.printf("\rProcessed variants : \t%8d\n", VariantProcessor.getVariantCount().get());
            }
            CalculateDistancesCOSINE.resetCounters();
            CalculateDistancesCOSINE fj = new CalculateDistancesCOSINE(this.verbose);
            double[][] distances = fj.calculateDistances(usingThreads, sampleNames, vm, vcfm, this.ignoreHets, this.onlyHets, this.ignoreMissing);
            int sampleCounter = 0;
            ops.println(vm.getNumSamples() + "\t" + vm.getNumVariants());
            for (int i = 0; i < vm.getNumSamples(); ++i) {
                String sampleName1 = (String)sampleNames.get(i);
                ops.print(sampleName1);
                for (int j = 0; j < vm.getNumSamples(); ++j) {
                    String sampleName2 = (String)sampleNames.get(j);
                    ops.print("\t" + GeneralTools.decimalFormat.format(distances[i][j]));
                }
                ops.println("");
                ++sampleCounter;
            }
            ops.flush();
            ops.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

