/*
 * Decompiled with CFR 0.152.
 */
package ciat.agrobio.javautils;

import ciat.agrobio.core.Logger;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.zip.GZIPInputStream;

@Parameters(commandDescription="VCF2ISTATS")
public class UtilVCF2ISTATS {
    @Parameter(names={"--help"}, help=true)
    private boolean help;
    @Parameter(description="Input_File", required=true)
    private List<String> inputFileNames = new ArrayList<String>();

    public static String getUtilName() {
        return "VCF2ISTATS";
    }

    public void go() {
        try {
            String line;
            InputStream fis = Files.newInputStream(Paths.get(this.inputFileNames.get(0), new String[0]), new OpenOption[0]);
            BufferedReader br = this.inputFileNames.get(0).endsWith(".gz") ? new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(fis), "UTF-8")) : new BufferedReader(new InputStreamReader(fis, "UTF-8"));
            int varCounter = 0;
            List<String> headerData = null;
            int numOfInd = 0;
            ArrayList indivStats = new ArrayList();
            while ((line = br.readLine()) != null) {
                if (line.startsWith("##")) continue;
                if (line.startsWith("#")) {
                    headerData = Arrays.asList(line.split("\\t"));
                    numOfInd = headerData.size() - 9;
                    System.err.println("Num of Ind = " + numOfInd);
                    for (int i = 9; i < headerData.size(); ++i) {
                        ArrayList<Object> indiv = new ArrayList<Object>();
                        indiv.add(headerData.get(i));
                        indiv.add(0);
                        indiv.add(0);
                        indiv.add(0);
                        indiv.add(0);
                        indiv.add(0);
                        indivStats.add(indiv);
                    }
                    continue;
                }
                List<String> variantData = Arrays.asList(line.split("\\t"));
                if (variantData.size() < 10) continue;
                String format = variantData.get(8);
                int indexGT = Arrays.asList(format.split(":")).indexOf("GT");
                for (int i = 9; i < headerData.size(); ++i) {
                    ArrayList indiv = (ArrayList)indivStats.get(i - 9);
                    indiv.set(1, (Integer)indiv.get(1) + 1);
                    String GT = variantData.get(i).split(":")[indexGT];
                    int allele1 = -1;
                    int allele2 = -1;
                    try {
                        allele1 = Integer.parseInt(GT.split("[/|]")[0]);
                        allele2 = Integer.parseInt(GT.split("[/|]")[1]);
                    }
                    catch (Exception e) {
                        allele1 = -1;
                        allele2 = -1;
                    }
                    if (allele1 < 0) {
                        indiv.set(5, (Integer)indiv.get(5) + 1);
                        continue;
                    }
                    if (allele1 != allele2) {
                        indiv.set(2, (Integer)indiv.get(2) + 1);
                        continue;
                    }
                    if (allele1 == 0) {
                        indiv.set(4, (Integer)indiv.get(4) + 1);
                        continue;
                    }
                    indiv.set(3, (Integer)indiv.get(3) + 1);
                }
                if (++varCounter % 1000 != 0) continue;
                Logger.infoCarret(this, "Variants Processed: \t" + varCounter);
            }
            br.close();
            DecimalFormat formatter = new DecimalFormat("#0.0000", new DecimalFormatSymbols(Locale.US));
            System.out.println("INDIV\tN_SITES\tN_HET\tN_ALT\tN_REF\tN_MISS\tP_HET\tP_ALT\tP_REF\tP_MISS");
            for (int i = 0; i < numOfInd; ++i) {
                String indivName = (String)((ArrayList)indivStats.get(i)).get(0);
                int n_sites = (Integer)((ArrayList)indivStats.get(i)).get(1);
                int n_het = (Integer)((ArrayList)indivStats.get(i)).get(2);
                int n_alt = (Integer)((ArrayList)indivStats.get(i)).get(3);
                int n_ref = (Integer)((ArrayList)indivStats.get(i)).get(4);
                int n_miss = (Integer)((ArrayList)indivStats.get(i)).get(5);
                double p_het = (double)n_het / ((double)n_het + (double)n_alt + (double)n_ref);
                double p_alt = (double)n_alt / ((double)n_het + (double)n_alt + (double)n_ref);
                double p_ref = (double)n_ref / ((double)n_het + (double)n_alt + (double)n_ref);
                double p_miss = (double)n_miss / ((double)n_het + (double)n_alt + (double)n_ref + (double)n_miss);
                System.out.println(indivName + "\t" + n_sites + "\t" + n_het + "\t" + n_alt + "\t" + n_ref + "\t" + n_miss + "\t" + formatter.format(p_het) + "\t" + formatter.format(p_alt) + "\t" + formatter.format(p_ref) + "\t" + formatter.format(p_miss));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

