"""
    Securitized Derivatives API For Digital Portals

    Search for securitized derivative instruments, using a criteria-based screener. The API provides also fundamental data, notation-based key figures, list of barrier types, and details regarding the underlyings, their respective barriers and related cash flows, coupon lists and derived basic interest rate information.  The screener is based on securitized derivatives-specific parameters. The result is limited to the notations that satisfy all the selected filters. If more than one notation of an instrument matches the parameters, and no market priority has been specified, only the notation with the highest trading volume, averaged over one month, is considered. All identifier types used as parameters must be valid and application must have permissions for them.  Available search criteria include:  * validation: filter for only active listings, by price quality and latest/previous available price dates * traded markets: filter and indicate a market priority for the validation * life cycle: important dates in and features of the life cycle of the securitized derivatives instruments * filter by issuer, country of registration of the securitized derivatives * underlying and related barriers, including level and distance, and resulting cash flows * coupon data: where applicable, occurrence and frequency of coupon payments, current interest rate range * performance and volatility * product-specific ask-based key figures (not all key figures are available for all product types):     * bonus yield, sideways yield, maximum yield based on the ask price     * agio, discount     * spread     * break even, outperformance point, parity     * delta, weekly theta, vega, implied volatility     * leverage, omega     * intrinsic value, time value         Since some underlyings, e.g. an index or a performance difference of a stock and an index (alpha structure), do not represent a directly tradable asset, they do not have a price in the classical sense. Therefore, the term *level* is used instead of *price*, e.g. underlying level instead of underlying price. The endpoint does not support the search for securitized derivatives with multiple underlyings, thus only securitized derivatives with a single underlying are returned in the result.  The search can be restricted to a specific set of products by using customer-specific instrument or notation lists. Such restriction lists are set up by FactSet upon request.  This API is fully integrated with the corresponding [Quotes API](https://developer.factset.com/api-catalog/quotes-api-digital-portals), allowing access to detailed price and performance information of instruments, as well as basic security identifier cross-reference. For direct access to price histories, please refer to the [Time Series API for Digital Portals](https://developer.factset.com/api-catalog/time-series-api-digital-portals).  Similar criteria based screener APIs exist for equity and fixed income instruments: See the [Stocks API](https://developer.factset.com/api-catalog/stocks-api-digital-portals) and the [Bonds API](https://developer.factset.com/api-catalog/bonds-api-digital-portals) for details.    # noqa: E501

    The version of the OpenAPI document: 4.0.0
    Contact: api@factset.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.exceptions import ApiAttributeError


def lazy_import():
    from fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.model.get_securitized_derivative_underlying_list_data_underlyings_items_notation_instrument_fsym import GetSecuritizedDerivativeUnderlyingListDataUnderlyingsItemsNotationInstrumentFsym
    from fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.model.inline_response200_data_nsin import InlineResponse200DataNsin
    from fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.model.post_securitized_derivative_notation_screener_search_data_items_instrument_bonus_level import PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentBonusLevel
    from fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.model.post_securitized_derivative_notation_screener_search_data_items_instrument_cap import PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCap
    from fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.model.post_securitized_derivative_notation_screener_search_data_items_instrument_capital_guarantee import PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCapitalGuarantee
    from fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.model.post_securitized_derivative_notation_screener_search_data_items_instrument_categorization import PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCategorization
    from fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.model.post_securitized_derivative_notation_screener_search_data_items_instrument_coupon_trigger_level import PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCouponTriggerLevel
    from fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.model.post_securitized_derivative_notation_screener_search_data_items_instrument_current_interest_rate import PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCurrentInterestRate
    from fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.model.post_securitized_derivative_notation_screener_search_data_items_instrument_exercise import PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentExercise
    from fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.model.post_securitized_derivative_notation_screener_search_data_items_instrument_issuer import PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentIssuer
    from fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.model.post_securitized_derivative_notation_screener_search_data_items_instrument_knock_in import PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentKnockIn
    from fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.model.post_securitized_derivative_notation_screener_search_data_items_instrument_knock_out import PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentKnockOut
    from fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.model.post_securitized_derivative_notation_screener_search_data_items_instrument_life_cycle import PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentLifeCycle
    from fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.model.post_securitized_derivative_notation_screener_search_data_items_instrument_lock_in import PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentLockIn
    from fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.model.post_securitized_derivative_notation_screener_search_data_items_instrument_lock_out import PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentLockOut
    from fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.model.post_securitized_derivative_notation_screener_search_data_items_instrument_nominal_currency import PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentNominalCurrency
    from fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.model.post_securitized_derivative_notation_screener_search_data_items_instrument_range_knock_out import PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentRangeKnockOut
    from fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.model.post_securitized_derivative_notation_screener_search_data_items_instrument_strike import PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentStrike
    from fds.sdk.SecuritizedDerivativesAPIforDigitalPortals.model.post_securitized_derivative_notation_screener_search_data_items_instrument_underlying import PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentUnderlying
    globals()['GetSecuritizedDerivativeUnderlyingListDataUnderlyingsItemsNotationInstrumentFsym'] = GetSecuritizedDerivativeUnderlyingListDataUnderlyingsItemsNotationInstrumentFsym
    globals()['InlineResponse200DataNsin'] = InlineResponse200DataNsin
    globals()['PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentBonusLevel'] = PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentBonusLevel
    globals()['PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCap'] = PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCap
    globals()['PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCapitalGuarantee'] = PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCapitalGuarantee
    globals()['PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCategorization'] = PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCategorization
    globals()['PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCouponTriggerLevel'] = PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCouponTriggerLevel
    globals()['PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCurrentInterestRate'] = PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCurrentInterestRate
    globals()['PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentExercise'] = PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentExercise
    globals()['PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentIssuer'] = PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentIssuer
    globals()['PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentKnockIn'] = PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentKnockIn
    globals()['PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentKnockOut'] = PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentKnockOut
    globals()['PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentLifeCycle'] = PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentLifeCycle
    globals()['PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentLockIn'] = PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentLockIn
    globals()['PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentLockOut'] = PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentLockOut
    globals()['PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentNominalCurrency'] = PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentNominalCurrency
    globals()['PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentRangeKnockOut'] = PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentRangeKnockOut
    globals()['PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentStrike'] = PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentStrike
    globals()['PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentUnderlying'] = PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentUnderlying


class PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrument(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('settlement',): {
            'None': None,
            'CASH': "cash",
            'PHYSICAL': "physical",
            'EITHER': "either",


        },
        ('participation',): {
            'None': None,
            'LONG': "long",
            'SHORT': "short",


        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'id': (str, none_type,),  # noqa: E501
            'name': (str, none_type,),  # noqa: E501
            'short_name': (str, none_type,),  # noqa: E501
            'isin': (str, none_type,),  # noqa: E501
            'nsin': (InlineResponse200DataNsin,),  # noqa: E501
            'fsym': (GetSecuritizedDerivativeUnderlyingListDataUnderlyingsItemsNotationInstrumentFsym,),  # noqa: E501
            'categorization': (PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCategorization,),  # noqa: E501
            'life_cycle': (PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentLifeCycle,),  # noqa: E501
            'issuer': (PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentIssuer,),  # noqa: E501
            'exercise': (PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentExercise,),  # noqa: E501
            'settlement': (str, none_type,),  # noqa: E501
            'collateralized': (bool, none_type,),  # noqa: E501
            'quanto': (bool, none_type,),  # noqa: E501
            'capital_protection': (float, none_type,),  # noqa: E501
            'underlying': (PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentUnderlying,),  # noqa: E501
            'strike': (PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentStrike,),  # noqa: E501
            'bonus_level': (PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentBonusLevel,),  # noqa: E501
            'cap': (PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCap,),  # noqa: E501
            'knock_out': (PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentKnockOut,),  # noqa: E501
            'knock_in': (PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentKnockIn,),  # noqa: E501
            'lock_out': (PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentLockOut,),  # noqa: E501
            'lock_in': (PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentLockIn,),  # noqa: E501
            'capital_guarantee': (PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCapitalGuarantee,),  # noqa: E501
            'coupon_trigger_level': (PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCouponTriggerLevel,),  # noqa: E501
            'range_knock_out': (PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentRangeKnockOut,),  # noqa: E501
            'participation': (str, none_type,),  # noqa: E501
            'constant_leverage': (float, none_type,),  # noqa: E501
            'nominal_currency': (PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentNominalCurrency,),  # noqa: E501
            'current_interest_rate': (PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCurrentInterestRate,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'id': 'id',  # noqa: E501
        'name': 'name',  # noqa: E501
        'short_name': 'shortName',  # noqa: E501
        'isin': 'isin',  # noqa: E501
        'nsin': 'nsin',  # noqa: E501
        'fsym': 'fsym',  # noqa: E501
        'categorization': 'categorization',  # noqa: E501
        'life_cycle': 'lifeCycle',  # noqa: E501
        'issuer': 'issuer',  # noqa: E501
        'exercise': 'exercise',  # noqa: E501
        'settlement': 'settlement',  # noqa: E501
        'collateralized': 'collateralized',  # noqa: E501
        'quanto': 'quanto',  # noqa: E501
        'capital_protection': 'capitalProtection',  # noqa: E501
        'underlying': 'underlying',  # noqa: E501
        'strike': 'strike',  # noqa: E501
        'bonus_level': 'bonusLevel',  # noqa: E501
        'cap': 'cap',  # noqa: E501
        'knock_out': 'knockOut',  # noqa: E501
        'knock_in': 'knockIn',  # noqa: E501
        'lock_out': 'lockOut',  # noqa: E501
        'lock_in': 'lockIn',  # noqa: E501
        'capital_guarantee': 'capitalGuarantee',  # noqa: E501
        'coupon_trigger_level': 'couponTriggerLevel',  # noqa: E501
        'range_knock_out': 'rangeKnockOut',  # noqa: E501
        'participation': 'participation',  # noqa: E501
        'constant_leverage': 'constantLeverage',  # noqa: E501
        'nominal_currency': 'nominalCurrency',  # noqa: E501
        'current_interest_rate': 'currentInterestRate',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrument - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            id (str, none_type): Identifier of the instrument.. [optional]  # noqa: E501
            name (str, none_type): Name of the instrument.. [optional]  # noqa: E501
            short_name (str, none_type): Short name of the instrument.. [optional]  # noqa: E501
            isin (str, none_type): The International Securities Identification Number (ISIN) of the instrument.The ISIN is a 12-character code of digits and upper-case letters that uniquely identifiesan instrument.. [optional]  # noqa: E501
            nsin (InlineResponse200DataNsin): [optional]  # noqa: E501
            fsym (GetSecuritizedDerivativeUnderlyingListDataUnderlyingsItemsNotationInstrumentFsym): [optional]  # noqa: E501
            categorization (PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCategorization): [optional]  # noqa: E501
            life_cycle (PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentLifeCycle): [optional]  # noqa: E501
            issuer (PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentIssuer): [optional]  # noqa: E501
            exercise (PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentExercise): [optional]  # noqa: E501
            settlement (str, none_type): Settlement of the securitized derivative. It concerns the fulfillment of the issuer's contractual obligations arising from the securitized derivative. Depending on the terms, the underlying asset may be delivered physically or its equivalent monetary value may be payed out. | Value | Description | | --- | --- | | cash | Transfer of a cash amount. | | physical | Physical delivery of the underlying asset. | | either | Cash or physical, at the discretion of the issuer. |  . [optional]  # noqa: E501
            collateralized (bool, none_type): If `true`, this instrument is protected against an issuer default by collateral (e.g. COSI collateralization by SIX Swiss Exchange).. [optional]  # noqa: E501
            quanto (bool, none_type): If `true`, the risk of exchange rate fluctuations between the value unit of the underlying and the value unit of the cash flows is hedged.. [optional]  # noqa: E501
            capital_protection (float, none_type): Proportion of the nominal amount protected against loss.. [optional]  # noqa: E501
            underlying (PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentUnderlying): [optional]  # noqa: E501
            strike (PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentStrike): [optional]  # noqa: E501
            bonus_level (PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentBonusLevel): [optional]  # noqa: E501
            cap (PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCap): [optional]  # noqa: E501
            knock_out (PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentKnockOut): [optional]  # noqa: E501
            knock_in (PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentKnockIn): [optional]  # noqa: E501
            lock_out (PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentLockOut): [optional]  # noqa: E501
            lock_in (PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentLockIn): [optional]  # noqa: E501
            capital_guarantee (PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCapitalGuarantee): [optional]  # noqa: E501
            coupon_trigger_level (PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCouponTriggerLevel): [optional]  # noqa: E501
            range_knock_out (PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentRangeKnockOut): [optional]  # noqa: E501
            participation (str, none_type): Participation direction of a factor certificate at the level movement of its effective underlying. | Value | Description | | --- | --- | | long | The factor certificate participates positively with rising levels of its effective underlying. | | short | The factor certificate participates negatively with rising levels of its effective underlying. |  . [optional]  # noqa: E501
            constant_leverage (float, none_type): Constant leverage of a factor certificate.. [optional]  # noqa: E501
            nominal_currency (PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentNominalCurrency): [optional]  # noqa: E501
            current_interest_rate (PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCurrentInterestRate): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrument - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            id (str, none_type): Identifier of the instrument.. [optional]  # noqa: E501
            name (str, none_type): Name of the instrument.. [optional]  # noqa: E501
            short_name (str, none_type): Short name of the instrument.. [optional]  # noqa: E501
            isin (str, none_type): The International Securities Identification Number (ISIN) of the instrument.The ISIN is a 12-character code of digits and upper-case letters that uniquely identifiesan instrument.. [optional]  # noqa: E501
            nsin (InlineResponse200DataNsin): [optional]  # noqa: E501
            fsym (GetSecuritizedDerivativeUnderlyingListDataUnderlyingsItemsNotationInstrumentFsym): [optional]  # noqa: E501
            categorization (PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCategorization): [optional]  # noqa: E501
            life_cycle (PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentLifeCycle): [optional]  # noqa: E501
            issuer (PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentIssuer): [optional]  # noqa: E501
            exercise (PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentExercise): [optional]  # noqa: E501
            settlement (str, none_type): Settlement of the securitized derivative. It concerns the fulfillment of the issuer's contractual obligations arising from the securitized derivative. Depending on the terms, the underlying asset may be delivered physically or its equivalent monetary value may be payed out. | Value | Description | | --- | --- | | cash | Transfer of a cash amount. | | physical | Physical delivery of the underlying asset. | | either | Cash or physical, at the discretion of the issuer. |  . [optional]  # noqa: E501
            collateralized (bool, none_type): If `true`, this instrument is protected against an issuer default by collateral (e.g. COSI collateralization by SIX Swiss Exchange).. [optional]  # noqa: E501
            quanto (bool, none_type): If `true`, the risk of exchange rate fluctuations between the value unit of the underlying and the value unit of the cash flows is hedged.. [optional]  # noqa: E501
            capital_protection (float, none_type): Proportion of the nominal amount protected against loss.. [optional]  # noqa: E501
            underlying (PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentUnderlying): [optional]  # noqa: E501
            strike (PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentStrike): [optional]  # noqa: E501
            bonus_level (PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentBonusLevel): [optional]  # noqa: E501
            cap (PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCap): [optional]  # noqa: E501
            knock_out (PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentKnockOut): [optional]  # noqa: E501
            knock_in (PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentKnockIn): [optional]  # noqa: E501
            lock_out (PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentLockOut): [optional]  # noqa: E501
            lock_in (PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentLockIn): [optional]  # noqa: E501
            capital_guarantee (PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCapitalGuarantee): [optional]  # noqa: E501
            coupon_trigger_level (PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCouponTriggerLevel): [optional]  # noqa: E501
            range_knock_out (PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentRangeKnockOut): [optional]  # noqa: E501
            participation (str, none_type): Participation direction of a factor certificate at the level movement of its effective underlying. | Value | Description | | --- | --- | | long | The factor certificate participates positively with rising levels of its effective underlying. | | short | The factor certificate participates negatively with rising levels of its effective underlying. |  . [optional]  # noqa: E501
            constant_leverage (float, none_type): Constant leverage of a factor certificate.. [optional]  # noqa: E501
            nominal_currency (PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentNominalCurrency): [optional]  # noqa: E501
            current_interest_rate (PostSecuritizedDerivativeNotationScreenerSearchDataItemsInstrumentCurrentInterestRate): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
