# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

from typing import Iterable
from typing_extensions import Literal, Required, TypedDict

from .routes.route_steps_request_param import RouteStepsRequestParam

__all__ = ["RouteCreateParams", "Routing"]


class RouteCreateParams(TypedDict, total=False):
    key: Required[str]
    """
    A key is a unique identifier that is required to authenticate a request to the
    API.
    """

    driver_email: Required[str]
    """Specify the e-mail address of the driver who should receive the route.

    The e-mail address must be registered in
    [NextBillion.ai Cloud Console](https://console.nextbillion.ai/).
    """

    steps: Required[Iterable[RouteStepsRequestParam]]
    """
    An array of objects to collect the details about the intermediate steps in the
    route to be dispatched. Each object corresponds to a single step. The array must
    begin with a start-type step and end with an end-type step, to form a valid
    route.
    """

    distance: int
    """
    Specify the total distance, in meters, for an informative display in Driver's
    app. The distance specified here has no effect on the actual route that the
    service generates.
    """

    document_template_id: str
    """
    Specify the ID of the document template that should be used to collect proof of
    completion for all steps in the route. In order to complete each route step, the
    driver will need to submit a form generated by the rules defined in the given
    document template. Use the
    [Documents API](https://docs.nextbillion.ai/docs/dispatches/documents-api) to
    create, read and manage document templates.

    Please note that the document template ID assigned to a route does not apply to
    following step types - `start`, `end`, `break`, `layover`.
    """

    ro_request_id: str
    """Specify the Route Optimization request ID.

    When this ID is provided, all other fields will be ignored (including the
    required fields) and the route optimization result will be used to form the
    routes and corresponding steps.

    Please note that:

    - The driver's email ID must be provided in input `vehicle.metadata` as
      `user_email` such that the route optimization result must contain a valid
      driver email, step's arrival time, etc., to make a successful dispatch.
    - Document Template for collecting proof of delivery or completion can not be
      specified when using this field to dispatch a route.
    - In case of an error at any part among the routes, the API will immediately
      return the error with the index of the specific route or route step.
    - On a successful dispatch, the API returns the last route, if there are many,
      in the response payload.
    """

    routing: Routing
    """
    The `routing` object allows defining the routing characteristics that should be
    used to generate a route when the Driver uses the in-app navigation. Only `car`
    mode is supported currently.
    """


class Routing(TypedDict, total=False):
    approaches: Literal["`unrestricted`", "`curb`"]
    """
    Specify the side of the road from which the route should approach the step
    location. When set to `unrestricted` a route can arrive at the step location
    from either side of the road and when set to `curb` the route will arrive at the
    step location only from the driving side of the region. Use a semi-colon `;` to
    specify approach configurations for multiple steps.
    """

    avoid: Literal[
        "`toll`",
        "`highway`",
        "`ferry`",
        "`sharp_turn`",
        "`uturn`",
        "`left_turn`",
        "`right_turn`",
        "`service_road`",
        "`none`",
    ]
    """
    Setting this will ensure the generated route avoids the object(s) specified in
    the input. Multiple values should be separated by a pipe (|). If `none` is
    provided along with other values, an error is returned as a valid route is not
    feasible.
    """

    hazmat_type: Literal["`general`", "`circumstantial`", "`explosive`", "`harmful_to_water`"]
    """
    Specify the type of hazardous material being carried and the dispatch service
    will avoid roads which are not suitable for the type of goods specified.
    Multiple values can be separated using a pipe operator `|` .

    Please note that this parameter is effective only when `mode=truck`.
    """

    mode: Literal["`car`"]
    """Specify the driving mode that the service should use to determine a route"""

    truck_axle_load: int
    """
    Specify the total load per axle (including the weight of trailers and shipped
    goods) of the truck, in tonnes. When specified, the dispatched route uses only
    those roads which can be used by a truck to carry the specified load per axle.

    Please note this parameter is effective only when `mode=truck`.
    """

    truck_size: str
    """
    Specify the dimensions of a truck, in centimeters (cm), in the format of
    <height, width, length>. When specified, the dispatched route uses only those
    roads which allow trucks with specified dimensions.

    Please note this parameter is effective only when `mode=truck`. Also, the
    maximum dimensions that can be specified are as follows:

    Height = 1000 cm
    Width = 5000 cm
    Length = 5000 cm
    """

    truck_weight: int
    """
    Specify the weight of the truck, including trailers and shipped goods, in
    kilograms (kg). When specified, the dispatched route uses only those roads which
    allow trucks with specified weight.

    Please note this parameter is effective only when `mode=truck`. Also, the
    maximum weight that can be specified for a truck is 100,000 kgs.
    """
