# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

import os
from typing import Any, cast

import pytest

from tests.utils import assert_matches_type
from nextbillion_sdk import NextbillionSDK, AsyncNextbillionSDK
from nextbillion_sdk.types.skynet.asset import EventRetrieveListResponse

base_url = os.environ.get("TEST_API_BASE_URL", "http://127.0.0.1:4010")


class TestEvent:
    parametrize = pytest.mark.parametrize("client", [False, True], indirect=True, ids=["loose", "strict"])

    @pytest.mark.skip()
    @parametrize
    def test_method_retrieve_list(self, client: NextbillionSDK) -> None:
        event = client.skynet.asset.event.retrieve_list(
            id="id",
            key="key=API_KEY",
        )
        assert_matches_type(EventRetrieveListResponse, event, path=["response"])

    @pytest.mark.skip()
    @parametrize
    def test_method_retrieve_list_with_all_params(self, client: NextbillionSDK) -> None:
        event = client.skynet.asset.event.retrieve_list(
            id="id",
            key="key=API_KEY",
            cluster="america",
            end_time=0,
            monitor_id="monitor_id",
            pn=0,
            ps=100,
            start_time=0,
        )
        assert_matches_type(EventRetrieveListResponse, event, path=["response"])

    @pytest.mark.skip()
    @parametrize
    def test_raw_response_retrieve_list(self, client: NextbillionSDK) -> None:
        response = client.skynet.asset.event.with_raw_response.retrieve_list(
            id="id",
            key="key=API_KEY",
        )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        event = response.parse()
        assert_matches_type(EventRetrieveListResponse, event, path=["response"])

    @pytest.mark.skip()
    @parametrize
    def test_streaming_response_retrieve_list(self, client: NextbillionSDK) -> None:
        with client.skynet.asset.event.with_streaming_response.retrieve_list(
            id="id",
            key="key=API_KEY",
        ) as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            event = response.parse()
            assert_matches_type(EventRetrieveListResponse, event, path=["response"])

        assert cast(Any, response.is_closed) is True

    @pytest.mark.skip()
    @parametrize
    def test_path_params_retrieve_list(self, client: NextbillionSDK) -> None:
        with pytest.raises(ValueError, match=r"Expected a non-empty value for `id` but received ''"):
            client.skynet.asset.event.with_raw_response.retrieve_list(
                id="",
                key="key=API_KEY",
            )


class TestAsyncEvent:
    parametrize = pytest.mark.parametrize(
        "async_client", [False, True, {"http_client": "aiohttp"}], indirect=True, ids=["loose", "strict", "aiohttp"]
    )

    @pytest.mark.skip()
    @parametrize
    async def test_method_retrieve_list(self, async_client: AsyncNextbillionSDK) -> None:
        event = await async_client.skynet.asset.event.retrieve_list(
            id="id",
            key="key=API_KEY",
        )
        assert_matches_type(EventRetrieveListResponse, event, path=["response"])

    @pytest.mark.skip()
    @parametrize
    async def test_method_retrieve_list_with_all_params(self, async_client: AsyncNextbillionSDK) -> None:
        event = await async_client.skynet.asset.event.retrieve_list(
            id="id",
            key="key=API_KEY",
            cluster="america",
            end_time=0,
            monitor_id="monitor_id",
            pn=0,
            ps=100,
            start_time=0,
        )
        assert_matches_type(EventRetrieveListResponse, event, path=["response"])

    @pytest.mark.skip()
    @parametrize
    async def test_raw_response_retrieve_list(self, async_client: AsyncNextbillionSDK) -> None:
        response = await async_client.skynet.asset.event.with_raw_response.retrieve_list(
            id="id",
            key="key=API_KEY",
        )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        event = await response.parse()
        assert_matches_type(EventRetrieveListResponse, event, path=["response"])

    @pytest.mark.skip()
    @parametrize
    async def test_streaming_response_retrieve_list(self, async_client: AsyncNextbillionSDK) -> None:
        async with async_client.skynet.asset.event.with_streaming_response.retrieve_list(
            id="id",
            key="key=API_KEY",
        ) as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            event = await response.parse()
            assert_matches_type(EventRetrieveListResponse, event, path=["response"])

        assert cast(Any, response.is_closed) is True

    @pytest.mark.skip()
    @parametrize
    async def test_path_params_retrieve_list(self, async_client: AsyncNextbillionSDK) -> None:
        with pytest.raises(ValueError, match=r"Expected a non-empty value for `id` but received ''"):
            await async_client.skynet.asset.event.with_raw_response.retrieve_list(
                id="",
                key="key=API_KEY",
            )
