# Generated by Django 2.0.6 on 2018-06-22 14:54

from django.conf import settings
import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('election', '0005_auto_20180206_2238'),
        ('geography', '0002_point_pointlabeloffset'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Author',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('first_name', models.CharField(max_length=128)),
                ('last_name', models.CharField(max_length=128)),
                ('user', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='rating_author', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='BadgeType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('label', models.CharField(max_length=140)),
                ('short_label', models.CharField(max_length=30)),
                ('description', models.TextField()),
            ],
        ),
        migrations.CreateModel(
            name='Category',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('label', models.CharField(max_length=50)),
                ('short_label', models.CharField(max_length=30)),
            ],
        ),
        migrations.CreateModel(
            name='DataProfile',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('data', django.contrib.postgres.fields.jsonb.JSONField()),
                ('division', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='geography.Division')),
            ],
        ),
        migrations.CreateModel(
            name='RaceBadge',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('explanation', models.TextField()),
                ('badge_type', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='raceratings.BadgeType')),
                ('race', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='election.Race')),
            ],
        ),
        migrations.CreateModel(
            name='RaceRating',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('rating_date', models.DateField()),
                ('created_date', models.DateField(auto_now_add=True)),
                ('blurb', django.contrib.postgres.fields.jsonb.JSONField(blank=True, default=[], null=True)),
                ('author', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='ratings', to='raceratings.Author')),
                ('category', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='ratings', to='raceratings.Category')),
                ('race', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='ratings', to='election.Race')),
            ],
        ),
    ]
