# Generated by Django 2.0.6 on 2018-06-25 15:23

from django.db import migrations, models
import django.db.models.deletion
import raceratings.fields
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
        ('raceratings', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='PageContent',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('object_id', models.CharField(max_length=500)),
                ('content_type', models.ForeignKey(limit_choices_to=models.Q(models.Q(('app_label', 'election'), ('model', 'race')), models.Q(('app_label', 'electionnight'), ('model', 'pagetype')), _connector='OR'), on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType')),
                ('parent', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='children', to='raceratings.PageContent')),
            ],
        ),
        migrations.CreateModel(
            name='PageContentBlock',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('content', raceratings.fields.MarkdownField()),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('updated', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='PageContentType',
            fields=[
                ('slug', models.SlugField(blank=True, editable=False, max_length=255, primary_key=True, serialize=False, unique=True)),
                ('name', models.CharField(max_length=255)),
            ],
        ),
        migrations.CreateModel(
            name='PageType',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('model_type', models.ForeignKey(limit_choices_to=models.Q(('app_label', 'election'), ('model', 'race')), on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType')),
            ],
        ),
        migrations.AddField(
            model_name='pagecontentblock',
            name='content_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='+', to='raceratings.PageContentType'),
        ),
        migrations.AddField(
            model_name='pagecontentblock',
            name='page',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='blocks', to='raceratings.PageContent'),
        ),
        migrations.AlterUniqueTogether(
            name='pagecontentblock',
            unique_together={('page', 'content_type')},
        ),
    ]
