# -*- coding: utf-8 -*-
#
# This file is part of Invenio.
#
# Copyright (C) 2024-2025 Graz University of Technology.
#
# invenio-catalogue-marc21 is free software; you can redistribute it and/or
# modify it under the terms of the MIT License; see LICENSE file for more
# details.

"""Records error handlers."""

from flask import current_app, render_template
from flask_login import current_user


#
# Error handlers
#
def not_found_error(error) -> tuple[str, int]:
    """Handle 'Not Found' errors."""
    return render_template(current_app.config["THEME_404_TEMPLATE"]), 404


def record_tombstone_error(error) -> tuple[str, int]:
    """Tombstone page."""
    return render_template("invenio_records_marc21/tombstone.html"), 410


def record_permission_denied_error(error) -> tuple[str, int]:
    """Handle permission denier error on record views."""
    if not current_user.is_authenticated:
        # trigger the flask-login unauthorized handler
        return current_app.login_manager.unauthorized()
    return render_template(current_app.config["THEME_403_TEMPLATE"]), 403
