# Copyright (c) 2025, Palo Alto Networks
#
# Licensed under the Polyform Internal Use License 1.0.0 (the "License");
# you may not use this file except in compliance with the License.
#
# You may obtain a copy of the License at:
#
# https://polyformproject.org/licenses/internal-use/1.0.0
# (or)
# https://github.com/polyformproject/polyform-licenses/blob/76a278c4/PolyForm-Internal-Use-1.0.0.md
#
# As far as the law allows, the software comes as is, without any warranty
# or condition, and the licensor will not be liable to you for any damages
# arising out of these terms or the use or nature of the software, under
# any kind of legal claim.

"""
AISec API service

OpenAPI Specification for the AI Runtime Security API service

The version of the OpenAPI document: 0.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from aisecurity.generated_openapi_client.models.prompt_detected import PromptDetected
from aisecurity.generated_openapi_client.models.response_detected import (
    ResponseDetected,
)
from typing import Set
from typing_extensions import Self


class ScanResponse(BaseModel):
    """
    ScanResponse
    """  # noqa: E501

    report_id: StrictStr = Field(description="Unique identifier for the scan report")
    scan_id: StrictStr = Field(description="Unique identifier for the scan")
    tr_id: Optional[StrictStr] = Field(
        default=None, description="Unique identifier for the transaction"
    )
    profile_id: Optional[StrictStr] = Field(
        default=None,
        description="Unique identifier of the AI security profile used for scanning",
    )
    profile_name: Optional[StrictStr] = Field(
        default=None, description="AI security profile name used for scanning"
    )
    category: StrictStr = Field(
        description='Category of the scanned content verdicts such as "malicious" or "benign"'
    )
    action: StrictStr = Field(
        description='The action is set to "block" or "allow" based on AI security profile used for scanning'
    )
    prompt_detected: Optional[PromptDetected] = None
    response_detected: Optional[ResponseDetected] = None
    created_at: Optional[datetime] = Field(
        default=None, description="Scan request timestamp"
    )
    completed_at: Optional[datetime] = Field(
        default=None, description="Scan completion timestamp"
    )
    __properties: ClassVar[List[str]] = [
        "report_id",
        "scan_id",
        "tr_id",
        "profile_id",
        "profile_name",
        "category",
        "action",
        "prompt_detected",
        "response_detected",
        "created_at",
        "completed_at",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ScanResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of prompt_detected
        if self.prompt_detected:
            _dict["prompt_detected"] = self.prompt_detected.to_dict()
        # override the default output from pydantic by calling `to_dict()` of response_detected
        if self.response_detected:
            _dict["response_detected"] = self.response_detected.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ScanResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "report_id": obj.get("report_id"),
                "scan_id": obj.get("scan_id"),
                "tr_id": obj.get("tr_id"),
                "profile_id": obj.get("profile_id"),
                "profile_name": obj.get("profile_name"),
                "category": obj.get("category"),
                "action": obj.get("action"),
                "prompt_detected": PromptDetected.from_dict(obj["prompt_detected"])
                if obj.get("prompt_detected") is not None
                else None,
                "response_detected": ResponseDetected.from_dict(
                    obj["response_detected"]
                )
                if obj.get("response_detected") is not None
                else None,
                "created_at": obj.get("created_at"),
                "completed_at": obj.get("completed_at"),
            }
        )
        return _obj
