from splitwise import Splitwise
import unittest
try:
    from unittest.mock import patch
except ImportError:  # Python 2
    from mock import patch


@patch('splitwise.Splitwise._Splitwise__makeRequest')
class GetExpenseTestCase(unittest.TestCase):

    def setUp(self):
        self.sObj = Splitwise('consumerkey', 'consumersecret')

    def test_getExpense_equally_distributed_success(self, mockMakeRequest):
        mockMakeRequest.return_value = '{"expense":{"id":1010404721,"group_id":19433671,"friendship_id":null,"expense_bundle_id":null,"description":"test","repeats":false,"repeat_interval":"never","email_reminder":false,"email_reminder_in_advance":-1,"next_repeat":null,"details":null,"comments_count":0,"payment":false,"creation_method":"equal","transaction_method":"offline","transaction_confirmed":false,"transaction_id":null,"cost":"10.0","currency_code":"SGD","repayments":[{"from":643871,"to":79774,"amount":"5.0"}],"date":"2020-06-23T09:56:09Z","created_at":"2020-06-23T09:56:14Z","created_by":{"id":79774,"first_name":"Naman","last_name":"Aggarwal","picture":{"medium":"https://splitwise.s3.amazonaws.com/uploads/user/avatar/79774/medium_mypic.jpg"},"custom_picture":true},"updated_at":"2020-06-23T09:56:14Z","updated_by":null,"deleted_at":null,"deleted_by":null,"category":{"id":18,"name":"General"},"receipt":{"large":null,"original":null},"users":[{"user":{"id":79774,"first_name":"Naman","last_name":"Aggarwal","picture":{"medium":"https://splitwise.s3.amazonaws.com/uploads/user/avatar/79774/medium_mypic.jpg"}},"user_id":79774,"paid_share":"10.0","owed_share":"5.0","net_balance":"5.0"},{"user":{"id":643871,"first_name":"Shantanu","last_name":"Alshi","picture":{"medium":"https://s3.amazonaws.com/splitwise/uploads/user/default_avatars/avatar-blue19-100px.png"}},"user_id":643871,"paid_share":"0.0","owed_share":"5.0","net_balance":"-5.0"}],"comments":[]}}'  # noqa: E501
        expense = self.sObj.getExpense(1010404721)
        mockMakeRequest.assert_called_with(
            "https://secure.splitwise.com/api/v3.0/get_expense/1010404721")
        self.assertEqual(expense.getId(), 1010404721)
        self.assertEqual(expense.getGroupId(), 19433671)
        self.assertEqual(expense.getFriendshipId(), None)
        self.assertEqual(expense.getExpenseBundleId(), None)
        self.assertEqual(expense.getDescription(), "test")
        self.assertEqual(expense.getRepeatInterval(), "never")
        self.assertEqual(expense.getEmailReminderInAdvance(), -1)
        self.assertEqual(expense.getNextRepeat(), None)
        self.assertEqual(expense.getDetails(), None)
        self.assertEqual(expense.getCommentsCount(), 0)
        self.assertEqual(expense.getCreationMethod(), "equal")
        self.assertEqual(expense.getTransactionMethod(), "offline")
        # self.assertEqual(expense.getTransactionId(), None)
        self.assertEqual(expense.getCost(), "10.0")
        self.assertEqual(expense.getCurrencyCode(), "SGD")
        self.assertEqual(len(expense.getRepayments()), 1)
        self.assertEqual(expense.getRepayments()[0].getFromUser(), 643871)
        self.assertEqual(expense.getRepayments()[0].getToUser(), 79774)
        self.assertEqual(expense.getRepayments()[0].getAmount(), "5.0")
        self.assertEqual(expense.getDate(), "2020-06-23T09:56:09Z")
        self.assertEqual(expense.getCreatedAt(), "2020-06-23T09:56:14Z")
        self.assertEqual(expense.getCreatedBy().getId(), 79774)
        self.assertEqual(expense.getCreatedBy().getFirstName(), "Naman")
        self.assertEqual(expense.getCreatedBy().getLastName(), "Aggarwal")
        self.assertEqual(expense.getCreatedBy().getPicture().getMedium(),
                         "https://splitwise.s3.amazonaws.com/uploads/user/avatar/79774/medium_mypic.jpg")
        self.assertEqual(expense.getUpdatedAt(), "2020-06-23T09:56:14Z")
        self.assertEqual(expense.getUpdatedBy(), None)
        self.assertEqual(expense.getDeletedAt(), None)
        self.assertEqual(expense.getDeletedBy(), None)
        self.assertEqual(expense.getCategory().getId(), 18)
        self.assertEqual(expense.getCategory().getName(), "General")
        self.assertEqual(expense.getReceipt().getLarge(), None)
        self.assertEqual(expense.getReceipt().getOriginal(), None)
        self.assertEqual(len(expense.getUsers()), 2)
        self.assertEqual(expense.getUsers()[0].getId(), 79774)
        self.assertEqual(expense.getUsers()[0].getFirstName(), "Naman")
        self.assertEqual(expense.getUsers()[0].getLastName(), "Aggarwal")
        self.assertEqual(expense.getUsers()[0].getPicture().getMedium(),
                         "https://splitwise.s3.amazonaws.com/uploads/user/avatar/79774/medium_mypic.jpg")
        self.assertEqual(expense.getUsers()[0].getPaidShare(), "10.0")
        self.assertEqual(expense.getUsers()[0].getOwedShare(), "5.0")
        self.assertEqual(expense.getUsers()[0].getNetBalance(), "5.0")
        self.assertEqual(expense.getUsers()[1].getId(), 643871)
        self.assertEqual(expense.getUsers()[1].getFirstName(), "Shantanu")
        self.assertEqual(expense.getUsers()[1].getLastName(), "Alshi")
        self.assertEqual(expense.getUsers()[1].getPicture().getMedium(
        ), "https://s3.amazonaws.com/splitwise/uploads/user/default_avatars/avatar-blue19-100px.png")
        self.assertEqual(expense.getUsers()[1].getPaidShare(), "0.0")
        self.assertEqual(expense.getUsers()[1].getOwedShare(), "5.0")
        self.assertEqual(expense.getUsers()[1].getNetBalance(), "-5.0")
        # self.assertEqual(len(expense.getComments()), 0)

    def test_getExpense_equally_except_one_success(self, mockMakeRequest):
        mockMakeRequest.return_value = '{"expense":{"id":1010396012,"group_id":10843533,"friendship_id":null,"expense_bundle_id":null,"description":"anna shop groceries parantha execpt curd","repeats":false,"repeat_interval":"never","email_reminder":false,"email_reminder_in_advance":-1,"next_repeat":null,"details":null,"comments_count":0,"payment":false,"creation_method":"equal","transaction_method":"offline","transaction_confirmed":false,"transaction_id":null,"cost":"8.0","currency_code":"SGD","repayments":[{"from":281236,"to":79774,"amount":"2.67"},{"from":643871,"to":79774,"amount":"2.66"}],"date":"2020-06-23T09:33:07Z","created_at":"2020-06-23T09:33:38Z","created_by":{"id":79774,"first_name":"Naman","last_name":"Aggarwal","picture":{"medium":"https://splitwise.s3.amazonaws.com/uploads/user/avatar/79774/medium_mypic.jpg"},"custom_picture":true},"updated_at":"2020-06-23T09:33:38Z","updated_by":null,"deleted_at":null,"deleted_by":null,"category":{"id":12,"name":"Groceries"},"receipt":{"large":null,"original":null},"users":[{"user":{"id":79774,"first_name":"Naman","last_name":"Aggarwal","picture":{"medium":"https://splitwise.s3.amazonaws.com/uploads/user/avatar/79774/medium_mypic.jpg"}},"user_id":79774,"paid_share":"8.0","owed_share":"2.67","net_balance":"5.33"},{"user":{"id":281236,"first_name":"Siddharth","last_name":"Goel","picture":{"medium":"https://splitwise.s3.amazonaws.com/uploads/user/avatar/281236/medium_f5fccc37-0a88-4519-9398-59c8c19b92aa.jpeg"}},"user_id":281236,"paid_share":"0.0","owed_share":"2.67","net_balance":"-2.67"},{"user":{"id":643871,"first_name":"Shantanu","last_name":"Alshi","picture":{"medium":"https://s3.amazonaws.com/splitwise/uploads/user/default_avatars/avatar-blue19-100px.png"}},"user_id":643871,"paid_share":"0.0","owed_share":"2.66","net_balance":"-2.66"}],"comments":[]}}'  # noqa: E501
        expense = self.sObj.getExpense(1010396012)
        mockMakeRequest.assert_called_with(
            "https://secure.splitwise.com/api/v3.0/get_expense/1010396012")
        self.assertEqual(expense.getId(), 1010396012)
        self.assertEqual(expense.getGroupId(), 10843533)
        self.assertEqual(expense.getFriendshipId(), None)
        self.assertEqual(expense.getExpenseBundleId(), None)
        self.assertEqual(expense.getDescription(), "anna shop groceries parantha execpt curd")
        self.assertEqual(expense.getRepeatInterval(), "never")
        self.assertEqual(expense.getEmailReminderInAdvance(), -1)
        self.assertEqual(expense.getNextRepeat(), None)
        self.assertEqual(expense.getDetails(), None)
        self.assertEqual(expense.getCommentsCount(), 0)
        self.assertEqual(expense.getCreationMethod(), "equal")
        self.assertEqual(expense.getTransactionMethod(), "offline")
        # self.assertEqual(expense.getTransactionId(), None)
        self.assertEqual(expense.getCost(), "8.0")
        self.assertEqual(expense.getCurrencyCode(), "SGD")
        self.assertEqual(len(expense.getRepayments()), 2)
        self.assertEqual(expense.getRepayments()[0].getFromUser(), 281236)
        self.assertEqual(expense.getRepayments()[0].getToUser(), 79774)
        self.assertEqual(expense.getRepayments()[0].getAmount(), "2.67")
        self.assertEqual(expense.getRepayments()[1].getFromUser(), 643871)
        self.assertEqual(expense.getRepayments()[1].getToUser(), 79774)
        self.assertEqual(expense.getRepayments()[1].getAmount(), "2.66")
        self.assertEqual(expense.getDate(), "2020-06-23T09:33:07Z")
        self.assertEqual(expense.getCreatedAt(), "2020-06-23T09:33:38Z")
        self.assertEqual(expense.getCreatedBy().getId(), 79774)
        self.assertEqual(expense.getCreatedBy().getFirstName(), "Naman")
        self.assertEqual(expense.getCreatedBy().getLastName(), "Aggarwal")
        self.assertEqual(expense.getCreatedBy().getPicture().getMedium(),
                         "https://splitwise.s3.amazonaws.com/uploads/user/avatar/79774/medium_mypic.jpg")
        self.assertEqual(expense.getUpdatedAt(), "2020-06-23T09:33:38Z")
        self.assertEqual(expense.getUpdatedBy(), None)
        self.assertEqual(expense.getDeletedAt(), None)
        self.assertEqual(expense.getDeletedBy(), None)
        self.assertEqual(expense.getCategory().getId(), 12)
        self.assertEqual(expense.getCategory().getName(), "Groceries")
        self.assertEqual(expense.getReceipt().getLarge(), None)
        self.assertEqual(expense.getReceipt().getOriginal(), None)
        self.assertEqual(len(expense.getUsers()), 3)
        self.assertEqual(expense.getUsers()[0].getId(), 79774)
        self.assertEqual(expense.getUsers()[0].getFirstName(), "Naman")
        self.assertEqual(expense.getUsers()[0].getLastName(), "Aggarwal")
        self.assertEqual(expense.getUsers()[0].getPicture().getMedium(),
                         "https://splitwise.s3.amazonaws.com/uploads/user/avatar/79774/medium_mypic.jpg")
        self.assertEqual(expense.getUsers()[0].getPaidShare(), "8.0")
        self.assertEqual(expense.getUsers()[0].getOwedShare(), "2.67")
        self.assertEqual(expense.getUsers()[0].getNetBalance(), "5.33")
        self.assertEqual(expense.getUsers()[1].getId(), 281236)
        self.assertEqual(expense.getUsers()[1].getFirstName(), "Siddharth")
        self.assertEqual(expense.getUsers()[1].getLastName(), "Goel")
        self.assertEqual(expense.getUsers()[1].getPicture().getMedium(
        ), "https://splitwise.s3.amazonaws.com/uploads/user/avatar/281236/medium_f5fccc37-0a88-4519-9398-59c8c19b92aa.jpeg")
        self.assertEqual(expense.getUsers()[1].getPaidShare(), "0.0")
        self.assertEqual(expense.getUsers()[1].getOwedShare(), "2.67")
        self.assertEqual(expense.getUsers()[1].getNetBalance(), "-2.67")
        self.assertEqual(expense.getUsers()[2].getId(), 643871)
        self.assertEqual(expense.getUsers()[2].getFirstName(), "Shantanu")
        self.assertEqual(expense.getUsers()[2].getLastName(), "Alshi")
        self.assertEqual(expense.getUsers()[2].getPicture().getMedium(
        ), "https://s3.amazonaws.com/splitwise/uploads/user/default_avatars/avatar-blue19-100px.png")
        self.assertEqual(expense.getUsers()[2].getPaidShare(), "0.0")
        self.assertEqual(expense.getUsers()[2].getOwedShare(), "2.66")
        self.assertEqual(expense.getUsers()[2].getNetBalance(), "-2.66")

    def test_getExpense_itemized_success(self, mockMakeRequest):
        mockMakeRequest.return_value = '{"expense":{"id":1004919507,"group_id":10843533,"friendship_id":null,"expense_bundle_id":null,"description":"Anna shop","repeats":false,"repeat_interval":"never","email_reminder":false,"email_reminder_in_advance":-1,"next_repeat":null,"details":"Mango - 2.20 (Naman Aggarwal)\\nBread - 3.00 (Siddharth Goel)\\nVegetable \\u0026 misc - 5.80 (Naman Aggarwal, Shantanu Alshi, Siddharth Goel)\\nTax: Naman Aggarwal - 0.00, ruks - 0.00, Shantanu Alshi - 0.00, Siddharth Goel - 0.00\\nTip: Naman Aggarwal - 0.00, ruks - 0.00, Shantanu Alshi - 0.00, Siddharth Goel - 0.00\\n","comments_count":0,"payment":false,"creation_method":"itemized","transaction_method":"offline","transaction_confirmed":false,"transaction_id":null,"cost":"11.0","currency_code":"SGD","repayments":[{"from":79774,"to":281236,"amount":"4.14"},{"from":643871,"to":281236,"amount":"1.93"}],"date":"2020-06-14T06:53:49Z","created_at":"2020-06-14T06:54:37Z","created_by":{"id":281236,"first_name":"Siddharth","last_name":"Goel","picture":{"medium":"https://splitwise.s3.amazonaws.com/uploads/user/avatar/281236/medium_f5fccc37-0a88-4519-9398-59c8c19b92aa.jpeg"},"custom_picture":true},"updated_at":"2020-06-14T06:54:37Z","updated_by":null,"deleted_at":null,"deleted_by":null,"category":{"id":12,"name":"Groceries"},"receipt":{"large":null,"original":null},"users":[{"user":{"id":281236,"first_name":"Siddharth","last_name":"Goel","picture":{"medium":"https://splitwise.s3.amazonaws.com/uploads/user/avatar/281236/medium_f5fccc37-0a88-4519-9398-59c8c19b92aa.jpeg"}},"user_id":281236,"paid_share":"11.0","owed_share":"4.93","net_balance":"6.07"},{"user":{"id":79774,"first_name":"Naman","last_name":"Aggarwal","picture":{"medium":"https://splitwise.s3.amazonaws.com/uploads/user/avatar/79774/medium_mypic.jpg"}},"user_id":79774,"paid_share":"0.0","owed_share":"4.14","net_balance":"-4.14"},{"user":{"id":643871,"first_name":"Shantanu","last_name":"Alshi","picture":{"medium":"https://s3.amazonaws.com/splitwise/uploads/user/default_avatars/avatar-blue19-100px.png"}},"user_id":643871,"paid_share":"0.0","owed_share":"1.93","net_balance":"-1.93"}],"comments":[]}}'  # noqa: E501
        expense = self.sObj.getExpense(1004919507)
        mockMakeRequest.assert_called_with(
            "https://secure.splitwise.com/api/v3.0/get_expense/1004919507")
        self.assertEqual(expense.getId(), 1004919507)
        self.assertEqual(expense.getGroupId(), 10843533)
        self.assertEqual(expense.getFriendshipId(), None)
        self.assertEqual(expense.getExpenseBundleId(), None)
        self.assertEqual(expense.getDescription(), "Anna shop")
        self.assertEqual(expense.getRepeatInterval(), "never")
        self.assertEqual(expense.getEmailReminderInAdvance(), -1)
        self.assertEqual(expense.getNextRepeat(), None)
        # self.assertEqual(expense.getDetails(),
        #                 "Mango - 2.20 (Naman Aggarwal)\nBread - 3.00 (Siddharth Goel)\nVegetable \u0026 misc - 5.80\
        # (Naman Aggarwal, Shantanu Alshi, Siddharth Goel)\nTax: Naman Aggarwal - 0.00, ruks - 0.00, Shantanu Alshi - 0.00, \
        # Siddharth Goel - 0.00\nTip: Naman Aggarwal - 0.00, ruks - 0.00, Shantanu Alshi - 0.00, Siddharth Goel - 0.00\n")
        self.assertEqual(expense.getCommentsCount(), 0)
        self.assertEqual(expense.getCreationMethod(), "itemized")
        self.assertEqual(expense.getTransactionMethod(), "offline")
        # self.assertEqual(expense.getTransactionId(), None)
        self.assertEqual(expense.getCost(), "11.0")
        self.assertEqual(expense.getCurrencyCode(), "SGD")
        self.assertEqual(len(expense.getRepayments()), 2)
        self.assertEqual(expense.getRepayments()[0].getFromUser(), 79774)
        self.assertEqual(expense.getRepayments()[0].getToUser(), 281236)
        self.assertEqual(expense.getRepayments()[0].getAmount(), "4.14")
        self.assertEqual(expense.getRepayments()[1].getFromUser(), 643871)
        self.assertEqual(expense.getRepayments()[1].getToUser(), 281236)
        self.assertEqual(expense.getRepayments()[1].getAmount(), "1.93")
        self.assertEqual(expense.getDate(), "2020-06-14T06:53:49Z")
        self.assertEqual(expense.getCreatedAt(), "2020-06-14T06:54:37Z")
        self.assertEqual(expense.getCreatedBy().getId(), 281236)
        self.assertEqual(expense.getCreatedBy().getFirstName(), "Siddharth")
        self.assertEqual(expense.getCreatedBy().getLastName(), "Goel")
        self.assertEqual(expense.getCreatedBy().getPicture().getMedium(
        ), "https://splitwise.s3.amazonaws.com/uploads/user/avatar/281236/medium_f5fccc37-0a88-4519-9398-59c8c19b92aa.jpeg")
        self.assertEqual(expense.getUpdatedAt(), "2020-06-14T06:54:37Z")
        self.assertEqual(expense.getUpdatedBy(), None)
        self.assertEqual(expense.getDeletedAt(), None)
        self.assertEqual(expense.getDeletedBy(), None)
        self.assertEqual(expense.getCategory().getId(), 12)
        self.assertEqual(expense.getCategory().getName(), "Groceries")
        self.assertEqual(expense.getReceipt().getLarge(), None)
        self.assertEqual(expense.getReceipt().getOriginal(), None)
        self.assertEqual(len(expense.getUsers()), 3)
        self.assertEqual(expense.getUsers()[0].getId(), 281236)
        self.assertEqual(expense.getUsers()[0].getFirstName(), "Siddharth")
        self.assertEqual(expense.getUsers()[0].getLastName(), "Goel")
        self.assertEqual(expense.getUsers()[0].getPicture().getMedium(
        ), "https://splitwise.s3.amazonaws.com/uploads/user/avatar/281236/medium_f5fccc37-0a88-4519-9398-59c8c19b92aa.jpeg")
        self.assertEqual(expense.getUsers()[0].getPaidShare(), "11.0")
        self.assertEqual(expense.getUsers()[0].getOwedShare(), "4.93")
        self.assertEqual(expense.getUsers()[0].getNetBalance(), "6.07")
        self.assertEqual(expense.getUsers()[1].getId(), 79774)
        self.assertEqual(expense.getUsers()[1].getFirstName(), "Naman")
        self.assertEqual(expense.getUsers()[1].getLastName(), "Aggarwal")
        self.assertEqual(expense.getUsers()[1].getPicture().getMedium(),
                         "https://splitwise.s3.amazonaws.com/uploads/user/avatar/79774/medium_mypic.jpg")
        self.assertEqual(expense.getUsers()[1].getPaidShare(), "0.0")
        self.assertEqual(expense.getUsers()[1].getOwedShare(), "4.14")
        self.assertEqual(expense.getUsers()[1].getNetBalance(), "-4.14")
        self.assertEqual(expense.getUsers()[2].getId(), 643871)
        self.assertEqual(expense.getUsers()[2].getFirstName(), "Shantanu")
        self.assertEqual(expense.getUsers()[2].getLastName(), "Alshi")
        self.assertEqual(expense.getUsers()[2].getPicture().getMedium(
        ), "https://s3.amazonaws.com/splitwise/uploads/user/default_avatars/avatar-blue19-100px.png")
        self.assertEqual(expense.getUsers()[2].getPaidShare(), "0.0")
        self.assertEqual(expense.getUsers()[2].getOwedShare(), "1.93")
        self.assertEqual(expense.getUsers()[2].getNetBalance(), "-1.93")

    def test_getExpense_non_group_success(self, mockMakeRequest):
        mockMakeRequest.return_value = '{"expense":{"id":982430660,"group_id":null,"friendship_id":null,"expense_bundle_id":null,"description":"From flatmates","repeats":false,"repeat_interval":"never","email_reminder":false,"email_reminder_in_advance":-1,"next_repeat":null,"details":null,"comments_count":0,"payment":false,"creation_method":"equal","transaction_method":"offline","transaction_confirmed":false,"transaction_id":null,"cost":"2162.82","currency_code":"SGD","repayments":[{"from":784241,"to":79774,"amount":"2162.82"}],"date":"2020-05-06T05:48:14Z","created_at":"2020-05-06T05:48:30Z","created_by":{"id":79774,"first_name":"Naman","last_name":"Aggarwal","picture":{"medium":"https://splitwise.s3.amazonaws.com/uploads/user/avatar/79774/medium_mypic.jpg"},"custom_picture":true},"updated_at":"2020-05-06T05:48:30Z","updated_by":null,"deleted_at":null,"deleted_by":null,"category":{"id":18,"name":"General"},"receipt":{"large":null,"original":null},"users":[{"user":{"id":79774,"first_name":"Naman","last_name":"Aggarwal","picture":{"medium":"https://splitwise.s3.amazonaws.com/uploads/user/avatar/79774/medium_mypic.jpg"}},"user_id":79774,"paid_share":"2162.82","owed_share":"0.0","net_balance":"2162.82"},{"user":{"id":784241,"first_name":"ruks","last_name":null,"picture":{"medium":"https://s3.amazonaws.com/splitwise/uploads/user/default_avatars/avatar-ruby47-100px.png"}},"user_id":784241,"paid_share":"0.0","owed_share":"2162.82","net_balance":"-2162.82"}],"comments":[]}}'  # noqa: E501
        expense = self.sObj.getExpense(982430660)
        mockMakeRequest.assert_called_with(
            "https://secure.splitwise.com/api/v3.0/get_expense/982430660")
        self.assertEqual(expense.getId(), 982430660)
        self.assertEqual(expense.getGroupId(), None)
        self.assertEqual(expense.getFriendshipId(), None)
        self.assertEqual(expense.getExpenseBundleId(), None)
        self.assertEqual(expense.getDescription(), "From flatmates")
        self.assertEqual(expense.getRepeatInterval(), "never")
        self.assertEqual(expense.getEmailReminderInAdvance(), -1)
        self.assertEqual(expense.getNextRepeat(), None)
        self.assertEqual(expense.getDetails(), None)
        self.assertEqual(expense.getCommentsCount(), 0)
        self.assertEqual(expense.getCreationMethod(), "equal")
        self.assertEqual(expense.getTransactionMethod(), "offline")
        # self.assertEqual(expense.getTransactionId(), None)
        self.assertEqual(expense.getCost(), "2162.82")
        self.assertEqual(expense.getCurrencyCode(), "SGD")
        self.assertEqual(len(expense.getRepayments()), 1)
        self.assertEqual(expense.getRepayments()[0].getFromUser(), 784241)
        self.assertEqual(expense.getRepayments()[0].getToUser(), 79774)
        self.assertEqual(expense.getRepayments()[0].getAmount(), "2162.82")
        self.assertEqual(expense.getDate(), "2020-05-06T05:48:14Z")
        self.assertEqual(expense.getCreatedAt(), "2020-05-06T05:48:30Z")
        self.assertEqual(expense.getCreatedBy().getId(), 79774)
        self.assertEqual(expense.getCreatedBy().getFirstName(), "Naman")
        self.assertEqual(expense.getCreatedBy().getLastName(), "Aggarwal")
        self.assertEqual(expense.getCreatedBy().getPicture().getMedium(),
                         "https://splitwise.s3.amazonaws.com/uploads/user/avatar/79774/medium_mypic.jpg")
        self.assertEqual(expense.getUpdatedAt(), "2020-05-06T05:48:30Z")
        self.assertEqual(expense.getUpdatedBy(), None)
        self.assertEqual(expense.getDeletedAt(), None)
        self.assertEqual(expense.getDeletedBy(), None)
        self.assertEqual(expense.getCategory().getId(), 18)
        self.assertEqual(expense.getCategory().getName(), "General")
        self.assertEqual(expense.getReceipt().getLarge(), None)
        self.assertEqual(expense.getReceipt().getOriginal(), None)
        self.assertEqual(len(expense.getUsers()), 2)
        self.assertEqual(expense.getUsers()[0].getId(), 79774)
        self.assertEqual(expense.getUsers()[0].getFirstName(), "Naman")
        self.assertEqual(expense.getUsers()[0].getLastName(), "Aggarwal")
        self.assertEqual(expense.getUsers()[0].getPicture().getMedium(),
                         "https://splitwise.s3.amazonaws.com/uploads/user/avatar/79774/medium_mypic.jpg")
        self.assertEqual(expense.getUsers()[0].getPaidShare(), "2162.82")
        self.assertEqual(expense.getUsers()[0].getOwedShare(), "0.0")
        self.assertEqual(expense.getUsers()[0].getNetBalance(), "2162.82")
        self.assertEqual(expense.getUsers()[1].getId(), 784241)
        self.assertEqual(expense.getUsers()[1].getFirstName(), "ruks")
        self.assertEqual(expense.getUsers()[1].getLastName(), None)
        self.assertEqual(expense.getUsers()[1].getPicture().getMedium(
        ), "https://s3.amazonaws.com/splitwise/uploads/user/default_avatars/avatar-ruby47-100px.png")
        self.assertEqual(expense.getUsers()[1].getPaidShare(), "0.0")
        self.assertEqual(expense.getUsers()[1].getOwedShare(), "2162.82")
        self.assertEqual(expense.getUsers()[1].getNetBalance(), "-2162.82")

    def test_getExpense_exception(self, mockMakeRequest):
        mockMakeRequest.side_effect = Exception(
            "Invalid response %s. Please check your consumer key and secret." % 404)
        with self.assertRaises(Exception):
            self.sObj.getExpense(123)
        mockMakeRequest.assert_called_with(
            "https://secure.splitwise.com/api/v3.0/get_expense/123")
