"""
Descriptors derived from a molecule's 3D structure

"""
from __future__ import annotations
from rdkit.Chem.Descriptors import _isCallable
from rdkit.Chem import rdMolDescriptors
__all__: list[str] = ['CalcMolDescriptors3D', 'descList', 'rdMolDescriptors']
def CalcMolDescriptors3D(mol, confId = None):
    """
    
    Compute all 3D descriptors of a molecule
    
    Arguments:
    - mol: the molecule to work with
    - confId: conformer ID to work with. If not specified the default (-1) is used
    
    Return:
    
    dict
        A dictionary with decriptor names as keys and the descriptor values as values
    
    raises a ValueError 
        If the molecule does not have conformers
    """
def _setupDescriptors(namespace):
    ...
descList: list  # value = [('PMI1', <function <lambda> at 0xffffa9e185c0>), ('PMI2', <function <lambda> at 0xffff9ce83060>), ('PMI3', <function <lambda> at 0xffff9ce83110>), ('NPR1', <function <lambda> at 0xffff9ce831c0>), ('NPR2', <function <lambda> at 0xffff9ce83270>), ('RadiusOfGyration', <function <lambda> at 0xffff9ce83320>), ('InertialShapeFactor', <function <lambda> at 0xffff9ce833d0>), ('Eccentricity', <function <lambda> at 0xffff9ce83480>), ('Asphericity', <function <lambda> at 0xffff9ce83530>), ('SpherocityIndex', <function <lambda> at 0xffff9ce835e0>), ('PBF', <function <lambda> at 0xffff9ce83690>)]
