% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Circ.filter.R
\name{Circ.filter}
\alias{Circ.filter}
\title{Circ.filter}
\usage{
Circ.filter(circ = circ, linear = linear, Nreplicates = 6,
  filter.sample = 4, filter.count = 5, percentage = 1,
  circle_description = c(1:3))
}
\arguments{
\item{circ}{CircRNACount file. A file of circRNA read count table. First three columns are circRNA coordinates, and followed by columns for circRNA read counts, each sample per column.}

\item{linear}{LinearCount file. A file of circRNA host gene expression count table. Same configuration as CircRNACount file.}

\item{Nreplicates}{Number of replicates in your data. Expect each group have the same number of replicates.}

\item{filter.sample}{The minimum number of samples need to have above filter.count number of circRNA supporting reads.}

\item{filter.count}{The minimum read count used for filtering.}

\item{percentage}{The minimum percentage of circRNAs account for the total transcripts in at leat one group.}

\item{circle_description}{Column indices which do not carry circle/linear read counts.}
}
\description{
Filter circRNA candidates based on expression level. User specify how many samples (filter.sample) need to have above
which minimum number (filter.count) of read count support. In addition, circRNA need to account for which percentage (percentage) of the total transcripts in at least one group.
}

