% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Circ.linePlot.R
\name{Circ.lineplot}
\alias{Circ.lineplot}
\title{Circ.lineplot}
\usage{
Circ.lineplot(Circ, Linear, CircCoordinates = None, plotrow = "1",
  size = 18, ncol = 2, groupindicator1 = NULL, groupindicator2 = NULL,
  x = "Conditions", y = "Counts", circle_description = c(1:3),
  gene_column = None)
}
\arguments{
\item{Circ}{CircRNACount file. A file of circRNA read count table. First three columns are circRNA coordinates, and followed by columns for circRNA read counts, each sample per column.}

\item{Linear}{LinearCount file. A file of circRNA host gene expression count table. Same configuration as CircRNACount file.}

\item{CircCoordinates}{BED format circRNA coordinates file.}

\item{plotrow}{The rownumber or rowname in the CircRNACount table corresponding the specific gene which you want to plot.}

\item{size}{the text size. Default 18.}

\item{ncol}{if groupindicator2 is provided, specify the panel layout. Default 2.}

\item{groupindicator1}{A vector of group indicators. For example, ages.}

\item{groupindicator2}{An other vector of group indicators. For example, tissues. This indicator will be used to segement plots out.}

\item{x}{x axis lable. Default 'Conditions'.}

\item{y}{y axis lable. Default 'Counts'.}

\item{circle_description}{Column indices which do not carry circle/linear read counts.}

\item{gene_column}{Column index of the column containing the gene name in CircCoordinates if available, otherwise its chosen from Circ.}
}
\description{
Plot circRNA and host gene expression as line plot. Plot per gene-wise.
}
\examples{
data(Coordinates)
data(Circ)
data(Linear)
Circ.lineplot(Circ,Linear,Coordinates,plotrow=10,groupindicator1=c(rep('1days',6),rep('4days',6),rep('20days',6)),groupindicator2=rep(c(rep('Female',4),rep('Male',2)),3),x='Ages',circle_description = c(1:3), gene_column = 4 )
}

