% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Circ.test.R
\name{Circ.test}
\alias{Circ.test}
\title{Circ.test}
\usage{
Circ.test(Circ, Linear, CircCoordinates = None, group, alpha = 0.05,
  plotsig = T, circle_description = c(1:3))
}
\arguments{
\item{Circ}{CircRNACount file. A file of circRNA read count table. First three columns are circRNA coordinates, and followed by columns for circRNA read counts, each sample per column.}

\item{Linear}{LinearCount file. A file of circRNA host gene expression count table. Same configuration as CircRNACount file.}

\item{group}{A vector of group indicators.}

\item{alpha}{p value cut off. Defaul 0.05.}

\item{plotsig}{If 'TRUE', significantly host-independently regulated circRNAs will be ploted.}

\item{circle_description}{Column indices which do not carry circle/linear read counts.}

\item{(Optional)}{CircCoordinates BED format circRNA coordinates file.}
}
\description{
Test the independent variation of circRNAs in relevant to their host genes.
}
\examples{
data(Circ)
data(Linear)
test=Circ.test(Circ=Circ,Linear=Linear,group=c(rep(1,6),rep(2,6),rep(3,6)))
View(test$sig.dat)
# Plot one of them
Circ.ratioplot(Circ,Linear,Coordinates,plotrow=rownames(test$sig.dat)[1],groupindicator1=c(rep('1days',6),rep('4days',6),rep('20days',6)),groupindicator2=rep(c(rep('Female',4),rep('Male',2)),3),lab_legend='Ages', circle_description = c(1:3))
}

