% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design.R
\name{design}
\alias{design}
\title{Run primer design}
\usage{
design(seqOpts, primerOpts = NULL, returnStats = TRUE, ...)
}
\arguments{
\item{seqOpts}{parameters for the given sequence, 
i.e. template sequence, its name, junction position}

\item{primerOpts}{(optional) thermodynamical and other primer-specific
parameters. Can be created using \link{p3Settings}.}

\item{returnStats}{(default: TRUE) if the "EXPLAIN" fields with 
the run statistics should be returned. This option overwrites 
the one provided in the `primerOpts$PRIMER_EXPLAIN_FLAG`.}

\item{...}{path parameters for the `\link{runPrimer3}` call.}
}
\value{
a data.frame with the designed primers
}
\description{
Run primer design
}
\details{
By default, if `primer3Config` is not secified/NULL,
  it is inferred on the basis of the `primer3Path` as a subdirectory 
  `primer3_config`
}
\examples{
# make up a sequence
seq1 <- paste(c("A", "T", "G", "C")[sample(4, 300, replace = TRUE)], 
              collapse = "")
seqOpts <- seqSettings(seqId = "seq1", seq = seq1)
res <- design(seqOpts)
res$primers

}
