% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design.R
\name{seqSettings}
\alias{seqSettings}
\title{A helper to define template parameters}
\usage{
seqSettings(settings = NULL, granges = NULL, seqId = NULL, seq = NULL)
}
\arguments{
\item{settings}{a list with predefined parameters}

\item{granges}{A `GRanges` object with `seq` column. It can include one or
two elements. In the case of two, the sequences are concatenated and
one of the primers will be forced two overlap the splice junction.}

\item{seqId}{a character name for the sequence}

\item{seq}{(if gr is NULL) a character vector of length 1 or 2.
In the case of two sequences, they are treated as consequent exons and
either of two primers will be forced two overlap the splice junction.}
}
\value{
a named list with all template parameters (with defaults for the ones
 not specified in  the `seqOpts`  or in the function arguments. 
 The function arguments, i.e. `seq1` etc. overwrite the ones provided in
 the `seqOpts`.
}
\description{
A helper to define template parameters
}
\examples{
seqOpts <- seqSettings(seqId = "seq1", seq = "AATCTGAATCGCGCTTAAAGCTA")

}
