"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ActionGroup = void 0;
const monitor_action_group_1 = require("@cdktf/provider-azurerm/lib/monitor-action-group");
const cdktf = require("cdktf");
const lib_1 = require("../../core-azure/lib");
const model = require("../model");
class ActionGroup extends lib_1.AzureResource {
    /**
     * Manages an Azure Monitor Action Group, which is used to trigger actions or notifications based on alerts or conditions met within Azure Monitor.
     *
     * An Action Group in Azure Monitor defines a collection of individual actions that are triggered when the conditions of an associated alert rule are met. Actions can include sending emails, triggering Azure Functions, calling webhooks, and more. This class allows for configuring and managing these actions, making it essential for setting up comprehensive monitoring and response systems in Azure applications.
     *
     * @param scope - The scope in which to define this construct, typically representing the Cloud Development Kit (CDK) stack.
     * @param id - The unique identifier for this instance of the Action Group.
     * @param props - Configuration properties for the Action Group. These properties may include:
     *                - `name`: The name of the Action Group.
     *                - `resourceGroup`: Optional. Reference to the resource group for deployment.
     *                - `shortName`: A shorter name for the Action Group used in notifications.
     *                - `enabled`: Specifies if the Action Group is active. Defaults to true.
     *                - `location`: The Azure region where the Action Group is hosted. Defaults to global.
     *                - `tags`: A dictionary of tags to apply to the Action Group for resource management.
     *                - Receivers: Configurations for various types of notifications (e.g., email, SMS, webhook).
     *
     * Example usage:
     * ```typescript
     * const actionGroup = new ActionGroup(this, 'myActionGroup', {
     *   name: 'criticalAlertsGroup',
     *   resourceGroup: myResourceGroup,
     *   shortName: 'Alerts',
     *   location: 'East US',
     *   emailReceivers: [{
     *     name: 'admin',
     *     emailAddress: 'admin@example.com'
     *   }],
     *   smsReceivers: [{
     *     name: 'adminSms',
     *     countryCode: '1',
     *     phoneNumber: '5551234567'
     *   }],
     *   tags: {
     *     environment: 'production'
     *   }
     * });
     * ```
     * This setup creates an Action Group that sends email and SMS notifications when triggered by an alert.
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.props = props;
        this.resourceGroup = this.setupResourceGroup(props);
        /**
         * Define default values.
         */
        const defaults = {
            enabled: props.enabled ?? true,
            location: props.location ?? "global",
            tags: props.tags ?? {},
        };
        // Create the Action Group with the provided properties
        const azurermMonitorActionGroup = new monitor_action_group_1.MonitorActionGroup(this, "actiongroup", {
            ...defaults,
            name: props.name,
            resourceGroupName: this.resourceGroup.name,
            shortName: props.shortName,
            armRoleReceiver: cdktf.listMapper(model.monitorActionGroupArmRoleReceiverToTerraform, true)(this.props.armRoleReceivers),
            emailReceiver: cdktf.listMapper(model.monitorActionGroupEmailReceiverToTerraform, true)(this.props.emailReceivers),
            voiceReceiver: cdktf.listMapper(model.monitorActionGroupVoiceReceiverToTerraform, true)(this.props.voiceReceivers),
            smsReceiver: cdktf.listMapper(model.monitorActionGroupSmsReceiverToTerraform, true)(this.props.smsReceivers),
            webhookReceiver: cdktf.listMapper(model.monitorActionGroupWebhookReceiverToTerraform, true)(this.props.webhookReceivers),
            eventHubReceiver: cdktf.listMapper(model.monitorActionGroupEventHubReceiverToTerraform, true)(this.props.eventHubReceivers),
            azureAppPushReceiver: cdktf.listMapper(model.monitorActionGroupAzureAppPushReceiverToTerraform, true)(this.props.azureAppPushReceivers),
            logicAppReceiver: cdktf.listMapper(model.monitorActionGroupLogicAppReceiverToTerraform, true)(this.props.logicAppReceivers),
        });
        // Terraform Outputs
        this.id = azurermMonitorActionGroup.id;
        const cdktfTerraformOutputActionGroupId = new cdktf.TerraformOutput(this, "id", {
            value: azurermMonitorActionGroup.id,
        });
        /*This allows the Terraform resource name to match the original name. You can remove the call if you don't need them to match.*/
        cdktfTerraformOutputActionGroupId.overrideLogicalId("id");
    }
}
exports.ActionGroup = ActionGroup;
//# sourceMappingURL=data:application/json;base64,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