"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.monitorActionGroupLogicAppReceiverToTerraform = exports.monitorActionGroupAzureAppPushReceiverToTerraform = exports.monitorActionGroupEventHubReceiverToTerraform = exports.monitorActionGroupWebhookReceiverToTerraform = exports.monitorActionGroupSmsReceiverToTerraform = exports.monitorActionGroupVoiceReceiverToTerraform = exports.monitorActionGroupEmailReceiverToTerraform = exports.monitorActionGroupArmRoleReceiverToTerraform = void 0;
const cdktf = require("cdktf");
/**
 * Helper function to convert ArmRoleReceiverProps to Terraform format.
 */
function monitorActionGroupArmRoleReceiverToTerraform(props) {
    if (!cdktf.canInspect(props)) {
        return props;
    }
    return {
        name: props.name,
        roleId: props.roleId,
        useCommonAlertSchema: props.useCommonAlertSchema || false,
    };
}
exports.monitorActionGroupArmRoleReceiverToTerraform = monitorActionGroupArmRoleReceiverToTerraform;
/**
 * Helper function to convert EmailReceiversProps to Terraform format.
 */
function monitorActionGroupEmailReceiverToTerraform(props) {
    if (!cdktf.canInspect(props)) {
        return props;
    }
    return {
        name: props.name,
        emailAddress: props.emailAddress,
        useCommonAlertSchema: props.useCommonAlertSchema || false,
    };
}
exports.monitorActionGroupEmailReceiverToTerraform = monitorActionGroupEmailReceiverToTerraform;
/**
 * Helper function to convert VoiceReceiverProps to Terraform format.
 */
function monitorActionGroupVoiceReceiverToTerraform(props) {
    if (!cdktf.canInspect(props)) {
        return props;
    }
    return {
        name: props.name,
        countryCode: props.countryCode,
        phoneNumber: props.phoneNumber,
    };
}
exports.monitorActionGroupVoiceReceiverToTerraform = monitorActionGroupVoiceReceiverToTerraform;
/**
 * Helper function to convert SmsReceiverProps to Terraform format.
 */
function monitorActionGroupSmsReceiverToTerraform(props) {
    if (!cdktf.canInspect(props)) {
        return props;
    }
    return {
        name: props.name,
        countryCode: props.countryCode,
        phoneNumber: props.phoneNumber,
    };
}
exports.monitorActionGroupSmsReceiverToTerraform = monitorActionGroupSmsReceiverToTerraform;
/**
 * Helper function to convert WebhookReceiverProps to Terraform format.
 */
function monitorActionGroupWebhookReceiverToTerraform(props) {
    if (!cdktf.canInspect(props)) {
        return props;
    }
    return {
        name: props.name,
        serviceUri: props.serviceUri,
        useCommonAlertSchema: props.useCommonAlertSchema || false,
    };
}
exports.monitorActionGroupWebhookReceiverToTerraform = monitorActionGroupWebhookReceiverToTerraform;
/**
 * Helper function to convert EventhubReceiverProps to Terraform format.
 */
function monitorActionGroupEventHubReceiverToTerraform(props) {
    if (!cdktf.canInspect(props)) {
        return props;
    }
    return {
        name: props.name,
        eventHubName: props.eventHubName,
        eventHubNamespace: props.eventHubNamespace,
        useCommonAlertSchema: props.useCommonAlertSchema || false,
    };
}
exports.monitorActionGroupEventHubReceiverToTerraform = monitorActionGroupEventHubReceiverToTerraform;
/**
 * Helper function to convert AzureAppPushReceiverProps to Terraform format.
 */
function monitorActionGroupAzureAppPushReceiverToTerraform(props) {
    if (!cdktf.canInspect(props)) {
        return props;
    }
    return {
        name: props.name,
        emailAddress: props.emailAddress,
    };
}
exports.monitorActionGroupAzureAppPushReceiverToTerraform = monitorActionGroupAzureAppPushReceiverToTerraform;
/**
 * Helper function to convert LogicAppReceiverProps to Terraform format.
 */
function monitorActionGroupLogicAppReceiverToTerraform(props) {
    if (!cdktf.canInspect(props)) {
        return props;
    }
    return {
        name: props.name,
        resourceId: props.resourceId,
        callbackUrl: props.callbackUrl,
        useCommonAlertSchema: props.useCommonAlertSchema || false,
    };
}
exports.monitorActionGroupLogicAppReceiverToTerraform = monitorActionGroupLogicAppReceiverToTerraform;
//# sourceMappingURL=data:application/json;base64,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