"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const provider_1 = require("@cdktf/provider-azurerm/lib/provider");
const cdktf_1 = require("cdktf");
const __1 = require("..");
const testing_1 = require("../../testing");
require("cdktf/lib/testing/adapters/jest");
const model = require("../model");
describe("Action Group With Defaults", () => {
    let stack;
    let fullSynthResult;
    beforeEach(() => {
        const app = cdktf_1.Testing.app();
        stack = new cdktf_1.TerraformStack(app, "test");
        new provider_1.AzurermProvider(stack, "azureFeature", { features: {} });
        new __1.ActionGroup(stack, "testAzureActionGroupDefaults", {
            name: "testactiongroup",
            shortName: "testshortn",
        });
        fullSynthResult = cdktf_1.Testing.fullSynth(stack); // Save the result for reuse
    });
    it("renders an Action Group with defaults and checks snapshot", () => {
        expect(cdktf_1.Testing.synth(stack)).toMatchSnapshot(); // Compare the already prepared stack
    });
    it("check if the produced terraform configuration is valid", () => {
        expect(fullSynthResult).toBeValidTerraform(); // Use the saved result
    });
    it("check if this can be planned", () => {
        (0, testing_1.TerraformPlan)(fullSynthResult); // Use the saved result
    });
});
describe("Action Group With Defaults 2", () => {
    let stack;
    let fullSynthResult;
    beforeEach(() => {
        const app = cdktf_1.Testing.app();
        stack = new cdktf_1.TerraformStack(app, "test2");
        new provider_1.AzurermProvider(stack, "azureFeature", { features: {} });
        new __1.ActionGroup(stack, "testAzureActionGroupDefaults", {
            name: "testactiongroup",
            shortName: "testshortn",
            enabled: false,
            location: "global",
            tags: {
                test: "test",
            },
        });
        fullSynthResult = cdktf_1.Testing.fullSynth(stack); // Save the result for reuse
    });
    it("renders an Action Group with defaults and checks snapshot", () => {
        expect(cdktf_1.Testing.synth(stack)).toMatchSnapshot(); // Compare the already prepared stack
    });
    it("check if the produced terraform configuration is valid", () => {
        expect(fullSynthResult).toBeValidTerraform(); // Use the saved result
    });
    it("check if this can be planned", () => {
        (0, testing_1.TerraformPlan)(fullSynthResult); // Use the saved result
    });
});
/**
 * Unit Tests for Action Group Helper Functions
 */
describe("Action Group Helper Functions Unit Test for ArmRoleReceiverProps", () => {
    let armRoleReceiverProps1 = {
        name: "test_arm_role_receiver_1",
        roleId: "test-role-id-1",
        useCommonAlertSchema: true,
    };
    let armRoleReceiverProps2 = {
        name: "test_arm_role_receiver_2",
        roleId: "test-role-id-2",
    };
    let armRoleReceiverProps3;
    it("arm role receiver prop with useCommonAlertSchema defined", () => {
        expect(model.monitorActionGroupArmRoleReceiverToTerraform(armRoleReceiverProps1)).toMatchObject({
            name: "test_arm_role_receiver_1",
            roleId: "test-role-id-1",
            useCommonAlertSchema: true,
        });
    });
    it("arm role receiver prop without useCommonAlertSchema defined", () => {
        expect(model.monitorActionGroupArmRoleReceiverToTerraform(armRoleReceiverProps2)).toMatchObject({
            name: "test_arm_role_receiver_2",
            roleId: "test-role-id-2",
            useCommonAlertSchema: false,
        });
    });
    it("arm role receiver prop undefined", () => {
        expect(model.monitorActionGroupArmRoleReceiverToTerraform(armRoleReceiverProps3)).toBeUndefined();
    });
});
describe("Action Group Helper Functions Unit Test for EmailReceiversProps", () => {
    let emailReceiverProps1 = {
        name: "test_email_receiver_1",
        emailAddress: "test-email-address-1",
        useCommonAlertSchema: true,
    };
    let emailReceiverProps2 = {
        name: "test_email_receiver_2",
        emailAddress: "test-email-address-2",
    };
    let emailReceiverProps3;
    it("email receiver prop with useCommonAlertSchema defined", () => {
        expect(model.monitorActionGroupEmailReceiverToTerraform(emailReceiverProps1)).toMatchObject({
            name: "test_email_receiver_1",
            emailAddress: "test-email-address-1",
            useCommonAlertSchema: true,
        });
    });
    it("email receiver prop without useCommonAlertSchema defined", () => {
        expect(model.monitorActionGroupEmailReceiverToTerraform(emailReceiverProps2)).toMatchObject({
            name: "test_email_receiver_2",
            emailAddress: "test-email-address-2",
            useCommonAlertSchema: false,
        });
    });
    it("email receiver prop undefined", () => {
        expect(model.monitorActionGroupEmailReceiverToTerraform(emailReceiverProps3)).toBeUndefined();
    });
});
describe("Action Group Helper Functions Unit Test for VoiceReceiverProps", () => {
    let voiceReceiverProps1 = {
        name: "test_voice_receiver_1",
        countryCode: "1",
        phoneNumber: "0123456789",
    };
    let voiceReceiverProps2;
    it("voice receiver prop defined", () => {
        expect(model.monitorActionGroupVoiceReceiverToTerraform(voiceReceiverProps1)).toMatchObject({
            name: "test_voice_receiver_1",
            countryCode: "1",
            phoneNumber: "0123456789",
        });
    });
    it("voice receiver prop undefined", () => {
        expect(model.monitorActionGroupVoiceReceiverToTerraform(voiceReceiverProps2)).toBeUndefined();
    });
});
describe("Action Group Helper Functions Unit Test for SmsReceiverProps", () => {
    let smsReceiverProps1 = {
        name: "test_sms_receiver_1",
        countryCode: "1",
        phoneNumber: "0123456789",
    };
    let smsReceiverProps2;
    it("sms receiver prop defined", () => {
        expect(model.monitorActionGroupSmsReceiverToTerraform(smsReceiverProps1)).toMatchObject({
            name: "test_sms_receiver_1",
            countryCode: "1",
            phoneNumber: "0123456789",
        });
    });
    it("sms receiver prop undefined", () => {
        expect(model.monitorActionGroupSmsReceiverToTerraform(smsReceiverProps2)).toBeUndefined();
    });
});
describe("Action Group Helper Functions Unit Test for WebhookReceiverProps", () => {
    let webhookReceiverProps1 = {
        name: "test_webhook_receiver_1",
        serviceUri: "https://test-webhook-uri-1",
        useCommonAlertSchema: true,
    };
    let webhookReceiverProps2 = {
        name: "test_webhook_receiver_2",
        serviceUri: "https://test-webhook-uri-2",
    };
    let webhookReceiverProps3;
    it("webhook receiver prop with useCommonAlertSchema defined", () => {
        expect(model.monitorActionGroupWebhookReceiverToTerraform(webhookReceiverProps1)).toMatchObject({
            name: "test_webhook_receiver_1",
            serviceUri: "https://test-webhook-uri-1",
            useCommonAlertSchema: true,
        });
    });
    it("webhook receiver prop without useCommonAlertSchema defined", () => {
        expect(model.monitorActionGroupWebhookReceiverToTerraform(webhookReceiverProps2)).toMatchObject({
            name: "test_webhook_receiver_2",
            serviceUri: "https://test-webhook-uri-2",
            useCommonAlertSchema: false,
        });
    });
    it("webhook receiver prop undefined", () => {
        expect(model.monitorActionGroupWebhookReceiverToTerraform(webhookReceiverProps3)).toBeUndefined();
    });
});
describe("Action Group Helper Functions Unit Test for EventhubReceiverProps", () => {
    let eventhubReceiverProps1 = {
        name: "test_eventhub_receiver_1",
        eventHubName: "testeventhubname1",
        eventHubNamespace: "testnamespace1",
        useCommonAlertSchema: true,
    };
    let eventhubReceiverProps2 = {
        name: "test_eventhub_receiver_2",
        eventHubName: "testeventhubname2",
        eventHubNamespace: "testnamespace2",
    };
    let eventhubReceiverProps3;
    it("eventhub receiver prop with useCommonAlertSchema defined", () => {
        expect(model.monitorActionGroupEventHubReceiverToTerraform(eventhubReceiverProps1)).toMatchObject({
            name: "test_eventhub_receiver_1",
            eventHubName: "testeventhubname1",
            eventHubNamespace: "testnamespace1",
            useCommonAlertSchema: true,
        });
    });
    it("eventhub receiver prop without useCommonAlertSchema defined", () => {
        expect(model.monitorActionGroupEventHubReceiverToTerraform(eventhubReceiverProps2)).toMatchObject({
            name: "test_eventhub_receiver_2",
            eventHubName: "testeventhubname2",
            eventHubNamespace: "testnamespace2",
            useCommonAlertSchema: false,
        });
    });
    it("eventhub receiver prop undefined", () => {
        expect(model.monitorActionGroupEventHubReceiverToTerraform(eventhubReceiverProps3)).toBeUndefined();
    });
});
describe("Action Group Helper Functions Unit Test for AzureAppPushReceiverProps", () => {
    let azureAppPushReceiverProps1 = {
        name: "test_azure_app_push_receiver_1",
        emailAddress: "testemail@gtestemail.com",
    };
    let azureAppPushReceiverProps2;
    it("azure app push receiver prop with useCommonAlertSchema defined", () => {
        expect(model.monitorActionGroupAzureAppPushReceiverToTerraform(azureAppPushReceiverProps1)).toMatchObject({
            name: "test_azure_app_push_receiver_1",
            emailAddress: "testemail@gtestemail.com",
        });
    });
    it("azure app push receiver prop undefined", () => {
        expect(model.monitorActionGroupAzureAppPushReceiverToTerraform(azureAppPushReceiverProps2)).toBeUndefined();
    });
});
describe("Action Group Helper Functions Unit Test for LogicAppReceiverProps", () => {
    let logicAppReceiverProps1 = {
        name: "test_logic_app_receiver_1",
        resourceId: "test/resource/id/1",
        callbackUrl: "https://test-logic-app-uri-1",
        useCommonAlertSchema: true,
    };
    let logicAppReceiverProps2 = {
        name: "test_logic_app_receiver_2",
        resourceId: "test/resource/id/2",
        callbackUrl: "https://test-logic-app-uri-2",
    };
    let logicAppReceiverProps3;
    it("logic app receiver prop with useCommonAlertSchema defined", () => {
        expect(model.monitorActionGroupLogicAppReceiverToTerraform(logicAppReceiverProps1)).toMatchObject({
            name: "test_logic_app_receiver_1",
            callbackUrl: "https://test-logic-app-uri-1",
            useCommonAlertSchema: true,
        });
    });
    it("logic app receiver prop without useCommonAlertSchema defined", () => {
        expect(model.monitorActionGroupLogicAppReceiverToTerraform(logicAppReceiverProps2)).toMatchObject({
            name: "test_logic_app_receiver_2",
            callbackUrl: "https://test-logic-app-uri-2",
            useCommonAlertSchema: false,
        });
    });
    it("logic app receiver prop undefined", () => {
        expect(model.monitorActionGroupLogicAppReceiverToTerraform(logicAppReceiverProps3)).toBeUndefined();
    });
});
//# sourceMappingURL=data:application/json;base64,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