import * as azapgw from "@cdktf/provider-azurerm/lib/application-gateway";
import { KeyVault } from "@cdktf/provider-azurerm/lib/key-vault";
import { PublicIp } from "@cdktf/provider-azurerm/lib/public-ip";
import { ResourceGroup } from "@cdktf/provider-azurerm/lib/resource-group";
import { Subnet } from "@cdktf/provider-azurerm/lib/subnet";
import { Construct } from "constructs";
import { AzureResource } from "../../core-azure";
export interface IGatewayProps {
    /**
     * Optional public IP address for the frontend of the Application Gateway.
     */
    publicIpAddress?: PublicIp;
    /**
     * Optional private IP address for the frontend of the Application Gateway.
     */
    privateIpAddress?: string;
    /**
     * Allocation method for the private IP address (e.g., Static, Dynamic).
     */
    privateIpAddressAllocation?: string;
    /**
     * The name of the Application Gateway.
     */
    readonly name: string;
    /**
     * The location where the Application Gateway will be deployed (e.g., region).
     */
    readonly location: string;
    /**
     * An optional reference to the resource group in which to deploy the Application Gateway.
     * If not provided, the Application Gateway will be deployed in the default resource group.
     */
    readonly resourceGroup?: ResourceGroup;
    /**
     * The SKU tier of the Application Gateway (e.g., Standard, WAF).
     */
    readonly skuTier: string;
    /**
     * The size of the SKU for the Application Gateway.
     */
    readonly skuSize: string;
    /**
     * The capacity (instance count) of the Application Gateway.
     */
    readonly capacity: number;
    /**
     * The backend address pools for the Application Gateway.
     */
    readonly backendAddressPools: azapgw.ApplicationGatewayBackendAddressPool[];
    /**
     * The backend HTTP settings for the Application Gateway.
     */
    readonly backendHttpSettings: azapgw.ApplicationGatewayBackendHttpSettings[];
    /**
     * Optional frontend ports for the Application Gateway.
     */
    readonly frontendPorts?: azapgw.ApplicationGatewayFrontendPort[];
    /**
     * The HTTP listeners for the Application Gateway.
     */
    readonly httpListeners: azapgw.ApplicationGatewayHttpListener[];
    /**
     * The request routing rules for the Application Gateway.
     */
    readonly requestRoutingRules: azapgw.ApplicationGatewayRequestRoutingRule[];
    /**
     * Optional subnet for the Application Gateway.
     */
    readonly subnet?: Subnet;
    /**
     * Optional tenant ID for use with Key Vault, if applicable.
     */
    readonly tenantId?: string;
    /**
     * Flag to enable HTTP2.
     */
    readonly enableHttp2?: boolean;
    /**
     * Flag to enable FIPS-compliant algorithms.
     */
    readonly fipsEnabled?: boolean;
    /**
     * Optional ID of the firewall policy.
     */
    readonly firewallPolicyId?: string;
    /**
     * Flag to enforce association of the firewall policy.
     */
    readonly forceFirewallPolicyAssociation?: boolean;
    /**
     * Optional tags for the Application Gateway resource.
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * Optional availability zones for the Application Gateway.
     */
    readonly zones?: string[];
    /**
     * Optional Key Vault resource for storing SSL certificates.
     */
    readonly keyVault?: KeyVault;
    /**
     * Optional authentication certificates for mutual authentication.
     */
    readonly authenticationCertificate?: azapgw.ApplicationGatewayAuthenticationCertificate[];
    /**
     * Optional autoscale configuration for dynamically adjusting the capacity of the Application Gateway.
     */
    readonly autoscaleConfiguration?: azapgw.ApplicationGatewayAutoscaleConfiguration;
    /**
     * Optional custom error configurations to specify custom error pages.
     */
    readonly customErrorConfiguration?: azapgw.ApplicationGatewayCustomErrorConfiguration[];
    /**
     * Optional identity for the Application Gateway, used for accessing other Azure resources.
     */
    readonly identity?: azapgw.ApplicationGatewayIdentity;
    /**
     * Optional configurations for enabling Private Link on the Application Gateway.
     */
    readonly privateLinkConfiguration?: azapgw.ApplicationGatewayPrivateLinkConfiguration[];
    /**
     * Optional probes for health checks of the backend HTTP settings.
     */
    readonly probe?: azapgw.ApplicationGatewayProbe[];
    /**
     * Optional configurations for redirect rules.
     */
    readonly redirectConfiguration?: azapgw.ApplicationGatewayRedirectConfiguration[];
    /**
     * Optional rewrite rule sets for modifying HTTP request and response headers and bodies.
     */
    readonly rewriteRuleSet?: azapgw.ApplicationGatewayRewriteRuleSet[];
    /**
     * Optional SSL certificates for enabling HTTPS on the Application Gateway.
     */
    readonly sslCertificate?: azapgw.ApplicationGatewaySslCertificate[];
    /**
     * Optional SSL policy configurations, defining the protocol and cipher suites used.
     */
    readonly sslPolicy?: azapgw.ApplicationGatewaySslPolicy;
    /**
     * Optional SSL profiles for managing SSL termination and policy settings.
     */
    readonly sslProfile?: azapgw.ApplicationGatewaySslProfile[];
    /**
     * Optional timeout settings for the Application Gateway resources.
     */
    readonly timeouts?: azapgw.ApplicationGatewayTimeouts;
    /**
     * Optional trusted client certificates for mutual authentication.
     */
    readonly trustedClientCertificate?: azapgw.ApplicationGatewayTrustedClientCertificate[];
    /**
     * Optional trusted root certificates for backend authentication.
     */
    readonly trustedRootCertificate?: azapgw.ApplicationGatewayTrustedRootCertificate[];
    /**
     * Optional URL path map for routing based on URL paths.
     */
    readonly urlPathMap?: azapgw.ApplicationGatewayUrlPathMap[];
    /**
     * Optional Web Application Firewall (WAF) configuration to provide enhanced security.
     */
    readonly wafConfiguration?: azapgw.ApplicationGatewayWafConfiguration;
}
export declare class Gateway extends AzureResource {
    readonly props: IGatewayProps;
    resourceGroup: ResourceGroup;
    id: string;
    /**
     * Constructs a new Azure Application Gateway.
     *
     * @param scope - The scope in which to define this construct.
     * @param id - The ID of this construct.
     * @param props - The properties for configuring the Azure Application Gateway. The properties include:
     *                - `name`: Required. Unique name for the Application Gateway within Azure.
     *                - `location`: Required. Azure Region for deployment.
     *                - `resourceGroup`: Optional. Reference to the resource group for deployment.
     *                - `skuTier`: Required. SKU tier of the Application Gateway (e.g., Standard, WAF).
     *                - `skuSize`: Required. Size of the SKU for the Application Gateway.
     *                - `capacity`: Required. Capacity (instance count) of the Application Gateway.
     *                - `backendAddressPools`: Required. Backend address pools for the Application Gateway.
     *                - `backendHttpSettings`: Required. Backend HTTP settings for the Application Gateway.
     *                - `httpListeners`: Required. HTTP listeners for the Application Gateway.
     *                - `requestRoutingRules`: Required. Request routing rules for the Application Gateway.
     *                - `publicIpAddress`: Optional. Public IP address for the frontend.
     *                - `privateIpAddress`: Optional. Private IP address for the frontend.
     *                - `privateIpAddressAllocation`: Optional. Allocation method for the private IP (Static, Dynamic).
     *                - `frontendPorts`: Optional. Frontend ports for the Application Gateway.
     *                - `subnet`: Optional. Subnet for the Application Gateway.
     *                - `enableHttp2`: Optional. Flag to enable HTTP2.
     *                - `fipsEnabled`: Optional. Flag to enable FIPS-compliant algorithms.
     *                - `firewallPolicyId`: Optional. ID of the firewall policy.
     *                - `forceFirewallPolicyAssociation`: Optional. Flag to enforce association of the firewall policy.
     *                - `tags`: Optional. Tags for resource management.
     *                - Additional optional properties as described in `IGatewayProps` interface.
     *
     * Example usage:
     * ```typescript
     * new Gateway(this, 'appGateway1', {
     *   name: 'gatewayEast',
     *   resourceGroup: resourceGroup,
        location: "eastus",
        skuTier: "Standard_v2",
        skuSize: "Standard_v2",
        capacity: 2,
        publicIpAddress: publicIp,
        subnet: subnet,
        backendAddressPools: [
          { name: "backend-address-pool-1" },
          {
            name: "backend-address-pool-2",
            ipAddresses: ["10.1.0.4", "10.1.0.5", "10.1.0.6"],
          },
        ],
        httpListeners: [
          {
            name: "http-listener",
            frontendPortName: "80",
            frontendIpConfigurationName: "Public-frontend-ip-configuration",
            protocol: "Http",
          },
        ],
        backendHttpSettings: [
          {
            name: "backend-http-setting",
            port: 80,
            protocol: "Http",
            requestTimeout: 20,
            cookieBasedAffinity: "Disabled",
          },
        ],
        requestRoutingRules: [
          {
            name: "request-routing-rule-1",
            httpListenerName: "http-listener",
            priority: 1,
            backendAddressPoolName: "backend-address-pool-1",
            backendHttpSettingsName: "backend-http-setting",
            ruleType: "Basic",
          },
        ],
     * });
     * ```
     */
    constructor(scope: Construct, id: string, props: IGatewayProps);
}
