"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const provider_1 = require("@cdktf/provider-azurerm/lib/provider");
const cdktf_1 = require("cdktf");
require("cdktf/lib/testing/adapters/jest");
const apgw = require("..");
const testing_1 = require("../../testing");
describe("Application Gateway With Defaults", () => {
    let stack;
    let fullSynthResult;
    beforeEach(() => {
        const app = cdktf_1.Testing.app();
        stack = new cdktf_1.TerraformStack(app, "test");
        new provider_1.AzurermProvider(stack, "azureFeature", { features: {} });
        new apgw.Gateway(stack, "testAzureApplicationGatewayDefaults2", {
            name: "application-gateway",
            location: "eastus",
            skuTier: "WAF_v2",
            skuSize: "WAF_v2",
            capacity: 2,
            backendAddressPools: [
                { name: "backend-address-pool-1" },
                {
                    name: "backend-address-pool-2",
                    ipAddresses: ["10.0.0.4", "10.0.0.5", "10.0.0.6"],
                },
            ],
            httpListeners: [
                {
                    name: "http-listener",
                    frontendPortName: "frontend-port",
                    frontendIpConfigurationName: "Public",
                    protocol: "Http",
                },
            ],
            backendHttpSettings: [
                {
                    name: "backend-http-setting",
                    port: 80,
                    protocol: "Http",
                    requestTimeout: 20,
                    cookieBasedAffinity: "Disabled",
                },
            ],
            requestRoutingRules: [
                {
                    name: "request-routing-rule-1",
                    httpListenerName: "http-listener",
                    backendAddressPoolName: "backend-address-pool-1",
                    backendHttpSettingsName: "backend-http-setting",
                    ruleType: "Basic",
                },
                {
                    name: "request-routing-rule-2",
                    httpListenerName: "http-listener",
                    backendAddressPoolName: "backend-address-pool-2",
                    backendHttpSettingsName: "backend-http-setting",
                    ruleType: "Basic",
                },
            ],
        });
        fullSynthResult = cdktf_1.Testing.fullSynth(stack); // Save the result for reuse
    });
    it("renders an Application Gateway with defaults and checks snapshot", () => {
        expect(cdktf_1.Testing.synth(stack)).toMatchSnapshot(); // Compare the already prepared stack
    });
    it("check if the produced terraform configuration is valid", () => {
        expect(fullSynthResult).toBeValidTerraform(); // Use the saved result
    });
    it("check if this can be planned", () => {
        (0, testing_1.TerraformPlan)(fullSynthResult); // Use the saved result
    });
});
//# sourceMappingURL=data:application/json;base64,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