import { ResourceGroup } from "@cdktf/provider-azurerm/lib/resource-group";
import { Construct } from "constructs";
import { AzureResource } from "../../core-azure/lib";
/**
 * Properties for the resource group
 */
export interface AppInsightsProps {
    /**
     * The Azure Region to deploy.
     */
    readonly location: string;
    /**
     * The name of the Application Insights resource.
     */
    readonly name: string;
    /**
     * An optional reference to the resource group in which to deploy the Application Insights.
     * If not provided, the Application Insights will be deployed in the default resource group.
     */
    readonly resourceGroup?: ResourceGroup;
    /**
     * The number of days of retention.
     * Possible values are 30, 60, 90, 120, 180, 270, 365, 550 or 730. Defaults to 90.
     * @default 90
     */
    readonly retentionInDays?: number;
    /**
     * The tags to assign to the Application Insights resource.
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * The Application type.
     */
    readonly applicationType: string;
    /**
     * The Application Insights daily data cap in GB.
     */
    readonly dailyDataCapInGb?: number;
    /**
     * The Application Insights daily data cap notifications disabled.
     */
    readonly dailyDataCapNotificationDisabled?: boolean;
    /**
     * The id of the Log Analytics Workspace.
     * @default - If no workspace id is provided, a new one will be created automatically
     * in the same resource group. The name will be the same as the Application Insights
     * resource with a "-la" suffix.
     */
    readonly workspaceId?: string;
}
export declare class AppInsights extends AzureResource {
    readonly props: AppInsightsProps;
    resourceGroup: ResourceGroup;
    id: string;
    private readonly instrumentationKey;
    /**
     * Constructs a new Azure Application Insights resource.
     *
     * @param scope - The scope in which to define this construct.
     * @param id - The ID of this construct.
     * @param props - The properties for configuring the Azure Application Insights. The properties include:
     *                - `name`: Required. Unique name for the Application Insights resource within Azure.
     *                - `location`: Required. Azure Region for deployment.
     *                - `resourceGroup`: Optional. Reference to the resource group for deployment.
     *                - `retentionInDays`: Optional. Number of days to retain data. Default is 90 days.
     *                - `tags`: Optional. Tags for resource management.
     *                - `applicationType`: Required. The type of application (e.g., web, other).
     *                - `dailyDataCapInGb`: Optional. Daily data cap in gigabytes.
     *                - `dailyDataCapNotificationDisabled`: Optional. Flag to disable notifications when the daily data cap is reached.
     *                - `workspaceId`: Optional. ID of the Log Analytics Workspace to associate with Application Insights. If not provided, a new workspace is created automatically.
     *
     * Example usage:
     * ```typescript
     * new AppInsights(this, 'myAppInsights', {
     *   name: 'myAppInsightsResource',
     *   location: 'West US',
     *   resourceGroup: resourceGroup,
     *   retentionInDays: 120,
     *   tags: {
     *     "environment": "production"
     *   },
     *   applicationType: 'web',
     *   dailyDataCapInGb: 10,
     *   dailyDataCapNotificationDisabled: true,
     *   workspaceId: 'existing-workspace-id'
     * });
     * ```
     */
    constructor(scope: Construct, id: string, props: AppInsightsProps);
    /**
     * Saves the Application Insights instrumentation key to an Azure Key Vault.
     *
     * This method creates a new secret in the specified Azure Key Vault with the
     * instrumentation key of the Application Insights resource. This enables secure storage
     * and management of the instrumentation key, facilitating secure access across various
     * Azure services.
     *
     * @param keyVaultId - The unique identifier of the Azure Key Vault where the secret will be stored.
     * @param keyVaultSecretName - The name of the secret within the Key Vault. Defaults to 'instrumentation-key'.
     *                             This name can be used to retrieve the secret in client applications.
     *
     * Example usage:
     * ```typescript
     * appInsightsInstance.saveIKeyToKeyVault('my-key-vault-id');
     * ```
     */
    saveIKeyToKeyVault(keyVaultId: string, keyVaultSecretName?: string): void;
    private setupLogAnalytics;
}
