"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppInsights = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const application_insights_1 = require("@cdktf/provider-azurerm/lib/application-insights");
const key_vault_secret_1 = require("@cdktf/provider-azurerm/lib/key-vault-secret");
const log_analytics_workspace_1 = require("@cdktf/provider-azurerm/lib/log-analytics-workspace");
const cdktf = require("cdktf");
const lib_1 = require("../../core-azure/lib");
class AppInsights extends lib_1.AzureResource {
    /**
     * Constructs a new Azure Application Insights resource.
     *
     * @param scope - The scope in which to define this construct.
     * @param id - The ID of this construct.
     * @param props - The properties for configuring the Azure Application Insights. The properties include:
     *                - `name`: Required. Unique name for the Application Insights resource within Azure.
     *                - `location`: Required. Azure Region for deployment.
     *                - `resourceGroup`: Optional. Reference to the resource group for deployment.
     *                - `retentionInDays`: Optional. Number of days to retain data. Default is 90 days.
     *                - `tags`: Optional. Tags for resource management.
     *                - `applicationType`: Required. The type of application (e.g., web, other).
     *                - `dailyDataCapInGb`: Optional. Daily data cap in gigabytes.
     *                - `dailyDataCapNotificationDisabled`: Optional. Flag to disable notifications when the daily data cap is reached.
     *                - `workspaceId`: Optional. ID of the Log Analytics Workspace to associate with Application Insights. If not provided, a new workspace is created automatically.
     *
     * Example usage:
     * ```typescript
     * new AppInsights(this, 'myAppInsights', {
     *   name: 'myAppInsightsResource',
     *   location: 'West US',
     *   resourceGroup: resourceGroup,
     *   retentionInDays: 120,
     *   tags: {
     *     "environment": "production"
     *   },
     *   applicationType: 'web',
     *   dailyDataCapInGb: 10,
     *   dailyDataCapNotificationDisabled: true,
     *   workspaceId: 'existing-workspace-id'
     * });
     * ```
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.props = props;
        this.resourceGroup = this.setupResourceGroup(props);
        const azurermApplicationInsightsAppinsights = new application_insights_1.ApplicationInsights(this, "appinsights", {
            location: props.location,
            name: props.name,
            resourceGroupName: this.resourceGroup.name,
            tags: props.tags,
            applicationType: props.applicationType,
            dailyDataCapInGb: props.dailyDataCapInGb,
            dailyDataCapNotificationsDisabled: props.dailyDataCapNotificationDisabled,
            retentionInDays: props.retentionInDays,
            workspaceId: this.setupLogAnalytics(props),
        });
        this.instrumentationKey =
            azurermApplicationInsightsAppinsights.instrumentationKey;
        this.id = azurermApplicationInsightsAppinsights.id;
        // Terraform Outputs
        const cdktfTerraformOutputAppiID = new cdktf.TerraformOutput(this, "id", {
            value: azurermApplicationInsightsAppinsights.id,
        });
        const cdktfTerraformOutputAppiName = new cdktf.TerraformOutput(this, "name", {
            value: azurermApplicationInsightsAppinsights.name,
        });
        const cdktfTerraformOutputAppiAppId = new cdktf.TerraformOutput(this, "app_id", {
            value: azurermApplicationInsightsAppinsights.appId,
        });
        const cdktfTerraformOutputAppiIKey = new cdktf.TerraformOutput(this, "instrumentation_key", {
            value: azurermApplicationInsightsAppinsights.instrumentationKey,
            sensitive: true,
        });
        const cdktfTerraformOutputAppiConnectStr = new cdktf.TerraformOutput(this, "connection_string", {
            value: azurermApplicationInsightsAppinsights.connectionString,
            sensitive: true,
        });
        /*This allows the Terraform resource name to match the original name. You can remove the call if you don't need them to match.*/
        cdktfTerraformOutputAppiID.overrideLogicalId("id");
        cdktfTerraformOutputAppiName.overrideLogicalId("name");
        cdktfTerraformOutputAppiAppId.overrideLogicalId("app_id");
        cdktfTerraformOutputAppiIKey.overrideLogicalId("instrumentation_key");
        cdktfTerraformOutputAppiConnectStr.overrideLogicalId("connection_string");
    }
    /**
     * Saves the Application Insights instrumentation key to an Azure Key Vault.
     *
     * This method creates a new secret in the specified Azure Key Vault with the
     * instrumentation key of the Application Insights resource. This enables secure storage
     * and management of the instrumentation key, facilitating secure access across various
     * Azure services.
     *
     * @param keyVaultId - The unique identifier of the Azure Key Vault where the secret will be stored.
     * @param keyVaultSecretName - The name of the secret within the Key Vault. Defaults to 'instrumentation-key'.
     *                             This name can be used to retrieve the secret in client applications.
     *
     * Example usage:
     * ```typescript
     * appInsightsInstance.saveIKeyToKeyVault('my-key-vault-id');
     * ```
     */
    saveIKeyToKeyVault(keyVaultId, keyVaultSecretName = "instrumentation-key") {
        new key_vault_secret_1.KeyVaultSecret(this, keyVaultSecretName, {
            keyVaultId: keyVaultId,
            name: keyVaultSecretName,
            value: this.instrumentationKey,
        });
    }
    setupLogAnalytics(props) {
        if (cdktf.canInspect(props.workspaceId)) {
            // Use the provided Log Analytics Workspace
            return props.workspaceId;
        }
        else {
            // Create a new Log Analytics Workspace
            const logAnalyticsWorkspace = new log_analytics_workspace_1.LogAnalyticsWorkspace(this, "log_analytics", {
                location: props.location,
                name: `${props.name}-la`,
                resourceGroupName: this.resourceGroup.name,
                sku: "PerGB2018",
                retentionInDays: props.retentionInDays,
                tags: props.tags,
            });
            return logAnalyticsWorkspace.id;
        }
    }
}
exports.AppInsights = AppInsights;
_a = JSII_RTTI_SYMBOL_1;
AppInsights[_a] = { fqn: "@microsoft/terraform-cdk-constructs.azure_applicationinsights.AppInsights", version: "0.0.3-pre.12" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXBwaW5zaWdodHMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvYXp1cmUtYXBwbGljYXRpb25pbnNpZ2h0cy9saWIvYXBwaW5zaWdodHMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSwyRkFBdUY7QUFDdkYsbUZBQThFO0FBQzlFLGlHQUE0RjtBQUU1RiwrQkFBK0I7QUFFL0IsOENBQXFEO0FBcURyRCxNQUFhLFdBQVksU0FBUSxtQkFBYTtJQU01Qzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7T0FnQ0c7SUFFSCxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQXVCO1FBQy9ELEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUM7UUFDbkIsSUFBSSxDQUFDLGFBQWEsR0FBRyxJQUFJLENBQUMsa0JBQWtCLENBQUMsS0FBSyxDQUFDLENBQUM7UUFFcEQsTUFBTSxxQ0FBcUMsR0FBRyxJQUFJLDBDQUFtQixDQUNuRSxJQUFJLEVBQ0osYUFBYSxFQUNiO1lBQ0UsUUFBUSxFQUFFLEtBQUssQ0FBQyxRQUFRO1lBQ3hCLElBQUksRUFBRSxLQUFLLENBQUMsSUFBSTtZQUNoQixpQkFBaUIsRUFBRSxJQUFJLENBQUMsYUFBYSxDQUFDLElBQUk7WUFDMUMsSUFBSSxFQUFFLEtBQUssQ0FBQyxJQUFJO1lBQ2hCLGVBQWUsRUFBRSxLQUFLLENBQUMsZUFBZTtZQUN0QyxnQkFBZ0IsRUFBRSxLQUFLLENBQUMsZ0JBQWdCO1lBQ3hDLGlDQUFpQyxFQUMvQixLQUFLLENBQUMsZ0NBQWdDO1lBQ3hDLGVBQWUsRUFBRSxLQUFLLENBQUMsZUFBZTtZQUN0QyxXQUFXLEVBQUUsSUFBSSxDQUFDLGlCQUFpQixDQUFDLEtBQUssQ0FBQztTQUMzQyxDQUNGLENBQUM7UUFFRixJQUFJLENBQUMsa0JBQWtCO1lBQ3JCLHFDQUFxQyxDQUFDLGtCQUFrQixDQUFDO1FBQzNELElBQUksQ0FBQyxFQUFFLEdBQUcscUNBQXFDLENBQUMsRUFBRSxDQUFDO1FBRW5ELG9CQUFvQjtRQUNwQixNQUFNLDBCQUEwQixHQUFHLElBQUksS0FBSyxDQUFDLGVBQWUsQ0FBQyxJQUFJLEVBQUUsSUFBSSxFQUFFO1lBQ3ZFLEtBQUssRUFBRSxxQ0FBcUMsQ0FBQyxFQUFFO1NBQ2hELENBQUMsQ0FBQztRQUNILE1BQU0sNEJBQTRCLEdBQUcsSUFBSSxLQUFLLENBQUMsZUFBZSxDQUM1RCxJQUFJLEVBQ0osTUFBTSxFQUNOO1lBQ0UsS0FBSyxFQUFFLHFDQUFxQyxDQUFDLElBQUk7U0FDbEQsQ0FDRixDQUFDO1FBQ0YsTUFBTSw2QkFBNkIsR0FBRyxJQUFJLEtBQUssQ0FBQyxlQUFlLENBQzdELElBQUksRUFDSixRQUFRLEVBQ1I7WUFDRSxLQUFLLEVBQUUscUNBQXFDLENBQUMsS0FBSztTQUNuRCxDQUNGLENBQUM7UUFDRixNQUFNLDRCQUE0QixHQUFHLElBQUksS0FBSyxDQUFDLGVBQWUsQ0FDNUQsSUFBSSxFQUNKLHFCQUFxQixFQUNyQjtZQUNFLEtBQUssRUFBRSxxQ0FBcUMsQ0FBQyxrQkFBa0I7WUFDL0QsU0FBUyxFQUFFLElBQUk7U0FDaEIsQ0FDRixDQUFDO1FBQ0YsTUFBTSxrQ0FBa0MsR0FBRyxJQUFJLEtBQUssQ0FBQyxlQUFlLENBQ2xFLElBQUksRUFDSixtQkFBbUIsRUFDbkI7WUFDRSxLQUFLLEVBQUUscUNBQXFDLENBQUMsZ0JBQWdCO1lBQzdELFNBQVMsRUFBRSxJQUFJO1NBQ2hCLENBQ0YsQ0FBQztRQUVGLGdJQUFnSTtRQUNoSSwwQkFBMEIsQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUNuRCw0QkFBNEIsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLENBQUMsQ0FBQztRQUN2RCw2QkFBNkIsQ0FBQyxpQkFBaUIsQ0FBQyxRQUFRLENBQUMsQ0FBQztRQUMxRCw0QkFBNEIsQ0FBQyxpQkFBaUIsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO1FBQ3RFLGtDQUFrQyxDQUFDLGlCQUFpQixDQUFDLG1CQUFtQixDQUFDLENBQUM7SUFDNUUsQ0FBQztJQUVEOzs7Ozs7Ozs7Ozs7Ozs7O09BZ0JHO0lBQ0ksa0JBQWtCLENBQ3ZCLFVBQWtCLEVBQ2xCLHFCQUE2QixxQkFBcUI7UUFFbEQsSUFBSSxpQ0FBYyxDQUFDLElBQUksRUFBRSxrQkFBa0IsRUFBRTtZQUMzQyxVQUFVLEVBQUUsVUFBVTtZQUN0QixJQUFJLEVBQUUsa0JBQWtCO1lBQ3hCLEtBQUssRUFBRSxJQUFJLENBQUMsa0JBQWtCO1NBQy9CLENBQUMsQ0FBQztJQUNMLENBQUM7SUFFTyxpQkFBaUIsQ0FBQyxLQUF1QjtRQUMvQyxJQUFJLEtBQUssQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDLFdBQVcsQ0FBQyxFQUFFO1lBQ3ZDLDJDQUEyQztZQUMzQyxPQUFPLEtBQUssQ0FBQyxXQUFZLENBQUM7U0FDM0I7YUFBTTtZQUNMLHVDQUF1QztZQUN2QyxNQUFNLHFCQUFxQixHQUFHLElBQUksK0NBQXFCLENBQ3JELElBQUksRUFDSixlQUFlLEVBQ2Y7Z0JBQ0UsUUFBUSxFQUFFLEtBQUssQ0FBQyxRQUFRO2dCQUN4QixJQUFJLEVBQUUsR0FBRyxLQUFLLENBQUMsSUFBSSxLQUFLO2dCQUN4QixpQkFBaUIsRUFBRSxJQUFJLENBQUMsYUFBYSxDQUFDLElBQUk7Z0JBQzFDLEdBQUcsRUFBRSxXQUFXO2dCQUNoQixlQUFlLEVBQUUsS0FBSyxDQUFDLGVBQWU7Z0JBQ3RDLElBQUksRUFBRSxLQUFLLENBQUMsSUFBSTthQUNqQixDQUNGLENBQUM7WUFDRixPQUFPLHFCQUFxQixDQUFDLEVBQUUsQ0FBQztTQUNqQztJQUNILENBQUM7O0FBOUpILGtDQStKQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEFwcGxpY2F0aW9uSW5zaWdodHMgfSBmcm9tIFwiQGNka3RmL3Byb3ZpZGVyLWF6dXJlcm0vbGliL2FwcGxpY2F0aW9uLWluc2lnaHRzXCI7XG5pbXBvcnQgeyBLZXlWYXVsdFNlY3JldCB9IGZyb20gXCJAY2RrdGYvcHJvdmlkZXItYXp1cmVybS9saWIva2V5LXZhdWx0LXNlY3JldFwiO1xuaW1wb3J0IHsgTG9nQW5hbHl0aWNzV29ya3NwYWNlIH0gZnJvbSBcIkBjZGt0Zi9wcm92aWRlci1henVyZXJtL2xpYi9sb2ctYW5hbHl0aWNzLXdvcmtzcGFjZVwiO1xuaW1wb3J0IHsgUmVzb3VyY2VHcm91cCB9IGZyb20gXCJAY2RrdGYvcHJvdmlkZXItYXp1cmVybS9saWIvcmVzb3VyY2UtZ3JvdXBcIjtcbmltcG9ydCAqIGFzIGNka3RmIGZyb20gXCJjZGt0ZlwiO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSBcImNvbnN0cnVjdHNcIjtcbmltcG9ydCB7IEF6dXJlUmVzb3VyY2UgfSBmcm9tIFwiLi4vLi4vY29yZS1henVyZS9saWJcIjtcblxuLy8gQ29uc3RydWN0XG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIHRoZSByZXNvdXJjZSBncm91cFxuICovXG5cbmV4cG9ydCBpbnRlcmZhY2UgQXBwSW5zaWdodHNQcm9wcyB7XG4gIC8qKlxuICAgKiBUaGUgQXp1cmUgUmVnaW9uIHRvIGRlcGxveS5cbiAgICovXG4gIHJlYWRvbmx5IGxvY2F0aW9uOiBzdHJpbmc7XG4gIC8qKlxuICAgKiBUaGUgbmFtZSBvZiB0aGUgQXBwbGljYXRpb24gSW5zaWdodHMgcmVzb3VyY2UuXG4gICAqL1xuICByZWFkb25seSBuYW1lOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIEFuIG9wdGlvbmFsIHJlZmVyZW5jZSB0byB0aGUgcmVzb3VyY2UgZ3JvdXAgaW4gd2hpY2ggdG8gZGVwbG95IHRoZSBBcHBsaWNhdGlvbiBJbnNpZ2h0cy5cbiAgICogSWYgbm90IHByb3ZpZGVkLCB0aGUgQXBwbGljYXRpb24gSW5zaWdodHMgd2lsbCBiZSBkZXBsb3llZCBpbiB0aGUgZGVmYXVsdCByZXNvdXJjZSBncm91cC5cbiAgICovXG4gIHJlYWRvbmx5IHJlc291cmNlR3JvdXA/OiBSZXNvdXJjZUdyb3VwO1xuICAvKipcbiAgICogVGhlIG51bWJlciBvZiBkYXlzIG9mIHJldGVudGlvbi5cbiAgICogUG9zc2libGUgdmFsdWVzIGFyZSAzMCwgNjAsIDkwLCAxMjAsIDE4MCwgMjcwLCAzNjUsIDU1MCBvciA3MzAuIERlZmF1bHRzIHRvIDkwLlxuICAgKiBAZGVmYXVsdCA5MFxuICAgKi9cbiAgcmVhZG9ubHkgcmV0ZW50aW9uSW5EYXlzPzogbnVtYmVyO1xuICAvKipcbiAgICogVGhlIHRhZ3MgdG8gYXNzaWduIHRvIHRoZSBBcHBsaWNhdGlvbiBJbnNpZ2h0cyByZXNvdXJjZS5cbiAgICovXG4gIHJlYWRvbmx5IHRhZ3M/OiB7IFtrZXk6IHN0cmluZ106IHN0cmluZyB9O1xuICAvKipcbiAgICogVGhlIEFwcGxpY2F0aW9uIHR5cGUuXG4gICAqL1xuICByZWFkb25seSBhcHBsaWNhdGlvblR5cGU6IHN0cmluZztcbiAgLyoqXG4gICAqIFRoZSBBcHBsaWNhdGlvbiBJbnNpZ2h0cyBkYWlseSBkYXRhIGNhcCBpbiBHQi5cbiAgICovXG4gIHJlYWRvbmx5IGRhaWx5RGF0YUNhcEluR2I/OiBudW1iZXI7XG4gIC8qKlxuICAgKiBUaGUgQXBwbGljYXRpb24gSW5zaWdodHMgZGFpbHkgZGF0YSBjYXAgbm90aWZpY2F0aW9ucyBkaXNhYmxlZC5cbiAgICovXG4gIHJlYWRvbmx5IGRhaWx5RGF0YUNhcE5vdGlmaWNhdGlvbkRpc2FibGVkPzogYm9vbGVhbjtcbiAgLyoqXG4gICAqIFRoZSBpZCBvZiB0aGUgTG9nIEFuYWx5dGljcyBXb3Jrc3BhY2UuXG4gICAqIEBkZWZhdWx0IC0gSWYgbm8gd29ya3NwYWNlIGlkIGlzIHByb3ZpZGVkLCBhIG5ldyBvbmUgd2lsbCBiZSBjcmVhdGVkIGF1dG9tYXRpY2FsbHlcbiAgICogaW4gdGhlIHNhbWUgcmVzb3VyY2UgZ3JvdXAuIFRoZSBuYW1lIHdpbGwgYmUgdGhlIHNhbWUgYXMgdGhlIEFwcGxpY2F0aW9uIEluc2lnaHRzXG4gICAqIHJlc291cmNlIHdpdGggYSBcIi1sYVwiIHN1ZmZpeC5cbiAgICovXG4gIHJlYWRvbmx5IHdvcmtzcGFjZUlkPzogc3RyaW5nO1xufVxuXG5leHBvcnQgY2xhc3MgQXBwSW5zaWdodHMgZXh0ZW5kcyBBenVyZVJlc291cmNlIHtcbiAgcmVhZG9ubHkgcHJvcHM6IEFwcEluc2lnaHRzUHJvcHM7XG4gIHB1YmxpYyByZXNvdXJjZUdyb3VwOiBSZXNvdXJjZUdyb3VwO1xuICBwdWJsaWMgaWQ6IHN0cmluZztcbiAgcHJpdmF0ZSByZWFkb25seSBpbnN0cnVtZW50YXRpb25LZXk6IHN0cmluZztcblxuICAvKipcbiAgICogQ29uc3RydWN0cyBhIG5ldyBBenVyZSBBcHBsaWNhdGlvbiBJbnNpZ2h0cyByZXNvdXJjZS5cbiAgICpcbiAgICogQHBhcmFtIHNjb3BlIC0gVGhlIHNjb3BlIGluIHdoaWNoIHRvIGRlZmluZSB0aGlzIGNvbnN0cnVjdC5cbiAgICogQHBhcmFtIGlkIC0gVGhlIElEIG9mIHRoaXMgY29uc3RydWN0LlxuICAgKiBAcGFyYW0gcHJvcHMgLSBUaGUgcHJvcGVydGllcyBmb3IgY29uZmlndXJpbmcgdGhlIEF6dXJlIEFwcGxpY2F0aW9uIEluc2lnaHRzLiBUaGUgcHJvcGVydGllcyBpbmNsdWRlOlxuICAgKiAgICAgICAgICAgICAgICAtIGBuYW1lYDogUmVxdWlyZWQuIFVuaXF1ZSBuYW1lIGZvciB0aGUgQXBwbGljYXRpb24gSW5zaWdodHMgcmVzb3VyY2Ugd2l0aGluIEF6dXJlLlxuICAgKiAgICAgICAgICAgICAgICAtIGBsb2NhdGlvbmA6IFJlcXVpcmVkLiBBenVyZSBSZWdpb24gZm9yIGRlcGxveW1lbnQuXG4gICAqICAgICAgICAgICAgICAgIC0gYHJlc291cmNlR3JvdXBgOiBPcHRpb25hbC4gUmVmZXJlbmNlIHRvIHRoZSByZXNvdXJjZSBncm91cCBmb3IgZGVwbG95bWVudC5cbiAgICogICAgICAgICAgICAgICAgLSBgcmV0ZW50aW9uSW5EYXlzYDogT3B0aW9uYWwuIE51bWJlciBvZiBkYXlzIHRvIHJldGFpbiBkYXRhLiBEZWZhdWx0IGlzIDkwIGRheXMuXG4gICAqICAgICAgICAgICAgICAgIC0gYHRhZ3NgOiBPcHRpb25hbC4gVGFncyBmb3IgcmVzb3VyY2UgbWFuYWdlbWVudC5cbiAgICogICAgICAgICAgICAgICAgLSBgYXBwbGljYXRpb25UeXBlYDogUmVxdWlyZWQuIFRoZSB0eXBlIG9mIGFwcGxpY2F0aW9uIChlLmcuLCB3ZWIsIG90aGVyKS5cbiAgICogICAgICAgICAgICAgICAgLSBgZGFpbHlEYXRhQ2FwSW5HYmA6IE9wdGlvbmFsLiBEYWlseSBkYXRhIGNhcCBpbiBnaWdhYnl0ZXMuXG4gICAqICAgICAgICAgICAgICAgIC0gYGRhaWx5RGF0YUNhcE5vdGlmaWNhdGlvbkRpc2FibGVkYDogT3B0aW9uYWwuIEZsYWcgdG8gZGlzYWJsZSBub3RpZmljYXRpb25zIHdoZW4gdGhlIGRhaWx5IGRhdGEgY2FwIGlzIHJlYWNoZWQuXG4gICAqICAgICAgICAgICAgICAgIC0gYHdvcmtzcGFjZUlkYDogT3B0aW9uYWwuIElEIG9mIHRoZSBMb2cgQW5hbHl0aWNzIFdvcmtzcGFjZSB0byBhc3NvY2lhdGUgd2l0aCBBcHBsaWNhdGlvbiBJbnNpZ2h0cy4gSWYgbm90IHByb3ZpZGVkLCBhIG5ldyB3b3Jrc3BhY2UgaXMgY3JlYXRlZCBhdXRvbWF0aWNhbGx5LlxuICAgKlxuICAgKiBFeGFtcGxlIHVzYWdlOlxuICAgKiBgYGB0eXBlc2NyaXB0XG4gICAqIG5ldyBBcHBJbnNpZ2h0cyh0aGlzLCAnbXlBcHBJbnNpZ2h0cycsIHtcbiAgICogICBuYW1lOiAnbXlBcHBJbnNpZ2h0c1Jlc291cmNlJyxcbiAgICogICBsb2NhdGlvbjogJ1dlc3QgVVMnLFxuICAgKiAgIHJlc291cmNlR3JvdXA6IHJlc291cmNlR3JvdXAsXG4gICAqICAgcmV0ZW50aW9uSW5EYXlzOiAxMjAsXG4gICAqICAgdGFnczoge1xuICAgKiAgICAgXCJlbnZpcm9ubWVudFwiOiBcInByb2R1Y3Rpb25cIlxuICAgKiAgIH0sXG4gICAqICAgYXBwbGljYXRpb25UeXBlOiAnd2ViJyxcbiAgICogICBkYWlseURhdGFDYXBJbkdiOiAxMCxcbiAgICogICBkYWlseURhdGFDYXBOb3RpZmljYXRpb25EaXNhYmxlZDogdHJ1ZSxcbiAgICogICB3b3Jrc3BhY2VJZDogJ2V4aXN0aW5nLXdvcmtzcGFjZS1pZCdcbiAgICogfSk7XG4gICAqIGBgYFxuICAgKi9cblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogQXBwSW5zaWdodHNQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICB0aGlzLnByb3BzID0gcHJvcHM7XG4gICAgdGhpcy5yZXNvdXJjZUdyb3VwID0gdGhpcy5zZXR1cFJlc291cmNlR3JvdXAocHJvcHMpO1xuXG4gICAgY29uc3QgYXp1cmVybUFwcGxpY2F0aW9uSW5zaWdodHNBcHBpbnNpZ2h0cyA9IG5ldyBBcHBsaWNhdGlvbkluc2lnaHRzKFxuICAgICAgdGhpcyxcbiAgICAgIFwiYXBwaW5zaWdodHNcIixcbiAgICAgIHtcbiAgICAgICAgbG9jYXRpb246IHByb3BzLmxvY2F0aW9uLFxuICAgICAgICBuYW1lOiBwcm9wcy5uYW1lLFxuICAgICAgICByZXNvdXJjZUdyb3VwTmFtZTogdGhpcy5yZXNvdXJjZUdyb3VwLm5hbWUsXG4gICAgICAgIHRhZ3M6IHByb3BzLnRhZ3MsXG4gICAgICAgIGFwcGxpY2F0aW9uVHlwZTogcHJvcHMuYXBwbGljYXRpb25UeXBlLFxuICAgICAgICBkYWlseURhdGFDYXBJbkdiOiBwcm9wcy5kYWlseURhdGFDYXBJbkdiLFxuICAgICAgICBkYWlseURhdGFDYXBOb3RpZmljYXRpb25zRGlzYWJsZWQ6XG4gICAgICAgICAgcHJvcHMuZGFpbHlEYXRhQ2FwTm90aWZpY2F0aW9uRGlzYWJsZWQsXG4gICAgICAgIHJldGVudGlvbkluRGF5czogcHJvcHMucmV0ZW50aW9uSW5EYXlzLFxuICAgICAgICB3b3Jrc3BhY2VJZDogdGhpcy5zZXR1cExvZ0FuYWx5dGljcyhwcm9wcyksXG4gICAgICB9LFxuICAgICk7XG5cbiAgICB0aGlzLmluc3RydW1lbnRhdGlvbktleSA9XG4gICAgICBhenVyZXJtQXBwbGljYXRpb25JbnNpZ2h0c0FwcGluc2lnaHRzLmluc3RydW1lbnRhdGlvbktleTtcbiAgICB0aGlzLmlkID0gYXp1cmVybUFwcGxpY2F0aW9uSW5zaWdodHNBcHBpbnNpZ2h0cy5pZDtcblxuICAgIC8vIFRlcnJhZm9ybSBPdXRwdXRzXG4gICAgY29uc3QgY2RrdGZUZXJyYWZvcm1PdXRwdXRBcHBpSUQgPSBuZXcgY2RrdGYuVGVycmFmb3JtT3V0cHV0KHRoaXMsIFwiaWRcIiwge1xuICAgICAgdmFsdWU6IGF6dXJlcm1BcHBsaWNhdGlvbkluc2lnaHRzQXBwaW5zaWdodHMuaWQsXG4gICAgfSk7XG4gICAgY29uc3QgY2RrdGZUZXJyYWZvcm1PdXRwdXRBcHBpTmFtZSA9IG5ldyBjZGt0Zi5UZXJyYWZvcm1PdXRwdXQoXG4gICAgICB0aGlzLFxuICAgICAgXCJuYW1lXCIsXG4gICAgICB7XG4gICAgICAgIHZhbHVlOiBhenVyZXJtQXBwbGljYXRpb25JbnNpZ2h0c0FwcGluc2lnaHRzLm5hbWUsXG4gICAgICB9LFxuICAgICk7XG4gICAgY29uc3QgY2RrdGZUZXJyYWZvcm1PdXRwdXRBcHBpQXBwSWQgPSBuZXcgY2RrdGYuVGVycmFmb3JtT3V0cHV0KFxuICAgICAgdGhpcyxcbiAgICAgIFwiYXBwX2lkXCIsXG4gICAgICB7XG4gICAgICAgIHZhbHVlOiBhenVyZXJtQXBwbGljYXRpb25JbnNpZ2h0c0FwcGluc2lnaHRzLmFwcElkLFxuICAgICAgfSxcbiAgICApO1xuICAgIGNvbnN0IGNka3RmVGVycmFmb3JtT3V0cHV0QXBwaUlLZXkgPSBuZXcgY2RrdGYuVGVycmFmb3JtT3V0cHV0KFxuICAgICAgdGhpcyxcbiAgICAgIFwiaW5zdHJ1bWVudGF0aW9uX2tleVwiLFxuICAgICAge1xuICAgICAgICB2YWx1ZTogYXp1cmVybUFwcGxpY2F0aW9uSW5zaWdodHNBcHBpbnNpZ2h0cy5pbnN0cnVtZW50YXRpb25LZXksXG4gICAgICAgIHNlbnNpdGl2ZTogdHJ1ZSxcbiAgICAgIH0sXG4gICAgKTtcbiAgICBjb25zdCBjZGt0ZlRlcnJhZm9ybU91dHB1dEFwcGlDb25uZWN0U3RyID0gbmV3IGNka3RmLlRlcnJhZm9ybU91dHB1dChcbiAgICAgIHRoaXMsXG4gICAgICBcImNvbm5lY3Rpb25fc3RyaW5nXCIsXG4gICAgICB7XG4gICAgICAgIHZhbHVlOiBhenVyZXJtQXBwbGljYXRpb25JbnNpZ2h0c0FwcGluc2lnaHRzLmNvbm5lY3Rpb25TdHJpbmcsXG4gICAgICAgIHNlbnNpdGl2ZTogdHJ1ZSxcbiAgICAgIH0sXG4gICAgKTtcblxuICAgIC8qVGhpcyBhbGxvd3MgdGhlIFRlcnJhZm9ybSByZXNvdXJjZSBuYW1lIHRvIG1hdGNoIHRoZSBvcmlnaW5hbCBuYW1lLiBZb3UgY2FuIHJlbW92ZSB0aGUgY2FsbCBpZiB5b3UgZG9uJ3QgbmVlZCB0aGVtIHRvIG1hdGNoLiovXG4gICAgY2RrdGZUZXJyYWZvcm1PdXRwdXRBcHBpSUQub3ZlcnJpZGVMb2dpY2FsSWQoXCJpZFwiKTtcbiAgICBjZGt0ZlRlcnJhZm9ybU91dHB1dEFwcGlOYW1lLm92ZXJyaWRlTG9naWNhbElkKFwibmFtZVwiKTtcbiAgICBjZGt0ZlRlcnJhZm9ybU91dHB1dEFwcGlBcHBJZC5vdmVycmlkZUxvZ2ljYWxJZChcImFwcF9pZFwiKTtcbiAgICBjZGt0ZlRlcnJhZm9ybU91dHB1dEFwcGlJS2V5Lm92ZXJyaWRlTG9naWNhbElkKFwiaW5zdHJ1bWVudGF0aW9uX2tleVwiKTtcbiAgICBjZGt0ZlRlcnJhZm9ybU91dHB1dEFwcGlDb25uZWN0U3RyLm92ZXJyaWRlTG9naWNhbElkKFwiY29ubmVjdGlvbl9zdHJpbmdcIik7XG4gIH1cblxuICAvKipcbiAgICogU2F2ZXMgdGhlIEFwcGxpY2F0aW9uIEluc2lnaHRzIGluc3RydW1lbnRhdGlvbiBrZXkgdG8gYW4gQXp1cmUgS2V5IFZhdWx0LlxuICAgKlxuICAgKiBUaGlzIG1ldGhvZCBjcmVhdGVzIGEgbmV3IHNlY3JldCBpbiB0aGUgc3BlY2lmaWVkIEF6dXJlIEtleSBWYXVsdCB3aXRoIHRoZVxuICAgKiBpbnN0cnVtZW50YXRpb24ga2V5IG9mIHRoZSBBcHBsaWNhdGlvbiBJbnNpZ2h0cyByZXNvdXJjZS4gVGhpcyBlbmFibGVzIHNlY3VyZSBzdG9yYWdlXG4gICAqIGFuZCBtYW5hZ2VtZW50IG9mIHRoZSBpbnN0cnVtZW50YXRpb24ga2V5LCBmYWNpbGl0YXRpbmcgc2VjdXJlIGFjY2VzcyBhY3Jvc3MgdmFyaW91c1xuICAgKiBBenVyZSBzZXJ2aWNlcy5cbiAgICpcbiAgICogQHBhcmFtIGtleVZhdWx0SWQgLSBUaGUgdW5pcXVlIGlkZW50aWZpZXIgb2YgdGhlIEF6dXJlIEtleSBWYXVsdCB3aGVyZSB0aGUgc2VjcmV0IHdpbGwgYmUgc3RvcmVkLlxuICAgKiBAcGFyYW0ga2V5VmF1bHRTZWNyZXROYW1lIC0gVGhlIG5hbWUgb2YgdGhlIHNlY3JldCB3aXRoaW4gdGhlIEtleSBWYXVsdC4gRGVmYXVsdHMgdG8gJ2luc3RydW1lbnRhdGlvbi1rZXknLlxuICAgKiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgVGhpcyBuYW1lIGNhbiBiZSB1c2VkIHRvIHJldHJpZXZlIHRoZSBzZWNyZXQgaW4gY2xpZW50IGFwcGxpY2F0aW9ucy5cbiAgICpcbiAgICogRXhhbXBsZSB1c2FnZTpcbiAgICogYGBgdHlwZXNjcmlwdFxuICAgKiBhcHBJbnNpZ2h0c0luc3RhbmNlLnNhdmVJS2V5VG9LZXlWYXVsdCgnbXkta2V5LXZhdWx0LWlkJyk7XG4gICAqIGBgYFxuICAgKi9cbiAgcHVibGljIHNhdmVJS2V5VG9LZXlWYXVsdChcbiAgICBrZXlWYXVsdElkOiBzdHJpbmcsXG4gICAga2V5VmF1bHRTZWNyZXROYW1lOiBzdHJpbmcgPSBcImluc3RydW1lbnRhdGlvbi1rZXlcIixcbiAgKSB7XG4gICAgbmV3IEtleVZhdWx0U2VjcmV0KHRoaXMsIGtleVZhdWx0U2VjcmV0TmFtZSwge1xuICAgICAga2V5VmF1bHRJZDoga2V5VmF1bHRJZCxcbiAgICAgIG5hbWU6IGtleVZhdWx0U2VjcmV0TmFtZSxcbiAgICAgIHZhbHVlOiB0aGlzLmluc3RydW1lbnRhdGlvbktleSxcbiAgICB9KTtcbiAgfVxuXG4gIHByaXZhdGUgc2V0dXBMb2dBbmFseXRpY3MocHJvcHM6IEFwcEluc2lnaHRzUHJvcHMpOiBzdHJpbmcge1xuICAgIGlmIChjZGt0Zi5jYW5JbnNwZWN0KHByb3BzLndvcmtzcGFjZUlkKSkge1xuICAgICAgLy8gVXNlIHRoZSBwcm92aWRlZCBMb2cgQW5hbHl0aWNzIFdvcmtzcGFjZVxuICAgICAgcmV0dXJuIHByb3BzLndvcmtzcGFjZUlkITtcbiAgICB9IGVsc2Uge1xuICAgICAgLy8gQ3JlYXRlIGEgbmV3IExvZyBBbmFseXRpY3MgV29ya3NwYWNlXG4gICAgICBjb25zdCBsb2dBbmFseXRpY3NXb3Jrc3BhY2UgPSBuZXcgTG9nQW5hbHl0aWNzV29ya3NwYWNlKFxuICAgICAgICB0aGlzLFxuICAgICAgICBcImxvZ19hbmFseXRpY3NcIixcbiAgICAgICAge1xuICAgICAgICAgIGxvY2F0aW9uOiBwcm9wcy5sb2NhdGlvbixcbiAgICAgICAgICBuYW1lOiBgJHtwcm9wcy5uYW1lfS1sYWAsXG4gICAgICAgICAgcmVzb3VyY2VHcm91cE5hbWU6IHRoaXMucmVzb3VyY2VHcm91cC5uYW1lLFxuICAgICAgICAgIHNrdTogXCJQZXJHQjIwMThcIixcbiAgICAgICAgICByZXRlbnRpb25JbkRheXM6IHByb3BzLnJldGVudGlvbkluRGF5cyxcbiAgICAgICAgICB0YWdzOiBwcm9wcy50YWdzLFxuICAgICAgICB9LFxuICAgICAgKTtcbiAgICAgIHJldHVybiBsb2dBbmFseXRpY3NXb3Jrc3BhY2UuaWQ7XG4gICAgfVxuICB9XG59XG4iXX0=