"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Registry = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const container_registry_1 = require("@cdktf/provider-azurerm/lib/container-registry");
const cdktf = require("cdktf");
const lib_1 = require("../../core-azure/lib");
class Registry extends lib_1.AzureResource {
    /**
     * Constructs a new Azure Container Registry (ACR).
     *
     * This class creates an Azure Container Registry instance, which is a managed Docker registry service based on the Docker Registry 2.0 specification.
     * This service enables you to store and manage container images across all types of Azure deployments, you can also use it to build, store, and manage images for all types of container deployments.
     *
     * @param scope - The scope in which to define this construct, typically used for managing lifecycles and creation order.
     * @param id - The unique identifier for this construct instance.
     * @param props - The properties for configuring the Azure Container Registry. The properties include:
     *                - `location`: Required. The Azure region where the registry will be deployed.
     *                - `name`: Required. The name of the Container Registry.
     *                - `resourceGroup`: Optional. Reference to the resource group for deployment.
     *                - `sku`: Optional. The SKU of the Container Registry (e.g., Basic, Standard, Premium). Determines the features available.
     *                - `tags`: Optional. Tags for resource management.
     *                - `adminEnabled`: Optional. Specifies whether the admin user is enabled for the registry. Defaults to false if not set.
     *                - `geoReplicationLocations`: Optional. Specifies additional Azure regions where the registry should be geo-replicated.
     *
     * Example usage:
     * ```typescript
     * new Registry(this, 'myRegistry', {
     *   location: 'West US',
     *   name: 'myContainerRegistry',
     *   resourceGroup: resourceGroup,
     *   sku: 'Premium',
     *   adminEnabled: true,
     *   geoReplicationLocations: ['East US', 'West Europe']
     * });
     * ```
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.props = props;
        this.resourceGroup = this.setupResourceGroup(props);
        // Provide default values
        const sku = props.sku ?? "Basic";
        const admin_enabled = props.adminEnabled ?? false;
        const georeplication_locations = props.geoReplicationLocations ?? [];
        const azurermContainerRegistry = new container_registry_1.ContainerRegistry(this, "acr", {
            location: props.location,
            name: props.name,
            resourceGroupName: this.resourceGroup.name,
            sku: sku,
            tags: props.tags,
            adminEnabled: admin_enabled,
            georeplications: georeplication_locations,
        });
        this.id = azurermContainerRegistry.id;
        // Terraform Outputs
        const cdktfTerraformOutputACRid = new cdktf.TerraformOutput(this, "id", {
            value: azurermContainerRegistry.id,
        });
        const cdktfTerraformOutputACRName = new cdktf.TerraformOutput(this, "container_registry_name", {
            value: azurermContainerRegistry.name,
        });
        const cdktfTerraformOutputACRloginserver = new cdktf.TerraformOutput(this, "login_server", {
            value: azurermContainerRegistry.loginServer,
        });
        /*This allows the Terraform resource name to match the original name. You can remove the call if you don't need them to match.*/
        cdktfTerraformOutputACRid.overrideLogicalId("id");
        cdktfTerraformOutputACRName.overrideLogicalId("container_registry_name");
        cdktfTerraformOutputACRloginserver.overrideLogicalId("login_server");
    }
}
exports.Registry = Registry;
_a = JSII_RTTI_SYMBOL_1;
Registry[_a] = { fqn: "@microsoft/terraform-cdk-constructs.azure_containerregistry.Registry", version: "0.0.3-pre.12" };
//# sourceMappingURL=data:application/json;base64,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